/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.Artifact;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.PandoraQuery;
import com.pinkmatter.pandora.PandoraQueryResult;
import com.pinkmatter.pandora.PandoraSearch;
import com.pinkmatter.pandora.lucene.LuceneConnection;
import com.pinkmatter.pandora.lucene.LuceneSchema;
import com.pinkmatter.pandora.lucene.PandoraQueryImpl;
import com.pinkmatter.pandora.lucene.PandoraQueryResultImpl;
import com.pinkmatter.pandora.lucene.PropertyFieldVisitorFactory;
import com.pinkmatter.pandora.lucene.serialize.IndexSerializer;
import com.pinkmatter.utils.bean.ObjectIntrospector;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneSearcher
implements PandoraSearch {
    private final LuceneConnection _connection;
    private static final Logger LOG = LoggerFactory.getLogger(LuceneSearcher.class);
    private boolean _autoRefresh = true;
    private boolean _refreshSearchNow = true;
    private boolean _refreshSchemaNow = true;
    private final ObjectIntrospector _introspector;

    public LuceneSearcher(LuceneConnection connection) {
        this(connection, true);
    }

    public LuceneSearcher(LuceneConnection connection, boolean autoRefresh) {
        this._connection = connection;
        this._autoRefresh = autoRefresh;
        this._introspector = new ObjectIntrospector();
        BooleanQuery.setMaxClauseCount((int)0x7FFFFFF5);
        LOG.debug("Created IndexSearcher with auto refresh {}", (Object)this._autoRefresh);
    }

    public Artifact getArtifact(long key) throws PandoraException {
        PandoraQueryResult result = this.query().keys(new long[]{key}).list(1);
        if (result.getHitCount() > 1) {
            LOG.error("Multiple artifacts found in index with key={}. This should NEVER happen!", (Object)key);
            throw new PandoraException(String.format("Multiple artifacts found in index with key=%s. This should NEVER happen!", key));
        }
        return result.getFirst();
    }

    public Artifact getArtifactSkeleton(long key) throws PandoraException {
        PandoraQueryResult result = this.query().keys(new long[]{key}).includeKeyOnly().list(1);
        if (result.getHitCount() > 1) {
            LOG.error("Multiple artifacts found in index with key={}. This should NEVER happen!", (Object)key);
            throw new PandoraException(String.format("Multiple artifacts found in index with key=%s. This should NEVER happen!", key));
        }
        return result.getFirst();
    }

    private PandoraQueryResult listArtifacts(SearchQuery query, int from, int maxResults) throws PandoraException {
        PandoraQueryResult pandoraQueryResult;
        LOG.debug("Searching for artifacts in index with query: {}", (Object)query);
        IndexSearcher searcher = null;
        try {
            int limit;
            if (from < 0 || maxResults <= 0) {
                throw new IllegalArgumentException("From cannot be negative and maxResults must be greater than 0.");
            }
            int offset = from;
            ScoreDoc afterDoc = null;
            if (from > query.getLastPagingIndex()) {
                offset = from - (query.getLastPagingIndex() + 1);
                afterDoc = query.getLastPagingScoreDoc();
            }
            if ((limit = offset + maxResults) <= 0) {
                limit = Integer.MAX_VALUE;
            }
            Sort sort = this.createSort(query.getSorters());
            Query luceneQuery = this.createQuery(query.getFilters());
            searcher = this.getSearcher();
            Object hits = sort == null ? searcher.searchAfter(afterDoc, luceneQuery, limit) : searcher.searchAfter(afterDoc, luceneQuery, limit, sort, false, false);
            if (hits.scoreDocs.length > 0) {
                if (afterDoc == null) {
                    query.setLastPagingResult(hits.scoreDocs[hits.scoreDocs.length - 1], hits.scoreDocs.length);
                } else {
                    query.setLastPagingResult(hits.scoreDocs[hits.scoreDocs.length - 1], query.getLastPagingIndex() + hits.scoreDocs.length);
                }
            }
            pandoraQueryResult = this.populateHits(searcher, query, (TopDocs)hits, offset);
        }
        catch (IOException ex) {
            try {
                throw new PandoraException("Index artifact search failed.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.releaseSearcher(searcher);
                throw throwable;
            }
        }
        this.releaseSearcher(searcher);
        return pandoraQueryResult;
    }

    private PandoraQueryResult populateHits(IndexSearcher searcher, SearchQuery query, TopDocs hits, int offset) throws PandoraException, IOException {
        PandoraQueryImpl.IncludeProperty[] returnProperties = query.getProperties();
        IndexSerializer serializer = new IndexSerializer();
        Artifact[] results = new Artifact[Math.max(hits.scoreDocs.length - offset, 0)];
        PropertyFieldVisitorFactory visitorFactory = new PropertyFieldVisitorFactory(this.getSchema(), returnProperties);
        int index = 0;
        for (int i = offset; i < hits.scoreDocs.length; ++i) {
            Artifact artifact;
            Document document;
            ScoreDoc scoreDoc = hits.scoreDocs[i];
            if (returnProperties.length == 0) {
                document = searcher.doc(scoreDoc.doc);
            } else {
                DocumentStoredFieldVisitor visitor = visitorFactory.createVisitor();
                searcher.doc(scoreDoc.doc, (StoredFieldVisitor)visitor);
                document = visitor.getDocument();
            }
            LinkedHashMap<String, Object> map = serializer.readAll(document);
            long key = (Long)map.get("__key");
            Date indexDate = (Date)map.get("__index-date");
            Date birthDate = (Date)map.get("__birth-date");
            map.remove("__key");
            map.remove("__index-date");
            map.remove("__birth-date");
            results[index] = artifact = new Artifact(key, map, birthDate, indexDate);
            ++index;
        }
        return new PandoraQueryResultImpl(results, hits.totalHits);
    }

    private long countArtifacts(PandoraFilter[] searchFilter) throws PandoraException {
        LOG.debug("Counting artifacts in index with searchFilter: {}", (Object)searchFilter);
        IndexSearcher searcher = null;
        try {
            searcher = this.getSearcher();
            if (searchFilter == null || searchFilter.length == 0) {
                long l = searcher.getIndexReader().numDocs();
                return l;
            }
            long l = searcher.count(this.createQuery(searchFilter));
            return l;
        }
        catch (IOException ex) {
            throw new PandoraException("Index artifact count failed.", (Throwable)ex);
        }
        finally {
            this.releaseSearcher(searcher);
        }
    }

    public Object getMinimumValue(String dottedProperty) throws PandoraException {
        try {
            return this.getMinMaxValue(dottedProperty, null, true);
        }
        catch (IOException ex) {
            throw new PandoraException(String.format("Error while getting minimum value for property %s from the index.", dottedProperty), (Throwable)ex);
        }
    }

    public Object getMaximumValue(String dottedProperty) throws PandoraException {
        try {
            return this.getMinMaxValue(dottedProperty, null, false);
        }
        catch (IOException ex) {
            throw new PandoraException(String.format("Error while getting maximum value for property %s from the index.", dottedProperty), (Throwable)ex);
        }
    }

    private Object getMinMaxValue(String dottedProperty, Class type, boolean minimum) throws IOException, PandoraException {
        LOG.debug("Getting min/max index value for property: {}, type: {}", (Object)dottedProperty, (Object)type);
        String baseProperty = LuceneSchema.getMainPropertyName(dottedProperty);
        Artifact artifact = this.query().filterNotEmpty(dottedProperty).include(baseProperty).sort(dottedProperty, minimum, type).list(1).getFirst();
        if (artifact != null) {
            switch (dottedProperty) {
                case "__key": {
                    return artifact.getKey();
                }
                case "__index-date": {
                    return artifact.getIndexDate();
                }
                case "__birth-date": {
                    return artifact.getBirthDate();
                }
            }
            Object value = this._introspector.get((Object)artifact, dottedProperty);
            if (value != null && value.getClass().isArray()) {
                return this.getMinMaxValue(value, minimum);
            }
            return value;
        }
        return null;
    }

    public Object getMinMaxValue(Object array, boolean minimum) {
        Comparable result = null;
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object o = Array.get(array, i);
            if (!(o instanceof Comparable)) continue;
            Comparable c = (Comparable)o;
            if (result == null) {
                result = c;
                continue;
            }
            if (minimum) {
                if (result.compareTo(c) <= 0) continue;
                result = c;
                continue;
            }
            if (result.compareTo(c) >= 0) continue;
            result = c;
        }
        return result;
    }

    private Sort createSort(PandoraQueryImpl.SortProperty ... sorters) throws PandoraException {
        if (sorters.length == 0) {
            return null;
        }
        ArrayList<SortField> allFields = new ArrayList<SortField>();
        for (PandoraQueryImpl.SortProperty sorter : sorters) {
            SortField[] sortFields = this.getQueryHelper().createSortFields(sorter);
            allFields.addAll(Arrays.asList(sortFields));
        }
        if (allFields.isEmpty()) {
            return null;
        }
        return new Sort(allFields.toArray(new SortField[0]));
    }

    private Query createQuery(PandoraFilter[] searchFilters) throws PandoraException, IOException {
        Object filter = null;
        filter = searchFilters != null && searchFilters.length > 0 ? (searchFilters.length == 1 ? this.getQueryHelper().createQuery(searchFilters[0]) : this.getQueryHelper().createQuery((PandoraFilter)new PandoraFilter.And(searchFilters))) : new MatchAllDocsQuery();
        return filter;
    }

    private LuceneSchema.QueryHelper getQueryHelper() throws PandoraException {
        return this.getSchema().getQueryHelper();
    }

    private synchronized LuceneSchema getSchema() throws PandoraException {
        LuceneSchema schema;
        if (this._refreshSchemaNow || this._autoRefresh) {
            schema = this._connection.getSchema(true);
            this._refreshSchemaNow = false;
        } else {
            schema = this._connection.getSchema(false);
        }
        return schema;
    }

    public void refresh() throws PandoraException {
        this._refreshSearchNow = true;
        this._refreshSchemaNow = true;
    }

    public boolean isAutoRefresh() {
        return this._autoRefresh;
    }

    public void setAutoRefresh(boolean auto) {
        this._autoRefresh = auto;
        LOG.info("Changed IndexSearcher to auto refresh {}", (Object)this._autoRefresh);
    }

    private IndexSearcher getSearcher() throws IOException {
        if (this._autoRefresh || this._refreshSearchNow) {
            this._refreshSearchNow = false;
            return this._connection.acquireWithRefresh();
        }
        return this._connection.acquire();
    }

    private void releaseSearcher(IndexSearcher searcher) throws PandoraException {
        if (searcher != null) {
            this._connection.release(searcher);
        }
    }

    public PandoraQuery query() {
        return new SearchQuery();
    }

    private class SearchQuery
    extends PandoraQueryImpl {
        private ScoreDoc _lastDoc;
        private int _lastIndex;

        private SearchQuery() {
        }

        public PandoraQueryResult list() throws PandoraException {
            return LuceneSearcher.this.listArtifacts(this, 0, Integer.MAX_VALUE);
        }

        public PandoraQueryResult list(int maxResults) throws PandoraException {
            return LuceneSearcher.this.listArtifacts(this, 0, maxResults);
        }

        public PandoraQueryResult list(int from, int maxResults) throws PandoraException {
            return LuceneSearcher.this.listArtifacts(this, from, maxResults);
        }

        public PandoraQueryResult listNext(int maxResults) throws PandoraException {
            return LuceneSearcher.this.listArtifacts(this, this.getLastPagingIndex() + 1, maxResults);
        }

        public long count() throws PandoraException {
            return LuceneSearcher.this.countArtifacts(this.getFilters());
        }

        public void setLastPagingResult(ScoreDoc lastScoreDoc, int index) {
            this.setPagingMode();
            this._lastDoc = lastScoreDoc;
            this._lastIndex = index;
        }

        public ScoreDoc getLastPagingScoreDoc() {
            if (this.mustResetPaging()) {
                this._lastDoc = null;
                this._lastIndex = -1;
            }
            return this._lastDoc;
        }

        public int getLastPagingIndex() {
            if (this.mustResetPaging()) {
                this._lastDoc = null;
                this._lastIndex = -1;
            }
            return this._lastIndex;
        }
    }
}

