/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.serialize;

import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.LicenseErrorDisplayer;
import com.paterva.maltego.licensing.serialize.F;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.MachineIDProvider;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class C {
    private static final Logger C = Logger.getLogger(C.class.getName());
    private static final String A = "Maltego.lic";
    private static final String B = "maltego.license.machine";
    private static final boolean D = false;

    public static void A(F licenseFile) throws IOException, GeneralSecurityException {
        File file = com.paterva.maltego.licensing.serialize.C.C(false);
        if (file != null) {
            byte[] blob = com.paterva.maltego.licensing.serialize.C.B(licenseFile.getBlob());
            byte[] signature = licenseFile.getSignature();
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
                dos.writeInt(blob.length);
                dos.write(blob);
                dos.writeInt(signature.length);
                dos.write(signature);
            }
            if (Utilities.isWindows()) {
                file.setWritable(true, false);
            }
        }
    }

    public static Optional<D> F() {
        D license = null;
        try {
            Optional<F> licenseBlob;
            File file = com.paterva.maltego.licensing.serialize.C.C(true);
            if (file != null && file.exists() && (licenseBlob = com.paterva.maltego.licensing.serialize.C.A(file)).isPresent()) {
                List<String> rhs;
                license = licenseBlob.get().A();
                String[] ids = MachineIDProvider.getDefault().getIDCandidates(false);
                List<String> lhs = license.D();
                if (Collections.disjoint(lhs, rhs = Arrays.asList(ids))) {
                    String msg = String.format("Machine ID mismatch, removing license file. %s vs %s", lhs, rhs);
                    C.log(Level.WARNING, msg);
                    com.paterva.maltego.licensing.serialize.C.B(msg);
                    license = null;
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Optional.ofNullable(license);
    }

    public static void B(String msg) {
        File file = com.paterva.maltego.licensing.serialize.C.C(false);
        if (file != null && file.exists()) {
            file.delete();
            if (msg != null) {
                SwingUtilities.invokeLater(() -> LicenseErrorDisplayer.getDefault().show(msg));
            }
        }
    }

    public static boolean C() {
        boolean machineLicense = false;
        if (Utilities.isWindows()) {
            machineLicense = com.paterva.maltego.licensing.serialize.C.D().getBoolean(B, false);
        }
        return machineLicense;
    }

    public static void A(boolean machineLicense) {
        if (Utilities.isWindows()) {
            com.paterva.maltego.licensing.serialize.C.D().putBoolean(B, machineLicense);
        }
    }

    private static Optional<F> A(File file) throws IOException, GeneralSecurityException {
        F licenseBlob = null;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            byte[] blob = new byte[dis.readInt()];
            dis.readFully(blob);
            byte[] signature = new byte[dis.readInt()];
            dis.readFully(signature);
            licenseBlob = new F(com.paterva.maltego.licensing.serialize.C.A(blob), signature);
        }
        catch (GeneralSecurityException ex) {
            throw new IOException("Failed to read license.", ex);
        }
        if (!licenseBlob.isValidSignature()) {
            String msg = "License signature invalid, removing license file.";
            C.warning(msg);
            com.paterva.maltego.licensing.serialize.C.B(msg);
            licenseBlob = null;
        }
        return Optional.ofNullable(licenseBlob);
    }

    private static File C(boolean fallBackIfNotFound) {
        File fallbackFile;
        boolean machineLicense = com.paterva.maltego.licensing.serialize.C.C();
        File licFile = com.paterva.maltego.licensing.serialize.C.B(machineLicense);
        if (fallBackIfNotFound && (licFile == null || !licFile.exists()) && (fallbackFile = com.paterva.maltego.licensing.serialize.C.B(!machineLicense)) != null && fallbackFile.exists()) {
            licFile = fallbackFile;
            com.paterva.maltego.licensing.serialize.C.A(!machineLicense);
        }
        return licFile;
    }

    private static File B(boolean machineLicense) {
        File userDir = FileUtilities.getUserDir((boolean)machineLicense);
        File lf = null;
        if (userDir == null) {
            C.severe("Unable to determine license directory location");
        } else {
            File licenseFile;
            lf = licenseFile = new File(userDir, A);
            if (!machineLicense) {
                File correctLocationLf = null;
                File parentDir = userDir.getParentFile();
                if (parentDir != null && parentDir.isDirectory()) {
                    File parentDirLicenseFile = new File(parentDir, A);
                    if (parentDirLicenseFile.exists()) {
                        if (licenseFile.exists()) {
                            licenseFile.delete();
                        }
                        correctLocationLf = parentDirLicenseFile;
                    } else {
                        try {
                            if (licenseFile.exists()) {
                                FileUtilities.copyFile((File)licenseFile, (File)parentDirLicenseFile);
                                licenseFile.delete();
                                correctLocationLf = parentDirLicenseFile;
                            }
                        }
                        catch (IOException ex) {
                            C.log(Level.WARNING, "Failed to copy the license file: ", ex.toString());
                        }
                    }
                    if (correctLocationLf == null) {
                        File oldParentDirLicenseFile;
                        File oldParentDir;
                        File parentOfParent;
                        String newMaltegoId = "maltego";
                        if (parentDir.toString().endsWith(File.separator)) {
                            newMaltegoId = newMaltegoId + File.separator;
                        }
                        if (parentDir.toString().endsWith(newMaltegoId) && (parentOfParent = parentDir.getParentFile()) != null && parentOfParent.isDirectory() && (oldParentDir = new File(parentOfParent, ".maltego")).isDirectory() && oldParentDir.canWrite() && (oldParentDirLicenseFile = new File(oldParentDir, A)).exists()) {
                            try {
                                FileUtilities.copyFile((File)oldParentDirLicenseFile, (File)parentDirLicenseFile);
                                oldParentDirLicenseFile.delete();
                                if (licenseFile.exists()) {
                                    licenseFile.delete();
                                }
                                correctLocationLf = parentDirLicenseFile;
                            }
                            catch (IOException ex) {
                                C.log(Level.WARNING, "Failed to copy the license file: ", ex.toString());
                            }
                        }
                    }
                }
                if (correctLocationLf != null) {
                    lf = correctLocationLf;
                }
            }
        }
        return lf;
    }

    private static byte[] B(byte[] bytes) throws UnsupportedEncodingException, GeneralSecurityException {
        Cipher cipher = com.paterva.maltego.licensing.serialize.C.A();
        cipher.init(1, (Key)com.paterva.maltego.licensing.serialize.C.B(), com.paterva.maltego.licensing.serialize.C.E());
        return cipher.doFinal(bytes);
    }

    private static byte[] A(byte[] bytes) throws IOException, GeneralSecurityException {
        Cipher cipher = com.paterva.maltego.licensing.serialize.C.A();
        cipher.init(2, (Key)com.paterva.maltego.licensing.serialize.C.B(), com.paterva.maltego.licensing.serialize.C.E());
        return cipher.doFinal(bytes);
    }

    private static Cipher A() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("DESede/CBC/PKCS5Padding");
    }

    private static SecretKey B() throws UnsupportedEncodingException, GeneralSecurityException {
        DESedeKeySpec keySpec = new DESedeKeySpec("!BlUeM0nk3YsE@tTh0ughT5!".getBytes("UTF8"));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
        return keyFactory.generateSecret(keySpec);
    }

    private static IvParameterSpec E() throws UnsupportedEncodingException {
        return new IvParameterSpec("Q!UaMtun".getBytes("UTF-8"));
    }

    private static Preferences D() {
        return NbPreferences.forModule(C.class);
    }
}

