/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.rest;

import com.paterva.maltego.crypto.SignedData;
import com.paterva.maltego.licensing.ApiKeyProvider;
import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.LicensingException;
import com.paterva.maltego.licensing.PatervaUrl;
import com.paterva.maltego.licensing.serialize.E;
import com.paterva.maltego.licensing.serialize.F;
import com.paterva.maltego.licensing.serialize.H;
import com.paterva.maltego.licensing.serialize.I;
import com.paterva.maltego.rest.MaltegoRestExchange;
import com.paterva.maltego.rest.MaltegoRestRequest;
import com.paterva.maltego.rest.MaltegoRestResponse;
import com.paterva.maltego.rest.RestException;
import com.paterva.maltego.rest.StandardRestEntries;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class A {
    private static final Logger A = Logger.getLogger(A.class.getName());

    private A() {
    }

    public static I B(String version) throws LicensingException, IOException, GeneralSecurityException {
        String apiKey = ApiKeyProvider.get().orElse(null);
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.A(null, apiKey, null, null, true);
        entries.put("EulaVersion", version);
        MaltegoRestResponse response = com.paterva.maltego.licensing.rest.A.A(PatervaUrl.EULA, "MaltegoEulaRequest", entries, false);
        return com.paterva.maltego.licensing.rest.A.A(response);
    }

    public static String C(String licenseKey) throws GeneralSecurityException {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.A(licenseKey);
        MaltegoRestRequest request = new MaltegoRestRequest("MaltegoLicenseRequest", entries);
        return request.getRequestBase64();
    }

    public static H D(String offlineResponse) throws GeneralSecurityException, IOException, RestException {
        MaltegoRestResponse response = new MaltegoRestResponse(offlineResponse, null, false);
        _A signedDataAndEula = com.paterva.maltego.licensing.rest.A.B(response);
        String nonce = null;
        return com.paterva.maltego.licensing.rest.A.A(nonce, signedDataAndEula);
    }

    public static H F(String licenseKey) throws LicensingException, IOException, GeneralSecurityException {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.A(licenseKey);
        _A signedDataAndEula = com.paterva.maltego.licensing.rest.A.A(entries);
        String nonce = entries.get("Nonce");
        return com.paterva.maltego.licensing.rest.A.A(nonce, signedDataAndEula);
    }

    private static H A(String nonce, _A signedDataAndEula) throws GeneralSecurityException, IOException {
        SignedData signedData = signedDataAndEula.B();
        I eula = signedDataAndEula.A().orElse(null);
        F blob = com.paterva.maltego.licensing.rest.A.A(nonce, signedData);
        return new H(blob, eula);
    }

    private static F A(String requestNonce, SignedData response) throws IOException, GeneralSecurityException {
        F licenseBlob = new F(response.getBlob(), response.getSignature());
        D license = licenseBlob.A();
        com.paterva.maltego.licensing.rest.A.A(requestNonce, license.F());
        return licenseBlob;
    }

    public static boolean B(String licenseKey, String hash) throws IOException, GeneralSecurityException {
        try {
            Map<String, String> entries = com.paterva.maltego.licensing.rest.A.A(licenseKey, null, hash, null, false);
            MaltegoRestExchange exchange = new MaltegoRestExchange(PatervaUrl.SAME.getUrl(), "MaltegoLicenseSameRequest", entries);
            exchange.setCheckNonce(false);
            exchange.setCheckStatus(false);
            exchange.sendRequest();
            String message = exchange.getResponse().getMessage();
            return Boolean.parseBoolean(message);
        }
        catch (RestException ex) {
            A.log(Level.WARNING, "Error while checking if license changed: {0}", ex.getMessage());
            return false;
        }
    }

    public static String A(String apiKey, I eula) throws LicensingException, IOException, GeneralSecurityException {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.A(null, apiKey, null, null, true);
        entries.put("DocumentVersion", eula.B());
        MaltegoRestResponse response = com.paterva.maltego.licensing.rest.A.A(PatervaUrl.LICENSE_AGREEMENT_PERSIST, "MaltegoLicenseAgreementPersistRequest", entries, false);
        return response.getText();
    }

    public static String E(String apiKey) throws LicensingException, IOException, GeneralSecurityException {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.A(null, apiKey, null, null, true);
        return com.paterva.maltego.licensing.rest.A.A(PatervaUrl.HUB, "MaltegoHubRequest", entries);
    }

    private static Map<String, String> A(String licenseKey) {
        Map<String, String> entries = com.paterva.maltego.licensing.rest.A.A(licenseKey, null, null, null, false);
        return entries;
    }

    private static _A A(Map<String, String> entries) throws LicensingException {
        try {
            MaltegoRestResponse response = com.paterva.maltego.licensing.rest.A.A(PatervaUrl.ACTIVATE, "MaltegoLicenseRequest", entries, false);
            return com.paterva.maltego.licensing.rest.A.B(response);
        }
        catch (Exception ex) {
            if (ex instanceof LicensingException) {
                throw (LicensingException)ex;
            }
            throw new LicensingException(ex, true);
        }
    }

    private static _A B(MaltegoRestResponse response) throws GeneralSecurityException, IOException {
        SignedData data = response.getSignedData(true);
        I eula = com.paterva.maltego.licensing.rest.A.A(response);
        return new _A(data, eula);
    }

    private static I A(MaltegoRestResponse response) throws XmlSerializationException, IOException {
        XmlSerializer serializer = new XmlSerializer();
        E licenseResponse = (E)serializer.read(E.class, response.getText());
        com.paterva.maltego.licensing.serialize.D eulaStub = licenseResponse.A();
        return I.A(eulaStub.A(), eulaStub.B(), eulaStub.C());
    }

    private static String A(PatervaUrl url, String root, Map<String, String> entries) throws LicensingException, IOException, GeneralSecurityException {
        MaltegoRestResponse response = com.paterva.maltego.licensing.rest.A.A(url, root, entries, false);
        return response.getBlobPlain();
    }

    private static MaltegoRestResponse A(PatervaUrl url, String root, Map<String, String> entries, boolean skipStatusCheck) throws LicensingException, IOException, GeneralSecurityException {
        try {
            MaltegoRestExchange exchange = new MaltegoRestExchange(url.getUrl(), root, entries);
            exchange.setCheckNonce(false);
            exchange.setCheckStatus(!skipStatusCheck);
            exchange.sendRequest();
            return exchange.getResponse();
        }
        catch (RestException ex) {
            throw new LicensingException((Exception)((Object)ex), false);
        }
    }

    private static Map<String, String> A(String licenseKey, String apiKey, String hash, Map<String, String> addEntries, boolean machineIDsAppendRnd) {
        com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
        Map entries = StandardRestEntries.get((String)apiKey, (boolean)(machineIDsAppendRnd ? licenseMode.F() : false));
        entries.put("LicenseKey", licenseKey);
        entries.put("Hash", hash);
        if (addEntries != null && !addEntries.isEmpty()) {
            entries.putAll(addEntries);
        }
        return entries;
    }

    private static void A(String requestNonce, String responseNonce) throws IOException {
        if (requestNonce != null && !Objects.equals(responseNonce, requestNonce)) {
            throw new IOException("Response does not match request.");
        }
    }

    private static class _A {
        private final SignedData B;
        private final I A;

        public _A(SignedData data, I eula) {
            Args.notNull((Object)data, (String)"data");
            this.B = data;
            this.A = eula;
        }

        public SignedData B() {
            return this.B;
        }

        public Optional<I> A() {
            return Optional.ofNullable(this.A);
        }
    }
}

