/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing;

import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseCheckFailedListener;
import com.paterva.maltego.licensing.mode.B;
import com.paterva.maltego.licensing.serialize.C;
import com.paterva.maltego.licensing.serialize.G;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class LicenseManager {
    private static final Logger B = Logger.getLogger(LicenseManager.class.getName());
    private static final LicenseManager E = new LicenseManager();
    private final ChangeSupport C = new ChangeSupport((Object)this);
    private final LicenseSettings D = new LicenseSettings();
    private boolean A = false;

    private LicenseManager() {
    }

    public static LicenseManager A() {
        return E;
    }

    public synchronized boolean A(boolean checkOnline, boolean checkTransformRunAllowed) {
        boolean valid;
        com.paterva.maltego.licensing.mode.A licenseMode = this.A(checkOnline);
        boolean bl = valid = licenseMode.Q() || licenseMode.B() && licenseMode.P();
        if (checkTransformRunAllowed) {
            valid = com.paterva.maltego.licensing.A.A(licenseMode);
        }
        if (!valid) {
            Lookup.getDefault().lookupAll(LicenseCheckFailedListener.class).stream().forEach(LicenseCheckFailedListener::onLicenseCheckFailed);
        }
        return valid;
    }

    public synchronized com.paterva.maltego.licensing.mode.A A(boolean checkOnline) {
        com.paterva.maltego.licensing.mode.A licenseMode;
        long time;
        block9: {
            time = System.currentTimeMillis();
            licenseMode = null;
            try {
                String licenseKey;
                Optional<com.paterva.maltego.licensing.mode.A> licenseModeOpt;
                if (this.D.isFreeMode()) {
                    licenseMode = com.paterva.maltego.licensing.mode.A.A(time, this.D.isFreeOnline());
                    break block9;
                }
                Optional<D> license = com.paterva.maltego.licensing.serialize.C.F();
                if (!this.A && !license.isPresent()) {
                    this.A = true;
                    G reader = new G();
                    Optional<String> oldKey = reader.D();
                    if (oldKey.isPresent()) {
                        B.fine("Activating using old license key");
                        String oldLicKey = oldKey.get();
                        this.D.setLicenseKey(oldLicKey);
                        try {
                            license = com.paterva.maltego.licensing.mode.C.A(oldLicKey);
                        }
                        catch (Exception ex) {
                            B.log(Level.WARNING, "Error trying to activate with old key: {0}", ex.getMessage());
                            licenseMode = null;
                        }
                    }
                }
                if (license.isPresent() && (licenseModeOpt = com.paterva.maltego.licensing.mode.B.A(time, license.get(), checkOnline)).isPresent() && (licenseKey = (licenseMode = licenseModeOpt.get()).A().C()) != null && !licenseKey.equals(this.C())) {
                    this.D.setLicenseKey(licenseKey);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                licenseMode = null;
            }
        }
        if (licenseMode == null) {
            licenseMode = com.paterva.maltego.licensing.mode.A.A(time);
        }
        com.paterva.maltego.licensing.mode.A licMode = licenseMode;
        B.fine(() -> "License Mode (" + (checkOnline ? "Online" : "Offline") + "): " + licMode);
        String branding = this.C(licMode);
        NbPreferences.root().put("maltego.branding.code", branding);
        this.B(licenseMode);
        return licenseMode;
    }

    public synchronized String D() {
        return System.getProperty("maltego.product-name", "Maltego");
    }

    private void B(com.paterva.maltego.licensing.mode.A licenseMode) {
        String productName = "Maltego";
        String subscriptionPlan = "";
        if (licenseMode.B()) {
            E capability = licenseMode.J().J();
            productName = capability.F().trim();
            subscriptionPlan = capability.A();
        } else if (licenseMode.Q()) {
            productName = productName + (licenseMode.I() ? " Community Edition" : " CaseFile");
        }
        System.setProperty("maltego.product-name", productName);
        System.setProperty("maltego.subscriptionPlan", subscriptionPlan);
    }

    public void C(boolean freeModeSet) {
        this.D.setFreeMode(freeModeSet);
    }

    public void B(boolean freeOnline) {
        this.D.setFreeOnline(freeOnline);
    }

    public void A(String licenseKey) {
        this.D.setLicenseKey(licenseKey != null ? licenseKey.toUpperCase() : "");
    }

    public String C() {
        return this.D.getLicenseKey();
    }

    public void A(ChangeListener listener) {
        this.C.addChangeListener(listener);
    }

    public void B(ChangeListener listener) {
        this.C.removeChangeListener(listener);
    }

    public void A(com.paterva.maltego.licensing.mode.A oldMode) {
        com.paterva.maltego.licensing.mode.A newMode = this.A(false);
        boolean fire = false;
        if (oldMode.D() != newMode.D() || oldMode.Q() != newMode.Q() || oldMode.B() != newMode.B()) {
            fire = true;
        } else if (oldMode.Q() && oldMode.I() != newMode.I()) {
            fire = true;
        } else if (oldMode.B()) {
            D oldLicense = oldMode.A();
            D newLicense = newMode.A();
            if (!(oldLicense.H().equals(newLicense.H()) && oldLicense.C().equals(newLicense.C()) && oldLicense.I().equals(newLicense.I()) && oldLicense.J().equals(newLicense.J()) && oldLicense.B().equals(newLicense.B()) && oldLicense.E().equals(newLicense.E()) && oldLicense.D().equals(newLicense.D()))) {
                fire = true;
            }
        }
        B.log(Level.FINE, "Fire license change: {0}", fire);
        if (fire) {
            this.C.fireChange();
        }
    }

    public void E() {
        this.C.fireChange();
    }

    public String B() {
        return this.C(this.A(false));
    }

    public String C(com.paterva.maltego.licensing.mode.A licenseMode) {
        String branding = "Unknown";
        if (licenseMode.H()) {
            branding = "BT";
        } else if (licenseMode.Q()) {
            branding = licenseMode.I() ? "CE" : "CF";
        } else if (licenseMode.B()) {
            branding = licenseMode.E() ? "ONE" : (licenseMode.M() ? "XL" : "FULL");
        }
        return branding;
    }

    private class LicenseSettings {
        private static final String PREF_LICENSE_KEY = "maltego.licensing.key";
        private static final String PREF_FREE_MODE = "maltego.licensing.free.mode";
        private static final String PREF_FREE_ONLINE = "maltego.licensing.free.online";

        private LicenseSettings() {
        }

        public void setLicenseKey(String licenseKey) {
            this.getPrefs().put(PREF_LICENSE_KEY, licenseKey);
        }

        public String getLicenseKey() {
            return this.getPrefs().get(PREF_LICENSE_KEY, "");
        }

        public void setFreeMode(boolean freeModeSet) {
            this.getPrefs().putBoolean(PREF_FREE_MODE, freeModeSet);
        }

        public boolean isFreeMode() {
            return this.getPrefs().getBoolean(PREF_FREE_MODE, false);
        }

        public void setFreeOnline(boolean freeOnline) {
            this.getPrefs().putBoolean(PREF_FREE_ONLINE, freeOnline);
        }

        public boolean isFreeOnline() {
            return this.getPrefs().getBoolean(PREF_FREE_ONLINE, true);
        }

        private Preferences getPrefs() {
            return NbPreferences.forModule(this.getClass());
        }
    }
}

