/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineDescriptorComparator;
import com.paterva.maltego.automation.MachineException;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineManager;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.runtime.MachineValidationException;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.automation.view.startup.EntityNodePayload;
import com.paterva.maltego.automation.view.startup.Helper;
import com.paterva.maltego.automation.view.startup.MachineErrorHandler;
import com.paterva.maltego.automation.view.startup.MachineInputController;
import com.paterva.maltego.automation.view.startup.MachineSelectionController;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.GraphViewNotificationAdapter;
import com.paterva.maltego.ui.graph.actions.NewGraphAction;
import com.paterva.maltego.ui.graph.impl.SelectiveGlobalActionContext;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupManager;
import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import yguard.A.J.SA;

public class RunActions {
    private static final String PREF_RUN_ON_START = "showMachineWizardOnStartup";
    private static final String PREF_RUN_ON_EMPTY_GRAPH = "showMachineWizardOnEmptyGraphClick";

    private RunActions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showWizard() {
        boolean success = false;
        try {
            boolean ok;
            Dialog dialog;
            WizardDescriptor wizardDescriptor;
            try {
                WindowUtil.showWaitCursor();
                ArrayList<ValidatingController> panels = new ArrayList<ValidatingController>();
                MachineSelectionController selection = new MachineSelectionController();
                selection.setName("Choose machine");
                selection.setDescription("Please select the machine to run from the list below.");
                selection.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/RobotPlay.png".replace(".png", "48.png")));
                panels.add(selection);
                MachineInputController input = new MachineInputController();
                input.setName("Specify target");
                input.setDescription("Please provide parameters for the machine to target.");
                panels.add(input);
                WizardDescriptor.Panel[] panelArray = panels.toArray(new WizardDescriptor.Panel[panels.size()]);
                WizardUtilities.updatePanels((WizardDescriptor.Panel[])panelArray);
                wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panelArray));
                wizardDescriptor.setTitle("Start a Machine");
                ArrayList<MachineDescriptor> machines = new ArrayList<MachineDescriptor>(MachineRepository.getDefault().getAll(true));
                List<MachineDescriptor> machinesFiltered = RunActions.filterMachines(machines);
                Collections.sort(machinesFiltered, new MachineDescriptorComparator());
                wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
                wizardDescriptor.putProperty("machines", machinesFiltered);
                wizardDescriptor.putProperty("selectedMachine", null);
                wizardDescriptor.putProperty("selectedTarget", (Object)new MaltegoEntity[0]);
                wizardDescriptor.setTitleFormat(new MessageFormat("Run Machine - {0} ({1})"));
                dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
            dialog.setVisible(true);
            dialog.toFront();
            boolean bl = ok = wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION;
            if (ok) {
                MaltegoEntity[] targets = (MaltegoEntity[])wizardDescriptor.getProperty("selectedTarget");
                MachineDescriptor machine = (MachineDescriptor)wizardDescriptor.getProperty("selectedMachine");
                if (machine != null) {
                    if (targets != null) {
                        RunActions.runOnTargets(machine, targets);
                    } else {
                        RunActions.runNoInputEntityTypeMachine(machine);
                    }
                }
            }
            success = ok;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return success;
    }

    private static List<MachineDescriptor> filterMachines(List<MachineDescriptor> machines) {
        ArrayList<MachineDescriptor> machinesFiltered = new ArrayList<MachineDescriptor>();
        SelectiveGlobalActionContext selectionCtx = RunActions.getSelectionContext();
        GraphID graphId = selectionCtx.getTopGraphID();
        MachineInputProvider inputProvider = MachineInputProvider.getDefault();
        for (MachineDescriptor machine : machines) {
            boolean addMachine = true;
            if (machine == null) continue;
            MachineInput machineInput = inputProvider.getInputDescriptor(machine);
            if (inputProvider.isNonInputEntityTypeMachines(machineInput)) {
                if (graphId != null) {
                    if (GraphStoreHelper.getEntityIDs((GraphID)graphId).isEmpty() || GraphSelection.forGraph((GraphID)graphId).getSelectedModelEntities().isEmpty() && inputProvider.isLocalScope(machine)) {
                        addMachine = false;
                    }
                } else {
                    addMachine = false;
                }
            }
            if (!addMachine) continue;
            machinesFiltered.add(machine);
        }
        return machinesFiltered;
    }

    public static boolean show(MachineDescriptor machine) {
        boolean ok = false;
        MaltegoEntity[] targets = null;
        if (machine != null) {
            MachineInput machineInput = MachineInputProvider.getDefault().getInputDescriptor(machine);
            if (machineInput.getSupportedEntityTypes().length == 0) {
                RunActions.runNoInputEntityTypeMachine(machine);
            } else {
                MachineInputController input = new MachineInputController();
                EditDialogDescriptor dd = new EditDialogDescriptor("Specify target", (WizardDescriptor.Panel)input, true);
                dd.putProperty("selectedMachine", (Object)machine);
                dd.putProperty("selectedTarget", (Object)new MaltegoEntity[0]);
                input.readSettings((WizardDescriptor)dd);
                targets = (MaltegoEntity[])dd.getProperty("selectedTarget");
                if (targets == null || targets.length == 0) {
                    ok = true;
                } else {
                    boolean bl = ok = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == EditDialogDescriptor.OK_OPTION;
                    if (ok) {
                        targets = (MaltegoEntity[])dd.getProperty("selectedTarget");
                    }
                }
            }
        }
        if (ok) {
            RunActions.runOnTargets(machine, targets);
        }
        return ok;
    }

    private static void runNoInputEntityTypeMachine(MachineDescriptor machine) {
        SelectiveGlobalActionContext selectionCtx = RunActions.getSelectionContext();
        Set<EntityID> selectionEntityIDs = RunActions.getSelectedEntityIDs(selectionCtx);
        GraphID graphId = selectionCtx.getTopGraphID();
        if (graphId != null) {
            EntityNodePayload payLoad = new EntityNodePayload(graphId, selectionEntityIDs);
            RunActions.runMachine(Helper.getTarget(), machine, payLoad);
        }
    }

    public static boolean isShowOnStartup() {
        return NbPreferences.forModule(RunActions.class).getBoolean(PREF_RUN_ON_START, false);
    }

    public static void setShowOnStartup(boolean showOnStart) {
        NbPreferences.forModule(RunActions.class).putBoolean(PREF_RUN_ON_START, showOnStart);
    }

    public static boolean isShowOnEmptyGraphClick() {
        return NbPreferences.forModule(RunActions.class).getBoolean(PREF_RUN_ON_EMPTY_GRAPH, false);
    }

    public static void setShowOnEmptyGraphClick(boolean show) {
        NbPreferences.forModule(RunActions.class).putBoolean(PREF_RUN_ON_EMPTY_GRAPH, show);
    }

    public static void runOnTargets(MachineDescriptor machine, MaltegoEntity[] targets) {
        RunActions.runOnTargets(machine, targets, Integer.MAX_VALUE, false);
    }

    public static void runOnTargets(final MachineDescriptor machine, final MaltegoEntity[] targets, final int iterationCount, final boolean shutdownWhenComplete) {
        if (targets == null || targets.length == 0) {
            String msg = "The machine target(s) could not be found. Please make sure that the entity types and transforms that are used by the machine have been installed and/or imported.";
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 2);
            nd.setTitle("Missing target(s)");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        final AtomicBoolean otherFired = new AtomicBoolean(false);
        final TopComponent[] tcHolder = new TopComponent[1];
        GraphEditorRegistry.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("topmost".equals(evt.getPropertyName())) {
                    GraphEditorRegistry.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    tcHolder[0] = (TopComponent)evt.getNewValue();
                    if (otherFired.getAndSet(true)) {
                        RunActions.runMachineOnNewGraph(machine, targets, tcHolder[0], iterationCount, shutdownWhenComplete);
                    }
                }
            }
        });
        GraphViewNotificationAdapter.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphViewNotificationAdapter.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                if (otherFired.getAndSet(true)) {
                    RunActions.runMachineOnNewGraph(machine, targets, tcHolder[0], iterationCount, shutdownWhenComplete);
                }
            }
        });
        ((NewGraphAction)SystemAction.get(NewGraphAction.class)).performAction();
    }

    private static void runMachineOnNewGraph(MachineDescriptor machine, MaltegoEntity[] targets, TopComponent topComponent, int iterationCount, boolean shutdownWhenComplete) {
        Lookup lookup = topComponent.getLookup();
        GraphCookie graphCookie = (GraphCookie)lookup.lookup(GraphCookie.class);
        DataObject targetRef = (DataObject)lookup.lookup(DataObject.class);
        GraphID graphID = graphCookie.getOrLoadGraph();
        GraphStoreWriter.addEntities((GraphID)graphID, Arrays.asList(targets));
        GraphViewCookie viewCookie = (GraphViewCookie)lookup.lookup(GraphViewCookie.class);
        if (viewCookie != null) {
            viewCookie.getGraphView().fitContent();
        }
        SwingUtilities.invokeLater(() -> RunActions.runMachine(targetRef, machine, Payloads.fromEntities(targets), iterationCount, shutdownWhenComplete));
    }

    private static Set<EntityID> getSelectedEntityIDs(SelectiveGlobalActionContext selection) {
        Set selectedModelEntities = Collections.EMPTY_SET;
        GraphID graphID = selection.getTopGraphID();
        if (graphID != null) {
            selectedModelEntities = selection.getSelectedModelEntities();
        }
        return selectedModelEntities;
    }

    private static SelectiveGlobalActionContext getSelectionContext() {
        WindowPopupManager.getInstance().close();
        return SelectiveGlobalActionContext.instance();
    }

    private static boolean isTopGraphEmpty() {
        GraphCookie graphCookie;
        Lookup lookup;
        TopComponent topComponent = GraphEditorRegistry.getDefault().getTopmost();
        if (topComponent != null && (lookup = topComponent.getLookup()) != null && (graphCookie = (GraphCookie)lookup.lookup(GraphCookie.class)) != null) {
            GraphID graphID = graphCookie.getGraphID();
            SA graph = GraphViewManager.getDefault().getViewGraph(graphID);
            if (graph != null) {
                return graph.\u00c4();
            }
        }
        return false;
    }

    public static void runMachine(DataObject target, MachineDescriptor machine, Payload payload) {
        RunActions.runMachine(target, machine, payload, Integer.MAX_VALUE, false);
    }

    public static void runMachine(DataObject target, MachineDescriptor machine, Payload payload, int iterationCount, boolean shutdownWhenComplete) {
        try {
            MachineManager.getDefault().start(target, machine, payload, iterationCount, shutdownWhenComplete);
        }
        catch (MachineValidationException ex) {
            if (MachineErrorHandler.getDefault().warn(machine, ex)) {
                try {
                    MachineManager.getDefault().start(target, machine, payload, false, iterationCount, shutdownWhenComplete);
                }
                catch (MachineException ex1) {
                    MachineErrorHandler.getDefault().error(machine, ex);
                }
            }
        }
        catch (MachineException ex) {
            MachineErrorHandler.getDefault().error(machine, ex);
        }
    }
}

