/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.editor;

import com.paterva.maltego.automation.view.editor.MachineEditorControl;
import com.paterva.maltego.automation.view.editor.TransformFilterUtils;
import com.paterva.maltego.automation.view.editor.TransformNode;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import java.awt.Image;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

class TasNode
extends AbstractNode {
    public TasNode(TransformServerInfo tas, MachineEditorControl machineEditControl) {
        super(Children.create((ChildFactory)new TasTransformChildFactory(tas, machineEditControl), (boolean)true), Lookups.fixed((Object[])new Object[]{tas}));
        this.setDisplayName(tas.getDisplayName());
        this.setShortDescription(tas.getDescription());
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/TAS.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private static class TasTransformChildFactory
    extends ChildFactory<TransformDefinition> {
        private final TransformServerInfo _tas;
        private final MachineEditorControl _machineEditControl;

        public TasTransformChildFactory(TransformServerInfo tas, MachineEditorControl control) {
            this._tas = tas;
            this._machineEditControl = control;
        }

        protected boolean createKeys(List<TransformDefinition> fill) {
            String selectedType = TransformFilterUtils.getSelectedType(this._machineEditControl.getSelectedOption());
            List<TransformDefinition> transforms = TransformFilterUtils.getTransforms(this._tas, selectedType);
            fill.addAll(transforms);
            Collections.sort(fill, new Comparator<TransformDefinition>(){

                @Override
                public int compare(TransformDefinition o1, TransformDefinition o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            return true;
        }

        protected Node createNodeForKey(TransformDefinition key) {
            return new TransformNode(key);
        }

        protected Node createWaitNode() {
            AbstractNode wait = new AbstractNode(Children.LEAF);
            wait.setDisplayName("Getting transforms...");
            return wait;
        }
    }
}

