/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.view.AllMachinesChildFactory;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.table.TableColumnModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class MachineManagerTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private OutlineViewPanel _view = new OutlineViewPanel("Name");
    private ExplorerManager _explorer = new ExplorerManager();

    public MachineManagerTopComponent() {
        this(null);
    }

    public MachineManagerTopComponent(String selectTas) {
        this.initComponents();
        PanelWithMatteBorderAllSides outerPanel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout());
        outerPanel.add((Component)this._view);
        this.add((Component)outerPanel, "Center");
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new AllMachinesChildFactory(), (boolean)false));
        root.addNodeListener((NodeListener)new NodeSelector(selectTas));
        this._explorer.setRootContext((Node)root);
        this._view.getView().setPropertyColumns(new String[]{"status", "Status", "author", "Author", "description", "Description", "readonly", "Read-only"});
        this._view.getView().setPropertyColumnDescription("status", "Indicates whether this machine is active or not");
        this._view.getView().setPropertyColumnDescription("author", "Author who created this machine");
        this._view.getView().setPropertyColumnDescription("description", "Description of the machine");
        this._view.getView().setPropertyColumnDescription("readonly", "Indicates whether this machine is editable");
        this._view.getView().getOutline().setAutoResizeMode(2);
        TableColumnModel columns = this._view.getView().getOutline().getColumnModel();
        columns.getColumn(0).setPreferredWidth(170);
        columns.getColumn(1).setMinWidth(30);
        columns.getColumn(1).setMaxWidth(60);
        columns.getColumn(2).setPreferredWidth(40);
        columns.getColumn(3).setPreferredWidth(300);
        columns.getColumn(4).setMinWidth(30);
        columns.getColumn(4).setMaxWidth(70);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this._explorer));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this._explorer));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this._explorer));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)map));
        this.addActions();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public int getPersistenceType() {
        return 2;
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    private void saveMachineSettings(Node[] items) {
        for (Node item : items) {
            this.saveMachineSetting(item);
        }
    }

    protected void saveMachineSettings() {
        Node[] allNodes = this._explorer.getRootContext().getChildren().getNodes();
        this.saveMachineSettings(allNodes);
    }

    private void saveMachineSetting(Node item) {
        MachineRepository registry = MachineRepository.getDefault();
        MachineDescriptor info = (MachineDescriptor)item.getLookup().lookup(MachineDescriptor.class);
        if (info != null) {
            try {
                registry.update(info);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private void doSelectTas(String tasName) {
        try {
            if (!StringUtilities.isNullOrEmpty((String)tasName)) {
                Node[] allNodes;
                for (Node node : allNodes = this._explorer.getRootContext().getChildren().getNodes()) {
                    TransformServerInfo tas = (TransformServerInfo)node.getLookup().lookup(TransformServerInfo.class);
                    if (tas == null || !tas.getDisplayName().equals(tasName)) continue;
                    this._explorer.setSelectedNodes(new Node[]{node});
                    return;
                }
            }
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void addActions() {
        List actions = Utilities.actionsForPath((String)"Maltego/ContextActions/MachineManager");
        for (int i = actions.size() - 1; i >= 0; --i) {
            Action action = (Action)actions.get(i);
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(this.getLookup());
            }
            this._view.addToToolbarLeft(action);
        }
    }

    public void refresh(String selectTas) {
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new AllMachinesChildFactory(), (boolean)false));
        if (selectTas != null) {
            root.addNodeListener((NodeListener)new NodeSelector(selectTas));
        }
        this._explorer.setRootContext((Node)root);
    }

    public void refresh() {
        TransformServerInfo tas;
        String selectedTas = null;
        Node[] node = this._explorer.getSelectedNodes();
        if (node.length > 0 && (tas = (TransformServerInfo)node[0].getLookup().lookup(TransformServerInfo.class)) != null) {
            selectedTas = tas.getDisplayName();
        }
        this.refresh(selectedTas);
    }

    private class RefreshingActionWrapper
    implements Action {
        private Action _delegate;

        public RefreshingActionWrapper(Action action) {
            this._delegate = action;
        }

        @Override
        public Object getValue(String key) {
            return this._delegate.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this._delegate.putValue(key, value);
        }

        @Override
        public void setEnabled(boolean b) {
            this._delegate.setEnabled(b);
        }

        @Override
        public boolean isEnabled() {
            return this._delegate.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._delegate.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this._delegate.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._delegate.actionPerformed(e);
            MachineManagerTopComponent.this.refresh();
        }
    }

    private class NodeSelector
    implements NodeListener {
        private boolean waiting = true;
        private boolean nodesLoaded = false;
        private String selection;

        public NodeSelector(String defaultSelection) {
            this.selection = defaultSelection;
        }

        public void doSelection(String nodeName) {
            MachineManagerTopComponent.this.doSelectTas(nodeName);
        }

        public void childrenAdded(NodeMemberEvent nme) {
            if (!this.waiting && !this.nodesLoaded) {
                this.nodesLoaded = true;
                this.doSelection(this.selection);
            }
        }

        public void childrenRemoved(NodeMemberEvent nme) {
            if (this.waiting) {
                this.waiting = false;
            }
        }

        public void childrenReordered(NodeReorderEvent nre) {
        }

        public void nodeDestroyed(NodeEvent ne) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }
}

