/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.treelist;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineManager;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.MachineRuntimeEvent;
import com.paterva.maltego.automation.MachineRuntimeListener;
import com.paterva.maltego.automation.RuntimeState;
import com.paterva.maltego.automation.favs.MachineFavorites;
import com.paterva.maltego.automation.treelist.MachineRunItem;
import com.paterva.maltego.automation.treelist.MachineRunningItem;
import com.paterva.maltego.automation.treelist.MachineSetItem;
import com.paterva.maltego.automation.treelist.MachinesItem;
import com.paterva.maltego.automation.treelist.NoMachinesItem;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.automation.view.startup.MachinesForNodes;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.runregistry.RunProvider;
import com.paterva.maltego.runregistry.favs.RunFavorites;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.runregistry.item.RunProviderItemComparator;
import com.paterva.maltego.runregistry.item.RunnableItem;
import com.paterva.maltego.ui.graph.run.GlobalContextRunProvider;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class MachineRunProvider
extends GlobalContextRunProvider {
    private static final String FAVORITES = "Favorites";
    private static final String FAVORITES_LAF_PREFIX = "machines-item-fav";
    private final Map<String, MachineRunItem> _itemCache = new HashMap<String, MachineRunItem>();
    private final List<RunnableItem> _favorites = new ArrayList<RunnableItem>();

    public MachineRunProvider() {
        MachineManager.getDefault().addMachineListener(new MachineRunListener());
        MachineFavorites.getDefault().addPropertyChangeListener(new MachineFavoritesListener());
        this.updateItems();
    }

    public int getPosition() {
        return 1000;
    }

    public static boolean isShowIn(String componentName) {
        return "run-view".equals(componentName) || "context-menu".equals(componentName);
    }

    public void run(List<RunProviderItem> items, GraphID graphID, Set<EntityID> entities) {
        MachineRunItem runItem;
        RunProviderItem item;
        if (items.size() == 1 && (item = items.iterator().next()) instanceof MachineRunItem && (runItem = (MachineRunItem)item).canRun()) {
            runItem.run(graphID, entities);
        }
    }

    protected void updateFavorites() {
        RunFavorites.getDefault().setFavorites((RunProvider)this, this._favorites);
    }

    protected List<RunProviderItem> createItems(String component, GraphID graphID, Set<EntityID> entities) {
        String filterText;
        List<MachineDescriptor> machines = null;
        try {
            machines = MachinesForNodes.get(graphID, entities);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this._favorites.clear();
        if (graphID == null || entities == null || !A.B()) {
            return Collections.EMPTY_LIST;
        }
        if (machines == null || machines.isEmpty()) {
            if (entities.isEmpty()) {
                machines = this.getNoInputEntityTypeMachines(graphID);
            }
            if (machines == null || machines.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        if (!StringUtilities.isNullOrEmpty((String)(filterText = this.getFilterText(component)))) {
            return this.toFilteredItems(filterText.toLowerCase(), machines);
        }
        return this.toItems(machines);
    }

    private List<MachineDescriptor> getNoInputEntityTypeMachines(GraphID graphID) {
        ArrayList<MachineDescriptor> machines = new ArrayList<MachineDescriptor>();
        try {
            MachineInputProvider inputProvider = MachineInputProvider.getDefault();
            for (MachineDescriptor machineDescriptor : MachineRepository.getDefault().getAll(true)) {
                MachineInput input = inputProvider.getInputDescriptor(machineDescriptor);
                if (!inputProvider.isNonInputEntityTypeMachines(input) || inputProvider.isLocalScope(machineDescriptor) || GraphStoreHelper.getEntityIDs((GraphID)graphID).isEmpty()) continue;
                machines.add(machineDescriptor);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return machines;
    }

    private List<RunProviderItem> toFilteredItems(String filterText, List<MachineDescriptor> machines) {
        List<Object> rootItems = (machines = this.filter(filterText, machines)).isEmpty() ? Collections.singletonList(new NoMachinesItem()) : this.createMachineRunItems(machines);
        MachinesItem machinesItem = new MachinesItem(rootItems);
        return Collections.singletonList(machinesItem);
    }

    private List<MachineDescriptor> filter(String filterText, List<MachineDescriptor> machines) {
        return machines.stream().filter(machine -> this.filterKeepMachine(filterText, (MachineDescriptor)machine)).collect(Collectors.toList());
    }

    private boolean filterKeepMachine(String filterText, MachineDescriptor machine) {
        String displayName = machine.getDisplayName();
        return displayName != null && displayName.toLowerCase().contains(filterText);
    }

    private ArrayList<MachineRunItem> createMachineRunItems(List<MachineDescriptor> machines) {
        ArrayList<MachineRunItem> machineRunItems = new ArrayList<MachineRunItem>();
        for (MachineDescriptor machine : machines) {
            MachineRunItem runItem = this.getMachineRunItem(machine);
            if (runItem.isFavorite()) {
                this._favorites.add((RunnableItem)runItem);
            }
            machineRunItems.add(runItem);
        }
        Collections.sort(machineRunItems, new RunProviderItemComparator());
        return machineRunItems;
    }

    private List<RunProviderItem> toItems(List<MachineDescriptor> machines) {
        ArrayList<MachineRunItem> favs = new ArrayList<MachineRunItem>();
        for (MachineDescriptor machine : machines) {
            if (!machine.isFavorite()) continue;
            favs.add(this.getMachineRunItem(machine));
        }
        ArrayList<Object> items = new ArrayList<Object>();
        if (!favs.isEmpty()) {
            items.add((Object)new MachineSetItem(FAVORITES, favs, FAVORITES_LAF_PREFIX));
        }
        for (MachineDescriptor machine : machines) {
            MachineRunItem runItem = this.getMachineRunItem(machine);
            if (runItem.isFavorite()) {
                this._favorites.add((RunnableItem)runItem);
            }
            items.add((Object)runItem);
        }
        return Collections.singletonList(new MachinesItem(items));
    }

    private MachineRunItem getMachineRunItem(MachineDescriptor machine) {
        String machineName = machine.getName();
        MachineRunItem runItem = this._itemCache.get(machineName);
        if (runItem == null) {
            runItem = new MachineRunItem(machineName);
            this._itemCache.put(machineName, runItem);
        }
        return runItem;
    }

    private class MachineFavoritesListener
    implements PropertyChangeListener {
        private MachineFavoritesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MachineRunProvider.this.updateItems();
        }
    }

    private class MachineRunListener
    implements MachineRuntimeListener {
        private MachineRunListener() {
        }

        @Override
        public void machineProgress(MachineRuntimeEvent event) {
            MachineDescriptor machine = event.getMachine();
            MachineRunItem runItem = MachineRunProvider.this.getMachineRunItem(machine);
            RuntimeState state = event.getState();
            switch (state) {
                case Running: 
                case Paused: 
                case Waiting: {
                    MachineRunningItem child = this.getOrCreateRunningItem(runItem);
                    child.setState(state);
                    String msg = event.getMessage();
                    if (msg == null) break;
                    child.setMessage(msg);
                    break;
                }
                case Cancelled: 
                case Completed: 
                case Failed: {
                    runItem.setChild(null);
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                MachineRunProvider.this.fireItemsChanged();
            } else {
                SwingUtilities.invokeLater(() -> MachineRunProvider.this.fireItemsChanged());
            }
        }

        private MachineRunningItem getOrCreateRunningItem(MachineRunItem runItem) {
            MachineRunningItem child = runItem.getChild();
            if (child == null) {
                child = new MachineRunningItem(runItem.getMachine());
                runItem.setChild(child);
            }
            return child;
        }
    }
}

