/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.runtime;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.InitializationContext;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.runtime.MachineRuntimeException;
import com.paterva.maltego.automation.runtime.State;
import com.paterva.maltego.automation.runtime.StateSupport;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.transform.runner.api.GlobalInputProvider;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.openide.loaders.DataObject;

class RuntimeElement
extends StateSupport {
    private int _inputCount;
    private Action _action;
    private Collection<Payload> _inputs;
    private Collection<RuntimeElement> _dependants;
    private static final PropertyDescriptor SLIDER = new PropertyDescriptor(Integer.class, "maltego.global.slider");

    public RuntimeElement(int inputCount, Action action, Collection<RuntimeElement> dependants) {
        this._dependants = dependants;
        this._inputCount = inputCount;
        this._action = action;
    }

    public synchronized void input(Payload payload) throws MachineRuntimeException {
        if (this._inputs == null) {
            this._inputs = this.createInputCollection();
        }
        if (this._inputCount <= this._inputs.size()) {
            throw new MachineRuntimeException(String.format("More inputs have been added than the %d supported for action '%s'.", this._inputCount, this._action));
        }
        this._inputs.add(payload);
        if (this._inputCount == this._inputs.size()) {
            this.setState(State.Ready);
        }
    }

    protected Collection<Payload> getInputs() {
        return this._inputs;
    }

    @Override
    public synchronized void start(final AutomationContext context) throws MachineRuntimeException {
        if (!this.isReady()) {
            throw new MachineRuntimeException("Call to run() without being ready.");
        }
        if (this.isCompleted()) {
            throw new MachineRuntimeException("Call to run() when already completed.");
        }
        this.setState(State.Busy);
        A licenseMode = LicenseManager.A().A(false);
        Payload input = licenseMode.Q() ? Payloads.max(Payloads.fromPayloads(this._inputs), (Integer)GlobalInputProvider.getDefault().getInputs().getValue(SLIDER)) : Payloads.fromPayloads(this._inputs);
        input.sync();
        if (this._action != null) {
            this._action.start(context, input, new Action.Callback(){

                @Override
                public void completed(Payload output) {
                    RuntimeElement.this.actionCompleted(context, output);
                }

                @Override
                public void failed(String message, Exception e) {
                    RuntimeElement.this.actionFailed(context, message, e);
                }
            });
        } else {
            this.actionCompleted(context, input);
        }
    }

    protected synchronized void clearInput() {
        if (this._inputs != null) {
            this._inputs.clear();
        }
    }

    @Override
    public void cancel() {
        if (this._action != null) {
            this._action.cancel();
        }
    }

    @Override
    public InitializationContext initialize(Payload initialPayload) {
        if (this._action != null) {
            return this._action.initialize(initialPayload);
        }
        return InitializationContext.getEmpty();
    }

    private void actionCompleted(final AutomationContext ctx, final Payload output) {
        this.clearInput();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    RuntimeElement.this.setState(State.Completed);
                    RuntimeElement.this.route(output);
                }
                catch (MachineRuntimeException ex) {
                    RuntimeElement.this.handleError(ctx.getTarget(), null, ex);
                }
            }
        });
    }

    private void actionFailed(final AutomationContext ctx, final String message, final Exception e) {
        this.clearInput();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RuntimeElement.this.handleError(ctx.getTarget(), message, e);
            }
        });
    }

    private void handleError(DataObject target, String message, Exception e) {
        MachineMessageHandler.getDefault().error(target, this.buildErrorMessage(message, e), new Object[0]);
        this.setState(State.Failed);
    }

    private String buildErrorMessage(String message, Exception e) {
        StringBuilder buffer = new StringBuilder();
        if (this._action != null) {
            buffer.append(this._action.getName());
            buffer.append(" failed");
            if (message != null || e != null) {
                buffer.append(": ");
            }
        }
        if (message != null) {
            buffer.append(message);
            if (e != null) {
                buffer.append(": ");
            }
        }
        if (e != null) {
            buffer.append(e.getMessage());
        }
        return buffer.toString();
    }

    private Collection<Payload> createInputCollection() {
        return new LinkedList<Payload>();
    }

    private void route(Payload output) throws MachineRuntimeException {
        if (this._dependants != null) {
            for (RuntimeElement dep : this._dependants) {
                dep.input(output);
            }
        }
    }

    public String toString() {
        return String.format("%s [%s]", this.getActionName(), this.dependantsToString());
    }

    protected String getActionName() {
        if (this._action == null) {
            return null;
        }
        return this._action.getName();
    }

    private String dependantsToString() {
        StringBuilder buffer = new StringBuilder();
        if (this._dependants != null) {
            for (RuntimeElement e : this._dependants) {
                buffer.append(String.format("%s,", e.getActionName()));
            }
        }
        if (buffer.length() > 0) {
            return buffer.substring(0, buffer.length() - 1);
        }
        return "";
    }

    @Override
    public Action getAction() {
        return this._action;
    }
}

