/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.discover.DiscoveryContext;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryItems;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryProvider;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.imex.MachineImporter;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.DefaultHubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Exceptions;

public class MachineDiscoveryProvider
extends MtzDiscoveryProvider<MtzMachines> {
    private final Map<String, Map<String, MachineDescriptor>> machinesPerHubItem = new HashMap<String, Map<String, MachineDescriptor>>();

    public MtzMachines read(DiscoveryContext ctx, MaltegoArchiveReader reader) throws IOException {
        MachineImporter importer = new MachineImporter();
        return new MtzMachines(importer.read(reader), ctx);
    }

    public void apply(MtzMachines machines) {
        for (MachineDescriptor machine : machines.getMachines()) {
            machine.setReadOnly(true);
        }
        DiscoveryContext ctx = machines.getContext();
        String seedUrl = ctx.getSeedUrl();
        HubSeedDescriptor hubSeed = HubSeedRegistry.getDefault().getHubSeed(seedUrl);
        String hubItem = hubSeed == null ? null : hubSeed.getName();
        MachineImporter importer = new MachineImporter();
        importer.apply(machines.getMachines(), hubItem);
        if (hubItem != null) {
            Map<String, MachineDescriptor> machinesForHubItem = this.machinesPerHubItem.get(hubItem);
            if (machinesForHubItem == null) {
                machinesForHubItem = new HashMap<String, MachineDescriptor>();
                this.machinesPerHubItem.put(hubItem, machinesForHubItem);
            }
            for (MachineDescriptor machine : machines.getMachines()) {
                machinesForHubItem.put(machine.getName(), machine);
            }
        }
    }

    public void cleanup() {
        ArrayList<? extends MachineDescriptor> repoMachines;
        MachineRepository repo = MachineRepository.getDefault();
        for (Map.Entry<String, Map<String, MachineDescriptor>> entry : this.machinesPerHubItem.entrySet()) {
            String hubItem = entry.getKey();
            try {
                Map<String, MachineDescriptor> machinesForHubItem = entry.getValue();
                repoMachines = new ArrayList<MachineDescriptor>(repo.getAll());
                for (MachineDescriptor machineDescriptor : repoMachines) {
                    if (!machineDescriptor.getHubItems().contains(hubItem) || machinesForHubItem.containsKey(machineDescriptor.getName())) continue;
                    machineDescriptor.removeHubItem(hubItem);
                    if (!machineDescriptor.getHubItems().isEmpty()) continue;
                    repo.remove(machineDescriptor);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.machinesPerHubItem.clear();
        HubSeedRegistry hubSeedRegistry = DefaultHubSeedRegistry.getDefault();
        if (hubSeedRegistry.isOnline()) {
            HubSeeds seeds = hubSeedRegistry.getSeeds(false);
            ArrayList<String> allInstalledHubItems = new ArrayList<String>();
            HubSeedSettings settings = HubSeedSettings.getDefault();
            for (HubSeedDescriptor seed : seeds.getSeeds()) {
                if (!settings.isInstalled(seed)) continue;
                allInstalledHubItems.add(seed.getName());
            }
            try {
                repoMachines = new ArrayList<MachineDescriptor>(repo.getAll());
                for (MachineDescriptor machineDescriptor : repoMachines) {
                    ArrayList<String> machineHubItems = new ArrayList<String>(machineDescriptor.getHubItems());
                    machineHubItems.removeAll(allInstalledHubItems);
                    for (String machineHubItem : machineHubItems) {
                        machineDescriptor.removeHubItem(machineHubItem);
                        if (!machineDescriptor.getHubItems().isEmpty()) continue;
                        repo.remove(machineDescriptor);
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public MtzMachines getNewAndMerged(MtzMachines items) {
        List<MachineDescriptor> machines = items.getMachines();
        ArrayList<MachineDescriptor> newMachines = new ArrayList<MachineDescriptor>();
        MachineRepository repository = MachineRepository.getDefault();
        for (MachineDescriptor newMachine : machines) {
            try {
                MachineDescriptor oldMachine = repository.get(newMachine.getName());
                if (oldMachine != null && oldMachine.isCopy(newMachine)) continue;
                newMachines.add(newMachine);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return new MtzMachines(newMachines, items.getContext());
    }

    public class MtzMachines
    extends MtzDiscoveryItems {
        private final List<MachineDescriptor> _machines;

        private MtzMachines(List<MachineDescriptor> machines, DiscoveryContext context) {
            super((MtzDiscoveryProvider)MachineDiscoveryProvider.this, context);
            this._machines = machines;
        }

        public String getDescription() {
            return "Machines";
        }

        public List<MachineDescriptor> getMachines() {
            return this._machines;
        }

        public int size() {
            return this._machines.size();
        }
    }
}

