/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions.userfilter;

import com.paterva.maltego.automation.actions.userfilter.UserFilterDescriptor;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.util.ui.dialog.WindowHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public abstract class UserFilterManager {
    private Map<DataObject, LinkedList<UserFilterTask>> _queues;
    private Set<DataObject> _dialogsShowing;

    public static UserFilterManager getDefault() {
        UserFilterManager manager = (UserFilterManager)Lookup.getDefault().lookup(UserFilterManager.class);
        if (manager == null) {
            manager = new TrivialFilterManager();
        }
        return manager;
    }

    public Object show(UserFilterDescriptor descriptor, UserFilterCallback cb) {
        UserFilterTask task = new UserFilterTask(descriptor, cb);
        this.addToQueue(descriptor.getContext().getTarget(), task);
        this.processQueue(descriptor.getContext().getTarget());
        return task;
    }

    public void close(Object handle) {
        if (handle instanceof UserFilterTask) {
            UserFilterTask task = (UserFilterTask)handle;
            this.removeTask(task);
            if (task.getWindowHandle() != null && this.closeOne(task.getWindowHandle())) {
                this.setDialogShowing(task.getDescriptor().getContext().getTarget(), false);
            }
        } else {
            throw new IllegalArgumentException("Close handle must be an instance of UserFilterTask");
        }
    }

    private void removeTask(UserFilterTask task) {
        DataObject owner = null;
        if (this._queues != null) {
            LinkedList<UserFilterTask> tasks;
            for (Map.Entry<DataObject, LinkedList<UserFilterTask>> entry : this._queues.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().remove(task)) continue;
                owner = entry.getKey();
            }
            if (owner != null && (tasks = this._queues.get(owner)).isEmpty()) {
                this._queues.remove(owner);
            }
        }
    }

    protected abstract boolean closeOne(WindowHandle var1);

    private void addToQueue(DataObject target, UserFilterTask task) {
        LinkedList<UserFilterTask> tasks;
        if (this._queues == null) {
            this._queues = new HashMap<DataObject, LinkedList<UserFilterTask>>();
        }
        if ((tasks = this._queues.get(target)) == null) {
            tasks = new LinkedList();
            this._queues.put(target, tasks);
        }
        tasks.add(task);
    }

    private boolean dialogShowing(DataObject target) {
        if (this._dialogsShowing == null) {
            return false;
        }
        return this._dialogsShowing.contains(target);
    }

    private void setDialogShowing(DataObject target, boolean value) {
        if (value) {
            if (this._dialogsShowing == null) {
                this._dialogsShowing = new HashSet<DataObject>();
            }
            this._dialogsShowing.add(target);
        } else {
            this._dialogsShowing.remove(target);
        }
    }

    private boolean isQueueEmpty(DataObject target) {
        LinkedList<UserFilterTask> tasks;
        if (this._queues != null && (tasks = this._queues.get(target)) != null) {
            return tasks.isEmpty();
        }
        return true;
    }

    private UserFilterTask pop(DataObject target) {
        LinkedList<UserFilterTask> tasks;
        if (this._queues != null && (tasks = this._queues.get(target)) != null) {
            UserFilterTask task = tasks.pop();
            if (task == null || tasks.isEmpty()) {
                this._queues.remove(target);
            }
            return task;
        }
        return null;
    }

    protected abstract WindowHandle showOne(UserFilterDescriptor var1, UserFilterCallback var2);

    private void processQueue(DataObject target) {
        if (!this.dialogShowing(target) && !this.isQueueEmpty(target)) {
            UserFilterTask task = this.pop(target);
            this.show(target, task);
        }
    }

    private void show(final DataObject target, final UserFilterTask task) {
        this.setDialogShowing(target, true);
        WindowHandle window = this.showOne(task.getDescriptor(), new UserFilterCallback(){

            @Override
            public void onResume(Collection<MaltegoEntity> selected, Collection<MaltegoEntity> toDelete) {
                task.getCallback().onResume(selected, toDelete);
                UserFilterManager.this.setDialogShowing(target, false);
                UserFilterManager.this.processQueue(target);
            }
        });
        task.setWindowHandle(window);
    }

    private static class TrivialFilterManager
    extends UserFilterManager {
        private TrivialFilterManager() {
        }

        @Override
        protected boolean closeOne(WindowHandle handle) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected WindowHandle showOne(UserFilterDescriptor descriptor, UserFilterCallback cb) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static interface UserFilterCallback {
        public void onResume(Collection<MaltegoEntity> var1, Collection<MaltegoEntity> var2);
    }

    private class UserFilterTask {
        private UserFilterDescriptor _descriptor;
        private UserFilterCallback _cb;
        private WindowHandle _windowHandle;

        public UserFilterTask(UserFilterDescriptor descriptor, UserFilterCallback cb) {
            this._descriptor = descriptor;
            this._cb = cb;
        }

        public UserFilterDescriptor getDescriptor() {
            return this._descriptor;
        }

        public UserFilterCallback getCallback() {
            return this._cb;
        }

        public WindowHandle getWindowHandle() {
            return this._windowHandle;
        }

        public void setWindowHandle(WindowHandle handle) {
            this._windowHandle = handle;
        }
    }
}

