/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.InitializationContext;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.PropertySupport;
import com.paterva.maltego.automation.actions.VariableStore;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.api.TransformInputProvider;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformRunManager;
import com.paterva.maltego.transform.runner.api.TransformServerMap;
import com.paterva.maltego.transform.runner.api.TransformServerMapProvider;
import com.paterva.maltego.transform.runner.api.TransformsCallback;
import com.paterva.maltego.transform.runner.api.TransformsHandle;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.collections.CompoundReadonlyCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

class RunTransformAction
extends PropertySupport
implements Action,
DataSource {
    private static final Logger LOG = Logger.getLogger(RunTransformAction.class.getName());
    private TransformDefinition _transform;
    private DataSource _inputs;
    private static final String DOB_VARIABLE = "maltego.automation.dob";
    private TransformsHandle _handle;
    private boolean _cancelled = false;
    private static final int PROGRESS_TICKS = 3;

    public RunTransformAction(TransformDefinition transform) {
        this._transform = transform;
    }

    protected RunTransformAction() {
    }

    protected boolean ignoreSeenEntities() {
        return (Boolean)this.getProperty("ignoreSeenEntities", true);
    }

    @Override
    public String getName() {
        String name = (String)this.getValue();
        if (name != null) {
            name = this.stripNamespace(name);
        }
        return String.format("%s(%s)", this.getSimpleName(), name);
    }

    @Override
    public String getSimpleName() {
        return "run";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        if (payload.isEmpty()) {
            cb.completed(Payloads.getEmpty());
        } else {
            TransformDefinition transform = this.getTransform();
            if (transform == null) {
                cb.failed("Transform does not exist", null);
            } else {
                LOG.log(Level.FINE, "Running {0}", transform.getDisplayName());
                TransformServerMap serverMap = TransformServerMapProvider.getDefault().get(Collections.singleton(transform), null);
                Map.Entry entry = serverMap.getMap().entrySet().iterator().next();
                transform = (TransformDefinition)entry.getKey();
                TransformServerInfo tas = (TransformServerInfo)entry.getValue();
                if (tas == null) {
                    cb.failed(String.format("No server found for transform '%s'. Has the TAS been removed since writing this machine?", transform.getName()), null);
                } else {
                    DataSource inputs = this.getTransformInputs(transform, tas);
                    if (inputs != null) {
                        ctx.getLogger().info(this.getName(), new Object[0]);
                        GraphID graphID = ctx.getTargetGraphID();
                        EntityRegistry entityRegistry = ctx.getEntityRegistry();
                        EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
                        LinkFactory linkFactory = LinkFactory.forGraphID((GraphID)graphID);
                        TransformsCallback runCallback = this.createCallback(ctx, cb);
                        Set ids = GraphStoreHelper.getIds(payload.getEntities());
                        this._handle = TransformRunManager.getDefault().runTransform(graphID, transform, tas, inputs, ids, entityRegistry, entityFactory, linkFactory, false, runCallback);
                    } else {
                        cb.failed("Transform input cancelled", null);
                    }
                }
            }
        }
    }

    private Set<MaltegoEntity> getSeenList(AutomationContext ctx) {
        Set seenList = (Set)ctx.getGlobal(this);
        if (seenList == null) {
            seenList = Collections.newSetFromMap(new WeakHashMap());
            ctx.setGlobal(this, seenList);
        }
        return seenList;
    }

    public DataSource getTransformInputs(TransformDefinition transform, TransformServerInfo server) {
        Map<PropertyDescriptor, Object> settings = this.overrideTransformSettings(transform);
        this._inputs = TransformInputProvider.getDefault().getInputs(transform, server);
        this.restoreTransformSettings(transform, settings);
        return this._inputs != null ? this : null;
    }

    private TransformsCallback createCallback(final AutomationContext ctx, final Action.Callback cb) {
        return new TransformsCallback(){
            private final Set<MaltegoEntity> _new = new HashSet<MaltegoEntity>();
            private final Set<MaltegoEntity> _merged = new HashSet<MaltegoEntity>();
            private boolean _transformCompleted = false;

            public void onTransformResultAddedToTargetGraph(TransformRunContext transformCtx, Collection<MaltegoEntity> newEntities, Collection<MaltegoEntity> mergedEntities) {
                LOG.log(Level.FINE, "Transform result from {0}, {1} new and {2} merged entities", new Object[]{transformCtx.getTransform(), newEntities != null ? newEntities.size() : 0, mergedEntities != null ? mergedEntities.size() : 0});
                if (!RunTransformAction.this._cancelled) {
                    this.setDateOfBirth(ctx, newEntities);
                    this.setDateOfBirth(ctx, mergedEntities);
                    this.addToSets(newEntities, mergedEntities);
                }
            }

            public void onTransformError(TransformRunContext ctx2, List<TransformMessage> messages) {
                RunTransformAction.this._handle = null;
            }

            public void onTransformComplete(TransformRunContext transformCtx) {
                if (!this._transformCompleted) {
                    LOG.log(Level.FINE, "Transform complete: {0}", transformCtx.getTransform());
                    this._transformCompleted = true;
                    RunTransformAction.this._handle = null;
                    Set seen = RunTransformAction.this.getSeenList(ctx);
                    Payload payload = this.createPayload(seen);
                    this.add(seen, payload);
                    ctx.progress(3);
                    cb.completed(payload);
                }
            }

            private void setDateOfBirth(AutomationContext ctx2, Collection<MaltegoEntity> entities) {
                if (entities != null) {
                    DateTime now = new DateTime(System.currentTimeMillis());
                    VariableStore.setValue(ctx2, entities, RunTransformAction.DOB_VARIABLE, now, true, true);
                }
            }

            private void addToSets(Collection<MaltegoEntity> newEntities, Collection<MaltegoEntity> mergedEntities) {
                if (newEntities != null) {
                    this._new.addAll(newEntities);
                }
                if (mergedEntities != null) {
                    for (MaltegoEntity merged : mergedEntities) {
                        if (this._new.contains(merged)) {
                            this._new.add(merged);
                            continue;
                        }
                        this._merged.add(merged);
                    }
                }
            }

            private Payload createPayload(Set<MaltegoEntity> seen) {
                if (this._new.isEmpty() && this._merged.isEmpty()) {
                    return Payloads.getEmpty();
                }
                Collection<MaltegoEntity> merged = RunTransformAction.this.ignoreSeenEntities() ? this.subtract(this._merged, seen) : this._merged;
                return Payloads.fromEntities((Collection<MaltegoEntity>)new CompoundReadonlyCollection(new Collection[]{this._new, merged}));
            }

            private void add(Set<MaltegoEntity> seen, Payload payload) {
                if (RunTransformAction.this.ignoreSeenEntities()) {
                    for (MaltegoEntity entity : payload.getEntities()) {
                        seen.add(entity);
                    }
                }
            }

            private Collection<MaltegoEntity> subtract(Collection<MaltegoEntity> a, Collection<MaltegoEntity> b) {
                a.removeAll(b);
                return a;
            }
        };
    }

    public TransformDefinition getTransform() {
        return this._transform;
    }

    private String stripNamespace(String name) {
        int index = name.lastIndexOf(".");
        if (index >= 0 && index < name.length()) {
            return name.substring(index + 1, name.length());
        }
        return name;
    }

    private Map<PropertyDescriptor, Object> overrideTransformSettings(TransformDefinition transform) {
        HashMap<PropertyDescriptor, Object> backup = new HashMap<PropertyDescriptor, Object>();
        DisplayDescriptorCollection properties = transform.getProperties();
        for (DisplayDescriptor dd : properties) {
            Object value = this.getProperty((PropertyDescriptor)dd);
            if (value == null) continue;
            backup.put((PropertyDescriptor)dd, transform.getValue((PropertyDescriptor)dd));
            transform.setValue((PropertyDescriptor)dd, value);
        }
        return backup;
    }

    private void restoreTransformSettings(TransformDefinition transform, Map<PropertyDescriptor, Object> settings) {
        for (Map.Entry<PropertyDescriptor, Object> entry : settings.entrySet()) {
            PropertyDescriptor pd = entry.getKey();
            Object value = entry.getValue();
            transform.setValue(pd, value);
        }
    }

    public Object getValue(PropertyDescriptor descriptor) {
        Object slider;
        if ("maltego.global.slider".equals(descriptor.getName()) && (slider = this.getProperty("slider")) != null) {
            A licenseMode;
            int sliderValue = (Integer)slider;
            if (sliderValue > 10000) {
                sliderValue = 10000;
            }
            if (sliderValue <= 0) {
                sliderValue = 12;
            }
            if ((licenseMode = LicenseManager.A().A(false)).Q()) {
                sliderValue = Math.min(sliderValue, 12);
            }
            return sliderValue;
        }
        Object value = this.getProperty(descriptor);
        return value != null ? value : this._inputs.getValue(descriptor);
    }

    public void setValue(PropertyDescriptor descriptor, Object value) {
    }

    public void clear() {
    }

    private Object getProperty(PropertyDescriptor descriptor) {
        Object value = this.getProperty(descriptor.getName());
        if (value != null) {
            Class<?> fromType = value.getClass();
            Class toType = descriptor.getType();
            if (!Converter.isAssignableFrom((Class)toType, fromType)) {
                try {
                    value = Converter.convert((Object)value, fromType, (Class)toType);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    value = null;
                }
            }
        }
        return value;
    }

    @Override
    public MachineInput getInputDescriptor() {
        return new TransformConstraint(this.getTransform());
    }

    @Override
    public void cancel() {
        this._cancelled = true;
        if (this._handle != null) {
            TransformRunManager.getDefault().cancel(this._handle);
        }
    }

    @Override
    public InitializationContext initialize(final Payload initialPayload) {
        return new InitializationContext(){
            Payload _initialPayload;
            {
                this._initialPayload = initialPayload;
            }

            @Override
            public String[] getErrors() {
                ArrayList<String> errors = new ArrayList<String>();
                EntityRegistry entityRegistry = EntityRegistry.getDefault();
                ArrayList<String> missingEntities = new ArrayList<String>();
                this.checkMissingStartEntity(entityRegistry, missingEntities);
                TransformDefinition def = RunTransformAction.this.getTransform();
                if (def == null) {
                    errors.add(String.format(MachineMessageHandler.TRANSFORM_PREFIX + " '%s' was not found.", RunTransformAction.this.getValue()));
                } else {
                    this.checkMissingOutputEntities(def, entityRegistry, missingEntities);
                }
                if (!errors.isEmpty() || !missingEntities.isEmpty()) {
                    for (String missingEntity : missingEntities) {
                        errors.add(String.format("The entity '%s' was not found.", missingEntity));
                    }
                    return errors.toArray(new String[errors.size()]);
                }
                return null;
            }

            @Override
            public int getProgressSteps() {
                return 3;
            }

            private void checkMissingOutputEntities(TransformDefinition def, EntityRegistry entityRegistry, List<String> missingEntities) {
                Set outputEntities = def.getOutputEntities();
                for (String output : outputEntities) {
                    for (String split : output.split(",")) {
                        String trimmed = split.trim();
                        this.checkMissingEntities(trimmed, entityRegistry, missingEntities);
                    }
                }
            }

            private void checkMissingStartEntity(EntityRegistry entityRegistry, List<String> missingEntities) {
                Collection<MaltegoEntity> entities;
                if (this._initialPayload != null && (entities = this._initialPayload.getEntities()).size() < 100) {
                    for (MaltegoEntity entity : entities) {
                        String trimmed = entity.getTypeName().trim();
                        this.checkMissingEntities(trimmed, entityRegistry, missingEntities);
                    }
                }
            }

            private void checkMissingEntities(String trimmed, EntityRegistry entityRegistry, List<String> missingEntities) {
                if (trimmed.length() > 0 && !entityRegistry.contains(trimmed) && !missingEntities.contains(trimmed)) {
                    missingEntities.add(trimmed);
                }
            }
        };
    }

    private static class TransformConstraint
    implements MachineInput {
        private final TransformDefinition _transform;

        public TransformConstraint(TransformDefinition transform) {
            this._transform = transform;
        }

        @Override
        public boolean isSatisfiedByAny(AutomationContext ctx, Payload payload, InheritedTypesProvider typesProvider) {
            Collection<EntityID> entityIDs = payload.getEntityIDs();
            Set<Object> entityIDSet = entityIDs instanceof Set ? (Set<Object>)entityIDs : new HashSet<EntityID>(entityIDs);
            return this._transform != null && this._transform.getInputConstraint().isSatisfiedByAny(ctx.getTargetGraphID(), (Set)entityIDSet, typesProvider);
        }

        @Override
        public String[] getSupportedEntityTypes() {
            String type;
            String string = type = this._transform != null ? this._transform.getInputConstraint().getDisplay() : null;
            if (type == null || type.length() == 0) {
                return new String[0];
            }
            return new String[]{type};
        }

        @Override
        public boolean continueCheck() {
            return false;
        }

        public String toString() {
            return String.format("TRANSFORM(%s)", this._transform.getName());
        }
    }
}

