/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.archive.mtz.discover.DiscoveryMergingRules;
import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.ProgressCallback;
import com.paterva.maltego.transform.discovery.TransformFinder;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.discovery.TransformUpdater;
import com.paterva.maltego.transform.finder.wizard.FailurePanel;
import com.paterva.maltego.transform.finder.wizard.ProgressHandleAdapter;
import com.paterva.maltego.transform.finder.wizard.UpdateResultPanel;
import com.paterva.maltego.transform.finder.wizard.UpdateResultText;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformFindException;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;

class UpdateTransformsController
extends PassFailProgressController<DiscoveryResult<TransformServerListing>, UpdateResultPanel, FailurePanel>
implements WizardNavigationSupport {
    UpdateTransformsController() {
    }

    protected DiscoveryResult<TransformServerListing> doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws DiscoveryException {
        TransformFinder finder = TransformFinder.getDefault();
        ProgressHandleAdapter progress = new ProgressHandleAdapter(handle);
        HubSeedDescriptor hubSeed = (HubSeedDescriptor)descriptor.getProperty("hubItem");
        TransformSeed[] seeds = (TransformSeed[])descriptor.getProperty("transformSeeds");
        Boolean removeMissing = (Boolean)descriptor.getProperty("removeMissing");
        DiscoveryResult references = finder.findServers(seeds, (ProgressCallback)progress);
        if (references.getData() == null || ((TransformServerReference[])references.getData()).length == 0) {
            Exception[] errors = references.getErrors();
            if (errors != null && errors.length > 0) {
                throw new DiscoveryException((Throwable)errors[0]);
            }
            throw new DiscoveryException("No transforms were found");
        }
        DiscoveryResult details = finder.getDetails((TransformServerReference[])references.getData(), (ProgressCallback)progress);
        if (details.getData() == null || ((TransformServerDetail[])details.getData()).length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        DiscoveryResult listings = finder.listTransforms((TransformServerDetail[])details.getData(), (ProgressCallback)progress);
        Object[] data = (TransformServerListing[])listings.getData();
        if (data == null || data.length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        handle.progress("Updating transforms and entities...");
        try {
            TransformUpdater txUpdater = TransformUpdater.getDefault();
            if (removeMissing.booleanValue()) {
                txUpdater.removeMissing((TransformServerListing[])data);
            }
            txUpdater.updateServers((TransformServerListing[])data);
            Exception[] errors = references.getErrors();
            if (errors == null || errors.length == 0) {
                txUpdater.removeMissingServers((TransformServerReference[])references.getData());
            }
            listings = new DiscoveryResult(data);
            txUpdater.update(hubSeed, (TransformServerListing[])data, DiscoveryMergingRules.getDefault());
        }
        catch (IOException ex) {
            throw new DiscoveryException((Throwable)ex);
        }
        return listings;
    }

    protected UpdateResultPanel createPassComponent() {
        return new UpdateResultPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, UpdateResultPanel component, DiscoveryResult<TransformServerListing> result) {
        UpdateResultText urt = new UpdateResultText();
        component.setText(urt.get((TransformServerListing[])result.getData()));
        component.setDuplicateTransforms(UpdateTransformsController.getDuplicateTransforms((TransformServerListing[])result.getData()));
        descriptor.putProperty("success", (Object)Boolean.TRUE);
    }

    protected void fail(FailurePanel component, Exception e) {
        if (e == null) {
            component.setError(null);
        } else if (e instanceof DiscoveryException) {
            component.setError(e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null) {
                String msg = cause.getMessage();
                if (msg != null) {
                    component.setError(msg);
                }
                boolean knownCause = false;
                if (cause instanceof CertificateNeedValidationException) {
                    knownCause = this.setErrorMsg(msg, component);
                } else if (cause instanceof NoTrustedCertificateChainFoundException) {
                    knownCause = this.setErrorMsg(msg, component);
                } else if (cause instanceof RemoteTransformFindException) {
                    knownCause = this.setErrorMsg(msg, component);
                }
                if (knownCause) {
                    component.setTitle("Certificate chain is not trusted.");
                    String extraInfo = "Rerun this wizard from the \"Transform Hub\" item under the \"Transforms\" ribbon tab after the certificate has been trusted.";
                    component.setMessage(extraInfo);
                }
            }
        } else {
            component.setError(e.getMessage());
        }
    }

    public boolean canBack() {
        return false;
    }

    protected String getFailureMessage() {
        int index3;
        int index2;
        int index1;
        String msg = super.getFailureMessage();
        if (msg != null && (index1 = msg.indexOf(" [Action:")) > -1 && (index2 = msg.indexOf("]", index1)) > -1 && (index3 = (msg = msg.substring(0, index2 + 1)).indexOf("n:")) > -1) {
            msg = msg.substring(0, index3 + 1);
        }
        return msg;
    }

    private boolean setErrorMsg(String msg, FailurePanel component) {
        int index2;
        int index1;
        boolean knownCause = false;
        if (msg != null && (index1 = msg.indexOf(" [Action:")) > -1 && (index2 = msg.indexOf("]", index1)) > -1) {
            msg = msg.substring(0, index2 + 1);
            knownCause = true;
            component.setError(msg);
        }
        return knownCause;
    }

    public static Map<HubSeedDescriptor, Set<TransformDescriptor>> getDuplicateTransforms(TransformServerListing[] data) {
        HashMap<HubSeedDescriptor, Set<TransformDescriptor>> duplicates = new HashMap<HubSeedDescriptor, Set<TransformDescriptor>>();
        for (TransformServerListing listing : data) {
            for (Map.Entry entry : listing.getDuplicateTransforms().entrySet()) {
                TransformDescriptor transform = (TransformDescriptor)entry.getKey();
                HubSeedDescriptor hubSeed = (HubSeedDescriptor)entry.getValue();
                HashSet<TransformDescriptor> transforms = (HashSet<TransformDescriptor>)duplicates.get(hubSeed);
                if (transforms == null) {
                    transforms = new HashSet<TransformDescriptor>();
                    duplicates.put(hubSeed, transforms);
                }
                transforms.add(transform);
            }
        }
        return duplicates;
    }
}

