/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz.discover;

import java.util.prefs.Preferences;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public abstract class DiscoveryMergingRules {
    private static DiscoveryMergingRules _default;

    public static synchronized DiscoveryMergingRules getDefault() {
        if (_default == null && (_default = (DiscoveryMergingRules)Lookup.getDefault().lookup(DiscoveryMergingRules.class)) == null) {
            _default = new Default();
        }
        return _default;
    }

    public abstract EntityRule getEntityRule();

    public abstract void setEntityRule(EntityRule var1);

    public abstract IconRule getIconRule();

    public abstract void setIconRule(IconRule var1);

    private static class Default
    extends DiscoveryMergingRules {
        private final String PREF_ENTITY_RULE = "maltego.discover.match.entity";
        private final String PREF_ICON_RULE = "maltego.discover.match.icon";

        private Default() {
        }

        @Override
        public EntityRule getEntityRule() {
            return EntityRule.valueOf(this.getPrefs().get("maltego.discover.match.entity", EntityRule.MERGE.name()));
        }

        @Override
        public void setEntityRule(EntityRule rule) {
            this.getPrefs().put("maltego.discover.match.entity", rule.name());
        }

        @Override
        public IconRule getIconRule() {
            return IconRule.valueOf(this.getPrefs().get("maltego.discover.match.icon", IconRule.IGNORE.name()));
        }

        @Override
        public void setIconRule(IconRule rule) {
            this.getPrefs().put("maltego.discover.match.icon", rule.name());
        }

        private Preferences getPrefs() {
            return NbPreferences.forModule(DiscoveryMergingRules.class);
        }
    }

    public static class Replace
    extends DiscoveryMergingRules {
        @Override
        public EntityRule getEntityRule() {
            return EntityRule.REPLACE;
        }

        @Override
        public void setEntityRule(EntityRule rule) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public IconRule getIconRule() {
            return IconRule.REPLACE;
        }

        @Override
        public void setIconRule(IconRule rule) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static enum IconRule {
        REPLACE,
        IGNORE;

    }

    public static enum EntityRule {
        REPLACE,
        MERGE,
        IGNORE;

    }
}

