/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.ArabicLigaturizer;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.HebrewLigaturizer;
import com.lowagie.text.pdf.PdfPCell;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class iTextStyle {
    public Set<String> availableFonts;
    public List<BaseFont> baseFontList;
    public List<Font> fontList;

    public abstract Color getBackColor(boolean var1);

    public abstract String getFontType(boolean var1);

    public abstract float getFontSize(boolean var1);

    public abstract int getFontStyle(boolean var1);

    public abstract Color getFontColor(boolean var1);

    public abstract int getPadding(boolean var1);

    public abstract int getBorder(boolean var1);

    public List<Font> getFontList(boolean header) {
        this.fontList = new ArrayList<Font>();
        Font preferredFont = FontFactory.getFont(this.getFontType(header), this.getFontSize(header), this.getFontStyle(header), this.getFontColor(header));
        this.fontList.add(preferredFont);
        for (BaseFont baseFont : this.baseFontList) {
            Font font = new Font(baseFont, this.getFontSize(header), this.getFontStyle(header), this.getFontColor(header));
            String familyname = font.getFamilyname();
            if (StringUtilities.isNullOrEmpty((String)familyname)) continue;
            this.fontList.add(font);
        }
        return this.fontList;
    }

    public FontSelector getFontSelector(boolean header) {
        FontSelector fs = new FontSelector();
        Font preferredFont = FontFactory.getFont(this.getFontType(header), this.getFontSize(header), this.getFontStyle(header), this.getFontColor(header));
        fs.addFont(preferredFont);
        for (BaseFont baseFont : this.baseFontList) {
            Font font = new Font(baseFont, this.getFontSize(header), this.getFontStyle(header), this.getFontColor(header));
            String familyname = font.getFamilyname();
            if (StringUtilities.isNullOrEmpty((String)familyname)) continue;
            fs.addFont(font);
        }
        return fs;
    }

    public FontSelector getFontSelector(String fontType, float fontSize, int fontStyle, Color color) {
        FontSelector fs = new FontSelector();
        Font preferredFont = FontFactory.getFont(fontType, fontSize, fontStyle, color);
        fs.addFont(preferredFont);
        for (BaseFont baseFont : this.baseFontList) {
            Font font = new Font(baseFont, fontSize, fontStyle, color);
            String familyname = font.getFamilyname();
            if (StringUtilities.isNullOrEmpty((String)familyname)) continue;
            fs.addFont(font);
        }
        return fs;
    }

    public PdfPCell getCell(Object item, boolean header) {
        PdfPCell cell = null;
        if (item instanceof Image) {
            cell = new PdfPCell((Image)item);
        } else if (item instanceof Paragraph) {
            cell = new PdfPCell((Paragraph)item);
        } else if (item instanceof Element) {
            cell = new PdfPCell();
            cell.addElement((Element)item);
        } else {
            String text = item.toString();
            cell = this.getHebrewOrArabicCell(text, Character.UnicodeBlock.HEBREW);
            if (cell == null) {
                cell = this.getHebrewOrArabicCell(text, Character.UnicodeBlock.ARABIC);
            }
            if (cell == null) {
                FontSelector fs = this.getFontSelector(header);
                cell = new PdfPCell(new Paragraph(fs.process(text)));
            }
        }
        cell.setBackgroundColor(this.getBackColor(header));
        cell.setPaddingBottom(this.getPadding(header));
        cell.setBorder(this.getBorder(header));
        return cell;
    }

    private PdfPCell getHebrewOrArabicCell(String text, Character.UnicodeBlock desiredUnicode) {
        if (this.textContainsDesiredUnicode(text, desiredUnicode)) {
            for (char character : text.toCharArray()) {
                Object al;
                if (Character.UnicodeBlock.of(character) != desiredUnicode) continue;
                Font desiredFont = null;
                for (Font font : this.getFontList(false)) {
                    if (!font.getBaseFont().charExists(character)) continue;
                    desiredFont = font;
                    break;
                }
                if (desiredFont == null) continue;
                boolean process = false;
                if (Character.UnicodeBlock.HEBREW == desiredUnicode) {
                    al = new HebrewLigaturizer();
                    text = ((HebrewLigaturizer)al).process(text);
                    process = true;
                } else if (Character.UnicodeBlock.ARABIC == desiredUnicode) {
                    al = new ArabicLigaturizer();
                    text = ((ArabicLigaturizer)al).process(text);
                    process = true;
                }
                if (process) {
                    return new PdfPCell(new Paragraph(text, desiredFont));
                }
                return null;
            }
        }
        return null;
    }

    private boolean textContainsDesiredUnicode(String text, Character.UnicodeBlock desiredUnicode) {
        for (char character : text.toCharArray()) {
            if (Character.UnicodeBlock.of(character) != desiredUnicode) continue;
            return true;
        }
        return false;
    }
}

