/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chapter;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.html.simpleparser.ImageProvider;
import com.lowagie.text.html.simpleparser.StyleSheet;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.cache.skeletons.EntitySkeletonProvider;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.reporting.pdf.DefaultiTextStyle;
import com.paterva.maltego.reporting.pdf.ReportGenerator;
import com.paterva.maltego.reporting.pdf.iTextStyle;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewExporter;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.ui.look.ColorUtils;
import com.paterva.maltego.util.ui.progress.ProgressController;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import yguard.A.J.SA;
import yguard.A.J.U;

public class PdfReportGenerator
implements ReportGenerator {
    private static final Color UNKNOWN_TYPE_COLOR = Color.LIGHT_GRAY;
    private static final Font CHAPTER_TITLE_FONT = FontFactory.getFont("Helvetica", 18.0f, 1, Color.DARK_GRAY);
    private static final iTextStyle ITEXT_STYLE = new DefaultiTextStyle();
    private static final Logger LOG = Logger.getLogger(PdfReportGenerator.class.getName());
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final String SEPERATOR = ", ";
    private final boolean _generateTitlePage;
    private final boolean _generateFooter;
    private final HashMap<String, Object> _interfaceProps = new HashMap<String, MaltegoCacheImageProvider>(Collections.singletonMap("img_provider", new MaltegoCacheImageProvider()));
    private final HashMap<String, Object> _interfacePropsEmpty = new HashMap<String, MaltegoEmptyCacheImageProvider>(Collections.singletonMap("img_provider", new MaltegoEmptyCacheImageProvider()));
    private final HashMap<EntityID, Image> entityImages = new HashMap();
    private boolean _success;
    private Document _doc;
    private EntityImageFactory factory;
    private EntityRegistry _registry;
    private U _view;
    private Image _footerImage;
    private int _chapter;
    private int _progress;
    private int _progressTotal;
    private int _progressOffset;
    private List<File> _tempFiles;
    private Map<Object, Image> _imagesByObject;
    private Map<String, Image> _imagesByType;
    private Optional<Image> _brokenImage;
    private PdfWriter _writer;
    private StringBuilder _warnings;

    public PdfReportGenerator(boolean generateTitlePage, boolean generateFooter) {
        this._generateTitlePage = generateTitlePage;
        this._generateFooter = generateFooter;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean generateReport(File outFile, U view, boolean wholeGraph, boolean includeEntityImages, boolean includeDisplayInfoImages, boolean includeEmptyProperties, boolean includeHiddenProperties, boolean includeUserProperties) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Rectangle getPageDrawSize() {
        Rectangle pageSize = this._doc.getPageSize();
        Rectangle drawSize = new Rectangle(pageSize.getWidth() - this._doc.leftMargin() - this._doc.rightMargin(), pageSize.getHeight() - this._doc.bottomMargin() - this._doc.topMargin());
        return drawSize;
    }

    private void addWhiteSpace(float size) throws DocumentException {
        Paragraph whitespace = new Paragraph(" ");
        whitespace.setLeading(0.0f);
        whitespace.setSpacingAfter(size);
        this._doc.add(whitespace);
    }

    private void createTitlePage(ProgressController controller) throws IOException, DocumentException, BadElementException {
        controller.progress("Title Page", this._progress++);
        FontSelector titleFontSelectorBig = ITEXT_STYLE.getFontSelector("Helvetica", 42.0f, 4, Color.DARK_GRAY);
        FontSelector titleFontSelectorSmall = ITEXT_STYLE.getFontSelector("Helvetica", 36.0f, 2, Color.DARK_GRAY);
        this.addWhiteSpace(60.0f);
        PdfPTable table = new PdfPTable(3);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.3f, 0.4f, 0.3f});
        table.getDefaultCell().setBorder(0);
        table.getDefaultCell().setHorizontalAlignment(1);
        table.addCell(" ");
        table.addCell(this.javaToPdfImage(ImageUtilities.loadImage((String)"com/paterva/maltego/reporting/resources/ReportTitle.png")));
        table.completeRow();
        this._doc.add(table);
        this.addWhiteSpace(20.0f);
        Paragraph docTitle1 = new Paragraph(titleFontSelectorBig.process("Maltego investigation"));
        docTitle1.setAlignment(1);
        this._doc.add(docTitle1);
        this.addWhiteSpace(20.0f);
        DataObject dao = (DataObject)GraphEditorRegistry.getDefault().getTopmost().getLookup().lookup(DataObject.class);
        Paragraph docTitle2 = new Paragraph(titleFontSelectorSmall.process(dao.getName()));
        docTitle2.setAlignment(1);
        this._doc.add(docTitle2);
        this._doc.newPage();
    }

    private void createGraphImage(ProgressController controller, boolean wholeGraph) throws DocumentException, BadElementException, IOException {
        Image image;
        File tempFile;
        controller.progress("Graph Image", this._progress++);
        Graph2DViewExporter exporter = new Graph2DViewExporter(this._view);
        File tempDir = new File(System.getProperty("java.io.tmpdir")).getAbsoluteFile();
        try {
            tempFile = File.createTempFile("tmp", ".jpg", tempDir);
        }
        catch (IOException ex) {
            String msg = String.format("Failed to create graph image temp file in %s\n%s", tempDir.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        try {
            exporter.exportToFile(tempFile, 3011, wholeGraph, null);
        }
        catch (IOException ex) {
            String msg = String.format("Failed to create temp image of graph as %s\n%s", tempFile.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        this._tempFiles.add(tempFile);
        this._progress += this._progressOffset / 3 * 2;
        controller.progress("Graph Image", this._progress);
        try {
            image = Image.getInstance(tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            String msg = String.format("Failed to read temp graph image from %s\n%s", tempFile.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        image.scaleToFit(this.getPageDrawSize().getWidth(), this.getPageDrawSize().getHeight());
        this._progress += this._progressOffset / 3;
        controller.progress("Graph Image", this._progress);
        this._doc.add(image);
        this._doc.newPage();
    }

    private void createRankTables(List<EntityID> entities, ProgressController controller, int linkCount) throws DocumentException {
        controller.progress("Top 10 Entities", this._progress++);
        Paragraph title = new Paragraph("Top 10 Entities", CHAPTER_TITLE_FONT);
        Chapter chapter = new Chapter(title, this._chapter++);
        chapter.add(this.createSummaryTable(this._view.getGraph2D(), entities.size(), linkCount));
        try {
            this._progress += this._progressOffset / 3;
            controller.progress("Top 10 Entities", this._progress);
            chapter.add(this.createRankTable(entities, Rank.RANK_IN_LINKS, 10, controller));
            this._progress += this._progressOffset / 3;
            controller.progress("Top 10 Entities", this._progress);
            chapter.add(this.createRankTable(entities, Rank.RANK_OUT_LINKS, 10, controller));
            this._progress += this._progressOffset / 3;
            controller.progress("Top 10 Entities", this._progress);
            chapter.add(this.createRankTable(entities, Rank.RANK_TOTAL_LINKS, 10, controller));
        }
        catch (GraphStoreException ex) {
            throw new DocumentException((Exception)((Object)ex));
        }
        this._doc.add(chapter);
    }

    private void createTypeTables(GraphDataStoreReader dataStoreReader, List<EntityID> entities, ProgressController controller) throws DocumentException, GraphStoreException {
        controller.progress("Entities by Type", this._progress++);
        Paragraph title = new Paragraph("Entities by Type", CHAPTER_TITLE_FONT);
        Chapter chapter = new Chapter(title, this._chapter++);
        HashMap entityTypes = new HashMap();
        for (EntityID graphEntityID : entities) {
            Object specIdentifier;
            controller.progress(this._progress++);
            MaltegoEntity entity = dataStoreReader.getEntity(graphEntityID);
            MaltegoEntitySpec entitySpec = this.getMaltegoEntitySpec(entity);
            String entityName = InheritanceHelper.getDisplayString((SpecRegistry)this._registry, (TypedPropertyBag)entity);
            Object object = specIdentifier = entitySpec != null ? entitySpec : entity.getTypeName();
            if (!entityTypes.containsKey(specIdentifier)) {
                entityTypes.put((MaltegoEntitySpec)specIdentifier, new ArrayList());
            }
            ((List)entityTypes.get(specIdentifier)).add(entityName);
        }
        ArrayList keys = new ArrayList(entityTypes.keySet());
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object n1, Object n2) {
                String v1 = this.getSortingDisplayText(n1);
                String v2 = this.getSortingDisplayText(n2);
                return v1.compareTo(v2);
            }

            private String getSortingDisplayText(Object n) {
                String v = n instanceof String ? (String)n : ((MaltegoEntitySpec)n).getDisplayNamePlural();
                return v;
            }
        });
        for (Object key : keys) {
            List subTypes = (List)entityTypes.get(key);
            Collections.sort(subTypes);
            chapter.add(this.createEntityTypeTable(key, subTypes));
        }
        this._doc.add(chapter);
    }

    private void triggerImageDownload(GraphDataStoreReader dataStoreReader, List<EntityID> entityIDList, int startIndex, int endIndex) throws GraphStoreException {
        for (int i = startIndex; i <= endIndex; ++i) {
            this.factory.getImage(dataStoreReader.getEntity(entityIDList.get(i)), null);
        }
    }

    private void loadEntityImages(GraphID graphID, GraphDataStoreReader dataStoreReader, List<EntityID> entityIDList, ProgressController controller) throws IOException, BadElementException {
        int iconSize = (int)ITEXT_STYLE.getFontSize(false) + 2;
        int maxThreadCount = 10;
        int markerTrigger = 6;
        int nodesTotal = entityIDList.size();
        int startIndex = 0;
        int marker = 0;
        int endIndex = (maxThreadCount < nodesTotal ? maxThreadCount : nodesTotal) - 1;
        this.triggerImageDownload(dataStoreReader, entityIDList, startIndex, endIndex);
        String titleStr = "Loading Entity Images";
        controller.progress(titleStr, this._progress++);
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        int num = 0;
        for (EntityID graphEntityID : entityIDList) {
            if (controller.isCanceled()) {
                return;
            }
            String progressMsg = String.format("%s (%d/%d)", titleStr, ++num, nodesTotal);
            controller.progress(progressMsg, this._progress++);
            if (++marker == maxThreadCount) {
                marker = 0;
            } else if (marker == markerTrigger) {
                startIndex = endIndex + 1;
                if ((endIndex = startIndex + maxThreadCount) > nodesTotal) {
                    endIndex = nodesTotal;
                }
                if (startIndex < --endIndex) {
                    this.triggerImageDownload(dataStoreReader, entityIDList, startIndex, endIndex);
                }
            }
            try {
                if (view.getModelViewMappings().isOnlyViewEntity(graphEntityID)) continue;
                Image entityImage = this.getEntityImage(dataStoreReader, graphEntityID, iconSize, iconSize);
                this.entityImages.put(graphEntityID, entityImage);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void createEntityTables(GraphDataStoreReader dataStoreReader, List<EntityID> entityIDList, ProgressController controller, boolean includeEntityImages, boolean includeDisplayInfoImages, boolean includeEmptyProperties, boolean includeHiddenProperties, boolean includeUserProperties) throws IOException, DocumentException {
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        final GraphStructureReader structureReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphStructureStore().getStructureReader();
        Collections.sort(entityIDList, new Comparator<EntityID>(){

            @Override
            public int compare(EntityID n1, EntityID n2) {
                try {
                    return structureReader.getLinkCount(n2) - structureReader.getLinkCount(n1);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return 0;
                }
            }
        });
        String titleStr = "Entity Details";
        controller.progress(titleStr, this._progress++);
        Paragraph title = new Paragraph(titleStr, CHAPTER_TITLE_FONT);
        Chapter chapter = new Chapter(title, this._chapter++);
        int num = 0;
        int nodesTotal = entityIDList.size();
        for (EntityID graphEntityID : entityIDList) {
            if (controller.isCanceled()) {
                return;
            }
            String progressMsg = String.format("%s (%d/%d)", titleStr, ++num, nodesTotal);
            controller.progress(progressMsg, this._progress++);
            PdfPTable outerTable = new PdfPTable(1);
            outerTable.setSpacingBefore(10.0f);
            outerTable.setSpacingAfter(10.0f);
            outerTable.setKeepTogether(false);
            outerTable.setExtendLastRow(false);
            outerTable.setWidthPercentage(100.0f);
            outerTable.getDefaultCell().setPadding(3.0f);
            outerTable.getDefaultCell().setBorderColor(Color.LIGHT_GRAY);
            outerTable.getDefaultCell().setBorder(13);
            MaltegoEntity entity = dataStoreReader.getEntity(graphEntityID);
            outerTable.addCell(this.createNodeHeaderTable(entity, includeEntityImages));
            outerTable.getDefaultCell().setBorder(12);
            outerTable.addCell(this.createNodePropertiesTable(graphEntityID, includeEmptyProperties, includeHiddenProperties, includeUserProperties));
            DisplayInformationCollection displayInformation = entity.getDisplayInformation();
            if (displayInformation != null) {
                for (DisplayInformation displayInfo : displayInformation) {
                    outerTable.getDefaultCell().setBorder(12);
                    outerTable.addCell(this.createNodeDisplayInfoTable(displayInfo, includeDisplayInfoImages, progressMsg, controller));
                }
            }
            outerTable.getDefaultCell().setBorder(14);
            outerTable.addCell(this.createNodeLinksTable(graphEntityID, includeEntityImages));
            chapter.add(outerTable);
        }
        controller.progress(titleStr + " (Appending To Document)", this._progress);
        this._doc.add(chapter);
        this._progress += this._progressOffset;
        controller.progress(titleStr + " (Finalizing)", this._progress++);
    }

    private PdfPTable createSummaryTable(SA graph2D, int numberOfEntities, int linkCount) throws DocumentException {
        boolean wide = false;
        int nodeCount = graph2D.\u00ca();
        int edgeCount = graph2D.\u00c3();
        Object entities = nodeCount;
        Object links = edgeCount;
        if (numberOfEntities > nodeCount || linkCount > edgeCount) {
            wide = true;
            entities = numberOfEntities + " (" + nodeCount + " nodes)";
            links = linkCount + " (" + edgeCount + " edges)";
        }
        PdfPTable table = new PdfPTable(2);
        table.setSpacingBefore(20.0f);
        table.setWidthPercentage(40.0f);
        table.setWidths(new float[]{0.8f, wide ? 0.5f : 0.2f});
        table.setHorizontalAlignment(0);
        table.addCell(ITEXT_STYLE.getCell("Total number of entities", false));
        table.addCell(ITEXT_STYLE.getCell(entities, false));
        table.addCell(ITEXT_STYLE.getCell("Total number of links", false));
        table.addCell(ITEXT_STYLE.getCell(links, false));
        return table;
    }

    private PdfPTable createRankTable(List<EntityID> entities, final Rank rank, int topCount, ProgressController controller) throws BadElementException, DocumentException, GraphStoreException {
        String rankStr;
        FontSelector fs = ITEXT_STYLE.getFontSelector("Helvetica", 12.0f, 1, Color.DARK_GRAY);
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        final GraphStructureReader structureReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphStructureStore().getStructureReader();
        GraphDataStoreReader dataStoreReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphDataStore().getDataStoreReader();
        final EntitySkeletonProvider skeletonProvider = SkeletonProviders.entitiesForGraph((GraphID)graphID);
        Collections.sort(entities, new Comparator<EntityID>(){

            @Override
            public int compare(EntityID n1, EntityID n2) {
                try {
                    switch (rank) {
                        case RANK_IN_LINKS: {
                            return structureReader.getIncomingLinkCount(n2) - structureReader.getIncomingLinkCount(n1);
                        }
                        case RANK_OUT_LINKS: {
                            return structureReader.getOutgoingLinkCount(n2) - structureReader.getOutgoingLinkCount(n1);
                        }
                        case RANK_TOTAL_LINKS: {
                            return structureReader.getLinkCount(n2) - structureReader.getLinkCount(n1);
                        }
                    }
                    return skeletonProvider.getEntitySkeleton(n2).getWeight() - skeletonProvider.getEntitySkeleton(n1).getWeight();
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return 0;
                }
            }
        });
        PdfPTable table = new PdfPTable(4);
        table.setSpacingBefore(20.0f);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.8f, 3.0f, 4.5f, 1.7f});
        PdfPCell titleCell = new PdfPCell();
        titleCell.setColspan(4);
        titleCell.setHorizontalAlignment(1);
        titleCell.setBorder(0);
        titleCell.setPaddingBottom(5.0f);
        switch (rank) {
            case RANK_IN_LINKS: {
                titleCell.setPhrase(new Paragraph(fs.process("Ranked by Incoming Links")));
                break;
            }
            case RANK_OUT_LINKS: {
                titleCell.setPhrase(new Paragraph(fs.process("Ranked by Outgoing Links")));
                break;
            }
            case RANK_TOTAL_LINKS: {
                titleCell.setPhrase(new Paragraph(fs.process("Ranked by Total Links")));
                break;
            }
            default: {
                titleCell.setPhrase(new Paragraph(fs.process("Ranked by Weight")));
            }
        }
        table.addCell(titleCell);
        table.addCell(ITEXT_STYLE.getCell("Rank", true));
        table.addCell(ITEXT_STYLE.getCell("Type", true));
        table.addCell(ITEXT_STYLE.getCell("Value", true));
        switch (rank) {
            case RANK_IN_LINKS: {
                rankStr = "Incoming links";
                break;
            }
            case RANK_OUT_LINKS: {
                rankStr = "Outgoing links";
                break;
            }
            case RANK_TOTAL_LINKS: {
                rankStr = "Total links";
                break;
            }
            default: {
                rankStr = "Weight";
            }
        }
        table.addCell(ITEXT_STYLE.getCell(rankStr, true));
        int rankNum = 1;
        for (EntityID graphEntityID : entities) {
            int value;
            table.addCell(ITEXT_STYLE.getCell(rankNum++, false));
            MaltegoEntity entity = dataStoreReader.getEntity(graphEntityID);
            MaltegoEntitySpec spec = this.getMaltegoEntitySpec(entity);
            String typeDisplayName = spec != null ? spec.getDisplayName() : entity.getTypeName();
            PdfPCell cell = ITEXT_STYLE.getCell(typeDisplayName, false);
            cell.setBackgroundColor(this.getEntityTypeColor(spec));
            table.addCell(cell);
            table.addCell(ITEXT_STYLE.getCell(InheritanceHelper.getDisplayString((SpecRegistry)this._registry, (TypedPropertyBag)entity), false));
            switch (rank) {
                case RANK_IN_LINKS: {
                    value = structureReader.getIncomingLinkCount(graphEntityID);
                    break;
                }
                case RANK_OUT_LINKS: {
                    value = structureReader.getOutgoingLinkCount(graphEntityID);
                    break;
                }
                case RANK_TOTAL_LINKS: {
                    value = structureReader.getLinkCount(graphEntityID);
                    break;
                }
                default: {
                    value = entity.getWeight();
                }
            }
            table.addCell(ITEXT_STYLE.getCell(value, false));
            if (rankNum <= topCount) continue;
            break;
        }
        return table;
    }

    private PdfPTable createEntityTypeTable(Object entityTypeIdentifier, List<String> entityNames) throws DocumentException {
        Color typeColor;
        String displayNamePlural;
        PdfPTable table = new PdfPTable(2);
        table.setSpacingBefore(20.0f);
        table.setWidthPercentage(100.0f);
        PdfPCell defaultCell = ITEXT_STYLE.getCell(" ", false);
        table.getDefaultCell().setBorder(defaultCell.getBorder());
        table.getDefaultCell().setBackgroundColor(defaultCell.getBackgroundColor());
        if (entityTypeIdentifier instanceof MaltegoEntitySpec) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)entityTypeIdentifier;
            displayNamePlural = spec.getDisplayNamePlural();
            typeColor = this.getEntityTypeColor(spec);
        } else {
            displayNamePlural = entityTypeIdentifier.toString();
            typeColor = this.getEntityTypeColor(null);
        }
        PdfPCell headerCell = ITEXT_STYLE.getCell(displayNamePlural + " (" + entityNames.size() + ")", true);
        headerCell.setBackgroundColor(typeColor);
        headerCell.setColspan(2);
        table.addCell(headerCell);
        for (String entityName : entityNames) {
            table.addCell(ITEXT_STYLE.getCell(entityName, false));
        }
        table.completeRow();
        return table;
    }

    private PdfPTable createNodeHeaderTable(MaltegoEntity entity, boolean includeEntityImages) throws BadElementException, IOException, DocumentException {
        String typeName;
        int iconSize = IconSize.LARGE.getSize();
        PdfPTable table = new PdfPTable(2);
        table.setSpacingBefore(20.0f);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.2f, 0.8f});
        MaltegoEntitySpec spec = this.getMaltegoEntitySpec(entity);
        String typeDisplayName = spec != null ? spec.getDisplayName() : entity.getTypeName();
        String string = typeName = spec != null ? spec.getTypeName() : entity.getTypeName();
        if (includeEntityImages) {
            Image img = this.entityImages.get(entity.getID());
            if (img == null) {
                img = this._imagesByType.get(typeName);
            }
            img.scaleToFit(iconSize, iconSize);
            PdfPCell cell = ITEXT_STYLE.getCell(img, true);
            cell.setHorizontalAlignment(1);
            cell.setRowspan(3);
            table.addCell(cell);
        } else {
            PdfPCell cell = ITEXT_STYLE.getCell("", true);
            cell.setRowspan(3);
            table.addCell(cell);
        }
        FontSelector fs = ITEXT_STYLE.getFontSelector("Helvetica", 12.0f, 0, new Color(0x999999));
        Paragraph paragraph = new Paragraph(fs.process(typeDisplayName));
        table.addCell(ITEXT_STYLE.getCell(paragraph, true));
        fs = ITEXT_STYLE.getFontSelector("Helvetica", 10.0f, 0, new Color(0x999999));
        paragraph = new Paragraph(fs.process(typeName));
        table.addCell(ITEXT_STYLE.getCell(paragraph, true));
        fs = ITEXT_STYLE.getFontSelector("Helvetica", 14.0f, 0, new Color(6065035));
        paragraph = new Paragraph(fs.process(InheritanceHelper.getDisplayString((SpecRegistry)this._registry, (TypedPropertyBag)entity)));
        PdfPCell cell = ITEXT_STYLE.getCell(paragraph, true);
        cell.setPaddingBottom(5.0f);
        table.addCell(cell);
        return table;
    }

    private PdfPTable createNodePropertiesTable(EntityID graphEntityID, boolean includeEmptyProperties, boolean includeHiddenProperties, boolean includeUserProperties) throws DocumentException, GraphStoreException {
        PdfPTable table = new PdfPTable(3);
        table.setWidthPercentage(95.0f);
        table.setWidths(new float[]{0.05f, 0.3f, 0.65f});
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        GraphDataStoreReader dataStoreReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphDataStore().getDataStoreReader();
        MaltegoEntity maltegoEntity = dataStoreReader.getEntity(graphEntityID);
        PropertyDescriptorCollection properties = maltegoEntity.getProperties();
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        table.addCell(cell);
        table.addCell(ITEXT_STYLE.getCell("Weight", false));
        table.addCell(ITEXT_STYLE.getCell(maltegoEntity.getWeight(), false));
        for (PropertyDescriptor property : properties) {
            String propertyName = property.getName();
            String propertyDisplayName = property.getDisplayName();
            Object value = maltegoEntity.getValue(property);
            if (propertyName.equals("maltego.fixed.type") || propertyName.equals("maltego.calculated.value") || (!includeHiddenProperties || !property.isHidden()) && property.isHidden() || !includeUserProperties && (propertyName.equals("maltego.date.created") || propertyName.equals("maltego.date.modified") || propertyName.equals("maltego.user.created") || propertyName.equals("maltego.user.modified"))) continue;
            String propertyValue = "";
            if (value != null) {
                StringBuilder sb = new StringBuilder();
                if (value.getClass().isArray()) {
                    sb.append('[');
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        sb.append(Array.get(value, i));
                        if (i + 1 >= length) continue;
                        sb.append(SEPERATOR);
                    }
                    sb.append(']');
                } else {
                    sb.append(value.toString());
                }
                propertyValue = sb.toString();
            }
            if (!includeEmptyProperties && StringUtilities.isNullOrEmpty((String)propertyValue)) continue;
            cell = new PdfPCell();
            cell.setBorder(0);
            table.addCell(cell);
            table.addCell(ITEXT_STYLE.getCell(propertyDisplayName, false));
            table.addCell(ITEXT_STYLE.getCell(propertyValue, false));
        }
        return table;
    }

    private PdfPTable createNodeDisplayInfoTable(DisplayInformation displayInfo, boolean includeDisplayInfoImages, String progressMsg, ProgressController controller) throws DocumentException, IOException {
        PdfPTable table = new PdfPTable(1);
        table.setWidthPercentage(95.0f);
        table.setWidths(new float[]{1.0f});
        PdfPCell cell = ITEXT_STYLE.getCell(displayInfo.getName(), true);
        cell.setColspan(3);
        table.addCell(cell);
        String value = displayInfo.getValue();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.loadTagStyle("table", "color", "#404040");
        styleSheet.loadTagStyle("a", "color", "#0000FF");
        styleSheet.loadTagStyle("body", "size", "9pt");
        try {
            ArrayList list = includeDisplayInfoImages ? HTMLWorker.parseToList(new StringReader(value), styleSheet, this._interfaceProps) : HTMLWorker.parseToList(new StringReader(value), styleSheet, this._interfacePropsEmpty);
            controller.progress(progressMsg, this._progress);
            for (Object obj : list) {
                cell = ITEXT_STYLE.getCell(obj, false);
                table.addCell(cell);
            }
        }
        catch (Exception ex) {
            String msg = String.format("Failed to parse Display Info (invalid HTML?):\n%s\nError: %s", value, ex.getMessage());
            this._warnings.append(msg);
            this._warnings.append("\n\n");
        }
        return table;
    }

    private void sortByEntityName(List<LinkID> links, final GraphStructureReader structureReader, final EntitySkeletonProvider skeletonProvider, final SourceTarget sourceTarget) {
        Collections.sort(links, new Comparator<LinkID>(){

            @Override
            public int compare(LinkID o1, LinkID o2) {
                try {
                    EntityID e2;
                    EntityID e1;
                    switch (sourceTarget) {
                        case SOURCE: {
                            e1 = structureReader.getSource(o1);
                            e2 = structureReader.getSource(o2);
                            break;
                        }
                        case TARGET: {
                            e1 = structureReader.getTarget(o1);
                            e2 = structureReader.getTarget(o2);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported link target");
                        }
                    }
                    MaltegoEntity me1 = skeletonProvider.getEntitySkeleton(e1);
                    MaltegoEntitySpec spec1 = PdfReportGenerator.this.getMaltegoEntitySpec(me1);
                    MaltegoEntity me2 = skeletonProvider.getEntitySkeleton(e2);
                    MaltegoEntitySpec spec2 = PdfReportGenerator.this.getMaltegoEntitySpec(me2);
                    String type1 = spec1 != null ? spec1.getDisplayName() : me1.getTypeName();
                    String type2 = spec2 != null ? spec2.getDisplayName() : me2.getTypeName();
                    return type1.compareTo(type2);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return 0;
                }
            }
        });
    }

    private void addOrCreate(Map<String, List<EntityID>> sortedTypeNamesToEntities, EntitySkeletonProvider skeletonProvider, EntityID entityID) throws GraphStoreException {
        MaltegoEntity entity = skeletonProvider.getEntitySkeleton(entityID);
        MaltegoEntitySpec spec = this.getMaltegoEntitySpec(entity);
        String typeDisplayName = spec != null ? spec.getDisplayName() : entity.getTypeName();
        List<EntityID> list = sortedTypeNamesToEntities.get(typeDisplayName);
        if (list == null) {
            list = new ArrayList<EntityID>();
            sortedTypeNamesToEntities.put(typeDisplayName, list);
        }
        list.add(entityID);
    }

    private void sortList(List<EntityID> entityList, final GraphDataStoreReader dataStoreReader) {
        Collections.sort(entityList, new Comparator<EntityID>(){

            @Override
            public int compare(EntityID o1, EntityID o2) {
                try {
                    MaltegoEntity e1 = dataStoreReader.getEntity(o1);
                    MaltegoEntity e2 = dataStoreReader.getEntity(o2);
                    String t1 = InheritanceHelper.getDisplayString((SpecRegistry)PdfReportGenerator.this._registry, (TypedPropertyBag)e1);
                    String t2 = InheritanceHelper.getDisplayString((SpecRegistry)PdfReportGenerator.this._registry, (TypedPropertyBag)e2);
                    return t1.compareTo(t2);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return 0;
                }
            }
        });
    }

    private PdfPTable createNodeLinksTable(EntityID graphEntityID, boolean includeEntityImages) throws DocumentException, IOException {
        int iconSize = (int)ITEXT_STYLE.getFontSize(false) + 2;
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        GraphStructureReader structureReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphStructureStore().getStructureReader();
        GraphDataStoreReader dataStoreReader = GraphStoreRegistry.getDefault().forGraphID(graphID).getGraphDataStore().getDataStoreReader();
        EntitySkeletonProvider skeletonProvider = SkeletonProviders.entitiesForGraph((GraphID)graphID);
        if (!structureReader.hasLinks(graphEntityID)) {
            return null;
        }
        PdfPTable table = new PdfPTable(3);
        table.setSpacingBefore(5.0f);
        table.setWidthPercentage(100.0f);
        table.setWidths(new float[]{0.05f, 0.4f, 0.55f});
        table.setHorizontalAlignment(2);
        ArrayList<LinkID> incomingModelLinks = new ArrayList<LinkID>(structureReader.getIncoming(graphEntityID));
        this.sortByEntityName(incomingModelLinks, structureReader, skeletonProvider, SourceTarget.SOURCE);
        if (!incomingModelLinks.isEmpty()) {
            PdfPCell cell = ITEXT_STYLE.getCell("Incoming (" + incomingModelLinks.size() + ")", true);
            cell.setColspan(3);
            table.addCell(cell);
            LinkedHashMap<String, List<EntityID>> sortedTypeNamesToEntities = new LinkedHashMap<String, List<EntityID>>();
            for (LinkID incomingModelLink : incomingModelLinks) {
                EntityID sourceEntityID = structureReader.getSource(incomingModelLink);
                this.addOrCreate(sortedTypeNamesToEntities, skeletonProvider, sourceEntityID);
            }
            this.addEntityDetailSortedDataCells(sortedTypeNamesToEntities, dataStoreReader, includeEntityImages, iconSize, table);
        }
        ArrayList<LinkID> outgoingModelLinks = new ArrayList<LinkID>(structureReader.getOutgoing(graphEntityID));
        this.sortByEntityName(outgoingModelLinks, structureReader, skeletonProvider, SourceTarget.TARGET);
        if (!outgoingModelLinks.isEmpty()) {
            PdfPCell cell = ITEXT_STYLE.getCell("Outgoing (" + outgoingModelLinks.size() + ")", true);
            cell.setColspan(3);
            table.addCell(cell);
            LinkedHashMap<String, List<EntityID>> sortedTypeNamesToEntities = new LinkedHashMap<String, List<EntityID>>();
            for (LinkID outgoingModelLink : outgoingModelLinks) {
                EntityID targetEntityID = structureReader.getTarget(outgoingModelLink);
                this.addOrCreate(sortedTypeNamesToEntities, skeletonProvider, targetEntityID);
            }
            this.addEntityDetailSortedDataCells(sortedTypeNamesToEntities, dataStoreReader, includeEntityImages, iconSize, table);
        }
        return table;
    }

    private void addEntityDetailSortedDataCells(Map<String, List<EntityID>> sortedTypeNamesToEntities, GraphDataStoreReader dataStoreReader, boolean includeEntityImages, int iconSize, PdfPTable table) throws IOException, BadElementException {
        for (Map.Entry<String, List<EntityID>> entry : sortedTypeNamesToEntities.entrySet()) {
            List<EntityID> entityList = entry.getValue();
            this.sortList(entityList, dataStoreReader);
            for (EntityID entityID : entityList) {
                PdfPCell cell;
                String typeDisplayName;
                MaltegoEntity entity = dataStoreReader.getEntity(entityID);
                MaltegoEntitySpec spec = this.getMaltegoEntitySpec(entity);
                String string = typeDisplayName = spec != null ? spec.getDisplayName() : entity.getTypeName();
                if (includeEntityImages) {
                    String typeName = spec != null ? spec.getTypeName() : entity.getTypeName();
                    Image img = this.entityImages.get(entityID);
                    if (img == null) {
                        img = this._imagesByType.get(typeName);
                    }
                    img.scaleToFit(iconSize, iconSize);
                    cell = ITEXT_STYLE.getCell(img, false);
                    cell.setHorizontalAlignment(1);
                    table.addCell(cell);
                } else {
                    cell = ITEXT_STYLE.getCell("", true);
                    table.addCell(cell);
                }
                cell = ITEXT_STYLE.getCell(typeDisplayName, false);
                cell.setBackgroundColor(this.getEntityTypeColor(spec));
                table.addCell(cell);
                table.addCell(ITEXT_STYLE.getCell(InheritanceHelper.getDisplayString((SpecRegistry)this._registry, (TypedPropertyBag)entity), false));
            }
        }
    }

    private MaltegoEntitySpec getMaltegoEntitySpec(MaltegoEntity entity) throws GraphStoreException {
        String typeName = entity.getTypeName();
        return (MaltegoEntitySpec)this._registry.get(typeName);
    }

    private Color getEntityTypeColor(MaltegoEntitySpec entitySpec) {
        if (entitySpec != null) {
            Color color = EntityColorFactory.getDefault().getTypeColor(entitySpec.getTypeName());
            return ColorUtils.getLighter((Color)color, (double)0.75);
        }
        return UNKNOWN_TYPE_COLOR;
    }

    private Image getEntityImage(GraphDataStoreReader dataStoreReader, EntityID graphEntityID, int width, int height) throws IOException, BadElementException {
        java.awt.Image entityImage;
        MaltegoEntity entity = dataStoreReader.getEntity(graphEntityID);
        GraphID graphID = GraphIDProvider.forGraph((SA)this._view.getGraph2D());
        Object imageKey = InheritanceHelper.getImageKey((EntityRegistry)this._registry, (MaltegoEntity)entity).orElse(null);
        Image image = null;
        boolean useTypeImage = false;
        if (imageKey == null) {
            useTypeImage = true;
        } else if (this._imagesByObject.containsKey(imageKey)) {
            image = this._imagesByObject.get(imageKey);
        } else {
            entityImage = ImageFactory.getDefault().getImage(graphID, imageKey, -1, -1, null);
            if (entityImage == null) {
                if (imageKey instanceof FastURL || imageKey instanceof String && FastURL.isFastURL((String)((String)imageKey))) {
                    image = this.getBrokenImage();
                    if (image == null) {
                        useTypeImage = true;
                    }
                } else {
                    useTypeImage = true;
                }
            } else {
                image = this.javaToPdfImage(entityImage);
                this._imagesByObject.put(imageKey, image);
            }
        }
        if (useTypeImage) {
            if (this._imagesByType.containsKey(entity.getTypeName())) {
                image = this._imagesByType.get(entity.getTypeName());
            } else {
                entityImage = this.factory.getTypeImage(entity.getTypeName(), -1, -1, null);
                image = this.javaToPdfImage(entityImage);
                this._imagesByType.put(entity.getTypeName(), image);
            }
        }
        if (image != null) {
            image.scaleToFit(width, height);
        }
        return image;
    }

    private Image getBrokenImage() {
        if (this._brokenImage == null) {
            try {
                int size = IconSize.MASSIVE.getSize();
                this._brokenImage = Optional.ofNullable(this.javaToPdfImage(ImageUtils.getBrokenImage((int)size, (int)size)));
            }
            catch (Exception ex) {
                this._brokenImage = Optional.empty();
            }
        }
        return this._brokenImage.isPresent() ? this._brokenImage.get() : null;
    }

    private Image javaToPdfImage(java.awt.Image img) throws IOException, BadElementException {
        File tempFile;
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        File tempDir = new File(System.getProperty("java.io.tmpdir")).getAbsoluteFile();
        try {
            tempFile = File.createTempFile("tmp", ".png", tempDir).getAbsoluteFile();
        }
        catch (IOException ex) {
            String msg = String.format("Failed to create temp file in %s\n%s", tempDir.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", tempFile);
        }
        catch (IOException ex) {
            String msg = String.format("Failed to write %s\n%s", tempFile.getAbsolutePath(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
        this._tempFiles.add(tempFile);
        try {
            Image image = Image.getInstance(tempFile.getAbsolutePath());
            return image;
        }
        catch (IOException ex) {
            String msg = String.format("Failed to read %s\n%s", tempFile.getAbsoluteFile(), ex.getMessage());
            LOG.info(msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            throw ex;
        }
    }

    private static class MaltegoEmptyCacheImageProvider
    implements ImageProvider {
        private MaltegoEmptyCacheImageProvider() {
        }

        @Override
        public Image getImage(String src, HashMap h, ChainedProperties cprops, DocListener doc) {
            return null;
        }
    }

    private static class MaltegoCacheImageProvider
    implements ImageProvider {
        private MaltegoCacheImageProvider() {
        }

        @Override
        public Image getImage(String src, HashMap h, ChainedProperties cprops, DocListener doc) {
            try {
                java.awt.Image image;
                if ((src.startsWith("http:") || src.startsWith("https:")) && (image = ImageFactory.getDefault().getImage((Object)src, null)) != null) {
                    return Image.getInstance(image, null, false);
                }
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
            return null;
        }
    }

    private class EndPage
    extends PdfPageEventHelper {
        private EndPage() {
        }

        @Override
        public void onEndPage(PdfWriter writer, Document document) {
            int pageNumber = document.getPageNumber();
            if (pageNumber == 1) {
                return;
            }
            Rectangle page = document.getPageSize();
            FontSelector fs = ITEXT_STYLE.getFontSelector("Helvetica", 10.0f, 0, Color.LIGHT_GRAY);
            PdfPTable foot = new PdfPTable(1);
            foot.setWidthPercentage(100.0f);
            PdfPCell cell = new PdfPCell(new Paragraph(fs.process(Integer.toString(pageNumber))));
            cell.setHorizontalAlignment(1);
            cell.setBorder(0);
            cell.setVerticalAlignment(4);
            foot.addCell(cell);
            foot.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
            foot.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin() - 10.0f, writer.getDirectContent());
            if (PdfReportGenerator.this._generateFooter) {
                foot = new PdfPTable(2);
                foot.setWidthPercentage(100.0f);
                try {
                    foot.setWidths(new float[]{0.92f, 0.08f});
                }
                catch (DocumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    if (PdfReportGenerator.this._footerImage == null) {
                        PdfReportGenerator.this._footerImage = PdfReportGenerator.this.javaToPdfImage(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/view2d/PrintFooter.png"));
                    }
                }
                catch (BadElementException | IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                cell = new PdfPCell(new Paragraph(fs.process("Generated with " + Version.getCurrent().toString(true, false, true))));
                cell.setHorizontalAlignment(2);
                cell.setBorder(0);
                cell.setVerticalAlignment(6);
                foot.addCell(cell);
                cell = new PdfPCell(PdfReportGenerator.this._footerImage);
                cell.setBorder(0);
                foot.addCell(cell);
                foot.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
                foot.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin() - 10.0f, writer.getDirectContent());
            }
        }
    }

    private static enum SourceTarget {
        SOURCE,
        TARGET;

    }

    private static enum Rank {
        RANK_IN_LINKS,
        RANK_OUT_LINKS,
        RANK_TOTAL_LINKS,
        RANK_WEIGHT;

    }
}

