/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.image;

import com.paterva.maltego.reporting.image.Bundle;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import com.paterva.maltego.ui.graph.view2d.Graph2DExporter;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.components.ImageBoundsRadioButtons;
import com.paterva.maltego.util.ui.components.RangeClipSpinner;
import com.paterva.maltego.util.ui.filechooser.FileChooserUtil;
import com.paterva.maltego.util.ui.filechooser.SaveValidationFileChooser;
import com.paterva.maltego.util.ui.progress.ProgressController;
import com.paterva.maltego.util.ui.progress.ProgressDescriptor;
import com.paterva.maltego.util.ui.progress.ProgressDialogFactory;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import yguard.A.J.SA;
import yguard.A.J.U;

public class ExportAsImageAction
extends TopGraphAction {
    private static final Logger LOG = Logger.getLogger(ExportAsImageAction.class.getName());
    private static final String PREF_SAVED_DIR = "exportAsImageDir";
    private static final String PREF_SAVED_IMAGE_TYPE = "exportAsImageType";
    private static final String PREF_SAVED_BOUNDS_GRAPH = "exportAsImageBoundsGraph";
    private static final int ZOOM_LEVEL_MIN = 1;
    private static final int ZOOM_LEVEL_MAX = 15000;
    private static final int WIDTH_MIN = 1;
    private static final int WIDTH_MAX = 100000;
    private final AtomicBoolean _updating = new AtomicBoolean(false);
    private FILE_TYPE _fileType;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.CTL_ExportAsImageAction();
    }

    protected String iconResource() {
        return "com/paterva/maltego/reporting/resources/ExportImage.png";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.FALSE);
    }

    protected void actionPerformed(TopComponent tc) {
        this.setUpdating(true);
        SaveValidationFileChooser fileChooser = new SaveValidationFileChooser(){

            public void addNotify() {
                super.addNotify();
                WindowManager.getDefault().invokeWhenUIReady(() -> ExportAsImageAction.this.setUpdating(false));
            }
        };
        fileChooser.setAcceptAllFileFilterUsed(false);
        Preferences prefs = this.getPrefs();
        FileChooserUtil.setDirectoryAndFile((Preferences)prefs, (String)PREF_SAVED_DIR, (JFileChooser)fileChooser, (String)GraphUtils.getTopGraphName((TopComponent)tc, (String)"GraphImage"));
        LinkedHashMap<String, FileNameExtensionFilter> fileFilters = new LinkedHashMap<String, FileNameExtensionFilter>();
        LinkedHashMap<String, String> fileTypes = this.getFileTypes();
        for (Map.Entry<String, String> fileType : fileTypes.entrySet()) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter(fileType.getValue(), fileType.getKey());
            fileFilters.put(fileType.getKey(), filter);
            fileChooser.addChoosableFileFilter((FileFilter)filter);
        }
        this._fileType = this.getSavedFileType();
        FileNameExtensionFilter initType = (FileNameExtensionFilter)fileFilters.get(this._fileType.getExtension());
        if (initType != null) {
            fileChooser.setFileFilter((FileFilter)initType);
        }
        U graph2DView = this.getGraph2DView();
        int viewZoomLevel = (int)Math.max(1.0, Math.min(15000.0, ExportAsImageAction.getViewZoomLevel(graph2DView)));
        RangeClipSpinner zoomSpinner = new RangeClipSpinner(new SpinnerNumberModel(viewZoomLevel, 1, 15000, 25));
        boolean initWholeGraph = prefs.getBoolean(PREF_SAVED_BOUNDS_GRAPH, false);
        int desiredWidth = (int)ExportAsImageAction.getPredictedWidth(graph2DView, initWholeGraph, viewZoomLevel);
        desiredWidth = Math.max(1, Math.min(100000, desiredWidth));
        RangeClipSpinner widthSpinner = new RangeClipSpinner(new SpinnerNumberModel(desiredWidth, 1, 100000, 10));
        ImageBoundsRadioButtons imageBoundsRadios = new ImageBoundsRadioButtons(initWholeGraph);
        fileChooser.addPropertyChangeListener("fileFilterChanged", arg_0 -> this.lambda$actionPerformed$0(graph2DView, (JSpinner)zoomSpinner, widthSpinner, imageBoundsRadios, arg_0));
        zoomSpinner.addChangeListener(arg_0 -> this.lambda$actionPerformed$1(graph2DView, (JSpinner)zoomSpinner, widthSpinner, imageBoundsRadios, arg_0));
        widthSpinner.addChangeListener(arg_0 -> this.lambda$actionPerformed$2(graph2DView, widthSpinner, (JSpinner)zoomSpinner, imageBoundsRadios, arg_0));
        imageBoundsRadios.addActionListener(arg_0 -> this.lambda$actionPerformed$3(graph2DView, (JSpinner)zoomSpinner, widthSpinner, imageBoundsRadios, arg_0));
        FileChooserUtil.addAdditionalFieldsToChooser((JFileChooser)fileChooser, (String[])new String[]{"Image zoom level (%):", "Image width (px):", "Image bounds:"}, (JComponent[])new JComponent[]{zoomSpinner, widthSpinner, imageBoundsRadios});
        int result = fileChooser.showSaveDialog((Component)WindowManager.getDefault().getMainWindow());
        if (result == 0) {
            boolean htmlViewer;
            File file = fileChooser.getSelectedFile();
            String extension = FileChooserUtil.getFileExtension((FileNameExtensionFilter)((FileNameExtensionFilter)fileChooser.getFileFilter()));
            file = FileChooserUtil.addExtenstionIfMissing((File)file, (String)extension);
            boolean bl = htmlViewer = this.mapFileType(extension) == FILE_TYPE.HTML;
            if (htmlViewer) {
                file = new File(file.getPath().replaceAll("(?i)html$", "png"));
            }
            ProgressDescriptor progress = ProgressDialogFactory.createProgressDialog((String)"Exporting graph as image", (boolean)false);
            ProgressController controller = progress.getController();
            Component component = progress.getGUIComponent();
            File outImage = file;
            Thread process = new Thread(() -> {
                NotifyDescriptor nd = null;
                try {
                    controller.start(200);
                    nd = this.exportImage(widthSpinner, imageBoundsRadios.isWholeGraph(), htmlViewer, outImage, controller);
                }
                finally {
                    controller.finish();
                }
                if (nd != null) {
                    DialogDisplayer.getDefault().notify(nd);
                }
                String currentDirectory = fileChooser.getCurrentDirectory().getAbsolutePath();
                prefs.put(PREF_SAVED_DIR, currentDirectory);
                prefs.put(PREF_SAVED_IMAGE_TYPE, extension.toLowerCase());
                prefs.putBoolean(PREF_SAVED_BOUNDS_GRAPH, imageBoundsRadios.isWholeGraph());
            }, "Graph as image exporter");
            process.start();
            component.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotifyDescriptor exportImage(RangeClipSpinner widthSpinner, boolean wholeGraph, boolean htmlViewer, File outImage, ProgressController controller) {
        NotifyDescriptor.Message nd = null;
        try {
            SlownessDetector.setEnabled((boolean)false);
            WindowUtil.showWaitCursor();
            int width = (Integer)widthSpinner.getValue();
            File outHTML = null;
            if (htmlViewer) {
                outHTML = new File(outImage.getPath().replaceAll("(?i)png$", "html"));
                File tempDir = new File(System.getProperty("java.io.tmpdir")).getAbsoluteFile();
                outImage = File.createTempFile("tmp", ".png", tempDir);
            }
            nd = this.exportToFile(outImage, width, wholeGraph, outHTML, controller) ? new NotifyDescriptor.Message((Object)"Image generated successfully.", 1) : new NotifyDescriptor.Message((Object)"Could not write to output file.\nGraph exceeds the maximum size of 2147483647 pixels.", 2);
        }
        catch (OutOfMemoryError ex) {
            Exceptions.printStackTrace((Throwable)ex);
            nd = new NotifyDescriptor.Message((Object)(ex.getMessage() + " If your system still has enough free memory you can increase the maximum memory available to Maltego in Options->Java Options. Otherwise you can try to export the graph again, but with a smaller width."), 0);
            nd.setTitle("Not Enough Free Memory");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            nd = new NotifyDescriptor.Message((Object)("Could not write to output file.\n" + ex.getMessage()), 2);
        }
        finally {
            boolean success;
            if (htmlViewer && outImage.exists() && !(success = outImage.delete())) {
                outImage.deleteOnExit();
            }
            WindowUtil.hideWaitCursor();
            SlownessDetector.setEnabled((boolean)true);
        }
        return nd;
    }

    private Preferences getPrefs() {
        Preferences prefs = NbPreferences.forModule(ExportAsImageAction.class);
        return prefs;
    }

    private FILE_TYPE getSavedFileType() {
        LinkedHashMap<String, String> type = this.getFileTypes();
        String fallbackType = type.entrySet().iterator().next().getKey();
        String savedType = this.getPrefs().get(PREF_SAVED_IMAGE_TYPE, fallbackType).toLowerCase();
        if (!type.containsKey(savedType)) {
            savedType = fallbackType;
        }
        return this.mapFileType(savedType);
    }

    private FILE_TYPE mapFileType(String ext) {
        FILE_TYPE type = FILE_TYPE.PNG;
        switch (ext.toLowerCase()) {
            case "png": {
                type = FILE_TYPE.PNG;
                break;
            }
            case "jpg": {
                type = FILE_TYPE.JPG;
                break;
            }
            case "bmp": {
                type = FILE_TYPE.BMP;
                break;
            }
            case "html": {
                type = FILE_TYPE.HTML;
                break;
            }
        }
        return type;
    }

    private void setUpdating(boolean state) {
        this._updating.set(state);
    }

    private void updateWidth(U graph2DView, JSpinner zoomSpinner, RangeClipSpinner widthSpinner, boolean wholeGraph) {
        int widthCap = 30000;
        switch (this._fileType) {
            case PNG: {
                widthCap = 100000;
                break;
            }
            case JPG: {
                widthCap = 40000;
                break;
            }
            case BMP: {
                widthCap = 30000;
                break;
            }
            case HTML: {
                widthCap = 40000;
                break;
            }
        }
        int newWidth = (int)ExportAsImageAction.getPredictedWidth(graph2DView, wholeGraph, ((Integer)zoomSpinner.getValue()).intValue());
        newWidth = Math.max(1, Math.min(100000, newWidth));
        if (widthCap - newWidth < 100) {
            newWidth = widthCap;
        }
        newWidth = Math.min(widthCap, newWidth);
        if (widthCap != widthSpinner.getMaxValue()) {
            widthSpinner.setMaxValue(widthCap);
        }
        widthSpinner.setValue((Object)newWidth);
    }

    private void updateZoomLevel(U graph2DView, RangeClipSpinner widthSpinner, JSpinner zoomSpinner, boolean wholeGraph) {
        int newZoomLevel = (int)ExportAsImageAction.getPredictedZoomLevel(graph2DView, wholeGraph, ((Integer)widthSpinner.getValue()).intValue());
        newZoomLevel = Math.max(1, Math.min(15000, newZoomLevel));
        zoomSpinner.setValue(newZoomLevel);
    }

    private static double getPredictedWidth(U view, boolean wholeGraph, double desiredZoomLevel) {
        double width = wholeGraph ? ExportAsImageAction.getGraphWidth(view) * desiredZoomLevel / 100.0 : ExportAsImageAction.getViewWidth(view) * desiredZoomLevel / ExportAsImageAction.getViewZoomLevel(view);
        return width;
    }

    private static double getPredictedZoomLevel(U view, boolean wholeGraph, double desiredWidth) {
        double zoomLevel = wholeGraph ? 100.0 * desiredWidth / ExportAsImageAction.getGraphWidth(view) : ExportAsImageAction.getViewZoomLevel(view) * desiredWidth / ExportAsImageAction.getViewWidth(view);
        return zoomLevel;
    }

    private static double getViewZoomLevel(U view) {
        double zoomLevel = 100.0;
        if (view != null) {
            zoomLevel = view.getZoom() * 100.0;
        }
        return zoomLevel;
    }

    private static double getViewWidth(U view) {
        Component component;
        double viewWidth = 1024.0;
        if (view != null && (viewWidth = (double)(component = view.getGraph2D().\u00f1().getComponent()).getWidth()) < 0.0) {
            viewWidth *= -1.0;
        }
        return viewWidth;
    }

    private static double getGraphWidth(U view) {
        Rectangle graphRect;
        double graphWidth = 1024.0;
        if (view != null && (graphWidth = ((RectangularShape)(graphRect = view.getGraph2D().\u00d0())).getWidth()) < 0.0) {
            graphWidth *= -1.0;
        }
        return graphWidth;
    }

    private U getGraph2DView() {
        U view = null;
        JComponent viewControl = this.getTopGraphViewCookie().getGraphView().getViewControl();
        if (viewControl instanceof U) {
            view = (U)viewControl;
        }
        return view;
    }

    private LinkedHashMap<String, String> getFileTypes() {
        LinkedHashMap fileTypes = Graph2DExporter.getFileTypes();
        LinkedHashMap<String, String> imageSaveTypes = new LinkedHashMap<String, String>(fileTypes);
        imageSaveTypes.put("html", "Tiled Browser Image (*.html) (for large images)");
        return imageSaveTypes;
    }

    private boolean exportToFile(File outImage, int width, boolean wholeGraph, File outHTML, ProgressController controller) throws IOException {
        JComponent viewControl = this.getTopGraphViewCookie().getGraphView().getViewControl();
        if (viewControl instanceof U) {
            U view = (U)viewControl;
            boolean transparentBackground = false;
            if (outImage.getPath().toLowerCase().endsWith(".png")) {
                transparentBackground = true;
            }
            return Graph2DExporter.exportToFile((File)outImage, (SA)view.getGraph2D(), (boolean)transparentBackground, (int)width, (boolean)wholeGraph, (File)outHTML, (ProgressController)controller);
        }
        return false;
    }

    private /* synthetic */ void lambda$actionPerformed$3(U graph2DView, JSpinner zoomSpinner, RangeClipSpinner widthSpinner, ImageBoundsRadioButtons imageBoundsRadios, ActionEvent evt) {
        if (evt.getSource() instanceof JRadioButton && this._updating.compareAndSet(false, true)) {
            this.updateWidth(graph2DView, zoomSpinner, widthSpinner, imageBoundsRadios.isWholeGraph());
            this.setUpdating(false);
        }
    }

    private /* synthetic */ void lambda$actionPerformed$2(U graph2DView, RangeClipSpinner widthSpinner, JSpinner zoomSpinner, ImageBoundsRadioButtons imageBoundsRadios, ChangeEvent evt) {
        if (evt.getSource() instanceof RangeClipSpinner && this._updating.compareAndSet(false, true)) {
            this.updateZoomLevel(graph2DView, widthSpinner, zoomSpinner, imageBoundsRadios.isWholeGraph());
            this.setUpdating(false);
        }
    }

    private /* synthetic */ void lambda$actionPerformed$1(U graph2DView, JSpinner zoomSpinner, RangeClipSpinner widthSpinner, ImageBoundsRadioButtons imageBoundsRadios, ChangeEvent evt) {
        if (evt.getSource() instanceof JSpinner && this._updating.compareAndSet(false, true)) {
            this.updateWidth(graph2DView, zoomSpinner, widthSpinner, imageBoundsRadios.isWholeGraph());
            this.setUpdating(false);
        }
    }

    private /* synthetic */ void lambda$actionPerformed$0(U graph2DView, JSpinner zoomSpinner, RangeClipSpinner widthSpinner, ImageBoundsRadioButtons imageBoundsRadios, PropertyChangeEvent evt) {
        if (this._updating.compareAndSet(false, true)) {
            FileNameExtensionFilter filter = (FileNameExtensionFilter)evt.getNewValue();
            this._fileType = this.mapFileType(filter.getExtensions()[0]);
            this.updateWidth(graph2DView, zoomSpinner, widthSpinner, imageBoundsRadios.isWholeGraph());
            this.setUpdating(false);
        }
    }

    private static enum FILE_TYPE {
        PNG("png"),
        JPG("jpg"),
        BMP("bmp"),
        HTML("html");

        private final String ext;

        private FILE_TYPE(String ext) {
            this.ext = ext;
        }

        public String getExtension() {
            return this.ext;
        }
    }
}

