/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class DarculaModSliderUI
extends BasicSliderUI {
    public static ComponentUI createUI(JComponent component) {
        return new DarculaModSliderUI((JSlider)component);
    }

    public DarculaModSliderUI(JSlider slider) {
        super(slider);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        int height;
        int width;
        int y;
        int x;
        Color oldColor = graphics.getColor();
        if (this.slider.getOrientation() == 0) {
            x = this.trackRect.x;
            y = this.trackRect.y + (this.trackRect.height >> 1) - 2;
            width = this.trackRect.width;
            height = 5;
        } else {
            x = this.trackRect.x + (this.trackRect.width >> 1) - 2;
            y = this.trackRect.y;
            width = 5;
            height = this.trackRect.height;
        }
        graphics.setColor(UIManager.getLookAndFeelDefaults().getColor("Slider.darculaMod.trackBackgroundColor"));
        graphics.fillRect(x, y, width, height);
        if (this.slider.getClientProperty("JSlider.isFilled") != null && ((Boolean)this.slider.getClientProperty("JSlider.isFilled")).booleanValue()) {
            graphics.setColor(UIManager.getLookAndFeelDefaults().getColor("Slider.darculaMod.trackLeftBackgroundColor"));
            if (this.slider.getOrientation() == 0) {
                if (this.drawInverted()) {
                    graphics.fillRect(this.thumbRect.x, y + 1, width - 2 - (this.thumbRect.x - x), height - 2);
                } else {
                    graphics.fillRect(x + 1, y + 1, this.thumbRect.x - x, height - 2);
                }
            } else if (this.drawInverted()) {
                graphics.fillRect(x + 1, this.thumbRect.y, width - 2 - (this.thumbRect.y - y), height - 2);
            } else {
                graphics.fillRect(x + 1, y + 1, width - 2, this.thumbRect.y - y);
            }
        }
        graphics.setColor(oldColor);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Color oldColor = graphics.getColor();
        graphics.setColor(UIManager.getLookAndFeelDefaults().getColor("Slider.darculaMod.thumbBackgroundColor"));
        graphics.fillRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        graphics.setColor(oldColor);
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = 20;
            size.height = 4;
        } else {
            size.width = 4;
            size.height = 20;
        }
        return size;
    }

    @Override
    public void paintLabels(Graphics g) {
        Rectangle labelBounds = this.labelRect;
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            int minValue = this.slider.getMinimum();
            int maxValue = this.slider.getMaximum();
            boolean enabled = this.slider.isEnabled();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                int value = key;
                if (value < minValue || value > maxValue) continue;
                JComponent label = (JComponent)dictionary.get(key);
                label.setEnabled(enabled);
                if (label instanceof JLabel) {
                    Icon icon = label.isEnabled() ? ((JLabel)label).getIcon() : ((JLabel)label).getDisabledIcon();
                    label.setForeground(this.slider.isEnabled() ? UIManager.getLookAndFeelDefaults().getColor("Slider.darculaMod.labelForegroundColor") : UIManager.getLookAndFeelDefaults().getColor("Slider.darculaMod.labelDisabledForegroundColor"));
                    label.setFont(UIManager.getLookAndFeelDefaults().getFont("Slider.darculaMod.labelFont"));
                    if (icon instanceof ImageIcon) {
                        Toolkit.getDefaultToolkit().checkImage(((ImageIcon)icon).getImage(), -1, -1, this.slider);
                    }
                }
                if (this.slider.getOrientation() == 0) {
                    g.translate(0, labelBounds.y);
                    this.paintHorizontalLabel(g, value, label);
                    g.translate(0, -labelBounds.y);
                    continue;
                }
                int offset = 0;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    offset = labelBounds.width - label.getPreferredSize().width;
                }
                g.translate(labelBounds.x + offset, 0);
                this.paintVerticalLabel(g, value, label);
                g.translate(-labelBounds.x - offset, 0);
            }
        }
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle tickBounds, int x) {
        graphics.drawLine(x, 1, x, (tickBounds.height >> 1) - 1);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle tickBounds, int x) {
        graphics.drawLine(x, 1, x, tickBounds.height - 2);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle tickBounds, int y) {
        graphics.drawLine(1, y, (tickBounds.width >> 1) - 1, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle tickBounds, int y) {
        graphics.drawLine(1, y, tickBounds.width - 2, y);
    }
}

