/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaModLabelUI;
import com.bulenkov.iconloader.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;

public class DarculaModNetbeansOptionsAwareLabelUI
extends MetalLabelUI {
    private static final Color backgroundDefaultHover = new Color(224, 232, 246);
    private final Color foreground = UIManager.getLookAndFeelDefaults().getColor("Button.foreground");
    private final Color background = UIManager.getLookAndFeelDefaults().getColor("Button.darcula.color1");
    private final Color backgroundSelected = UIManager.getLookAndFeelDefaults().getColor("Button.darcula.selection.color1");
    private final Color backgroundHover = UIManager.getLookAndFeelDefaults().getColor("Button.darculaMod.hoverColor1");
    private final Border border = new EmptyBorder(6, 8, 6, 8);
    private boolean ignoreChanges;

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.ignoreChanges) {
            super.propertyChange(e);
            return;
        }
        if (!(e.getSource() instanceof JLabel)) {
            super.propertyChange(e);
            return;
        }
        JLabel c = (JLabel)e.getSource();
        this.checkParent(c);
        if (null != e.getPropertyName()) {
            switch (e.getPropertyName()) {
                case "background": {
                    this.ignoreChanges = true;
                    Color backgroundCurrent = c.getBackground();
                    if (Color.WHITE.equals(backgroundCurrent)) {
                        c.setBackground(this.background);
                    } else if (backgroundDefaultHover.equals(backgroundCurrent)) {
                        c.setBackground(this.backgroundHover);
                    } else if (!this.background.equals(backgroundCurrent)) {
                        c.setBackground(this.backgroundSelected);
                    }
                    this.ignoreChanges = false;
                    break;
                }
                case "foreground": {
                    this.ignoreChanges = true;
                    if (!this.foreground.equals(c.getForeground())) {
                        c.setForeground(this.foreground);
                    }
                    this.ignoreChanges = false;
                    break;
                }
                case "border": {
                    this.ignoreChanges = true;
                    c.setBorder(this.border);
                    this.ignoreChanges = false;
                    break;
                }
                default: {
                    super.propertyChange(e);
                }
            }
        }
    }

    private void checkParent(JComponent c) {
        Container parent = c.getParent();
        if (parent instanceof JPanel && !this.background.equals(parent.getBackground())) {
            parent.setBackground(this.background);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        if (c.getClass().getName().startsWith("org.netbeans.modules.options")) {
            return new DarculaModNetbeansOptionsAwareLabelUI();
        }
        return DarculaModLabelUI.createUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsUtil.setupTextAntialiasing(g, c);
        super.paint(g, c);
    }
}

