/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api.registry;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.api.registry.HubSeedSettingsAction;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformSeedRepository;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

class DefaultHubSeedSettings
extends HubSeedSettings {
    private final TransformSeedRepository _repo;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final HubSeedRegistry _registry = HubSeedRegistry.getDefault();

    public DefaultHubSeedSettings(TransformSeedRepository repo) {
        this._repo = repo;
    }

    @Override
    public boolean isInstalled(HubSeedDescriptor seed) {
        TransformSeed transformSeed = this._registry.getTransformSeed(seed);
        return transformSeed != null ? transformSeed.isEnabled() : false;
    }

    @Override
    public void setInstalled(HubSeedDescriptor seed, boolean installed) {
        TransformSeed transformSeed = this._registry.getTransformSeed(seed);
        if (transformSeed.isEnabled() != installed) {
            transformSeed.setEnabled(installed);
            this.save(transformSeed);
            this._changeSupport.firePropertyChange("maltego.hub.installed", null, seed);
        }
    }

    @Override
    public DisplayDescriptorCollection getGlobalTransformProperties(HubSeedDescriptor seed) {
        TransformSeed transformSeed = this._registry.getTransformSeed(seed);
        return transformSeed != null ? transformSeed.getGlobalTxProperties() : new DisplayDescriptorList();
    }

    @Override
    public DisplayDescriptorCollection getGlobalTransformProperties(HubSeedDescriptor seed, TransformDefinition transform, boolean authOnly) {
        DisplayDescriptorCollection txProps;
        DisplayDescriptorList properties = new DisplayDescriptorList();
        DisplayDescriptorCollection seedProps = this.getGlobalTransformProperties(seed);
        if (seedProps != null && (txProps = transform.getProperties()) != null) {
            for (DisplayDescriptor seedProp : seedProps) {
                TransformPropertyDescriptor seedTpd;
                if (seedProp == null || !txProps.contains((seedTpd = (TransformPropertyDescriptor)seedProp).getName()) || authOnly && !seedTpd.isAuth()) continue;
                properties.add((DisplayDescriptor)seedTpd);
            }
        }
        return properties;
    }

    @Override
    public DisplayDescriptorCollection getGlobalTransformProperties(TransformDefinition transform) {
        DisplayDescriptorList properties = new DisplayDescriptorList();
        for (HubSeedDescriptor hubSeed : HubSeedRegistry.getDefault().getHubSeeds((TransformDescriptor)transform)) {
            for (DisplayDescriptor prop : this.getGlobalTransformProperties(hubSeed, transform, false)) {
                DisplayDescriptor property;
                if (prop == null || properties.contains(prop.getName()) || (property = transform.getProperties().get(prop.getName())) == null) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    @Override
    public DataSource getGlobalTransformSettings(HubSeedDescriptor seed) {
        return new HubSettingsDataSource(seed);
    }

    @Override
    public void save(HubSeedDescriptor seed) {
        if (seed.getHubSeedUrl() != null) {
            this.save(this._registry.getTransformSeed(seed));
        }
    }

    @Override
    public void show(HubSeedDescriptor seed) {
        HubSeedSettingsAction action = (HubSeedSettingsAction)Lookup.getDefault().lookup(HubSeedSettingsAction.class);
        if (action != null) {
            action.show(seed);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private void save(TransformSeed transformSeed) {
        this._repo.add(transformSeed);
    }

    private class HubSettingsDataSource
    implements DataSource {
        private final HubSeedDescriptor _hubSeed;

        public HubSettingsDataSource(HubSeedDescriptor hubSeed) {
            this._hubSeed = hubSeed;
        }

        public Object getValue(PropertyDescriptor descriptor) {
            return this.getDelegate().getValue(descriptor);
        }

        public void setValue(PropertyDescriptor descriptor, Object value) {
            DataSources.Map delegate = this.getDelegate();
            this.setValue((DataSource)delegate, descriptor, value);
        }

        public void clear() {
            DataSources.Map delegate = this.getDelegate();
            for (PropertyDescriptor descriptor : delegate.keySet()) {
                this.setValue((DataSource)delegate, descriptor, null);
            }
            delegate.clear();
        }

        void setValue(DataSource delegate, PropertyDescriptor descriptor, Object value) {
            Object oldValue = delegate.getValue(descriptor);
            if (!Utilities.compareObjects((Object)oldValue, (Object)value)) {
                delegate.setValue(descriptor, value);
                DefaultHubSeedSettings.this._changeSupport.firePropertyChange(descriptor.getName(), oldValue, value);
            }
        }

        private DataSources.Map getDelegate() {
            TransformSeed transformSeed = DefaultHubSeedSettings.this._registry.getTransformSeed(this._hubSeed);
            return transformSeed.getGlobalTxSettings();
        }
    }
}

