/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api.registry;

import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedInstaller;
import com.paterva.maltego.seeds.api.HubSeedTagType;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.DefaultHubSeedSettings;
import com.paterva.maltego.seeds.api.registry.HubProvider;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.api.serialize.HubSeedReader;
import com.paterva.maltego.seeds.api.serialize.HubSeedWriter;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformSeedRepository;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.protocol.v2api.TransformTranslator;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformListInputDescriptor;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformTranslator;
import com.paterva.maltego.transform.repository.FSTransformSeedRepository;
import com.paterva.maltego.transform.repository.TransformRepositoriesLock;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class DefaultHubSeedRegistry
extends HubSeedRegistry {
    private static final Logger LOG = Logger.getLogger(DefaultHubSeedRegistry.class.getName());
    private static final String MALTEGO_FOLDER = "Maltego";
    private static final String SEED_FOLDER = "Seeds";
    private static final String EXTENSION = "hub";
    private static final String ATTR_ID = "url";
    private HubSeeds _seeds;
    private final TransformRepositoryRegistry repositoryRegistry = TransformRepositoryRegistry.getDefault();
    private final FileObject _configRoot;
    private final TransformSeedRepository _repo;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private boolean _online = true;

    public DefaultHubSeedRegistry() {
        this._configRoot = FileUtil.getConfigRoot();
        this._repo = TransformSeedRepository.getDefault();
        LicenseManager.A().A(ignored -> this.getSeeds(true));
    }

    public DefaultHubSeedRegistry(FileObject configRoot) {
        this._configRoot = configRoot;
        this._repo = new FSTransformSeedRepository(configRoot);
    }

    @Override
    public boolean isOnline() {
        return this._online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HubSeeds getSeeds(boolean refresh) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (refresh || this._seeds == null) {
                HubSeeds downloadedSeeds = this.downloadSeeds();
                HubSeeds loadedSeeds = this.loadSeeds();
                List<HubSeedDescriptor> seeds = this.mergeSeeds(downloadedSeeds, loadedSeeds);
                List<HubSeedTagType> tagTypes = downloadedSeeds != null ? downloadedSeeds.getTagTypes() : loadedSeeds.getTagTypes();
                this._seeds = new HubSeeds(seeds, tagTypes);
                this.updateGlobalTxProperties();
                if (downloadedSeeds != null) {
                    this.removeSeedsForMissingHubItems();
                }
                this.saveSeeds();
                this._online = downloadedSeeds != null;
                this.firePropertyChange("onlineChanged");
                this.firePropertyChange("seedsChanged");
            }
            return this._seeds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSeed(HubSeedDescriptor seed) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (seed.isCustom() && !A.A((String)seed.getHubSeedUrl().getUrl())) {
                throw new IllegalArgumentException("Only *.paterva.com custom hub items are allowed in the free version of Maltego.");
            }
            HubSeeds seeds = this.getSeeds(false);
            for (HubSeedDescriptor s : seeds.getSeeds()) {
                if (!s.equals(seed)) continue;
                throw new IllegalArgumentException("Seed already exist: " + seed.getDisplayName());
            }
            for (HubSeedDescriptor s : seeds.getSeeds()) {
                HubSeedUrl url = s.getHubSeedUrl();
                if (url == null || !url.getUrl().equals(seed.getHubSeedUrl().getUrl())) continue;
                throw new IllegalArgumentException("Seed for URL already exist: " + seed.getHubSeedUrl().getUrl());
            }
            seeds.getSeeds().add(seed);
            this.saveSeeds();
            this.firePropertyChange("seedsChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSeed(HubSeedDescriptor seed, boolean removeTransformSeed) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            HubSeeds seeds = this.getSeeds(false);
            seeds.getSeeds().remove(seed);
            if (removeTransformSeed) {
                this.removeOldStyleSeed(seed);
            }
            this.saveSeeds();
            this.firePropertyChange("seedsChanged");
        }
    }

    @Override
    public void removeSeeds(Collection<HubSeedDescriptor> descriptors, boolean removeTransformSeed) {
        HubSeeds seeds = this.getSeeds(false);
        seeds.getSeeds().removeAll(descriptors);
        if (removeTransformSeed) {
            for (HubSeedDescriptor descriptor : descriptors) {
                this.removeOldStyleSeed(descriptor);
            }
        }
        this.saveSeeds();
        this.firePropertyChange("seedsChanged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransformSeed getTransformSeed(HubSeedDescriptor seed) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            return this.getTransformSeed(seed, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformSeed getTransformSeed(HubSeedDescriptor seed, boolean create) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            FastURL url;
            TransformSeed transformSeed = null;
            HubSeedUrl hubSeedUrl = seed.getHubSeedUrl();
            if (hubSeedUrl != null && (transformSeed = this._repo.get(url = new FastURL(hubSeedUrl.getUrl()))) == null && create) {
                String description = seed.getDescription() != null ? seed.getDescription() : "";
                DisplayDescriptorCollection globalTxProperties = this.translateGlobalTransformInputs(seed);
                transformSeed = new TransformSeed(url, seed.getDisplayName(), description, globalTxProperties, null);
                transformSeed.setEnabled(false);
                this._repo.add(transformSeed);
            }
            return transformSeed;
        }
    }

    private DisplayDescriptorCollection translateGlobalTransformInputs(HubSeedDescriptor seed) {
        DisplayDescriptorCollection globalTxProperties = null;
        try {
            List<TransformListInputDescriptor> transformListInputs = seed.getTransformInputs();
            RemoteTransformTranslator remoteTransformTranslator = new RemoteTransformTranslator();
            Set transformInputs = remoteTransformTranslator.translateInputs(transformListInputs);
            globalTxProperties = TransformTranslator.translate((Set)transformInputs);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return globalTxProperties;
    }

    private void removeOldStyleSeed(HubSeedDescriptor seed) {
        HubSeedUrl url = seed.getHubSeedUrl();
        if (url != null) {
            TransformServerRegistry.getDefault().removeSeedUrl(url.getUrl());
            this._repo.remove(new FastURL(url.getUrl()));
        }
    }

    private void updateGlobalTxProperties() {
        for (HubSeedDescriptor seed : this._seeds.getSeeds()) {
            TransformSeed transformSeed = this.getTransformSeed(seed, false);
            if (transformSeed == null) continue;
            DisplayDescriptorCollection globalTxProperties = this.translateGlobalTransformInputs(seed);
            transformSeed.setGlobalTxProperties(globalTxProperties);
        }
    }

    @Override
    public HubSeedDescriptor getHubSeed(String url) {
        HubSeeds seeds = this.getSeeds(false);
        return seeds.getSeed(null, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HubSeedDescriptor getHubSeed(TransformSeed oldStyleSeed) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            HubSeedDescriptor sd = new HubSeedDescriptor();
            sd.setCustom(true);
            sd.setDisplayName(oldStyleSeed.getName());
            sd.setDescription(oldStyleSeed.getDescription());
            sd.setUrl(new HubSeedUrl(oldStyleSeed.getUrl().toString()));
            sd.setPos(1000000);
            return sd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HubSeedDescriptor> getHubSeeds(TransformServerInfo server) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            ArrayList<HubSeedDescriptor> hubSeeds = new ArrayList<HubSeedDescriptor>();
            HubSeeds seeds = this.getSeeds(false);
            for (String seedUrl : server.getSeedUrls()) {
                HubSeedDescriptor seed = seeds.getSeed(null, seedUrl);
                if (seed == null) continue;
                hubSeeds.add(seed);
            }
            Collections.sort(hubSeeds);
            return hubSeeds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HubSeedDescriptor> getHubSeeds(TransformDescriptor transform) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            HashSet<HubSeedDescriptor> hubSeedSet = new HashSet<HubSeedDescriptor>();
            TransformServerRegistry serverRegistry = TransformServerRegistry.getDefault();
            Set servers = serverRegistry.findServers(transform.getName(), false);
            for (TransformServerInfo server : servers) {
                hubSeedSet.addAll(this.getHubSeeds(server));
            }
            ArrayList<HubSeedDescriptor> hubSeeds = new ArrayList<HubSeedDescriptor>(hubSeedSet);
            Collections.sort(hubSeeds);
            return hubSeeds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TransformServerInfo> getServers(HubSeedDescriptor seed) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (!DefaultHubSeedSettings.getDefault().isInstalled(seed)) {
                return Collections.EMPTY_SET;
            }
            HashSet<TransformServerInfo> servers = new HashSet<TransformServerInfo>();
            TransformServerRegistry serverRegistry = TransformServerRegistry.getDefault();
            for (TransformServerInfo server : serverRegistry.getAll()) {
                if (!this.getHubSeeds(server).contains(seed)) continue;
                servers.add(server);
            }
            return servers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TransformDefinition> getTransforms(HubSeedDescriptor seed) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (!DefaultHubSeedSettings.getDefault().isInstalled(seed)) {
                return Collections.EMPTY_SET;
            }
            HashSet<TransformDefinition> transforms = new HashSet<TransformDefinition>();
            TransformRepository repository = this.repositoryRegistry.getRepository("Remote");
            for (TransformServerInfo server : this.getServers(seed)) {
                for (String transformName : server.getTransforms()) {
                    TransformDefinition transform = repository.get(transformName);
                    if (transform == null) continue;
                    transforms.add(transform);
                }
            }
            return transforms;
        }
    }

    private List<HubSeedDescriptor> mergeSeeds(HubSeeds downloadedSeeds, HubSeeds loadedSeeds) {
        boolean OLD_WAY = false;
        ArrayList<HubSeedDescriptor> seeds = new ArrayList<HubSeedDescriptor>();
        if (downloadedSeeds != null) {
            seeds.addAll(downloadedSeeds.getSeeds());
            for (HubSeedDescriptor seed : loadedSeeds.getSeeds()) {
                try {
                    HubSeedDescriptor onlineSeed = downloadedSeeds.getSeed(seed.getName(), seed.getHubSeedUrl());
                    if (onlineSeed == null) {
                        if (!seed.isCustom()) {
                            boolean installed = DefaultHubSeedSettings.getDefault().isInstalled(seed);
                            if (installed) {
                                if (OLD_WAY) {
                                    seed.setCustom(true);
                                    seeds.add(seed);
                                    continue;
                                }
                                this.uninstall(seed);
                                continue;
                            }
                            this.removeOldStyleSeed(seed);
                            continue;
                        }
                        seeds.add(seed);
                        continue;
                    }
                    HubSeedUrl oldSeedUrl = seed.getHubSeedUrl();
                    HubSeedUrl newSeedUrl = onlineSeed.getHubSeedUrl();
                    if (oldSeedUrl != null && newSeedUrl != null) {
                        String newUrl;
                        String oldUrl = oldSeedUrl.getUrl();
                        if (oldUrl.equalsIgnoreCase(newUrl = newSeedUrl.getUrl())) continue;
                        LOG.log(Level.FINE, "Updating seed URL for {0} from {1} to {2}", new Object[]{seed.getName(), oldSeedUrl.getUrl(), newSeedUrl.getUrl()});
                        TransformSeedRepository.getDefault().updateUrl(oldUrl, newUrl);
                        TransformServerRegistry.getDefault().updateSeedUrl(oldUrl, newUrl);
                        continue;
                    }
                    if (oldSeedUrl == null || newSeedUrl != null) continue;
                    this.uninstall(seed);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.removeMissingSeeds(downloadedSeeds, loadedSeeds);
        } else {
            for (HubSeedDescriptor seed : loadedSeeds.getSeeds()) {
                try {
                    if (seed.isCustom()) {
                        seeds.add(seed);
                        continue;
                    }
                    boolean installed = DefaultHubSeedSettings.getDefault().isInstalled(seed);
                    if (installed) {
                        if (!OLD_WAY) continue;
                        seeds.add(seed);
                        continue;
                    }
                    this.removeOldStyleSeed(seed);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return seeds;
    }

    private void removeMissingSeeds(HubSeeds downloadedSeeds, HubSeeds loadedSeeds) {
        TransformSeedRepository seedRepo = TransformSeedRepository.getDefault();
        List<FastURL> downloadedSeedUrls = this.getUrls(downloadedSeeds);
        LOG.log(Level.FINE, "Downloaded seed URLs: {0}", downloadedSeedUrls);
        List transformSeedUrls = Stream.of(seedRepo.getAll()).filter(transformSeed -> !this.isCustom(loadedSeeds, (TransformSeed)transformSeed)).map(TransformSeed::getUrl).collect(Collectors.toList());
        LOG.log(Level.FINE, "Existing seed URLs: {0}", transformSeedUrls);
        ArrayList missingSeedUrls = new ArrayList(transformSeedUrls);
        missingSeedUrls.removeAll(downloadedSeedUrls);
        for (FastURL missingSeedUrl : missingSeedUrls) {
            try {
                LOG.log(Level.FINE, "Removing old seeds for which the URL is missing (e.g. URL was modified): {0}", missingSeedUrl);
                seedRepo.remove(missingSeedUrl);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private List<FastURL> getUrls(HubSeeds downloadedSeeds) {
        List<FastURL> hubSeedUrls = downloadedSeeds.getSeeds().stream().map(this::getUrl).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return hubSeedUrls;
    }

    private boolean isCustom(HubSeeds loadedSeeds, TransformSeed transformSeed) {
        return loadedSeeds.getSeeds().stream().filter(HubSeedDescriptor::isCustom).map(this::getUrl).filter(Optional::isPresent).map(Optional::get).anyMatch(url -> url.equalsIgnoreCase(transformSeed.getUrl()));
    }

    private Optional<FastURL> getUrl(HubSeedDescriptor hubSeed) {
        return Optional.of(hubSeed).map(HubSeedDescriptor::getHubSeedUrl).filter(Objects::nonNull).map(HubSeedUrl::getUrl).filter(url -> !StringUtilities.isNullOrEmpty((String)url)).map(FastURL::new);
    }

    private void uninstall(HubSeedDescriptor seed) {
        HubSeedInstaller.getDefault().uninstall(seed);
        HubSeedSettings.getDefault().setInstalled(seed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HubSeeds downloadSeeds() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            HubSeeds seeds = null;
            boolean OLD_WAY = false;
            seeds = HubProvider.getDefault().getHubSeeds();
            return seeds;
        }
    }

    public HubSeeds loadSeeds() {
        ArrayList<HubSeedDescriptor> seeds = new ArrayList<HubSeedDescriptor>();
        for (FileObject seedFile : this.getSeedFiles()) {
            HubSeedDescriptor seed = this.load(seedFile);
            if (seed == null) continue;
            HubSeedUrl url = seed.getHubSeedUrl();
            if (seed.getName() == null && url == null) {
                LOG.severe(() -> "Seed must have a unique name or URL. Display name: " + seed.getDisplayName());
            }
            if (seed.isCustom() && url != null && !A.A((String)url.getUrl())) continue;
            seeds.add(seed);
        }
        return new HubSeeds(seeds, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HubSeedDescriptor load(FileObject seedFile) {
        InputStream is = null;
        HubSeedDescriptor seed = null;
        try {
            is = seedFile.getInputStream();
            HubSeedReader reader = new HubSeedReader();
            seed = reader.readSeed(is);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return seed;
    }

    private void saveSeeds() {
        FileObject[] seedFiles = this.getSeedFiles();
        for (FileObject seedFile : seedFiles) {
            try {
                seedFile.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        for (HubSeedDescriptor seed : this._seeds.getSeeds()) {
            this.save(seed);
        }
    }

    private void save(HubSeedDescriptor seed) {
        try {
            FileObject fo = this.getFile(seed);
            if (fo != null) {
                DefaultHubSeedRegistry.update(fo, seed);
            } else {
                FileObject folder = this.getOrCreateSeedFolder();
                DefaultHubSeedRegistry.update(FileUtilities.createUniqueFile((FileObject)folder, (String)FileUtilities.replaceIllegalChars((String)seed.getDisplayName()), (String)EXTENSION), seed);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void update(FileObject fo, HubSeedDescriptor seed) throws IOException {
        String id = seed.getName();
        if (id == null) {
            id = seed.getHubSeedUrl().getUrl();
        }
        fo.setAttribute(ATTR_ID, (Object)id);
        try (BufferedOutputStream os = new BufferedOutputStream(fo.getOutputStream());){
            HubSeedWriter writer = new HubSeedWriter();
            writer.writeXml(seed, (OutputStream)os);
        }
    }

    private FileObject getFile(HubSeedDescriptor seed) {
        for (FileObject fo : this.getSeedFiles()) {
            String name = seed.getName();
            if (name != null && name.equals(fo.getAttribute(ATTR_ID))) {
                return fo;
            }
            HubSeedUrl url = seed.getHubSeedUrl();
            if (url == null || !url.getUrl().equals(fo.getAttribute(ATTR_ID))) continue;
            return fo;
        }
        return null;
    }

    private FileObject[] getSeedFiles() {
        ArrayList<FileObject> seeds = new ArrayList<FileObject>();
        FileObject folder = this.getSeedFolder();
        if (folder != null) {
            Enumeration files = folder.getChildren(false);
            while (files.hasMoreElements()) {
                FileObject seedFile = (FileObject)files.nextElement();
                if (seedFile.isFolder() || !EXTENSION.equals(seedFile.getExt())) continue;
                seeds.add(seedFile);
            }
        }
        return seeds.toArray(new FileObject[seeds.size()]);
    }

    private FileObject getSeedFolder() {
        FileObject maltegoFolder = this._configRoot.getFileObject(MALTEGO_FOLDER);
        if (maltegoFolder != null) {
            return maltegoFolder.getFileObject(SEED_FOLDER);
        }
        return null;
    }

    private FileObject getOrCreateSeedFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this.getOrCreateMaltegoFolder(), (String)SEED_FOLDER);
    }

    private FileObject getOrCreateMaltegoFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)MALTEGO_FOLDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        PropertyChangeSupport propertyChangeSupport = this._changeSupport;
        synchronized (propertyChangeSupport) {
            this._changeSupport.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        PropertyChangeSupport propertyChangeSupport = this._changeSupport;
        synchronized (propertyChangeSupport) {
            this._changeSupport.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String propertyName) {
        PropertyChangeSupport propertyChangeSupport = this._changeSupport;
        synchronized (propertyChangeSupport) {
            this._changeSupport.firePropertyChange(propertyName, null, null);
        }
    }

    private void removeSeedsForMissingHubItems() {
        TransformSeed[] seeds;
        for (TransformSeed seed : seeds = TransformSeedRepository.getDefault().getAll()) {
            FastURL url = seed.getUrl();
            String seedUrl = url.toString();
            HubSeedDescriptor hubSeed = this.getHubSeed(seedUrl);
            if (hubSeed != null) continue;
            TransformServerRegistry serverRegistry = TransformServerRegistry.getDefault();
            serverRegistry.removeSeedUrl(seedUrl);
            this._repo.remove(url);
        }
    }
}

