/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import org.officelaf.ribbon.CollapsedBandIcon;
import org.officelaf.ribbon.OfficeCommandButtonUI;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;

public class OfficeRibbonBandUI
extends BasicRibbonBandUI {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    boolean isUnderMouse = false;

    public static ComponentUI createUI(JComponent c) {
        return new OfficeRibbonBandUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.ribbonBand.setOpaque(Boolean.FALSE.booleanValue());
    }

    protected void installComponents() {
        super.installComponents();
        CollapsedBandIcon icon = new CollapsedBandIcon((Icon)this.ribbonBand.getIcon());
        this.collapsedButton.setUI((CommandButtonUI)new CollapsedRibbonBandButtonUI());
        this.collapsedButton.setIcon((ResizableIcon)icon);
        this.collapsedButton.setDisabledIcon((ResizableIcon)icon);
    }

    protected void paintBandTitle(Graphics g, Rectangle titleRectangle, String title) {
    }

    public int getBandTitleHeight() {
        return 0;
    }

    protected void paintBandBackground(Graphics graphics, Rectangle toFill) {
        if (this.ribbonBand.getCurrentResizePolicy() instanceof IconRibbonBandResizePolicy) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int y = toFill.y;
        int x = toFill.x;
        int width = toFill.width;
        int height = toFill.height;
        int x3 = x + width - 2;
        int y3 = y + height - 2;
        int y1 = y + 3;
        g2d.setPaint(LAF.getColor("ribbon-band-separator-color"));
        g2d.drawLine(x3 + 1, y1 - 1, x3 + 1, y3 - 2);
        g2d.drawLine(x3, y1 - 1, x3, y3 - 2);
        g2d.dispose();
    }

    public void trackMouseCrossing(boolean isMouseIn) {
        super.trackMouseCrossing(isMouseIn);
        this.isUnderMouse = isMouseIn;
    }

    protected void paintBandTitleBackground(Graphics g, Rectangle titleRectangle, String title) {
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonBandLayout();
    }

    public static class CollapsedRibbonBandButtonUI
    extends OfficeCommandButtonUI {
        @Override
        protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
            this.painter.paintCollapsedBandButtonBackground(graphics, toFill);
        }

        protected boolean isPaintingBackground() {
            return true;
        }
    }

    private class RibbonBandLayout
    implements LayoutManager {
        private RibbonBandLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            AbstractBandControlPanel controlPanel = OfficeRibbonBandUI.this.ribbonBand.getControlPanel();
            boolean useCollapsedButton = controlPanel == null || !controlPanel.isVisible();
            int width = useCollapsedButton ? ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getPreferredSize().width : controlPanel.getPreferredSize().width;
            int height = (useCollapsedButton ? ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getPreferredSize().height : controlPanel.getPreferredSize().height) + OfficeRibbonBandUI.this.getBandTitleHeight();
            return new Dimension(width + 2 + (!useCollapsedButton ? ins.left + ins.right : 0), height + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Insets ins = c.getInsets();
            AbstractBandControlPanel controlPanel = OfficeRibbonBandUI.this.ribbonBand.getControlPanel();
            boolean useCollapsedButton = controlPanel == null || !controlPanel.isVisible();
            int width = useCollapsedButton ? ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getMinimumSize().width : controlPanel.getMinimumSize().width;
            int height = useCollapsedButton ? ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getMinimumSize().height + OfficeRibbonBandUI.this.getBandTitleHeight() : controlPanel.getMinimumSize().height + OfficeRibbonBandUI.this.getBandTitleHeight();
            return new Dimension(width + 2 + (!useCollapsedButton ? ins.left + ins.right : 0), height + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container c) {
            if (!c.isVisible()) {
                return;
            }
            Insets ins = c.getInsets();
            int availableHeight = c.getHeight() - ins.top - ins.bottom;
            RibbonBandResizePolicy resizePolicy = ((AbstractRibbonBand)c).getCurrentResizePolicy();
            if (resizePolicy instanceof IconRibbonBandResizePolicy) {
                OfficeRibbonBandUI.this.collapsedButton.setVisible(true);
                int w = ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getPreferredSize().width;
                OfficeRibbonBandUI.this.collapsedButton.setBounds(0, 0, c.getWidth(), c.getHeight());
                if (OfficeRibbonBandUI.this.collapsedButton.getPopupCallback() == null) {
                    final AbstractRibbonBand popupBand = OfficeRibbonBandUI.this.ribbonBand.cloneBand();
                    popupBand.setControlPanel(OfficeRibbonBandUI.this.ribbonBand.getControlPanel());
                    List resizePolicies = OfficeRibbonBandUI.this.ribbonBand.getResizePolicies();
                    popupBand.setResizePolicies(resizePolicies);
                    RibbonBandResizePolicy largest = (RibbonBandResizePolicy)resizePolicies.get(0);
                    popupBand.setCurrentResizePolicy(largest);
                    final Dimension size = new Dimension(4 + largest.getPreferredWidth(availableHeight, 4), ins.top + ins.bottom + Math.max(c.getHeight(), ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).ribbonBand.getControlPanel().getPreferredSize().height + OfficeRibbonBandUI.this.getBandTitleHeight()));
                    OfficeRibbonBandUI.this.collapsedButton.setPopupCallback(new PopupPanelCallback(){

                        public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                            return new BasicRibbonBandUI.CollapsedButtonPopupPanel((Component)popupBand, size);
                        }
                    });
                    OfficeRibbonBandUI.this.ribbonBand.setControlPanel(null);
                    OfficeRibbonBandUI.this.ribbonBand.setPopupRibbonBand(popupBand);
                }
                if (OfficeRibbonBandUI.this.expandButton != null) {
                    OfficeRibbonBandUI.this.expandButton.setBounds(0, 0, 0, 0);
                }
                return;
            }
            if (OfficeRibbonBandUI.this.collapsedButton.isVisible()) {
                BasicRibbonBandUI.CollapsedButtonPopupPanel popupPanel;
                BasicRibbonBandUI.CollapsedButtonPopupPanel collapsedButtonPopupPanel = popupPanel = OfficeRibbonBandUI.this.collapsedButton.getPopupCallback() != null ? (BasicRibbonBandUI.CollapsedButtonPopupPanel)OfficeRibbonBandUI.this.collapsedButton.getPopupCallback().getPopupPanel(OfficeRibbonBandUI.this.collapsedButton) : null;
                if (popupPanel != null) {
                    AbstractRibbonBand bandFromPopup = (AbstractRibbonBand)popupPanel.removeComponent();
                    OfficeRibbonBandUI.this.ribbonBand.setControlPanel(bandFromPopup.getControlPanel());
                    OfficeRibbonBandUI.this.ribbonBand.setPopupRibbonBand(null);
                    OfficeRibbonBandUI.this.collapsedButton.setPopupCallback(null);
                }
            }
            OfficeRibbonBandUI.this.collapsedButton.setVisible(false);
            AbstractBandControlPanel controlPanel = OfficeRibbonBandUI.this.ribbonBand.getControlPanel();
            controlPanel.setVisible(true);
            controlPanel.setBounds(ins.left, ins.top, c.getWidth() - ins.left - ins.right, c.getHeight() - OfficeRibbonBandUI.this.getBandTitleHeight() - ins.top - ins.bottom);
            controlPanel.doLayout();
            if (OfficeRibbonBandUI.this.expandButton != null) {
                int ebpw = ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).expandButton.getPreferredSize().width;
                int ebph = ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).expandButton.getPreferredSize().height;
                int maxHeight = OfficeRibbonBandUI.this.getBandTitleHeight() - 4;
                if (ebph > maxHeight) {
                    ebph = maxHeight > 0 ? maxHeight : 0;
                }
                int expandButtonBottomY = c.getHeight() - (OfficeRibbonBandUI.this.getBandTitleHeight() - ebph) / 2;
                OfficeRibbonBandUI.this.expandButton.setBounds(c.getWidth() - ins.right - ebpw, expandButtonBottomY - ebph, ebpw, ebph);
            }
        }
    }
}

