/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.repository.serializer.PropertiesStub;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="MaltegoTransform", strict=false)
public class TransformDescriptorStub {
    @Attribute(name="name")
    private String _name;
    @Attribute(name="displayName")
    private String _displayName;
    @Element(name="TransformAdapter")
    private String _transformAdapter;
    @Element(name="Properties", required=false)
    private PropertiesStub _properties;
    @Element(name="Extends", required=false)
    private ExtendsStub _extends;
    @ElementList(name="InputConstraints", type=EntityReferenceStub.class, required=false)
    private List<EntityReferenceStub> _inputConstraints;
    @ElementList(name="OutputEntities", type=EntityReferenceStub.class, required=false)
    private List<EntityReferenceStub> _outputEntities;
    @Attribute(name="abstract", required=false)
    private boolean _abstract;
    @Attribute(name="template", required=false)
    private boolean _template;
    @Attribute(name="visibility", required=false)
    private String _visibility;
    @Attribute(name="description", required=false)
    private String _description;
    @Attribute(name="helpURL", required=false)
    private String _helpUrl;
    @Element(name="Help", data=true, required=false)
    private String _helpText;
    @Attribute(name="author", required=false)
    private String _author;
    @Attribute(name="owner", required=false)
    private String _owner;
    @Element(name="Disclaimer", data=true, required=false)
    private String _disclaimer;
    @Attribute(name="locationRelevance", required=false)
    private String _locationRelevance;
    @Attribute(name="version", required=false)
    private String _version;
    @ElementList(name="defaultSets", type=SetReferenceStub.class, required=false)
    private List<SetReferenceStub> _defaultSets;
    @Attribute(name="requireDisplayInfo", required=false)
    private boolean _requireDisplayInfo;
    @Element(name="StealthLevel", required=false)
    private int _stealthLevel;
    @Element(name="Authenticator", required=false)
    private String _authenticator;

    public String getBaseName() {
        if (this._extends != null) {
            return this._extends.getTransform();
        }
        return null;
    }

    public void setBaseName(String value) {
        if (this._extends == null) {
            this._extends = new ExtendsStub();
        }
        this._extends.setTransform(value);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String display) {
        this._displayName = display;
    }

    public PropertiesStub getProperties() {
        return this._properties;
    }

    public void setProperties(PropertiesStub properties) {
        this._properties = properties;
    }

    public List<EntityReferenceStub> getInputConstraints() {
        if (this._inputConstraints == null) {
            this._inputConstraints = new LinkedList<EntityReferenceStub>();
        }
        return this._inputConstraints;
    }

    public Collection<String> getOutputEntities() {
        LinkedList<String> list = new LinkedList<String>();
        if (this._outputEntities != null) {
            for (EntityReferenceStub stub : this._outputEntities) {
                if (stub.getTypeName() == null) continue;
                list.add(stub.getTypeName());
            }
        }
        return list;
    }

    public void setOutputEntities(Collection<String> entities) {
        this._outputEntities = new LinkedList<EntityReferenceStub>();
        if (entities != null && entities.size() > 0) {
            for (String s : entities) {
                this._outputEntities.add(new EntityReferenceStub(s));
            }
        }
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean value) {
        this._abstract = value;
    }

    public String getVisibility() {
        return this._visibility;
    }

    public void setVisibility(String visibility) {
        this._visibility = visibility;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getHelpUrl() {
        return this._helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this._helpUrl = helpUrl;
    }

    public String getHelpText() {
        return this._helpText;
    }

    public void setHelpText(String helpText) {
        this._helpText = helpText;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setOwner(String owner) {
        this._owner = owner;
    }

    public String getDisclaimer() {
        return this._disclaimer;
    }

    public void setDisclaimer(String disclaimer) {
        this._disclaimer = disclaimer;
    }

    public String getLocationRelevance() {
        return this._locationRelevance;
    }

    public void setLocationRelevance(String locationRelevance) {
        this._locationRelevance = locationRelevance;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String[] getDefaultSets() {
        if (this._defaultSets == null) {
            return new String[0];
        }
        String[] sets = new String[this._defaultSets.size()];
        int i = 0;
        for (SetReferenceStub stub : this._defaultSets) {
            sets[i] = stub.getName();
            ++i;
        }
        return sets;
    }

    public void setDefaultSets(String[] defaultSets) {
        this._defaultSets = new LinkedList<SetReferenceStub>();
        if (defaultSets != null) {
            for (String s : defaultSets) {
                this._defaultSets.add(new SetReferenceStub(s));
            }
        }
    }

    public boolean requiresDisplayInfo() {
        return this._requireDisplayInfo;
    }

    public void setRequireDisplayInfo(boolean requireDisplayInfo) {
        this._requireDisplayInfo = requireDisplayInfo;
    }

    public int getStealthLevel() {
        return this._stealthLevel;
    }

    public void setStealthLevel(int stealthLevel) {
        this._stealthLevel = stealthLevel;
    }

    public boolean isTemplate() {
        return this._template;
    }

    public void setTemplate(boolean template) {
        this._template = template;
    }

    public String getTransformAdapter() {
        return this._transformAdapter;
    }

    public void setTransformAdapter(String transformAdapter) {
        this._transformAdapter = transformAdapter;
    }

    public String getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(String authenticator) {
        this._authenticator = authenticator;
    }

    @Root(name="Property", strict=false)
    static class PropertyConstraintStub {
        @Attribute(name="name", required=false)
        private String _name;
        @Attribute(name="type", required=false)
        private String _type;
        @Attribute(name="nullable", required=false)
        private boolean _nullable;

        PropertyConstraintStub() {
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getType() {
            return this._type;
        }

        public void setType(String type) {
            this._type = type;
        }

        public boolean isNullable() {
            return this._nullable;
        }

        public void setNullable(boolean nullable) {
            this._nullable = nullable;
        }
    }

    @Root(name="Entity", strict=false)
    static class EntityReferenceStub {
        @Attribute(name="type", required=false)
        private String _typeName;
        @Attribute(name="min", required=false)
        private int _minimum = 0;
        @Attribute(name="max", required=false)
        private int _maximum = 0;
        @ElementList(inline=true, type=PropertyConstraintStub.class, required=false)
        private List<PropertyConstraintStub> _properties;

        public EntityReferenceStub() {
        }

        public EntityReferenceStub(String type) {
            this._typeName = type;
        }

        public String getTypeName() {
            return this._typeName;
        }

        public void setTypeName(String typeName) {
            this._typeName = typeName;
        }

        public int getMinimum() {
            return this._minimum;
        }

        public void setMinimum(int minimum) {
            this._minimum = minimum;
        }

        public int getMaximum() {
            return this._maximum;
        }

        public void setMaximum(int maximum) {
            this._maximum = maximum;
        }

        public List<PropertyConstraintStub> getProperties() {
            if (this._properties == null) {
                this._properties = new LinkedList<PropertyConstraintStub>();
            }
            return this._properties;
        }
    }

    @Root(name="Set", strict=false)
    static class SetReferenceStub {
        @Attribute(name="name", required=true)
        private String _setName;

        public SetReferenceStub() {
        }

        public SetReferenceStub(String setName) {
            this._setName = setName;
        }

        public String getName() {
            return this._setName;
        }

        public void setName(String setName) {
            this._setName = setName;
        }
    }

    @Root(name="Extends", strict=false)
    static class ExtendsStub {
        @Attribute(name="transform")
        private String _transform;

        public String getTransform() {
            return this._transform;
        }

        public void setTransform(String transform) {
            this._transform = transform;
        }
    }
}

