/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.matching.StatelessMatchingRuleDescriptor;
import com.paterva.maltego.transform.descriptor.CompoundConstraint;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.EntityConstraint;
import com.paterva.maltego.transform.descriptor.IntegerStealthLevel;
import com.paterva.maltego.transform.descriptor.PersistenceMode;
import com.paterva.maltego.transform.descriptor.PropertyConstraint;
import com.paterva.maltego.transform.descriptor.StealthLevel;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.repository.serializer.PropertiesStub;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorStub;
import com.paterva.maltego.transform.repository.serializer.TransformPropertyStub;
import com.paterva.maltego.transform.repository.serializer.VisibilityTranslator;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.serializer.DisplayDescriptorTranslator;
import com.paterva.maltego.typing.serializer.FieldStub;
import com.paterva.maltego.typing.serializer.UnresolvedReferenceException;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class TransformDescriptorSerializer {
    public TransformDescriptor read(InputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformDescriptorStub stub = (TransformDescriptorStub)serializer.read(TransformDescriptorStub.class, stream);
        return TransformDescriptorSerializer.translate(stub);
    }

    public static TransformDescriptor translate(TransformDescriptorStub from) throws XmlSerializationException {
        TransformDescriptor to = new TransformDescriptor(from.getTransformAdapter(), from.getName(), from.getBaseName(), TransformDescriptorSerializer.translate(from.getProperties()));
        to.setAbstract(from.isAbstract());
        to.setTemplate(from.isTemplate());
        to.setAuthor(from.getAuthor());
        to.setDefaultSets(from.getDefaultSets());
        to.setDescription(from.getDescription());
        to.setDisclaimer(from.getDisclaimer());
        to.setDisplayName(from.getDisplayName());
        to.setHelpText(from.getHelpText());
        to.setHelpUrl(from.getHelpUrl());
        to.setVisibility(VisibilityTranslator.get(from.getVisibility()));
        to.setLocationRelevance(from.getLocationRelevance());
        to.setOwner(from.getOwner());
        to.setRequireDisplayInfo(from.requiresDisplayInfo());
        to.setStealthLevel((StealthLevel)new IntegerStealthLevel(from.getStealthLevel()));
        to.setVersion(from.getVersion());
        if (from.getInputConstraints() != null) {
            to.setInputConstraint(TransformDescriptorSerializer.translate(from.getInputConstraints()));
        }
        if (from.getOutputEntities() != null) {
            to.getOutputEntities().addAll(from.getOutputEntities());
        }
        to.setMatchingRule(StatelessMatchingRuleDescriptor.Value);
        to.setAuthenticator(from.getAuthenticator());
        return to;
    }

    private static Constraint translate(List<TransformDescriptorStub.EntityReferenceStub> from) {
        if (from.size() > 0) {
            CompoundConstraint cc = new CompoundConstraint();
            for (TransformDescriptorStub.EntityReferenceStub entityStub : from) {
                EntityConstraint constraint = new EntityConstraint();
                constraint.setMinimum(entityStub.getMinimum());
                constraint.setMaximum(entityStub.getMaximum());
                constraint.setTypeName(entityStub.getTypeName());
                LinkedList<PropertyConstraint> properties = new LinkedList<PropertyConstraint>();
                if (entityStub.getProperties() != null) {
                    for (TransformDescriptorStub.PropertyConstraintStub prop : entityStub.getProperties()) {
                        TypeDescriptor td = TypeRegistry.getDefault().getType(prop.getType());
                        if (td == null) continue;
                        PropertyConstraint pd = new PropertyConstraint(td.getType(), prop.getName(), prop.isNullable());
                        properties.add(pd);
                    }
                }
                constraint.setProperties(properties);
                cc.add((Constraint)constraint);
            }
            return cc;
        }
        return null;
    }

    static DisplayDescriptorCollection translate(PropertiesStub from) throws UnresolvedReferenceException {
        DisplayDescriptorList list = new DisplayDescriptorList();
        if (from != null) {
            for (TransformPropertyStub stub : from.getFields()) {
                TransformPropertyDescriptor td = TransformDescriptorSerializer.translate(stub);
                list.add((DisplayDescriptor)td);
            }
        }
        return list;
    }

    public static TransformPropertyDescriptor translate(TransformPropertyStub stub) throws UnresolvedReferenceException {
        DisplayDescriptorTranslator translator = new DisplayDescriptorTranslator();
        TransformPropertyDescriptor td = new TransformPropertyDescriptor(translator.translate((FieldStub)stub));
        td.setAbstract(stub.isAbstract());
        td.setPersistence(TransformDescriptorSerializer.getPersistence(stub.getPersistence()));
        td.setVisibility(VisibilityTranslator.get(stub.getVisibility()));
        td.setPopup(stub.isPopup());
        td.setAuth(stub.isAuth());
        return td;
    }

    private static PersistenceMode getPersistence(String s) {
        if ("no-export".equals(s)) {
            return PersistenceMode.NoExport;
        }
        if ("none".equals(s)) {
            return PersistenceMode.None;
        }
        return PersistenceMode.Normal;
    }

    private static String getPersistence(PersistenceMode mode) {
        switch (mode) {
            case NoExport: {
                return "no-export";
            }
            case None: {
                return "none";
            }
        }
        return null;
    }

    public void write(TransformDescriptor descriptor, OutputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformDescriptorStub stub = TransformDescriptorSerializer.translate(descriptor);
        serializer.write((Object)stub, stream);
    }

    public static TransformDescriptorStub translate(TransformDescriptor from) throws XmlSerializationException {
        TransformDescriptorStub to = new TransformDescriptorStub();
        to.setName(from.getName());
        to.setTransformAdapter(from.getTransformAdapterClass());
        to.setAbstract(from.isAbstract());
        to.setTemplate(from.isTemplate());
        to.setAuthor(from.getAuthor());
        to.setDescription(from.getDescription());
        to.setDisclaimer(from.getDisclaimer());
        to.setDisplayName(from.getDisplayName());
        to.setHelpText(from.getHelpText());
        to.setHelpUrl(from.getHelpUrl());
        to.setVisibility(VisibilityTranslator.get(from.getVisibility()));
        to.setLocationRelevance(from.getLocationRelevance());
        to.setOwner(from.getOwner());
        to.setRequireDisplayInfo(from.isRequireDisplayInfo());
        int stealthLevel = 0;
        if (from.getStealthLevel() != null) {
            IntegerStealthLevel level = (IntegerStealthLevel)from.getStealthLevel();
            stealthLevel = level.getLevelNumber();
        }
        to.setStealthLevel(stealthLevel);
        to.setVersion(from.getVersion());
        if (from.getDefaultSets() != null) {
            to.setDefaultSets(from.getDefaultSets());
        }
        if (from.getInputConstraint() != null) {
            to.getInputConstraints().addAll(TransformDescriptorSerializer.translate(from.getInputConstraint()));
        }
        if (from.getOutputEntities() != null) {
            to.setOutputEntities(from.getOutputEntities());
        }
        if (from.getProperties() != null) {
            to.setProperties(TransformDescriptorSerializer.translate(from.getProperties()));
        }
        to.setAuthenticator(from.getAuthenticator());
        return to;
    }

    static PropertiesStub translate(DisplayDescriptorCollection descriptors) throws UnresolvedReferenceException {
        ArrayList<TransformPropertyStub> stubs = new ArrayList<TransformPropertyStub>();
        if (descriptors != null) {
            for (DisplayDescriptor dd : descriptors) {
                if (!(dd instanceof TransformPropertyDescriptor)) continue;
                TransformPropertyDescriptor td = (TransformPropertyDescriptor)dd;
                TransformPropertyStub stub = TransformDescriptorSerializer.translate(td);
                stubs.add(stub);
            }
        }
        PropertiesStub stub = new PropertiesStub(stubs, null);
        return stub;
    }

    public static TransformPropertyStub translate(TransformPropertyDescriptor td) throws UnresolvedReferenceException {
        DisplayDescriptorTranslator translator = new DisplayDescriptorTranslator();
        TransformPropertyStub stub = new TransformPropertyStub();
        translator.translate((DisplayDescriptor)td, (FieldStub)stub);
        stub.setAbstract(td.isAbstract());
        stub.setPopup(td.isPopup());
        stub.setPersistence(TransformDescriptorSerializer.getPersistence(td.getPersistence()));
        stub.setVisibility(VisibilityTranslator.get(td.getVisibility()));
        stub.setAuth(td.isAuth());
        return stub;
    }

    private static Collection<TransformDescriptorStub.EntityReferenceStub> translate(Constraint c) {
        ArrayList<TransformDescriptorStub.EntityReferenceStub> to = new ArrayList<TransformDescriptorStub.EntityReferenceStub>();
        if (c instanceof EntityConstraint) {
            to.add(TransformDescriptorSerializer.translate((EntityConstraint)c));
        } else if (c instanceof CompoundConstraint) {
            CompoundConstraint from = (CompoundConstraint)c;
            for (EntityConstraint entity : from) {
                to.add(TransformDescriptorSerializer.translate(entity));
            }
        }
        return to;
    }

    private static TransformDescriptorStub.EntityReferenceStub translate(EntityConstraint entity) {
        TransformDescriptorStub.EntityReferenceStub stub = new TransformDescriptorStub.EntityReferenceStub(entity.getTypeName());
        stub.setMaximum(entity.getMaximum());
        stub.setMinimum(entity.getMinimum());
        if (entity.getProperties() != null) {
            for (PropertyConstraint propConstraint : entity.getProperties()) {
                TransformDescriptorStub.PropertyConstraintStub propStub = new TransformDescriptorStub.PropertyConstraintStub();
                propStub.setName(propConstraint.getName());
                propStub.setType(TypeRegistry.getDefault().getType(propConstraint.getType()).getTypeName());
                propStub.setNullable(propConstraint.isNullable());
                stub.getProperties().add(propStub);
            }
        }
        return stub;
    }
}

