/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.repository.TransformRepositoriesLock;
import com.paterva.maltego.util.FileUtilities;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class FSTransformSetRepository
extends TransformSetRepository {
    private static final String MALTEGO_FOLDER = "Maltego";
    private static final String SET_FOLDER = "TransformSets";
    private static final String ATTR_DESCRIPTION = "description";
    private Set<TransformSet> _sets;
    private final FileObject _configRoot;

    public FSTransformSetRepository() {
        this(FileUtil.getConfigRoot());
    }

    public FSTransformSetRepository(FileObject configRoot) {
        this._configRoot = configRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(TransformSet set) {
        boolean success = false;
        try {
            TransformSet old;
            Object object = TransformRepositoriesLock.LOCK;
            synchronized (object) {
                this.replaceSetFolder(set);
                set.markClean();
                old = this.get(set.getName());
                if (old != null) {
                    this.sets().remove(old);
                    this.sets().add(set);
                } else {
                    this.sets().add(set);
                }
            }
            if (old != null) {
                this.fireItemChanged(set);
            } else {
                this.fireItemAdded(set);
            }
            success = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        try {
            FileObject fo;
            TransformSet set = null;
            Object object = TransformRepositoriesLock.LOCK;
            synchronized (object) {
                FileObject setFolder = this.getOrCreateSetFolder();
                fo = setFolder.getFileObject(name);
                if (fo != null) {
                    fo.delete();
                    set = this.get(name);
                    this.sets().remove(set);
                }
            }
            if (fo != null) {
                this.fireItemRemoved(set);
                return true;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    private Set<TransformSet> sets() {
        if (this._sets == null) {
            this._sets = new HashSet<TransformSet>();
            try {
                FileObject setFolder = this.getOrCreateSetFolder();
                if (setFolder != null) {
                    for (FileObject fo : setFolder.getChildren()) {
                        TransformSet set = FSTransformSetRepository.loadSet(fo);
                        set.markClean();
                        this._sets.add(set);
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._sets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TransformSet> allSets() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            return Collections.unmodifiableSet(this.sets());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            TransformSet set = this.get(name);
            return set != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformSet get(String name) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            for (TransformSet set : this.sets()) {
                if (!set.getName().equals(name)) continue;
                return set;
            }
            return null;
        }
    }

    private static TransformSet loadSet(FileObject fo) {
        TransformSet set = new TransformSet(fo.getNameExt());
        set.setDescription((String)fo.getAttribute(ATTR_DESCRIPTION));
        for (FileObject child : fo.getChildren()) {
            set.addTransform(child.getNameExt());
        }
        return set;
    }

    private FileObject getOrCreateSetFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this.getOrCreateMaltegoFolder(), (String)SET_FOLDER);
    }

    private FileObject getOrCreateMaltegoFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)MALTEGO_FOLDER);
    }

    private boolean replaceSetFolder(TransformSet set) throws IOException {
        FileObject setFolder = this.getOrCreateSetFolder();
        FileObject folder = setFolder.getFileObject(set.getName());
        boolean replaced = false;
        if (folder != null) {
            this.deleteFolder(folder);
            replaced = true;
        }
        folder = setFolder.createFolder(set.getName());
        folder.setAttribute(ATTR_DESCRIPTION, (Object)(set.getDescription() == null ? "" : set.getDescription()));
        for (String transform : set.getAllTransforms()) {
            folder.createData(transform);
        }
        return replaced;
    }

    private void deleteFolder(FileObject folder) throws IOException {
        folder.delete();
    }
}

