/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformSeedRepository;
import com.paterva.maltego.transform.repository.TransformRepositoriesLock;
import com.paterva.maltego.transform.repository.serializer.TransformSeedSerializer;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class FSTransformSeedRepository
extends TransformSeedRepository {
    private static final String MALTEGO_FOLDER = "Maltego";
    private static final String SEED_FOLDER = "Seeds";
    private static final String EXTENSION = "seed";
    private static final String ATTR_DISPLAY_NAME = "displayName";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_URL = "url";
    private static final String ATTR_ENABLED = "enabled";
    private final FileObject _configRoot;
    private Map<FastURL, TransformSeed> _seeds;

    public FSTransformSeedRepository() {
        this(FileUtil.getConfigRoot());
    }

    public FSTransformSeedRepository(FileObject configRoot) {
        this._configRoot = configRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TransformSeed seed) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            Map<FastURL, TransformSeed> seeds = this.getSeeds();
            seeds.put(seed.getUrl(), seed);
            this.save(seed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(TransformSeed seed) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            try {
                FileObject fo = this.getFile(seed.getUrl());
                if (fo != null) {
                    FSTransformSeedRepository.update(fo, seed);
                } else {
                    FileObject folder = this.getOrCreateSeedFolder();
                    fo = FileUtilities.createUniqueFile((FileObject)folder, (String)FileUtilities.replaceIllegalChars((String)seed.getName()), (String)EXTENSION);
                    FSTransformSeedRepository.update(fo, seed);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private FileObject getOrCreateSeedFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this.getOrCreateMaltegoFolder(), (String)SEED_FOLDER);
    }

    private FileObject getOrCreateMaltegoFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)MALTEGO_FOLDER);
    }

    private static void update(FileObject fo, TransformSeed seed) throws IOException {
        TransformSeedSerializer serializer = TransformSeedSerializer.getDefault();
        try (BufferedOutputStream os = new BufferedOutputStream(fo.getOutputStream());){
            serializer.write(seed, os, false);
            fo.setAttribute(ATTR_URL, (Object)seed.getUrl().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Iterable<TransformSeed> seeds) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            this.deleteSeedFiles();
            this._seeds = null;
            for (TransformSeed seed : seeds) {
                this.add(seed);
            }
        }
    }

    private void deleteSeedFiles() {
        FileObject[] seedFiles;
        for (FileObject seedFile : seedFiles = this.getSeedFiles()) {
            try {
                seedFile.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void deleteSeedFolder() {
        FileObject folder = this.getSeedFolder();
        if (folder != null) {
            try {
                folder.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FastURL url) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            for (FileObject fo : this.getSeedFiles()) {
                if (!url.toString().equalsIgnoreCase((String)fo.getAttribute(ATTR_URL))) continue;
                try {
                    fo.delete();
                    if (this._seeds == null) continue;
                    this.removeIgnoreCase(url);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void removeIgnoreCase(FastURL url) {
        ArrayList<FastURL> toRemove = new ArrayList<FastURL>();
        for (Map.Entry<FastURL, TransformSeed> entry : this._seeds.entrySet()) {
            FastURL key = entry.getKey();
            if (!key.equalsIgnoreCase(url)) continue;
            toRemove.add(key);
        }
        for (FastURL fastURL : toRemove) {
            this._seeds.remove(fastURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUrl(String oldUrl, String newUrl) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            FastURL oldFastUrl = new FastURL(oldUrl);
            TransformSeed seed = this.get(oldFastUrl);
            if (seed == null) {
                throw new IllegalArgumentException("Transform Seed does not exist with URL: " + oldUrl);
            }
            FastURL url = new FastURL(newUrl);
            boolean enabled = seed.isEnabled();
            seed = new TransformSeed(url, seed.getName(), seed.getDescription(), seed.getGlobalTxProperties(), (DataSource)seed.getGlobalTxSettings());
            seed.setEnabled(enabled);
            this.add(seed);
        }
    }

    private FileObject getSeedFolder() {
        FileObject maltegoFolder = this._configRoot.getFileObject(MALTEGO_FOLDER);
        if (maltegoFolder != null) {
            return maltegoFolder.getFileObject(SEED_FOLDER);
        }
        return null;
    }

    private FileObject[] getSeedFiles() {
        ArrayList<FileObject> seeds = new ArrayList<FileObject>();
        FileObject folder = this.getSeedFolder();
        if (folder != null) {
            Enumeration files = folder.getChildren(false);
            while (files.hasMoreElements()) {
                FileObject seedFile = (FileObject)files.nextElement();
                if (seedFile.isFolder() || !EXTENSION.equals(seedFile.getExt())) continue;
                seeds.add(seedFile);
            }
        }
        return seeds.toArray(new FileObject[seeds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformSeed[] getAll() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            Map<FastURL, TransformSeed> seedsMap = this.getSeeds();
            Collection<TransformSeed> seeds = seedsMap.values();
            TransformSeed[] seedsArr = seeds.toArray(new TransformSeed[0]);
            return seedsArr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TransformSeed createSeed(FileObject file) throws MalformedURLException {
        TransformSeed seed = null;
        long size = file.getSize();
        if (size > 0L) {
            TransformSeedSerializer serializer = TransformSeedSerializer.getDefault();
            InputStream is = null;
            try {
                is = file.getInputStream();
                seed = serializer.read(is);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        } else {
            String displayName = (String)file.getAttribute(ATTR_DISPLAY_NAME);
            String urlString = (String)file.getAttribute(ATTR_URL);
            if (!StringUtilities.isNullOrEmpty((String)urlString)) {
                seed = new TransformSeed(new FastURL(urlString), displayName);
                seed.setDescription((String)file.getAttribute(ATTR_DESCRIPTION));
                Object enabledAttr = file.getAttribute(ATTR_ENABLED);
                seed.setEnabled(enabledAttr == null ? true : (Boolean)enabledAttr);
            }
        }
        return seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformSeed get(FastURL url) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            return this.getIgnoreCase(url);
        }
    }

    private TransformSeed getIgnoreCase(FastURL url) {
        FastURL foundUrl = null;
        TransformSeed seed = null;
        for (Map.Entry<FastURL, TransformSeed> entry : this.getSeeds().entrySet()) {
            FastURL key = entry.getKey();
            if (!key.equalsIgnoreCase(url)) continue;
            foundUrl = key;
            seed = entry.getValue();
        }
        if (seed != null && foundUrl != null && !foundUrl.equals((Object)url)) {
            seed.setUrl(url);
            this.save(seed);
        }
        return seed;
    }

    private FileObject getFile(FastURL url) {
        for (FileObject fo : this.getSeedFiles()) {
            if (!url.toString().equals(fo.getAttribute(ATTR_URL))) continue;
            return fo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(TransformSeed[] seeds) throws IOException {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (seeds != null && seeds.length != 0) {
                this.deleteSeedFiles();
                this.update(Arrays.asList(seeds));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformSeed[] getEnabled() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            ArrayList<TransformSeed> seeds = new ArrayList<TransformSeed>();
            for (Map.Entry<FastURL, TransformSeed> entry : this.getSeeds().entrySet()) {
                TransformSeed seed = entry.getValue();
                if (!seed.isEnabled()) continue;
                seeds.add(seed);
            }
            return seeds.toArray(new TransformSeed[seeds.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FastURL, TransformSeed> getSeeds() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (this._seeds == null) {
                this.load();
            }
            return this._seeds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            this._seeds = new HashMap<FastURL, TransformSeed>();
            for (FileObject fo : this.getSeedFiles()) {
                try {
                    TransformSeed seed = FSTransformSeedRepository.createSeed(fo);
                    if (seed == null) continue;
                    this._seeds.put(seed.getUrl(), seed);
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

