/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.repository.FSTransformRepository;
import com.paterva.maltego.transform.repository.TransformRepositoriesLock;
import com.paterva.maltego.util.ListMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FSTransformRepositoryRegistry
extends TransformRepositoryRegistry {
    private Map<String, FSTransformRepository> _repositories;
    private final FileObject _configRoot;

    public FSTransformRepositoryRegistry() {
        this(FileUtil.getConfigRoot());
    }

    public FSTransformRepositoryRegistry(FileObject configRoot) {
        this._configRoot = configRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformDefinition findTransform(String uniqueName) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            for (FSTransformRepository repo : this.repositories().values()) {
                TransformDefinition def = repo.get(uniqueName);
                if (def == null) continue;
                return def;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TransformDefinition> find(TransformFilter filter) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            HashSet<TransformDefinition> set = new HashSet<TransformDefinition>();
            for (FSTransformRepository repo : this.repositories().values()) {
                repo.find(filter, set);
            }
            return set;
        }
    }

    private Map<String, FSTransformRepository> repositories() {
        if (this._repositories == null) {
            try {
                this._repositories = new ListMap();
                for (FileObject fo : this.getRoot().getChildren()) {
                    if (!fo.isFolder()) continue;
                    this._repositories.put(fo.getName(), new FSTransformRepository(fo.getName(), fo));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this._repositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSTransformRepository getRepository(String name) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            FileObject fo;
            FSTransformRepository repository = this.repositories().get(name);
            if (repository == null && (fo = this.findRepository(name)) != null) {
                repository = new FSTransformRepository(name, fo);
                this.repositories().put(name, repository);
            }
            return repository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSTransformRepository getOrCreateRepository(String name) throws IOException {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            FSTransformRepository repository = this.getRepository(name);
            if (repository == null) {
                repository = this.createRepository(name);
                this.repositories().put(name, repository);
            }
            return repository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSTransformRepository createRepository(String name) throws IOException {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            FileObject fo = this.getRoot().createFolder(name);
            return new FSTransformRepository(name, fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject findRepository(String name) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            try {
                return this.getRoot().getFileObject(name);
            }
            catch (IOException ex) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getRoot() throws IOException {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            FileObject repositoriesFolder;
            FileObject maltegoFolder = this._configRoot.getFileObject("Maltego");
            if (maltegoFolder == null) {
                maltegoFolder = this._configRoot.createFolder("Maltego");
            }
            if ((repositoriesFolder = maltegoFolder.getFileObject("TransformRepositories")) == null) {
                repositoriesFolder = maltegoFolder.createFolder("TransformRepositories");
            }
            return repositoriesFolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTransform(String name) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            boolean found = false;
            for (FSTransformRepository repo : this.repositories().values()) {
                if (!repo.remove(name)) continue;
                found = true;
            }
            return found;
        }
    }
}

