/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.WebColour;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeRenderInfo;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.EntityLabelMax;
import com.paterva.maltego.ui.graph.view2d.EntityLabelOptions;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.RoundRectHotSpotPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityOverlay;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPaintContext;
import com.paterva.maltego.ui.graph.view2d.painter.GraphAnimatorSettings;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainterAnimatorRegistry;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.UIManager;
import yguard.A.J.BA;
import yguard.A.J.SA;
import yguard.A.J.U;

public class MainPaintUtils {
    private static final float BANNER_IMG_TEXT_GAP = 0.5f;
    private static final float BANNER_TEXT_MARGIN_RIGHT = 2.0f;
    private static final float SUB_PIXEL_OFFSET = 0.2f;
    private static final float ANIMATION_FACTOR_RANGE = 1.0f;
    private static final float ALPHA_UPPER_LIMIT = 1.0f;
    private static final float ALPHA_LOWER_LIMIT = 0.4f;
    private static final float ALPHA_RANGE_LIMIT = 0.6f;
    private static final float SQUARCLE_CIRCLE_LIMIT = 0.6f;
    private static final float EXTRA_BALL_LOWER_SCALE_LIMIT = 0.3f;
    private static final EntityPaintContext.EmptyImgCallback _imgCallback = new EntityPaintContext.EmptyImgCallback();

    public static void drawPaperClipOverlay(Graphics2D g2D, EntityPaintContext ctx) {
        Rectangle imgRect = ctx.getCenteredImageRect();
        GraphicsUtils.drawPaperClip((Graphics2D)g2D, (double)(imgRect.getX() + 58.0), (double)(imgRect.getCenterY() - 21.0));
    }

    public static void drawTypeOverlay(Graphics2D g2D, EntityPaintContext ctx) {
        boolean hasSouth;
        List<EntityOverlay> overlays = ctx.getEntityOverlays();
        if (overlays != null && !overlays.isEmpty() && (hasSouth = overlays.stream().map(EntityOverlay::getOverlay).map(OverlayDescriptor::getPosition).anyMatch(position -> OverlayDescriptor.Position.SOUTH_WEST.equals(position)))) {
            return;
        }
        Image overlay = ctx.getTypeImage();
        if (overlay == null) {
            return;
        }
        Rectangle imgRect = ctx.getCenteredImageRect();
        double overlaySize = IconSize.TINY.getSize();
        double overlayX = imgRect.getX() - 11.0;
        double overlayY = imgRect.getCenterY() - 5.5;
        ImageUtils.drawImageDouble((Graphics2D)g2D, (Image)overlay, (double)overlayX, (double)overlayY, (double)overlaySize, (double)overlaySize, (int)1);
    }

    public static boolean drawPropertyOverlays(Graphics2D g2D, EntityPaintContext ctx) {
        List<EntityOverlay> overlays = ctx.getEntityOverlays();
        if (overlays == null || overlays.isEmpty()) {
            return false;
        }
        float maxWidth = Float.MIN_VALUE;
        for (EntityOverlay overlay : overlays) {
            MainPaintUtils.drawOverlayImage(g2D, overlay);
            MainPaintUtils.drawOverlayColour(g2D, overlay);
            Dimension dimension = MainPaintUtils.drawOverlayText(g2D, overlay);
            maxWidth = Math.max(maxWidth, (float)dimension.width);
        }
        if (maxWidth == 0.0f) {
            return false;
        }
        float width = Math.max(ctx.getWidth(), 70.0f + 2.0f * maxWidth);
        if (width == ctx.getWidth()) {
            return false;
        }
        ctx.getRealizer().setSizeForce(width, ctx.getHeight());
        return true;
    }

    public static Dimension drawOverlayText(Graphics2D g2D, EntityOverlay overlay) {
        OverlayDescriptor descriptor = overlay.getOverlay();
        if (!OverlayDescriptor.Type.TEXT.equals((Object)descriptor.getType())) {
            return new Dimension(0, 0);
        }
        OverlayDescriptor.Position position = descriptor.getPosition();
        String text = Converter.convertTo((Object)overlay.getValue(), (Class)overlay.getProperty().getType());
        Rectangle rectangle = overlay.getRectangle();
        Color oldColour = g2D.getColor();
        Font oldFont = g2D.getFont();
        Font font = NodeRealizerSettings.getDefault().getValueLabelFont();
        g2D.setFont(font);
        Integer maxLength = null;
        if (OverlayDescriptor.Position.NORTH.equals((Object)position) && EntityLabelOptions.isEnabled(EntityLabelMax.NORTH)) {
            maxLength = EntityLabelOptions.getMaxLength(EntityLabelMax.NORTH);
        } else if (MainPaintUtils.isWestOverlay(position) && EntityLabelOptions.isEnabled(EntityLabelMax.WEST)) {
            maxLength = EntityLabelOptions.getMaxLength(EntityLabelMax.WEST);
        }
        text = text.replace("\n", " ").trim();
        if (maxLength != null) {
            text = StringUtilities.chomp((String)text, (int)maxLength);
        }
        float width = (float)StringUtilities.getStringWidth((Graphics)g2D, (String)text);
        float space = (float)StringUtilities.getStringWidth((Graphics)g2D, (String)"0") + 2.0f;
        float height = (float)StringUtilities.getStringHeight((Graphics)g2D);
        float xOffset = ((float)position.column - 2.0f) / 2.0f * (width - (float)rectangle.width) + ((float)position.column - 0.93f) * space;
        float yOffset = (float)rectangle.height / 2.0f + height / 2.0f - 2.0f;
        if (OverlayDescriptor.Position.NORTH.equals((Object)position)) {
            yOffset -= (float)rectangle.height / 2.0f - 2.0f;
        }
        if (OverlayDescriptor.Position.CENTER.equals((Object)position) || OverlayDescriptor.Position.SOUTH.equals((Object)position)) {
            yOffset = (float)rectangle.height + height;
        }
        rectangle.x = (int)((float)rectangle.x + xOffset);
        rectangle.y = (int)((float)rectangle.y + yOffset);
        g2D.setColor(NodeRealizerSettings.getDefault().getValueLabelColor());
        g2D.drawString(text, rectangle.x, rectangle.y);
        g2D.setColor(oldColour);
        g2D.setFont(oldFont);
        Dimension dimension = new Dimension();
        if (OverlayDescriptor.Position.NORTH.equals((Object)position)) {
            dimension.setSize(0.0, height);
        } else {
            dimension.setSize(width, 0.0);
        }
        return dimension;
    }

    public static void drawOverlayImage(Graphics2D g2D, EntityOverlay overlay) {
        OverlayDescriptor descriptor = overlay.getOverlay();
        if (!OverlayDescriptor.Type.IMAGE.equals((Object)descriptor.getType())) {
            return;
        }
        String imageUrl = Converter.convertTo((Object)overlay.getValue(), (Class)overlay.getProperty().getType());
        if (imageUrl == null || imageUrl.trim().isEmpty()) {
            return;
        }
        Image image = ImageFactory.getDefault().getImage((Object)imageUrl, (ImageCallback)_imgCallback);
        if (image == null) {
            return;
        }
        Rectangle rectangle = overlay.getRectangle();
        ImageUtils.drawImageDouble((Graphics2D)g2D, (Image)image, (double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height, (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawOverlayColour(Graphics2D g2D, EntityOverlay overlay) {
        OverlayDescriptor descriptor = overlay.getOverlay();
        if (!OverlayDescriptor.Type.COLOUR.equals((Object)descriptor.getType())) {
            return;
        }
        Class type = overlay.getProperty().getType();
        Color colour = null;
        try {
            if (type.isAssignableFrom(Color.class)) {
                colour = (Color)Converter.convert((Object)overlay.getValue(), Color.class);
            } else if (type == String.class) {
                String colourNotation = Converter.convertTo((Object)overlay.getValue(), (Class)type);
                if (colourNotation.length() == 7 && colourNotation.startsWith("#")) {
                    int rgb = Integer.parseInt(colourNotation.substring(1), 16) & 0xFFFFFF;
                    colour = new Color(rgb);
                } else {
                    WebColour webColour = WebColour.lookup((String)colourNotation);
                    if (webColour != null) {
                        colour = webColour.getColor();
                    }
                }
            } else if (type == Integer.TYPE) {
                Integer rgb = (Integer)overlay.getValue();
                colour = new Color(rgb);
            }
        }
        catch (Exception rgb) {
            // empty catch block
        }
        if (colour == null) {
            return;
        }
        Rectangle rectangle = overlay.getRectangle();
        GraphicsConfig config = new GraphicsConfig((Graphics)g2D);
        try {
            Ellipse2D.Double circle = new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            g2D.setColor(colour);
            g2D.fill(circle);
            g2D.setStroke(new BasicStroke(0.8f));
            g2D.setColor(colour.darker().darker());
            g2D.draw(circle);
        }
        catch (Exception exception) {
        }
        finally {
            config.restore();
        }
    }

    public static Rectangle2D drawCollectionNodeFrame(Graphics2D g2D, EntityPaintContext ctx, float factor, boolean isBulging) {
        Insets i = new Insets(4, 8, 4, 8);
        Rectangle[] r2 = ctx.getCenteredImageCollectionsRectArray();
        Rectangle imgRect = new Rectangle();
        imgRect.setRect(r2[0].getX(), r2[0].getY(), r2[0].getWidth() + r2[1].getWidth() + 2.0, r2[0].getHeight() + r2[2].getHeight() + 2.0);
        Rectangle2D.Double rect = new Rectangle2D.Double(imgRect.getX() - 0.6 - (double)i.left, imgRect.getY() - (double)i.top, imgRect.getWidth() + (double)i.left + (double)i.right, imgRect.getHeight() + (double)i.top + (double)i.bottom);
        float squarcleFactor = MainPaintUtils.getSquarcleFactor(factor);
        Shape shape = isBulging ? GraphicsUtils.getSquarcle((double)squarcleFactor, (Rectangle2D)rect) : GraphicsUtils.getSquarcleCollapse((double)squarcleFactor, (Rectangle2D)rect);
        GraphicsConfig config = new GraphicsConfig((Graphics)g2D);
        config.setInterpolation(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        config.setAntialiasing(true);
        g2D.setPaint(UIManager.getLookAndFeelDefaults().getColor("graph-collection-background-color"));
        g2D.fill(shape);
        g2D.setColor(UIManager.getLookAndFeelDefaults().getColor("graph-collection-selection-icon-background-color"));
        g2D.setStroke(new BasicStroke(RoundRectHotSpotPainter.getStrokeWidth(), 0, 0));
        g2D.draw(shape);
        config.restore();
        return rect;
    }

    public static void drawCollectionNodeFrameTab(Graphics2D g2D, EntityPaintContext ctx, Rectangle2D rect) {
        Font oldFont = g2D.getFont();
        NodeRealizerSettings settings = NodeRealizerSettings.getDefault();
        Font baseFont = settings.getValueLabelFont();
        Font labelFont = new Font(baseFont.getFamily(), 1, baseFont.getSize());
        g2D.setFont(labelFont);
        String countString = MainPaintUtils.getCollectionCountString(ctx);
        double fontWidth = Math.ceil(StringUtilities.getStringWidth((Graphics)g2D, (String)countString));
        int fontHeight = g2D.getFont().getSize();
        int xMargin = 8;
        double xOffset = rect.getX() + rect.getWidth() / 2.0 - fontWidth / 2.0 - (double)xMargin;
        double yExtraFontOffset = 4.0;
        double yOffset = rect.getY() - (double)fontHeight - yExtraFontOffset;
        g2D.translate(xOffset, yOffset);
        Rectangle2D.Double rect2 = new Rectangle2D.Double(0.0, 0.0, fontWidth + (double)(xMargin * 2), (double)fontHeight + yExtraFontOffset + (double)0.2f);
        g2D.setColor(UIManager.getLookAndFeelDefaults().getColor("graph-collection-selection-icon-background-color"));
        g2D.fill(rect2);
        g2D.setColor(UIManager.getLookAndFeelDefaults().getColor("graph-collection-label-value-color"));
        g2D.drawString(countString, xMargin, fontHeight);
        g2D.translate(-xOffset, -yOffset);
        g2D.setFont(oldFont);
    }

    public static void drawCollectionNodeBanner(Graphics2D g2D, EntityPaintContext ctx, float x2, float y2, float width, float height, float animationFactor) {
        MainPaintUtils.setupAlphaComposite(g2D, animationFactor, ctx);
        double zoom = GraphicsUtils.getZoom((Graphics2D)g2D);
        MainPaintUtils.drawBannerBackground(g2D, x2, y2, width, height, zoom);
        MainPaintUtils.resetAlphaComposite(g2D, animationFactor);
        float imgRectSideLength = height;
        MainPaintUtils.drawBannerImage(g2D, ctx, x2, y2, imgRectSideLength);
        MainPaintUtils.drawBannerText(g2D, ctx, x2, y2, width, imgRectSideLength, zoom);
    }

    public static void drawBannerBackground(Graphics2D g2D, float x2, float y2, float width, float height, double zoom) {
        float subPixelOffset = 0.2f / (float)zoom * 4.75f;
        g2D.setColor(UIManager.getLookAndFeelDefaults().getColor("graph-collection-selection-icon-background-color"));
        g2D.fill(new Rectangle2D.Double(x2 - (subPixelOffset /= 1.5f), y2 - subPixelOffset, width + 2.0f * subPixelOffset, height + subPixelOffset));
    }

    public static void drawBannerImage(Graphics2D g2D, EntityPaintContext ctx, float x2, float y2, float imgRectSideLength) {
        float imgMargin = 1.0f;
        float imgSize = imgRectSideLength - 2.0f * imgMargin;
        Image image = ctx.getImage();
        Dimension d2 = ImageUtils.calcScaledSize((Image)image, (double)imgSize);
        ImageUtils.drawImageDouble((Graphics2D)g2D, (Image)image, (double)(x2 + imgMargin), (double)(y2 + imgMargin), (double)d2.getWidth(), (double)d2.getHeight(), (int)1);
    }

    public static void drawBannerText(Graphics2D g2D, EntityPaintContext ctx, float x2, float y2, float width, float imgRectSideLength, double zoom) {
        float textXOffset = imgRectSideLength + 0.5f;
        Font font = new JLabel().getFont();
        float fontSize = 9.0f;
        font = new Font(font.getFamily(), 1, (int)fontSize);
        font.deriveFont(fontSize);
        g2D.setFont(font);
        g2D.setColor(UIManager.getLookAndFeelDefaults().getColor("7-white"));
        String typeDisplayName = ctx.getTypeDisplayName();
        String countStr = " (" + MainPaintUtils.getCollectionCountString(ctx) + ")";
        double displayNameWidth = (double)(width - textXOffset) - Math.ceil(StringUtilities.getStringWidth((Graphics)g2D, (String)countStr)) - 2.0 * (1.0 + 1.0 / zoom);
        FontMetrics fm = g2D.getFontMetrics();
        float displayNameHeight = fm.getAscent() + fm.getDescent();
        typeDisplayName = StringUtilities.truncate((Graphics2D)g2D, (String)typeDisplayName, (double)displayNameWidth, (double)displayNameHeight);
        typeDisplayName = typeDisplayName + countStr;
        g2D.drawString(typeDisplayName, x2 + textXOffset, y2 += fontSize + (15.0f - fontSize) / 2.0f - 1.0f);
    }

    private static String getCollectionCountString(EntityPaintContext ctx) {
        String countString = "";
        LightweightEntityRealizer realizer = ctx.getRealizer();
        GraphID graphID = realizer.getGraphEntity().getGraphID();
        EntityID entityID = (EntityID)realizer.getGraphEntity().getID();
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        if (CollectionNodeUtils.getSelectionState((BA)realizer) != SelectionState.NO && selection.hasSelection()) {
            int selectedModelEntityCount = selection.getSelectedModelEntities(entityID).size();
            countString = selectedModelEntityCount > 0 ? StringUtilities.countToString((long)selectedModelEntityCount) + "/" : "0/";
        }
        countString = countString + StringUtilities.countToString((long)ctx.getCollectionNodeInfo().getEntityCount());
        return countString;
    }

    public static Map<String, Object> getAnimationFactorAndChangeType(EntityPaintContext ctx) {
        LightweightEntityRealizer realizer = ctx.getRealizer();
        return MainPaintUtils.getAnimationFactorAndChangeType(realizer);
    }

    public static Map<String, Object> getAnimationFactorAndChangeType(LightweightEntityRealizer realizer) {
        MainEntityPainterAnimatorRegistry.AnimatorSettings animatorSettings;
        Map<EntityID, MainEntityPainterAnimatorRegistry.AnimatorSettings> graphAnimatorSettingsMap;
        U view;
        SA graph2D;
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("factor", Float.valueOf(-1.0f));
        changes.put("changeType", -1);
        GraphEntity graphEntity = realizer.getGraphEntity();
        GraphID graphID = graphEntity.getGraphID();
        if (MaltegoGraphManager.exists((GraphID)graphID) && (graph2D = GraphViewManager.getDefault().getViewGraph(graphID)) != null && !((view = (U)graph2D.\u00f1()).getZoom() < 0.1) && (graphAnimatorSettingsMap = GraphAnimatorSettings.getDefault(graphID).getGraphAnimatorSettingsMap()) != null && (animatorSettings = graphAnimatorSettingsMap.get(graphEntity.getID())) != null && animatorSettings.isAnimatorRunning()) {
            long startTimeMillis = animatorSettings.getStartMillis();
            long deltaMillis = System.currentTimeMillis() - startTimeMillis;
            if (deltaMillis > 0L) {
                float factor = (float)deltaMillis / 650.0f;
                factor = factor < 0.0f ? 0.0f : factor;
                factor = factor > 1.0f ? 1.0f : factor;
                changes.put("factor", Float.valueOf(factor));
                changes.put("changeType", animatorSettings.getChangeType());
            }
        }
        return changes;
    }

    public static void setupAlphaComposite(Graphics2D g2D, float factor, EntityPaintContext ctx) {
        LightweightEntityRealizer realizer = ctx.getRealizer();
        MainPaintUtils.setupAlphaComposite(g2D, factor, realizer);
    }

    public static void setupAlphaComposite(Graphics2D g2D, float factor, LightweightEntityRealizer realizer) {
        if (MainPaintUtils.mustAnimate(factor)) {
            float numFades = factor * 4.0f;
            float numFadesFrac = numFades - (float)((int)numFades);
            numFadesFrac = (numFadesFrac *= 0.6f) < 0.0f ? 0.0f : numFadesFrac;
            numFadesFrac = numFadesFrac > 0.6f ? 0.6f : numFadesFrac;
            float alpha = (int)numFades % 2 == 0 ? 1.0f - numFadesFrac : numFadesFrac + 0.4f;
            g2D.setComposite(AlphaComposite.SrcOver.derive(alpha));
        }
    }

    public static void resetAlphaComposite(Graphics2D g2D, float factor) {
        if (MainPaintUtils.mustAnimate(factor)) {
            g2D.setComposite(AlphaComposite.SrcOver);
        }
    }

    private static float getSquarcleFactor(float factor) {
        float factorReturn = 0.0f;
        if (MainPaintUtils.mustAnimate(factor)) {
            factorReturn = factor * 2.0f;
            float factorReturnFrac = factorReturn - (float)((int)factorReturn);
            factorReturnFrac = (factorReturnFrac *= 0.6f) < 0.0f ? 0.0f : factorReturnFrac;
            factorReturnFrac = factorReturnFrac > 0.6f ? 0.6f : factorReturnFrac;
            factorReturn = (int)factorReturn % 2 == 0 ? factorReturnFrac : 0.6f - factorReturnFrac;
        }
        return factorReturn;
    }

    private static float getRotationThetaFactor(float factor) {
        float factorReturn = 0.0f;
        if (MainPaintUtils.mustAnimate(factor)) {
            factorReturn = factor * 2.0f;
            float factorReturnFrac = factorReturn - (float)((int)factorReturn);
            factorReturnFrac = factorReturnFrac < 0.0f ? 0.0f : factorReturnFrac;
            factorReturnFrac = factorReturnFrac > 1.0f ? 1.0f : factorReturnFrac;
            factorReturn = (int)factorReturn % 2 == 0 ? factorReturnFrac : 1.0f - factorReturnFrac;
        }
        return factorReturn;
    }

    private static float getBulgeOrCollapseImagesFactor(float factor) {
        float factorReturn = 0.0f;
        if (MainPaintUtils.mustAnimate(factor)) {
            factorReturn = factor * 2.0f;
            float factorReturnFrac = factorReturn - (float)((int)factorReturn);
            factorReturnFrac = factorReturnFrac < 0.0f ? 0.0f : factorReturnFrac;
            factorReturnFrac = factorReturnFrac > 1.0f ? 1.0f : factorReturnFrac;
            factorReturn = (int)factorReturn % 2 == 0 ? factorReturnFrac : 1.0f - factorReturnFrac;
        }
        return factorReturn;
    }

    private static float getExtraBallScaleFactor(float factor, boolean isBulging) {
        float factorReturn = 1.0f;
        if (MainPaintUtils.mustAnimate(factor)) {
            factorReturn = factor;
            factorReturn = (factorReturn *= 0.7f) < 0.0f ? 0.0f : factorReturn;
            float f = factorReturn = factorReturn > 0.7f ? 0.7f : factorReturn;
            factorReturn = isBulging ? 1.0f - factorReturn : (factorReturn += 0.3f);
        }
        return factorReturn;
    }

    private static float getExtraBallYPosFactor(float factor, boolean isBulging) {
        float factorReturn = 1.0f;
        if (MainPaintUtils.mustAnimate(factor)) {
            factorReturn = factor * 1.7f;
            if (isBulging) {
                factorReturn = factorReturn < 0.0f ? 0.0f : factorReturn;
                factorReturn = factorReturn > 1.0f ? 1.0f : factorReturn;
                factorReturn = 1.0f - factorReturn;
            } else {
                factorReturn = (factorReturn -= 0.4f) < 0.0f ? 0.0f : factorReturn;
                factorReturn = factorReturn > 1.0f ? 1.0f : factorReturn;
            }
        }
        return factorReturn;
    }

    public static void cleanForAnimation(Graphics2D g2D, float factor, EntityPaintContext ctx) {
        LightweightEntityRealizer realizer = ctx.getRealizer();
        MainPaintUtils.cleanForAnimation(g2D, factor, realizer);
    }

    public static void cleanForAnimation(Graphics2D g2D, float factor, LightweightEntityRealizer realizer) {
        if (MainPaintUtils.mustAnimate(factor) && !realizer.isSelected()) {
            g2D.setColor(Color.white);
            Rectangle2D.Double rect = new Rectangle2D.Double(realizer.getX(), realizer.getY(), realizer.getWidth(), realizer.getHeight());
            g2D.fill(rect);
        }
    }

    public static void drawCollectionNodeSampleList(Graphics2D g2D, EntityPaintContext ctx, float x2, float y2, float width, double zoom) {
        CollectionNodeRenderInfo collectionNodeInfo = ctx.getCollectionNodeInfo();
        Font font = new JLabel().getFont();
        float fontSize = 5.0f;
        font = font.deriveFont(fontSize);
        g2D.setFont(font);
        g2D.setColor(Color.darkGray);
        g2D.setStroke(new BasicStroke(0.2f));
        List<String> bgText = collectionNodeInfo.getBgText();
        float topMargin = fontSize / 3.0f;
        float textY = y2 + fontSize + topMargin;
        float textXMargin = 2.0f;
        for (String text : bgText) {
            text = StringUtilities.truncate((Graphics2D)g2D, (String)text, (double)((double)width - (double)(2.0f * textXMargin) * (2.0 + 1.0 / zoom)), (double)fontSize);
            g2D.drawString(text, x2 + textXMargin, textY);
            g2D.draw(new Line2D.Double(x2, textY + 1.2f, x2 + width, textY + 1.2f));
            textY += fontSize + 1.4f;
        }
    }

    public static void drawCenteredImage(Graphics2D g2D, EntityPaintContext ctx) {
        Image image = ctx.getImage();
        Rectangle rect = ctx.getCenteredImageRect();
        ImageUtils.drawImageDouble((Graphics2D)g2D, (Image)image, (double)rect.getX(), (double)(rect.getY() - 15.0), (double)rect.getWidth(), (double)rect.getHeight(), (int)1);
    }

    public static void drawCollectionsImages(Graphics2D g2D, EntityPaintContext ctx, float factor, boolean isBulging, boolean animateRotate, boolean drawEntityImages, boolean bulgeOrCollapseImages, boolean drawAndAnimateExtraBall) {
        Image image = ctx.getImage();
        Rectangle[] r2 = ctx.getCenteredImageCollectionsRectArray();
        if (MainPaintUtils.mustAnimate(factor)) {
            Rectangle imgRect = new Rectangle();
            imgRect.setRect(r2[0].getX(), r2[0].getY(), r2[0].getWidth() + r2[1].getWidth() + 2.0, r2[0].getHeight() + r2[2].getHeight() + 2.0);
            float scale = 1.7f;
            BufferedImage imageCombinedRotated = new BufferedImage((int)((float)imgRect.width * scale), (int)((float)imgRect.height * scale), 2);
            double xOffset = (double)(imageCombinedRotated.getWidth() - imgRect.width) / 2.0;
            double yOffset = (double)(imageCombinedRotated.getHeight() - imgRect.height) / 2.0;
            Graphics2D g2DNew = (Graphics2D)g2D.create((int)(r2[0].getX() - xOffset), (int)(r2[0].getY() - yOffset), imageCombinedRotated.getWidth(), imageCombinedRotated.getHeight());
            AffineTransform transform = new AffineTransform();
            transform.setToIdentity();
            if (animateRotate) {
                float thetaFactor = MainPaintUtils.getRotationThetaFactor(factor);
                double theta = 0.7853981633974483 * (double)thetaFactor;
                transform.rotate(theta, (double)imageCombinedRotated.getWidth() / 2.0, (double)imageCombinedRotated.getHeight() / 2.0);
            }
            transform.translate(-r2[0].getX(), -r2[0].getY());
            transform.translate(xOffset, yOffset);
            g2DNew.transform(transform);
            Rectangle[] r22 = new Rectangle[4];
            if (bulgeOrCollapseImages) {
                float bulgeOrCollapseImagesFactor = MainPaintUtils.getBulgeOrCollapseImagesFactor(factor);
                for (int row = 0; row < 2; ++row) {
                    for (int col = 0; col < 2; ++col) {
                        double stepY;
                        double stepX;
                        int i = row * 2 + col;
                        if (isBulging) {
                            stepX = (double)(-1 + col % 2 * 2) * (xOffset / 4.0) * (double)bulgeOrCollapseImagesFactor;
                            stepY = (double)(-1 + row % 2 * 2) * (yOffset / 4.0) * (double)bulgeOrCollapseImagesFactor;
                        } else {
                            stepX = (double)(1 - col % 2 * 2) * (xOffset / 4.0) * (double)bulgeOrCollapseImagesFactor;
                            stepY = (double)(1 - row % 2 * 2) * (yOffset / 4.0) * (double)bulgeOrCollapseImagesFactor;
                        }
                        r22[i] = new Rectangle();
                        r22[i].setRect(r2[i].getX() + stepX, r2[i].getY() + stepY, r2[i].getWidth(), r2[i].getHeight());
                    }
                }
            }
            g2DNew.setColor(ctx.getTypeColor());
            Ellipse2D.Double circle = new Ellipse2D.Double();
            for (int i = 0; i < 4; ++i) {
                if (drawEntityImages) {
                    if (!bulgeOrCollapseImages) {
                        ImageUtils.drawImageDouble((Graphics2D)g2DNew, (Image)image, (double)r2[i].getX(), (double)r2[i].getY(), (double)r2[i].getWidth(), (double)r2[i].getHeight(), (int)1);
                        continue;
                    }
                    ImageUtils.drawImageDouble((Graphics2D)g2DNew, (Image)image, (double)r22[i].getX(), (double)r22[i].getY(), (double)r2[i].getWidth(), (double)r2[i].getHeight(), (int)1);
                    continue;
                }
                if (!bulgeOrCollapseImages) {
                    circle.setFrame(r2[i]);
                } else {
                    circle.setFrame(r22[i]);
                }
                g2DNew.fill(circle);
            }
            if (drawAndAnimateExtraBall) {
                Rectangle r3 = new Rectangle();
                float scaleFactor = MainPaintUtils.getExtraBallScaleFactor(factor, isBulging);
                double newWidth = r2[0].getWidth() * (double)scaleFactor;
                double newHeight = r2[0].getHeight() * (double)scaleFactor;
                float extraBallYPosFactor = MainPaintUtils.getExtraBallYPosFactor(factor, isBulging);
                r3.setRect(r2[1].getX() - 1.0 - newWidth / 2.0, r2[2].getY() - 1.0 - newHeight / 2.0 - ((double)(ctx.getHeight() / 2.0f) - r2[0].getHeight() / 2.0) * (double)extraBallYPosFactor, newWidth, newHeight);
                circle.setFrame(r3);
                g2DNew.fill(circle);
                g2DNew.setColor(UIManager.getLookAndFeelDefaults().getColor("7-white"));
                g2DNew.draw(circle);
            }
            g2DNew.dispose();
        } else {
            for (int i = 0; i < 4; ++i) {
                ImageUtils.drawImageDouble((Graphics2D)g2D, (Image)image, (double)r2[i].getX(), (double)r2[i].getY(), (double)r2[i].getWidth(), (double)r2[i].getHeight(), (int)1);
            }
        }
    }

    public static boolean mustAnimate(float factor) {
        return !(factor < 0.0f);
    }

    public static void drawCollectionNodeBackground(Graphics2D g2D, BA nr, Insets i) {
        g2D.setPaint(UIManager.getLookAndFeelDefaults().getColor("graph-collection-background-color"));
        g2D.fill(new Rectangle2D.Double((float)nr.getX() - (float)i.left, (float)nr.getY() - (float)i.top, (float)nr.getWidth() + (float)i.left + (float)i.right, (float)nr.getHeight() + (float)i.top + (float)i.bottom));
    }

    private static boolean isWestOverlay(OverlayDescriptor.Position position) {
        return OverlayDescriptor.Position.NORTH_WEST.equals((Object)position) || OverlayDescriptor.Position.WEST.equals((Object)position) || OverlayDescriptor.Position.SOUTH_WEST.equals((Object)position);
    }
}

