/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.api.TransformMessageCache;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeRenderInfo;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.EntityNodePainter;
import com.paterva.maltego.ui.graph.view2d.EntityRealizerConstants;
import com.paterva.maltego.ui.graph.view2d.EntitySloppyPainter;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.RoundRectHotSpotPainter;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import com.paterva.maltego.ui.graph.view2d.painter.AbstractEntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityLabels;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPaintContext;
import com.paterva.maltego.ui.graph.view2d.painter.MainPaintUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbPreferences;
import yguard.A.J.BA;
import yguard.A.J.gB;
import yguard.A.J.q;

public class MainEntityPainter
extends AbstractEntityPainter {
    private static final Logger LOG = Logger.getLogger(MainEntityPainter.class.getName());
    public static final String NAME = "Main";
    public static final String DISPLAY_NAME = "Graph View";
    public static final String BALL_VIEW_NAME = "BallView";
    private static final String ICON = "com/paterva/maltego/ui/graph/resources/MainView.png";
    public static final float BANNER_HEIGHT = 15.0f;
    public static final float OUTER_MARGIN_X = 0.0f;
    public static final float OUTER_MARGIN_Y = 0.0f;
    public static final double Y_CENTRE_OFFSET = 6.0;
    private static long _lastUpdate = 0L;
    private static boolean _paintTypeOverlay;
    private static boolean _paintAttachmentsOverlay;
    private final EntitySloppyPainter _sloppyPainter = new EntitySloppyPainter();
    private final RoundRectHotSpotPainter _hotSpotPainter = new RoundRectHotSpotPainter();

    public MainEntityPainter() {
        super(NAME, DISPLAY_NAME, ICON, 10);
    }

    @Override
    public boolean isCollectionNodeEditorEnabled() {
        return true;
    }

    @Override
    public void onGraphPaintStart(GraphID graphID, Collection<BA> nodeRealizersToPaint, Collection<q> edgeRealizersToPaint) {
        LOG.fine("Paint start");
        super.onGraphPaintStart(graphID, nodeRealizersToPaint, edgeRealizersToPaint);
        this._sloppyPainter.onPaintStart();
    }

    @Override
    public void paintSloppy(Graphics2D g2D, LightweightEntityRealizer realizer, boolean paintAnimations) throws Exception {
        LOG.log(Level.FINE, "{0} paint sloppy", realizer.getGraphEntity());
        this._sloppyPainter.setPaintAnimations(paintAnimations);
        this._sloppyPainter.paintSloppy((BA)realizer, g2D);
    }

    @Override
    public void paint(Graphics2D g2D, EntityPaintContext ctx) throws Exception {
        LOG.log(Level.FINE, "{0} paint normal", ctx.getRealizer().getGraphEntity());
        GraphicsUtil.setupTextAntialiasing((Graphics)g2D, null);
        Map<String, Object> changes = MainPaintUtils.getAnimationFactorAndChangeType(ctx);
        float animationFactor = ((Float)changes.get("factor")).floatValue();
        int animationChangeType = (Integer)changes.get("changeType");
        if (ctx.isCollectionNode()) {
            double zoom = this.getZoom();
            if (!this.isOptimizationsEnabled() || MainEntityPainter.isFarZoom(zoom)) {
                this.drawFarZoom(g2D, ctx, animationFactor, animationChangeType);
            } else if (MainEntityPainter.isMiddleZoom(zoom) || MainEntityPainter.isDeepZoom(zoom)) {
                float bannerX = ctx.getX() - 0.0f;
                float bannerY = ctx.getY() - 0.0f;
                float bannerWidth = ctx.getWidth() + 0.0f;
                LightweightEntityRealizer nr = ctx.getRealizer();
                if (MainEntityPainter.isMiddleZoom(zoom)) {
                    MainPaintUtils.drawCollectionNodeBackground(g2D, (BA)nr, new Insets(0, 0, 0, 0));
                    MainPaintUtils.drawCollectionNodeSampleList(g2D, ctx, ctx.getX(), ctx.getY() + 15.0f, ctx.getWidth(), zoom);
                }
                MainPaintUtils.drawCollectionNodeBanner(g2D, ctx, bannerX, bannerY, bannerWidth, 15.0f, animationFactor);
                if (CollectionNodeUtils.getSelectionState((BA)nr) == SelectionState.NO) {
                    RoundRectHotSpotPainter.paintBorder((BA)nr, g2D, new Insets(0, 0, 0, 0), false, null);
                }
            }
        } else {
            ZoomAndFlasher zoomFlasherInstance;
            LightweightEntityRealizer realizer = ctx.getRealizer();
            if (((Object)((Object)realizer)).equals((Object)(zoomFlasherInstance = ZoomAndFlasher.instance()).getRealizer())) {
                if (zoomFlasherInstance.isShowEntityFlashColour()) {
                    g2D.setComposite(AlphaComposite.SrcOver.derive(0.4f));
                }
                MainPaintUtils.drawCenteredImage(g2D, ctx);
                if (zoomFlasherInstance.isShowEntityFlashColour()) {
                    g2D.setComposite(AlphaComposite.SrcOver);
                }
            } else {
                MainPaintUtils.setupAlphaComposite(g2D, animationFactor, ctx);
                MainPaintUtils.drawCenteredImage(g2D, ctx);
                MainPaintUtils.resetAlphaComposite(g2D, animationFactor);
            }
            this.updateOverlayProperties();
            if (_paintTypeOverlay && ctx.hasNonTypeImage()) {
                MainPaintUtils.drawTypeOverlay(g2D, ctx);
            }
            if (_paintAttachmentsOverlay && ctx.getEntitySkeleton().hasAttachments()) {
                MainPaintUtils.drawPaperClipOverlay(g2D, ctx);
            }
            if (MainPaintUtils.drawPropertyOverlays(g2D, ctx)) {
                this.updateSizeNotes(realizer);
                this.updateSizeBookmark(realizer);
                this.updateSizePin(realizer);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            g2D.setStroke(new BasicStroke());
            g2D.setColor(Color.blue);
            g2D.drawRect((int)ctx.getX(), (int)ctx.getY(), (int)ctx.getWidth(), (int)ctx.getHeight());
            LightweightEntityRealizer realizer = ctx.getRealizer();
            g2D.setColor(Color.red);
            g2D.drawRect((int)realizer.getX(), (int)realizer.getY(), (int)realizer.getWidth(), (int)realizer.getHeight());
        }
    }

    private void paintMsgThing(Graphics2D g2D, LightweightEntityRealizer realizer) {
        List entityMsgs;
        GraphID graphID = realizer.getGraphEntity().getGraphID();
        EntityID id = (EntityID)realizer.getGraphEntity().getID();
        TransformMessageCache msgCache = TransformMessageCache.getInstance();
        TransformMessageCache.GraphMessages graphMsgs = (TransformMessageCache.GraphMessages)msgCache.getMessages().get(graphID);
        if (graphMsgs != null && (entityMsgs = (List)graphMsgs.get((Object)id)) != null) {
            int msgLifeTimeMillis = msgCache.getMessageLifetimeMillis();
            Double errorTimeDiff = this.getTimeDiffPercent(entityMsgs, TransformMessage.Severity.Error, msgLifeTimeMillis);
            Color msgColor = null;
            if (errorTimeDiff != null) {
                msgColor = new Color(200, 100, 100, (int)(100.0 * errorTimeDiff));
            } else {
                Double warnTimeDiff = this.getTimeDiffPercent(entityMsgs, TransformMessage.Severity.Warning, msgLifeTimeMillis);
                if (warnTimeDiff != null) {
                    msgColor = new Color(200, 100, 0, (int)(100.0 * warnTimeDiff));
                } else {
                    Double infoTimeDiff = this.getTimeDiffPercent(entityMsgs, TransformMessage.Severity.Info, msgLifeTimeMillis);
                    if (infoTimeDiff != null) {
                        msgColor = new Color(0, 200, 200, (int)(100.0 * infoTimeDiff));
                    }
                }
            }
            if (msgColor != null) {
                g2D.setColor(msgColor);
                this._hotSpotPainter.paintHotSpot(g2D, (BA)realizer);
            }
        }
    }

    private Double getTimeDiffPercent(List<TransformMessage> entityMsgs, TransformMessage.Severity severity, int msgLifeTimeMillis) {
        double diff;
        long newest = this.getNewest(entityMsgs, severity);
        if (newest >= 0L && (diff = (double)(System.currentTimeMillis() - newest)) >= 0.0 && diff < (double)msgLifeTimeMillis) {
            return 1.0 - diff / (double)msgLifeTimeMillis;
        }
        return null;
    }

    private long getNewest(List<TransformMessage> entityMsgs, TransformMessage.Severity severity) {
        long newest = -1L;
        for (TransformMessage msg : entityMsgs) {
            long time;
            if (msg.getSeverity() != severity || (time = msg.getTimestamp().getTime()) <= newest) continue;
            newest = time;
        }
        return newest;
    }

    private void drawFarZoom(Graphics2D g2D, EntityPaintContext ctx, float animationFactor, int animationChangeType) {
        boolean animationIsBulging = true;
        if (animationChangeType == 1) {
            animationIsBulging = false;
        }
        MainPaintUtils.cleanForAnimation(g2D, animationFactor, ctx);
        g2D.translate(0.0, 6.0);
        Rectangle2D rect = MainPaintUtils.drawCollectionNodeFrame(g2D, ctx, animationFactor, animationIsBulging);
        switch (animationChangeType) {
            case 1: {
                MainPaintUtils.drawCollectionsImages(g2D, ctx, animationFactor, animationIsBulging, false, true, true, true);
                break;
            }
            case 0: {
                MainPaintUtils.drawCollectionsImages(g2D, ctx, animationFactor, animationIsBulging, false, true, true, true);
                break;
            }
            default: {
                MainPaintUtils.drawCollectionsImages(g2D, ctx, animationFactor, animationIsBulging, true, true, false, false);
            }
        }
        GraphicsConfig config = new GraphicsConfig((Graphics)g2D);
        config.setAntialiasing(false);
        MainPaintUtils.drawCollectionNodeFrameTab(g2D, ctx, rect);
        config.restore();
        g2D.translate(0.0, -6.0);
    }

    @Override
    public void paintHotSpot(Graphics2D g2D, LightweightEntityRealizer realizer) throws Exception {
        LOG.log(Level.FINE, "{0} paint hotspot", realizer.getGraphEntity());
        this._hotSpotPainter.paintHotSpots((BA)realizer, g2D);
    }

    @Override
    public void createLabels(LightweightEntityRealizer realizer) {
        MaltegoEntity entitySkeleton = realizer.getEntitySkeleton();
        if (entitySkeleton != null) {
            EntityLabels.createValueLabel(realizer);
            EntityLabels.createPinLabel(realizer);
            EntityLabels.createNotesLabel(realizer);
            EntityLabels.createBookmarkLabel(realizer);
            EntityLabels.createNotesEditLabel(realizer);
            EntityLabels.createProviderLabels(realizer);
        } else {
            CollectionNodeRenderInfo collectionInfo = realizer.getCollectionNodeInfo();
            if (collectionInfo != null) {
                realizer.getLabel().setText("");
                EntityLabels.createPinLabel(realizer);
            }
        }
    }

    @Override
    public void updateSize(LightweightEntityRealizer realizer) {
        LOG.log(Level.FINE, "{0} updateSize", realizer.getGraphEntity());
        this.updateSizeNode(realizer);
        this.updateSizeNotes(realizer);
        this.updateSizeBookmark(realizer);
        this.updateSizePin(realizer);
    }

    private void updateSizeNode(LightweightEntityRealizer realizer) {
        gB bottom;
        boolean adjustSizeToMatchLabel;
        double h = EntityRealizerConstants.IMAGE_SIZE + 6;
        double w = EntityRealizerConstants.IMAGE_SIZE + 3;
        double collectionNodeRelativeSize = 1.2;
        if (realizer.isCollectionNode()) {
            h *= 1.2;
            w *= 1.2;
        } else {
            int outerMargin = 20;
            w += 40.0;
        }
        w += 38.0;
        double topLabelHeight = 19.0;
        double bottomLabelHeight = 19.0;
        boolean bl = adjustSizeToMatchLabel = !realizer.isCollectionNode();
        if (adjustSizeToMatchLabel && realizer.labelCount() > 0 && (bottom = realizer.getLabel()).isVisible()) {
            bottom.calculateSize();
            w = Math.max(w, bottom.getWidth() + 4.0);
            bottomLabelHeight = bottom.getHeight();
        }
        LOG.log(Level.FINE, "Normal {0} {1} Size={2},{3}", new Object[]{realizer.getGraphEntity(), realizer, w, h += 12.0 + topLabelHeight + bottomLabelHeight});
        realizer.setSizeForce(w, h);
    }

    private void updateSizeNotes(LightweightEntityRealizer realizer) {
        if (realizer.labelCount() > 2) {
            double w = realizer.getWidth();
            gB notesLabel = realizer.getLabel(2);
            double notesX = w / 2.0 + 20.0;
            double notesY = 32.0;
            notesLabel.setFreeOffset(notesX, notesY);
        }
    }

    private void updateSizeBookmark(LightweightEntityRealizer realizer) {
        if (realizer.labelCount() > 3) {
            double w = realizer.getWidth();
            gB bookmarkLabel = realizer.getLabel(3);
            double bookmarkX = w / 2.0 + 17.0;
            double bookmarkY = 13.0;
            bookmarkLabel.setFreeOffset(bookmarkX, bookmarkY);
        }
    }

    private void updateSizePin(LightweightEntityRealizer realizer) {
        if (realizer.labelCount() > 1) {
            double pinY;
            double pinX;
            gB label = realizer.getLabel(1);
            double w = realizer.getWidth();
            if (realizer.getEntitySkeleton() != null) {
                pinX = w / 2.0 + 18.0;
                pinY = 51.0;
            } else {
                pinX = w - 16.0 - 0.0;
                pinY = 0.0;
            }
            label.setFreeOffset(pinX, pinY);
        }
    }

    private void updateOverlayProperties() {
        if (System.currentTimeMillis() - _lastUpdate > 3000L) {
            _paintTypeOverlay = NbPreferences.forModule(EntityNodePainter.class).getBoolean("showTypeOverlayIcons", true);
            _paintAttachmentsOverlay = NbPreferences.forModule(EntityNodePainter.class).getBoolean("showAttachmentsOverlayIcons", true);
            _lastUpdate = System.currentTimeMillis();
        }
    }

    public static boolean isFarZoom(double zoom) {
        return zoom < 1.1;
    }

    public static boolean isMiddleZoom(double zoom) {
        return !MainEntityPainter.isFarZoom(zoom) && !MainEntityPainter.isDeepZoom(zoom);
    }

    public static boolean isDeepZoom(double zoom) {
        return zoom >= 2.0;
    }
}

