/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.options;

import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.ui.graph.nodes.CopyToNewGraphAction;
import com.paterva.maltego.ui.graph.view2d.EntityLabelMax;
import com.paterva.maltego.ui.graph.view2d.EntityLabelOptions;
import com.paterva.maltego.ui.graph.view2d.VisiblePrunerOptions;
import com.paterva.maltego.ui.graph.view2d.options.DisplayOptionsPanelController;
import com.paterva.maltego.util.ui.ColorButton;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import com.paterva.maltego.util.ui.components.MultiLineLabel;
import com.paterva.maltego.util.ui.fonts.FontAAValues;
import com.paterva.maltego.util.ui.fonts.FontSizeDescriptor;
import com.paterva.maltego.util.ui.fonts.FontSizeRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class DisplayPanel
extends JPanel {
    private static final String PREF_SHOW_MANUAL_DIALOG = "showEdgeCreationProperties";
    private static final String PREF_TYPE_OVERLAY = "showTypeOverlayIcons";
    private static final String PREF_ATTACHMENTS_OVERLAY = "showAttachmentsOverlayIcons";
    private final List<LabelMax> maxLabels;
    private final List<LabelMax> maxLinesLabels;
    private final DisplayOptionsPanelController _controller;
    private Color _defaultManualLinkColor;
    private Color _defaultTransformLinkColor;
    private final Map<String, JSpinner> _fontSizeItems = new HashMap<String, JSpinner>();
    private JComboBox _antialiasingComboBox;
    private JCheckBox _attachmentsOverlayCheckBox;
    private JPanel _fontAntialiasingPanel;
    private JPanel _fontSizePanel;
    private JCheckBox _hideLinksCheckBox;
    private JSpinner _hideLinksSpinner;
    private JPanel _hidePassthroughPanel;
    private JPanel _layoutPanel;
    private JCheckBox _limitNorthOverlayCheckBox;
    private JSpinner _limitNorthOverlaySpinner;
    private JCheckBox _limitNotesCheckBox;
    private JCheckBox _limitNotesLinesCheckBox;
    private JSpinner _limitNotesLinesSpinner;
    private JSpinner _limitNotesSpinner;
    private JCheckBox _limitValueCheckBox;
    private JSpinner _limitValueSpinner;
    private JCheckBox _limitWestOverlayCheckBox;
    private JSpinner _limitWestOverlaySpinner;
    private JButton _manualLinkColorButton;
    private JButton _manualLinkColorChangeButton;
    private JPanel _maxLabelLenghtPanel;
    private JPanel _maxLabelLinestPanel;
    private JCheckBox _relayoutAfterCopyCheckBox;
    private JCheckBox _showEditCheckBox;
    private JButton _transformLinkColorButton;
    private JButton _transformLinkColorChangeButton;
    private JCheckBox _typeOverlayCheckBox;

    DisplayPanel(DisplayOptionsPanelController controller) {
        this._controller = controller;
        this.initComponents();
        ChangeListener listener = __ -> this._controller.changed();
        this._limitValueSpinner.addChangeListener(listener);
        this._hideLinksSpinner.addChangeListener(listener);
        this._hideLinksCheckBox.setVisible(false);
        this._hideLinksSpinner.setVisible(false);
        this._hidePassthroughPanel.setVisible(false);
        this.maxLabels = Arrays.asList(new LabelMax(EntityLabelMax.VALUE, this._limitValueCheckBox, this._limitValueSpinner), new LabelMax(EntityLabelMax.NOTES, this._limitNotesCheckBox, this._limitNotesSpinner), new LabelMax(EntityLabelMax.NORTH, this._limitNorthOverlayCheckBox, this._limitNorthOverlaySpinner), new LabelMax(EntityLabelMax.WEST, this._limitWestOverlayCheckBox, this._limitWestOverlaySpinner));
        this.maxLinesLabels = Arrays.asList(new LabelMax(EntityLabelMax.NOTES_LINES, this._limitNotesLinesCheckBox, this._limitNotesLinesSpinner));
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this._showEditCheckBox = new JCheckBox();
        JLabel jLabel1 = new JLabel();
        this._manualLinkColorButton = new ColorButton();
        this._manualLinkColorChangeButton = new JButton();
        JLabel jLabel2 = new JLabel();
        this._transformLinkColorButton = new ColorButton();
        this._transformLinkColorChangeButton = new JButton();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel2 = new JPanel();
        this._typeOverlayCheckBox = new JCheckBox();
        this._attachmentsOverlayCheckBox = new JCheckBox();
        JPanel jPanel7 = new JPanel();
        this._fontSizePanel = new JPanel();
        this._fontAntialiasingPanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this._antialiasingComboBox = new JComboBox();
        JPanel jPanel4 = new JPanel();
        this._maxLabelLenghtPanel = new JPanel();
        this._limitValueCheckBox = new JCheckBox();
        this._limitValueSpinner = new JSpinner();
        this._limitNotesCheckBox = new JCheckBox();
        this._limitNotesSpinner = new JSpinner();
        this._limitNorthOverlayCheckBox = new JCheckBox();
        this._limitNorthOverlaySpinner = new JSpinner();
        this._limitWestOverlayCheckBox = new JCheckBox();
        this._limitWestOverlaySpinner = new JSpinner();
        JPanel jPanel3 = new JPanel();
        this._maxLabelLinestPanel = new JPanel();
        this._limitNotesLinesCheckBox = new JCheckBox();
        this._limitNotesLinesSpinner = new JSpinner();
        JPanel jPanel10 = new JPanel();
        this._hidePassthroughPanel = new JPanel();
        this._hideLinksCheckBox = new JCheckBox();
        this._hideLinksSpinner = new JSpinner();
        JPanel jPanel5 = new JPanel();
        this._layoutPanel = new JPanel();
        this._relayoutAfterCopyCheckBox = new JCheckBox();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel9 = new JPanel();
        this.setMinimumSize(new Dimension(550, 500));
        this.setLayout(new GridBagLayout());
        jPanel1.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel.jPanel1.border.title")));
        jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._showEditCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._showEditCheckBox.text"));
        this._showEditCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._showEditCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel1.add((Component)this._showEditCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)jLabel1, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        jPanel1.add((Component)jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._manualLinkColorButton, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._manualLinkColorButton.text"));
        this._manualLinkColorButton.setMaximumSize(new Dimension(15, 15));
        this._manualLinkColorButton.setMinimumSize(new Dimension(15, 15));
        this._manualLinkColorButton.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel1.add((Component)this._manualLinkColorButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._manualLinkColorChangeButton, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._manualLinkColorChangeButton.text"));
        this._manualLinkColorChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._manualLinkColorChangeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel1.add((Component)this._manualLinkColorChangeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        jPanel1.add((Component)jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._transformLinkColorButton, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._transformLinkColorButton.text"));
        this._transformLinkColorButton.setMaximumSize(new Dimension(15, 15));
        this._transformLinkColorButton.setMinimumSize(new Dimension(15, 15));
        this._transformLinkColorButton.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel1.add((Component)this._transformLinkColorButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._transformLinkColorChangeButton, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._transformLinkColorChangeButton.text"));
        this._transformLinkColorChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._transformLinkColorChangeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel1.add((Component)this._transformLinkColorChangeButton, gridBagConstraints);
        jPanel8.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel8Layout = new GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 303, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 29, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add((Component)jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel1, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel.jPanel2.border.title")));
        jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._typeOverlayCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._typeOverlayCheckBox.text"));
        this._typeOverlayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._typeOverlayCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel2.add((Component)this._typeOverlayCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._attachmentsOverlayCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._attachmentsOverlayCheckBox.text"));
        this._attachmentsOverlayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._attachmentsOverlayCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel2.add((Component)this._attachmentsOverlayCheckBox, gridBagConstraints);
        jPanel7.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 97, Short.MAX_VALUE));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 55, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        this._fontSizePanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._fontSizePanel.border.title")));
        this._fontSizePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this._fontSizePanel, gridBagConstraints);
        this._fontAntialiasingPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._fontAntialiasingPanel.border.title")));
        this._fontAntialiasingPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 9, 0, 3);
        this._fontAntialiasingPanel.add((Component)jLabel3, gridBagConstraints);
        this._antialiasingComboBox.setToolTipText(NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._antialiasingComboBox.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 30;
        this._fontAntialiasingPanel.add((Component)this._antialiasingComboBox, gridBagConstraints);
        jPanel4.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 409, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this._fontAntialiasingPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this._fontAntialiasingPanel, gridBagConstraints);
        this._maxLabelLenghtPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._maxLabelLenghtPanel.border.title")));
        this._maxLabelLenghtPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._limitValueCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._limitValueCheckBox.text"));
        this._limitValueCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._limitValueCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this._maxLabelLenghtPanel.add((Component)this._limitValueCheckBox, gridBagConstraints);
        this._limitValueSpinner.setModel(new SpinnerNumberModel(35, 5, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this._maxLabelLenghtPanel.add((Component)this._limitValueSpinner, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._limitNotesCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._limitNotesCheckBox.text"));
        this._limitNotesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._limitNotesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this._maxLabelLenghtPanel.add((Component)this._limitNotesCheckBox, gridBagConstraints);
        this._limitNotesSpinner.setModel(new SpinnerNumberModel(50, 5, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this._maxLabelLenghtPanel.add((Component)this._limitNotesSpinner, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._limitNorthOverlayCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._limitNorthOverlayCheckBox.text"));
        this._limitNorthOverlayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._limitNorthOverlayCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 24, 3, 3);
        this._maxLabelLenghtPanel.add((Component)this._limitNorthOverlayCheckBox, gridBagConstraints);
        this._limitNorthOverlaySpinner.setModel(new SpinnerNumberModel(35, 5, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this._maxLabelLenghtPanel.add((Component)this._limitNorthOverlaySpinner, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._limitWestOverlayCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._limitWestOverlayCheckBox.text"));
        this._limitWestOverlayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._limitWestOverlayCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 3, 3);
        this._maxLabelLenghtPanel.add((Component)this._limitWestOverlayCheckBox, gridBagConstraints);
        this._limitWestOverlaySpinner.setModel(new SpinnerNumberModel(16, 5, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this._maxLabelLenghtPanel.add((Component)this._limitWestOverlaySpinner, gridBagConstraints);
        jPanel3.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 211, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 55, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this._maxLabelLenghtPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this._maxLabelLenghtPanel, gridBagConstraints);
        this._maxLabelLinestPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._maxLabelLinestPanel.border.title")));
        this._maxLabelLinestPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._limitNotesLinesCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._limitNotesLinesCheckBox.text"));
        this._limitNotesLinesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._limitNotesLinesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this._maxLabelLinestPanel.add((Component)this._limitNotesLinesCheckBox, gridBagConstraints);
        this._limitNotesLinesSpinner.setModel(new SpinnerNumberModel(100, 1, 5000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this._maxLabelLinestPanel.add((Component)this._limitNotesLinesSpinner, gridBagConstraints);
        jPanel10.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel10Layout = new GroupLayout(jPanel10);
        jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 419, Short.MAX_VALUE));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this._maxLabelLinestPanel.add((Component)jPanel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this._maxLabelLinestPanel, gridBagConstraints);
        this._hidePassthroughPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._hidePassthroughPanel.border.title")));
        this._hidePassthroughPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._hideLinksCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._hideLinksCheckBox.text"));
        this._hideLinksCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._hideLinksCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this._hidePassthroughPanel.add((Component)this._hideLinksCheckBox, gridBagConstraints);
        this._hideLinksSpinner.setModel(new SpinnerNumberModel(35, 10, 100000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this._hidePassthroughPanel.add((Component)this._hideLinksSpinner, gridBagConstraints);
        jPanel5.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this._hidePassthroughPanel.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this._hidePassthroughPanel, gridBagConstraints);
        this._layoutPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._layoutPanel.border.title")));
        this._layoutPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._relayoutAfterCopyCheckBox, (String)NbBundle.getMessage(DisplayPanel.class, (String)"DisplayPanel._relayoutAfterCopyCheckBox.text"));
        this._relayoutAfterCopyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPanel.this._relayoutAfterCopyCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this._layoutPanel.add((Component)this._relayoutAfterCopyCheckBox, gridBagConstraints);
        jPanel6.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 363, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this._layoutPanel.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this._layoutPanel, gridBagConstraints);
        GroupLayout jPanel9Layout = new GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel9, gridBagConstraints);
    }

    private void _showEditCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
    }

    private void _manualLinkColorChangeButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Choose a Link Color", this._defaultManualLinkColor);
        if (newColor != null) {
            this._defaultManualLinkColor = newColor;
        }
        this._controller.changed();
        this.updateLinkColorButtons();
    }

    private void _transformLinkColorChangeButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Choose a Link Color", this._defaultTransformLinkColor);
        if (newColor != null) {
            this._defaultTransformLinkColor = newColor;
        }
        this._controller.changed();
        this.updateLinkColorButtons();
    }

    private void _typeOverlayCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
    }

    private void _attachmentsOverlayCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
    }

    private void _limitValueCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
        this._limitValueSpinner.setEnabled(this._limitValueCheckBox.isSelected());
    }

    private void _hideLinksCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
    }

    private void _relayoutAfterCopyCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
    }

    private void _limitWestOverlayCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
        this._limitWestOverlaySpinner.setEnabled(this._limitWestOverlayCheckBox.isSelected());
    }

    private void _limitNorthOverlayCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
        this._limitNorthOverlaySpinner.setEnabled(this._limitNorthOverlayCheckBox.isSelected());
    }

    private void _limitNotesCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
        this._limitNotesSpinner.setEnabled(this._limitNotesCheckBox.isSelected());
    }

    private void _limitNotesLinesCheckBoxActionPerformed(ActionEvent evt) {
        this._controller.changed();
        this._limitNotesLinesSpinner.setEnabled(this._limitNotesLinesCheckBox.isSelected());
    }

    private void addFontSizes() {
        this._fontSizeItems.clear();
        this._fontSizePanel.removeAll();
        GridBagLayout gbl = new GridBagLayout();
        this._fontSizePanel.setLayout(gbl);
        List fontSizes = FontSizeRegistry.getDefault().getAll();
        int row = 0;
        for (FontSizeDescriptor fontSizeDesc : fontSizes) {
            this.addFontSizeLabel(row, fontSizeDesc);
            if (fontSizeDesc.isEditable()) {
                this.addFontSizeSpinner(row, fontSizeDesc);
            } else {
                this.addFontSizeNoEditReason(row, fontSizeDesc);
            }
            if (fontSizeDesc.isRestartRequired()) {
                this.addFontSizeRestartLabel(row);
            }
            ++row;
        }
    }

    private void addFontSizeLabel(int row, FontSizeDescriptor fontSizeDesc) {
        JLabel mainDisplayLabel = new JLabel(fontSizeDesc.getDisplayName());
        GridBagConstraints labelCons = this.createFontSizeConstraints(row, 0);
        this._fontSizePanel.add((Component)mainDisplayLabel, labelCons);
    }

    private void addFontSizeSpinner(int row, FontSizeDescriptor fontSizeDesc) {
        GridBagConstraints spinEditCons = this.createFontSizeConstraints(row, 1);
        int fontSize = FontSizeRegistry.getDefault().getFontSize(fontSizeDesc.getName());
        JSpinner spinEdit = new JSpinner();
        spinEdit.setModel(new SpinnerNumberModel(fontSize, fontSizeDesc.getMinFontSize(), fontSizeDesc.getMaxFontSize(), 1));
        this._fontSizeItems.put(fontSizeDesc.getName(), spinEdit);
        spinEdit.addChangeListener(new FontSizeChangeListener());
        this._fontSizePanel.add((Component)spinEdit, spinEditCons);
    }

    private void addFontSizeNoEditReason(int row, FontSizeDescriptor fontSizeDesc) {
        MultiLineLabel nonEditableReasonLabel = new MultiLineLabel();
        nonEditableReasonLabel.setVerticalAlignment(1);
        nonEditableReasonLabel.setMaximumSize(new Dimension(2000, 2000));
        nonEditableReasonLabel.setVerticalTextPosition(1);
        nonEditableReasonLabel.setText(fontSizeDesc.nonEditableReason());
        JPanel labelPanel = new JPanel(new BorderLayout(0, 0));
        labelPanel.add((Component)nonEditableReasonLabel, "Center");
        GridBagConstraints nonEditCons = this.createFontSizeConstraints(row, 1);
        nonEditCons.fill = 1;
        nonEditCons.weightx = 1.0;
        nonEditCons.gridheight = 3;
        nonEditCons.gridwidth = 0;
        this._fontSizePanel.add((Component)labelPanel, nonEditCons);
    }

    private void addFontSizeRestartLabel(int row) {
        GridBagConstraints restartCons = this.createFontSizeConstraints(row, 2);
        JLabel restartLabel = this.getRestartLabel();
        this._fontSizePanel.add((Component)restartLabel, restartCons);
    }

    private JLabel getRestartLabel() {
        JLabel restartLabel = new JLabel("(Requires restart)");
        Font font = restartLabel.getFont();
        restartLabel.setFont(font.deriveFont((float)font.getSize() - 1.0f));
        return restartLabel;
    }

    private GridBagConstraints createFontSizeConstraints(int row, int col) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = col;
        cons.gridy = row;
        cons.anchor = 17;
        cons.insets = new Insets(3, 6, 3, 0);
        return cons;
    }

    private void addFontAntialiasing() {
        FontAAValues[] aaValues = FontAAValues.getArray();
        if (this._antialiasingComboBox.getItemCount() == 0) {
            for (FontAAValues aaValue : aaValues) {
                this._antialiasingComboBox.addItem(aaValue.toString());
            }
        }
        this._antialiasingComboBox.setSelectedItem(NbPreferences.forModule(FontAAValues.class).get("fontAntialiasing", aaValues[4].toString()));
        this.addFontAntialiasingRestartLabel();
    }

    private void addFontAntialiasingRestartLabel() {
        GridBagConstraints restartCons = this.createFontSizeConstraints(0, 2);
        JLabel restartLabel = this.getRestartLabel();
        this._fontAntialiasingPanel.add((Component)restartLabel, restartCons);
    }

    void load() {
        boolean enabled;
        JSpinner spinner;
        JCheckBox checkBox;
        EntityLabelMax label;
        this._showEditCheckBox.setSelected(NbPreferences.forModule(DisplayPanel.class).getBoolean(PREF_SHOW_MANUAL_DIALOG, true));
        this._defaultManualLinkColor = MaltegoLinkSpec.getDefaultManualLinkColor();
        this._defaultTransformLinkColor = MaltegoLinkSpec.getDefaultTransformLinkColor();
        this.updateLinkColorButtons();
        this._typeOverlayCheckBox.setSelected(NbPreferences.forModule(DisplayPanel.class).getBoolean(PREF_TYPE_OVERLAY, true));
        this._attachmentsOverlayCheckBox.setSelected(NbPreferences.forModule(DisplayPanel.class).getBoolean(PREF_ATTACHMENTS_OVERLAY, true));
        this.addFontSizes();
        this.addFontAntialiasing();
        for (LabelMax maxLabel : this.maxLabels) {
            label = maxLabel.getLabel();
            checkBox = maxLabel.getCheckBox();
            spinner = maxLabel.getSpinner();
            enabled = EntityLabelOptions.isEnabled(label);
            checkBox.setSelected(enabled);
            spinner.setValue(EntityLabelOptions.getMaxLength(label));
            spinner.setEnabled(enabled);
        }
        for (LabelMax maxLinesLabel : this.maxLinesLabels) {
            label = maxLinesLabel.getLabel();
            checkBox = maxLinesLabel.getCheckBox();
            spinner = maxLinesLabel.getSpinner();
            enabled = EntityLabelOptions.isEnabled(label);
            checkBox.setSelected(enabled);
            spinner.setValue(EntityLabelOptions.getMaxLength(label));
            spinner.setEnabled(enabled);
        }
        this._hideLinksCheckBox.setSelected(VisiblePrunerOptions.isHidePassthroughEdges());
        this._hideLinksSpinner.setValue(VisiblePrunerOptions.getStartHidingEdgesCount());
        this._relayoutAfterCopyCheckBox.setSelected(CopyToNewGraphAction.isRelayoutAfterCopy());
    }

    void store() {
        EntityLabelMax label;
        NbPreferences.forModule(DisplayPanel.class).putBoolean(PREF_SHOW_MANUAL_DIALOG, this._showEditCheckBox.isSelected());
        MaltegoLinkSpec.setDefaultManualLinkColor((Color)this._defaultManualLinkColor);
        MaltegoLinkSpec.setDefaultTransformLinkColor((Color)this._defaultTransformLinkColor);
        NbPreferences.forModule(DisplayPanel.class).putBoolean(PREF_TYPE_OVERLAY, this._typeOverlayCheckBox.isSelected());
        NbPreferences.forModule(DisplayPanel.class).putBoolean(PREF_ATTACHMENTS_OVERLAY, this._attachmentsOverlayCheckBox.isSelected());
        for (Map.Entry<String, JSpinner> entrySet : this._fontSizeItems.entrySet()) {
            String key = entrySet.getKey();
            JSpinner value = entrySet.getValue();
            FontSizeRegistry.getDefault().setFontSize(key, ((Integer)value.getValue()).intValue());
        }
        NbPreferences.forModule(FontAAValues.class).put("fontAntialiasing", (String)this._antialiasingComboBox.getSelectedItem());
        for (LabelMax maxLabel : this.maxLabels) {
            label = maxLabel.getLabel();
            EntityLabelOptions.setEnabled(label, maxLabel.getCheckBox().isSelected());
            EntityLabelOptions.setMaxLength(label, (Integer)maxLabel.getSpinner().getValue());
        }
        for (LabelMax maxLinesLabel : this.maxLinesLabels) {
            label = maxLinesLabel.getLabel();
            EntityLabelOptions.setEnabled(label, maxLinesLabel.getCheckBox().isSelected());
            EntityLabelOptions.setMaxLength(label, (Integer)maxLinesLabel.getSpinner().getValue());
        }
        VisiblePrunerOptions.setHidePassthroughEdges(this._hideLinksCheckBox.isSelected());
        VisiblePrunerOptions.setStartHidingEdgesCount((Integer)this._hideLinksSpinner.getValue());
        CopyToNewGraphAction.setRelayoutAfterCopy(this._relayoutAfterCopyCheckBox.isSelected());
    }

    boolean valid() {
        return true;
    }

    private void updateLinkColorButtons() {
        this._manualLinkColorButton.setBackground(this._defaultManualLinkColor);
        this._transformLinkColorButton.setBackground(this._defaultTransformLinkColor);
    }

    private static class LabelMax {
        private final EntityLabelMax label;
        private final JCheckBox checkBox;
        private final JSpinner spinner;

        public LabelMax(EntityLabelMax label, JCheckBox checkBox, JSpinner spinner) {
            this.label = label;
            this.checkBox = checkBox;
            this.spinner = spinner;
        }

        public EntityLabelMax getLabel() {
            return this.label;
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public JSpinner getSpinner() {
            return this.spinner;
        }
    }

    private class FontSizeChangeListener
    implements ChangeListener {
        private FontSizeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            DisplayPanel.this._controller.changed();
        }
    }
}

