/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.view2d.MaltegoGraph2DRenderer;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ui.image.TileViewer;
import com.paterva.maltego.util.ui.progress.ProgressController;
import com.paterva.maltego.util.yfiles.GIFIOHandlerJai;
import com.paterva.maltego.util.yfiles.IOHandlerJai;
import com.paterva.maltego.util.yfiles.ImageIoOutputHandlerJai;
import com.paterva.maltego.util.yfiles.JPGIOHandlerJai;
import com.paterva.maltego.util.yfiles.TiledImageOutputHandlerJai;
import gov.nist.isg.pyramidio.ProgressCallback;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.apache.commons.io.FilenameUtils;
import yguard.A.H.A;
import yguard.A.H.B;
import yguard.A.H.C;
import yguard.A.H.G;
import yguard.A.H.J;
import yguard.A.H.R;
import yguard.A.J.;
import yguard.A.J.LC;
import yguard.A.J.NA;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.uB;

public class Graph2DExporter {
    public static final int IMAGE_STREAM_THRESHOLD = 15000;
    public static final int IMAGE_PDF_EXPORT_WIDTH = 3011;
    private static final Logger LOG = Logger.getLogger(Graph2DExporter.class.getName());
    private static final LinkedHashMap<String, String> FILE_TYPES = new LinkedHashMap();

    private Graph2DExporter() {
    }

    public static LinkedHashMap<String, String> getFileTypes() {
        return FILE_TYPES;
    }

    public static boolean exportToFile(File outImage, SA graph, boolean transparentBackground, int width, boolean wholeGraph, File outHTML, ProgressController controller) throws IOException {
        C ioh;
        String path = outImage.getPath().toLowerCase();
        if (path.endsWith(".gif")) {
            ioh = new C();
        } else if (path.endsWith(".jpg")) {
            ioh = new R();
            ((R)ioh).A(0.9f);
        } else {
            ioh = Graph2DExporter.createOutputHandler(FileUtilities.getFileExtension((File)outImage).toLowerCase());
        }
        if (ioh != null) {
            return Graph2DExporter.exportGraphToImageFileFormat(graph, (J)ioh, outImage, transparentBackground, width, wholeGraph, outHTML, controller);
        }
        throw new IOException("Unable to export the graph. The given file format is not supported.");
    }

    private static J createOutputHandler(String extension) {
        ImageWriter iw;
        Iterator<ImageWriter> it = ImageIO.getImageWritersBySuffix(extension);
        ImageWriter imageWriter = iw = it.hasNext() ? it.next() : null;
        if (iw == null) {
            return null;
        }
        A ioh = new A(iw);
        if ("png".equalsIgnoreCase(extension)) {
            ioh.I(true);
        }
        return ioh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exportGraphToImageFileFormat(SA graph, J ioh, File outImage, boolean transparentBackground, int width, boolean wholeGraph, File outHTML, ProgressController controller) throws IOException {
        boolean exceedsMaxJpeg;
        U originalView = Graph2DExporter.replaceCurrentWithExportView(graph, ioh, wholeGraph, false);
        Graph2DExporter.configureExportView((U)graph.\u00f1(), transparentBackground, width, wholeGraph);
        Component component = graph.\u00f1().getComponent();
        long viewWidth = component.getWidth();
        long viewHeight = component.getHeight();
        long sumPixels = viewWidth * viewHeight;
        int maxJpegDimension = 43000;
        int sumLimitJpeg = Math.min(maxJpegDimension * maxJpegDimension, Integer.MAX_VALUE);
        boolean bl = exceedsMaxJpeg = sumPixels > (long)sumLimitJpeg || viewHeight > 65500L;
        if (exceedsMaxJpeg && "jpg".equalsIgnoreCase(FileUtilities.getFileExtension((File)outImage))) {
            throw new IOException("For JPG images the maximum pixel count is an image of roughly " + maxJpegDimension + " x " + maxJpegDimension + " px, or a height of 65500 pixels. Use PNG as the output format for larger images.");
        }
        int widthLimit = 15000;
        int sumLimit = Math.min(widthLimit * widthLimit, Integer.MAX_VALUE);
        boolean exceedsMaxGeneral = sumPixels > (long)sumLimit || viewWidth > (long)widthLimit;
        try {
            com.paterva.maltego.util.jai.ProgressCallback cb = (task, message, progress) -> {
                if (controller != null && "EXPORT_IMAGE".equals(task)) {
                    controller.progress(message, progress);
                }
            };
            Graph2DExporter.writeGraphToFile(graph, (G)ioh, outImage, exceedsMaxGeneral, cb);
        }
        finally {
            Graph2DExporter.restoreOriginalView(graph, originalView);
            if (outHTML != null && outImage.isFile()) {
                String baseName = FilenameUtils.getBaseName((String)outHTML.getName());
                if (controller != null) {
                    Graph2DExporter.updateProgress(controller, "Creating Tiled Browser Image", 101);
                }
                AtomicInteger progressUnit = new AtomicInteger(100);
                ProgressCallback cb = (task, message, progress) -> {
                    int stepProgress = progress + 100;
                    if (controller != null && "DZI_IMAGE".equals(task) && stepProgress > progressUnit.get() && stepProgress < 199) {
                        progressUnit.set(stepProgress);
                        Graph2DExporter.updateProgress(controller, message, stepProgress);
                    }
                };
                int maxZoom = TileViewer.createDeepZoomImage((File)outImage, (File)outHTML.getParentFile(), (String)baseName, (boolean)exceedsMaxGeneral, (ProgressCallback)cb);
                if (maxZoom > -1) {
                    String imagesFolderName = baseName + "_files";
                    TileViewer.createLeafletDeepZoomHTML((File)outHTML, (String)imagesFolderName, (int)maxZoom, (int)((int)viewWidth), (int)((int)viewHeight));
                    if (controller != null) {
                        Graph2DExporter.updateProgress(controller, "Finished creating Tiled Browser Image", 199);
                    }
                }
            }
            if (controller != null) {
                Graph2DExporter.updateProgress(controller, "Finished exporting graph as image", 200);
            }
        }
        return true;
    }

    private static void updateProgress(ProgressController controller, String message, int progress) {
        LOG.log(Level.INFO, "{0}: {1}", new Object[]{message, progress});
        controller.progress(message, progress);
    }

    private static void writeGraphToFile(SA graph, G ioh, File outImageFile, boolean exceedsMax, com.paterva.maltego.util.jai.ProgressCallback cb) throws IOException {
        if (cb != null) {
            Graph2DExporter.updateProgress(cb, "Starting graph export as image", 0);
        }
        if (exceedsMax) {
            String extension = FileUtilities.getFileExtension((File)outImageFile).toLowerCase();
            GIFIOHandlerJai iohJai = null;
            if (ioh instanceof C) {
                iohJai = new GIFIOHandlerJai();
            } else if (ioh instanceof R) {
                iohJai = new JPGIOHandlerJai();
                ((JPGIOHandlerJai)iohJai).setQuality(((R)ioh).Z());
            } else if (ioh instanceof A) {
                iohJai = new ImageIoOutputHandlerJai(((A)ioh).a());
                if ("png".equalsIgnoreCase(extension)) {
                    ((ImageIoOutputHandlerJai)iohJai).setTransparencyEnabled(true);
                }
            }
            if (iohJai == null) {
                throw new IOException("Unable to export the graph. The given file format is not supported.");
            }
            TiledImageOutputHandlerJai tioh = new TiledImageOutputHandlerJai((IOHandlerJai)iohJai, 5000, 256);
            tioh.write(graph, outImageFile, extension, cb);
        } else {
            ioh.A(graph, outImageFile.getPath());
        }
        if (cb != null) {
            Graph2DExporter.updateProgress(cb, "Finished image save", 100);
        }
    }

    private static void updateProgress(com.paterva.maltego.util.jai.ProgressCallback cb, String message, int progress) {
        LOG.log(Level.INFO, "{0}: {1}", new Object[]{message, progress});
        cb.progress("EXPORT_IMAGE", message, progress);
    }

    private static U replaceCurrentWithExportView(SA graph, J ioh, boolean wholeGraph, boolean optimizationsEnabled) {
        U originalView = (U)graph.\u00f1();
        U exportView = ioh.C(graph);
        if (!wholeGraph) {
            double margin = 0.0;
            Dimension canvasSize = originalView.getCanvasSize();
            exportView.setSize(canvasSize);
            exportView.setPreferredSize(canvasSize);
            Rectangle visibleRect = originalView.getVisibleRect();
            exportView.zoomToArea((double)visibleRect.x - margin, (double)visibleRect.y - margin, (double)visibleRect.width + 2.0 * margin, (double)visibleRect.height + 2.0 * margin);
        }
        MaltegoGraph2DRenderer renderer = new MaltegoGraph2DRenderer(exportView, false);
        GraphID graphID = GraphIDProvider.forGraph((SA)graph);
        renderer.setGraphID(graphID);
        EntityPainterSettings.getDefault().getEntityPainter(graphID).setOptimizationsEnabled(optimizationsEnabled);
        exportView.setGraph2DRenderer((LC)renderer);
        graph.A((.B)exportView);
        return originalView;
    }

    private static void restoreOriginalView(SA graph, U originalView) {
        graph.C(graph.\u00f1());
        graph.A((.B)originalView);
        GraphID graphID = GraphIDProvider.forGraph((SA)graph);
        EntityPainterSettings.getDefault().getEntityPainter(graphID).setOptimizationsEnabled(true);
    }

    private static void configureExportView(U exportView, boolean transparentBackground, int width, boolean wholeGraph) {
        if (transparentBackground) {
            uB transparentBackgroundR = new uB(exportView);
            transparentBackgroundR.setColor(new Color(255, 255, 255, 0));
            exportView.setBackgroundRenderer((NA)transparentBackgroundR);
        }
        B vpc = new B();
        if (wholeGraph) {
            vpc.A(exportView.getGraph2D());
            vpc.B(B.C);
        } else {
            vpc.B(exportView);
            vpc.B(B.M);
        }
        vpc.A(B.G);
        vpc.C(width);
        vpc.A(exportView);
    }

    static {
        FILE_TYPES.put("png", "Portable Network Graphics (*.png)");
        FILE_TYPES.put("jpg", "Joint Photographic Experts Group (*.jpg)");
        FILE_TYPES.put("bmp", "Windows & OS/2 bitmap (*.bmp)");
    }
}

