/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.SearchOptions;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.find.SearchProvider;
import com.paterva.maltego.ui.graph.find.ShowFindBarAction;
import com.paterva.maltego.ui.graph.find.ShowFindBarActionSingleton;
import com.paterva.maltego.ui.graph.view2d.BookmarkHoverViewMode;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeEditMode;
import com.paterva.maltego.ui.graph.view2d.EditNotesViewMode;
import com.paterva.maltego.ui.graph.view2d.EmptyGraphClickViewMode;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewAdapter;
import com.paterva.maltego.ui.graph.view2d.GraphViewActions;
import com.paterva.maltego.ui.graph.view2d.GraphViewOptions;
import com.paterva.maltego.ui.graph.view2d.LegendBackgroundRenderer;
import com.paterva.maltego.ui.graph.view2d.LinkHighlighter;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.NotesHoverViewMode;
import com.paterva.maltego.ui.graph.view2d.PinHoverViewMode;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jdesktop.swingx.color.ColorUtil;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import yguard.A.A.E;
import yguard.A.J.BA;
import yguard.A.J.NA;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.gB;
import yguard.A.J.mB;
import yguard.A.J.wA;

public class DefaultGraph2DViewAdapter
extends Graph2DViewAdapter {
    private LinkHighlighter _highlighter;
    private LegendBackgroundRenderer _backgroundRenderer;
    private PropertyChangeListener _lookAndFeelListener;
    private CollectionNodeEditMode _collectionNodeEditMode;

    public DefaultGraph2DViewAdapter(GraphID graphID) {
        super(graphID);
    }

    @Override
    public void onGraphLoaded() {
        super.onGraphLoaded();
        this._collectionNodeEditMode.setGraphID(this.getGraphID());
    }

    @Override
    protected void onGraphChanged(SA oldGraph, SA newGraph) {
        if (oldGraph != null) {
            this.linkHighlighter().disconnect(oldGraph);
        }
        if (newGraph != null) {
            this.linkHighlighter().connect(newGraph);
        }
    }

    @Override
    protected U createView() {
        U view = super.createView();
        GraphViewActions actions = new GraphViewActions(view);
        ActionMap amap = actions.createActionMap();
        InputMap imap = actions.createDefaultInputMap(amap);
        ShowFindBarAction showFindBarAction = new ShowFindBarAction(this, new GraphStoreSearchProvider());
        ShowFindBarActionSingleton.getInstance().register(this.getGraphID(), showFindBarAction);
        view.setActionMap(amap);
        view.setInputMap(1, imap);
        this._backgroundRenderer = this.createBackground(view);
        view.setBackgroundRenderer((NA)this._backgroundRenderer);
        view.addViewMode(this.disableGrabFocus(this.linkHighlighter()));
        view.addViewMode(this.disableGrabFocus(new BookmarkHoverViewMode()));
        view.addViewMode(this.disableGrabFocus(new PinHoverViewMode()));
        view.addViewMode(this.disableGrabFocus(new NotesHoverViewMode()));
        view.addViewMode(this.disableGrabFocus(new EditNotesViewMode()));
        view.addViewMode(this.disableGrabFocus(new EmptyGraphClickViewMode()));
        view.setAntialiasedPainting(true);
        this.updateLAF(view);
        return view;
    }

    private void updateLAF(U view) {
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color lineColor = laf.getColor("graph-selectionbox-line-color");
        Color fillColor = ColorUtil.setAlpha((Color)laf.getColor("graph-selectionbox-fill-color"), (int)laf.getInt("graph-selectionbox-fill-alpha"));
        view.putClientProperty((Object)"selectionbox.linecolor", (Object)lineColor);
        view.putClientProperty((Object)"selectionbox.fillcolor", (Object)fillColor);
        SA g2D = view.getGraph2D();
        if (g2D != null) {
            E nodes = g2D.\u00a4();
            while (nodes.ok()) {
                BA realizer = g2D.f(nodes.B());
                if (realizer != null && realizer.labelCount() > 0) {
                    gB label = realizer.getLabel();
                    NodeRealizerSettings settings = NodeRealizerSettings.getDefault();
                    label.setFont(settings.getValueLabelFont());
                    label.setTextColor(settings.getValueLabelColor());
                }
                nodes.next();
            }
        }
    }

    @Override
    public void componentOpened() {
        super.componentOpened();
        final U view = this.getView();
        if (view != null) {
            this._lookAndFeelListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DefaultGraph2DViewAdapter.this.updateLAF(view);
                }
            };
            UIManager.addPropertyChangeListener(this._lookAndFeelListener);
        }
        if (this._backgroundRenderer != null) {
            this._backgroundRenderer.addListeners();
        }
    }

    @Override
    public void componentClosed() {
        if (this._backgroundRenderer != null) {
            this._backgroundRenderer.removeListeners();
        }
        if (this._lookAndFeelListener != null) {
            UIManager.removePropertyChangeListener(this._lookAndFeelListener);
            this._lookAndFeelListener = null;
        }
        ShowFindBarActionSingleton.getInstance().deregister(this.getGraphID());
        super.componentClosed();
    }

    private synchronized LinkHighlighter linkHighlighter() {
        if (this._highlighter == null) {
            this._highlighter = this.createLinkHighlighter();
        }
        return this._highlighter;
    }

    protected LinkHighlighter createLinkHighlighter() {
        return new LinkHighlighter();
    }

    @Override
    protected wA createEditMode() {
        wA editMode = super.createEditMode();
        this._collectionNodeEditMode = new CollectionNodeEditMode(editMode);
        editMode.setEditNodeMode((mB)this._collectionNodeEditMode);
        return editMode;
    }

    private static void showActionMap(ActionMap actionMap, InputMap inputMap) {
        System.out.println("---- Actions -----");
        for (Object o : actionMap.allKeys()) {
            System.out.println(o + "->" + actionMap.get(o).getClass().getName());
        }
        System.out.println("---- Keys ------");
        for (KeyStroke key : inputMap.allKeys()) {
            System.out.println(key + "->" + inputMap.get(key));
        }
        System.out.println("--------------");
    }

    protected LegendBackgroundRenderer createBackground(U view) {
        LegendBackgroundRenderer bgr = new LegendBackgroundRenderer(this.getGraphID(), view);
        bgr.setMode((byte)0);
        bgr.setLegendPosition(1);
        bgr.setImage(GraphViewOptions.getDefault().getBackground());
        return bgr;
    }

    public static SearchOptions toSearchOptions(String text, Map<String, Object> constraints) {
        text = text.toLowerCase();
        boolean negated = false;
        if (text.startsWith("!")) {
            text = text.substring(1);
            negated = true;
        }
        String type = DefaultGraph2DViewAdapter.getType(constraints);
        boolean includeAllFields = DefaultGraph2DViewAdapter.getBoolean(constraints, "allProperties", false);
        boolean includeNotes = DefaultGraph2DViewAdapter.getBoolean(constraints, "notes", false);
        boolean includeDisplayInfo = DefaultGraph2DViewAdapter.getBoolean(constraints, "displayInfo", false);
        return new SearchOptions(text, negated, type, true, includeAllFields, includeNotes, includeDisplayInfo);
    }

    private static String getType(Map<String, Object> constraints) {
        String type = null;
        MaltegoEntitySpec spec = (MaltegoEntitySpec)constraints.get("type");
        if (spec != null) {
            type = spec.getTypeName();
        }
        return type;
    }

    private static boolean getBoolean(Map<String, Object> constraints, String name, boolean defaultValue) {
        Boolean value = (Boolean)constraints.get(name);
        return value == null ? defaultValue : value;
    }

    private class GraphStoreSearchProvider
    extends AbstractSearchProvider {
        private GraphStoreSearchProvider() {
        }

        @Override
        protected Set<? extends Guid> search(boolean findEntities, SearchOptions options) {
            Set found = Collections.emptySet();
            GraphID graphID = DefaultGraph2DViewAdapter.this.getGraphID();
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                found = findEntities ? dataReader.searchEntities(options) : dataReader.searchLinks(options);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return found;
        }
    }

    private abstract class AbstractSearchProvider
    implements SearchProvider {
        private AbstractSearchProvider() {
        }

        protected abstract Set<? extends Guid> search(boolean var1, SearchOptions var2);

        @Override
        public void search(String text, Map<String, Object> constraints) {
            GraphID graphID = DefaultGraph2DViewAdapter.this.getGraphID();
            try {
                if (!GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                    return;
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            StatusDisplayer.getDefault().setStatusText("Searching...");
            SearchOptions options = DefaultGraph2DViewAdapter.toSearchOptions(text, constraints);
            Object findEntitiesObj = constraints.get("findEntities");
            boolean findEntities = !Boolean.FALSE.equals(findEntitiesObj);
            Set<? extends Guid> found = this.search(findEntities, options);
            String msg = !found.isEmpty() ? "Found " + found.size() + " entities/links" : "No results were found";
            StatusDisplayer.getDefault().setStatusText(msg);
            if (findEntities) {
                Set<? extends Guid> entityIDs = found;
                GraphSelection.forGraph((GraphID)graphID).setSelectedModelEntities(entityIDs);
                boolean zoom = DefaultGraph2DViewAdapter.getBoolean(constraints, "zoomToResult", true);
                if (zoom) {
                    if (found.size() == 1) {
                        try {
                            EntityID entityID = (EntityID)entityIDs.iterator().next();
                            ZoomAndFlasher.instance().zoomAndFlash(graphID, entityID);
                        }
                        catch (GraphStoreException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else {
                        ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).zoomToSelection();
                    }
                }
            } else {
                Set<? extends Guid> linkIDs = found;
                GraphSelection.forGraph((GraphID)graphID).setSelectedModelLinks(linkIDs);
                ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).zoomToSelection();
            }
            DefaultGraph2DViewAdapter.this.getView().getGraph2D().\u0107();
        }
    }
}

