/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.ui.graph.actions.TopGraphPartSelectionAction;
import com.paterva.maltego.ui.graph.impl.SelectiveGlobalActionContext;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.WindowUtil;
import java.util.Set;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class QuickDeleteAction
extends TopGraphPartSelectionAction {
    public QuickDeleteAction() {
        this.putValue("position", 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed() {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)"Delete the selected items?", "Delete");
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.YES_OPTION) {
            return;
        }
        WindowUtil.showWaitCursor();
        try {
            GraphID graphID = this.getTopGraphID();
            SelectiveGlobalActionContext selection = this.getSelectionContext();
            Set<EntityID> entities = selection.getSelectedModelEntities();
            if (!entities.isEmpty()) {
                this.deleteEntities(graphID, entities);
            } else {
                Set<LinkID> links = selection.getSelectedModelLinks();
                this.deleteLinks(graphID, links);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    public String getName() {
        return "Delete";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/resources/Delete.png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLinks(GraphID graphID, Set<LinkID> modelLinkIDs) throws GraphStoreException {
        GraphStore graphStore = null;
        try {
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            String descriptionStr = "%s " + GraphTransactionHelper.getDescriptionForLinkIDs(graphID, modelLinkIDs, true);
            SimilarStrings description = new SimilarStrings(descriptionStr, "Delete", "Add");
            GraphTransactionHelper.doDeleteLinks(description, graphID, modelLinkIDs);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate((Object)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEntities(GraphID graphID, Set<EntityID> modelEntityIDs) throws GraphStoreException {
        GraphStore graphStore = null;
        try {
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            String descriptionStr = "%s " + GraphTransactionHelper.getDescriptionForEntityIDs(graphID, modelEntityIDs, true);
            SimilarStrings description = new SimilarStrings(descriptionStr, "Delete", "Add");
            GraphTransactionHelper.doDeleteEntities(description, graphID, modelEntityIDs);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate((Object)true);
            }
        }
    }
}

