/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.ui.graph.nodes.BulkQueryEntityCache;
import com.paterva.maltego.ui.graph.nodes.EntityNode;
import com.paterva.maltego.ui.graph.nodes.GraphFilterNode;
import com.paterva.maltego.ui.graph.nodes.NodePropertySupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class MergeEntitiesPanel
extends TopComponent
implements ExplorerManager.Provider,
Lookup.Provider {
    private final ExplorerManager _explorer = new ExplorerManager();
    private final Lookup _lookup;
    private final AbstractNode _rootNode;
    private final MergeChildFactory _childFactory;
    private final List<Node> _nodes;
    private MaltegoEntity _primaryEntity;
    private JCheckBox _mergeLinksCheckBox;
    private OutlineView _outlineView;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JTextArea jTextArea1;

    public MergeEntitiesPanel(GraphID graphID, Set<EntityID> entities) {
        this._nodes = this.createNetBeansNodes(graphID, entities);
        this._primaryEntity = (MaltegoEntity)this._nodes.get(0).getLookup().lookup(MaltegoEntity.class);
        this.initComponents();
        this._outlineView.getOutline().setRootVisible(false);
        this._outlineView.setPropertyColumns(new String[]{"PrimaryEntity", "<html><center>Primary<br>Entity</center></html>", "maltego.fixed.incominglinks", "<html><center>Incoming<br>Links</center></html>", "maltego.fixed.outgoinglinks", "<html><center>Outgoing<br>Links</center></html>"});
        this._outlineView.setDragSource(false);
        TableColumnModel columns = this._outlineView.getOutline().getColumnModel();
        TableColumn column = columns.getColumn(1);
        column.setMinWidth(20);
        column.setMaxWidth(70);
        column.setPreferredWidth(70);
        column = columns.getColumn(2);
        column.setMinWidth(20);
        column.setMaxWidth(70);
        column.setPreferredWidth(70);
        column = columns.getColumn(3);
        column.setMinWidth(20);
        column.setMaxWidth(70);
        column.setPreferredWidth(70);
        this._outlineView.getOutline().setAutoCreateColumnsFromModel(false);
        this._outlineView.addPropertyChangeListener("columnHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JViewport columnHeader = MergeEntitiesPanel.this._outlineView.getColumnHeader();
                if (columnHeader != null) {
                    columnHeader.setPreferredSize(new Dimension(0, 35));
                }
            }
        });
        AbstractAction emptyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
            }
        };
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", emptyAction);
        map.put("cut-to-clipboard", emptyAction);
        map.put("paste-from-clipboard", emptyAction);
        map.put("delete", emptyAction);
        this._lookup = ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)map);
        this.associateLookup(this._lookup);
        this._childFactory = new MergeChildFactory();
        this._rootNode = new AbstractNode(Children.create((ChildFactory)this._childFactory, (boolean)true));
        this._explorer.setRootContext((Node)this._rootNode);
    }

    public MaltegoEntity getPrimaryEntity() {
        return this._primaryEntity;
    }

    public void setPrimaryEntity(MaltegoEntity entity) {
        this._primaryEntity = entity;
    }

    public boolean isMergeLinks() {
        return this._mergeLinksCheckBox.isSelected();
    }

    public void setMergeLinks(boolean mergeLinks) {
        this._mergeLinksCheckBox.setSelected(mergeLinks);
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    public Lookup getLookup() {
        return this._lookup;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this._explorer, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this._explorer, (boolean)false);
    }

    public int getPersistenceType() {
        return 2;
    }

    private void initComponents() {
        this._outlineView = new OutlineView("Entity");
        this.jTextArea1 = new JTextArea();
        this.jPanel1 = new JPanel();
        this._mergeLinksCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setLayout(new BorderLayout());
        this._outlineView.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.add((Component)this._outlineView, "Center");
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(1);
        this.jTextArea1.setText(NbBundle.getMessage(MergeEntitiesPanel.class, (String)"MergeEntitiesPanel.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.add(this.jTextArea1, "North");
        this.jPanel1.setLayout(new BorderLayout());
        this._mergeLinksCheckBox.setText(NbBundle.getMessage(MergeEntitiesPanel.class, (String)"MergeEntitiesPanel._mergeLinksCheckBox.text"));
        this._mergeLinksCheckBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.jPanel1.add((Component)this._mergeLinksCheckBox, "Center");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont((float)this.jLabel1.getFont().getSize() - 1.0f));
        this.jLabel1.setText(NbBundle.getMessage(MergeEntitiesPanel.class, (String)"MergeEntitiesPanel.jLabel1.text"));
        this.jPanel1.add((Component)this.jLabel1, "East");
        this.add(this.jPanel1, "South");
    }

    private List<Node> createNetBeansNodes(GraphID graphID, Set<EntityID> entities) {
        ArrayList<Node> nbNodes = new ArrayList<Node>();
        BulkQueryEntityCache cache = new BulkQueryEntityCache(graphID, entities);
        for (EntityID entity : entities) {
            nbNodes.add((Node)new EntityNode(graphID, entity, cache));
        }
        return nbNodes;
    }

    private class PrimaryEntityProperty
    extends NodePropertySupport.ReadWrite {
        public static final String NAME = "PrimaryEntity";
        public static final String DISPLAYNAME = "Primary Entity";
        public static final String HTML_DISPLAYNAME = "<html><center>Primary<br>Entity</center></html>";

        public PrimaryEntityProperty(Node node) {
            super(node, NAME, Boolean.TYPE, DISPLAYNAME, "Primary entity selection");
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return ((MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class)).equals(MergeEntitiesPanel.this._primaryEntity);
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Boolean primary;
            if (val instanceof Boolean && (primary = (Boolean)val).booleanValue()) {
                MergeEntitiesPanel.this._primaryEntity = (MaltegoEntity)this.node().getLookup().lookup(MaltegoEntity.class);
            }
        }
    }

    private class MergeFilterNode
    extends GraphFilterNode {
        public MergeFilterNode(Node original) {
            super(original);
        }

        public SystemAction[] getActions() {
            return new SystemAction[0];
        }

        public Node.PropertySet[] getPropertySets() {
            Node.PropertySet[] propertySets = super.getPropertySets();
            ((Sheet.Set)propertySets[0]).put((Node.Property)new PrimaryEntityProperty((Node)this));
            return propertySets;
        }
    }

    private class MergeChildFactory
    extends ChildFactory<Node> {
        private MergeChildFactory() {
        }

        protected boolean createKeys(List<Node> toPopulate) {
            toPopulate.addAll(MergeEntitiesPanel.this._nodes);
            return true;
        }

        protected Node createNodeForKey(Node key) {
            return new MergeFilterNode(key);
        }
    }
}

