/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.merge;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.ui.graph.merge.MergeOptionsController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class MergeUtils {
    public static Map<MaltegoEntity, PartMergeStrategy> promptForEntityMergeStrategies(GraphMerger graphMerger, GraphID destGraphID, GraphID srcGraphID, Set<MaltegoEntity> skipped, AtomicBoolean cancelled) {
        PartMergeStrategy stratRemaining = null;
        boolean skipRemaining = false;
        HashMap<MaltegoEntity, PartMergeStrategy> mergeStrats = new HashMap<MaltegoEntity, PartMergeStrategy>();
        Map matches = graphMerger.getMatches();
        int count = 0;
        for (MaltegoEntity srcEntity : matches.keySet()) {
            ++count;
            MaltegoEntity destEntity = (MaltegoEntity)matches.get(srcEntity);
            PartMergeStrategy strategy = stratRemaining;
            if (skipRemaining) {
                skipped.add(srcEntity);
            } else if (strategy == null) {
                MergeOptionsController controller = new MergeOptionsController(destGraphID, srcGraphID, destEntity, srcEntity, matches.size() - count);
                if (controller.showMergeOptions()) {
                    if (controller.isMergeEntities()) {
                        strategy = controller.getMergeStrategy();
                    } else if (controller.isSkipEntity()) {
                        skipped.add(srcEntity);
                    }
                    if (controller.isDoForAll()) {
                        if (strategy != null) {
                            stratRemaining = strategy;
                        } else {
                            if (!controller.isSkipEntity()) break;
                            skipRemaining = true;
                        }
                    }
                } else {
                    cancelled.set(true);
                    return null;
                }
            }
            if (strategy == null) continue;
            mergeStrats.put(srcEntity, strategy);
        }
        return mergeStrats;
    }
}

