/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class OpenOptionProcessor
extends OptionProcessor {
    private static Option DEFAULT = Option.defaultArguments();
    private static Option OPEN = Option.additionalArguments((char)'o', (String)"open");

    protected Set<Option> getOptions() {
        HashSet<Option> options = new HashSet<Option>();
        options.add(DEFAULT);
        options.add(OPEN);
        return options;
    }

    protected void process(Env env, Map<Option, String[]> maps) throws CommandException {
        ArrayList<File> files = new ArrayList<File>();
        OpenOptionProcessor.addFiles(files, maps.get(DEFAULT));
        OpenOptionProcessor.addFiles(files, maps.get(OPEN));
        UIRunQueue uiRunQ = UIRunQueue.instance();
        uiRunQ.queue(200, () -> OpenOptionProcessor.openFiles(files));
    }

    private static void openFiles(List<File> files) {
        for (File file : files) {
            FileObject obj = FileUtil.toFileObject((File)file);
            if (obj == null) continue;
            try {
                OpenCookie cookie;
                DataObject dao = DataObject.find((FileObject)obj);
                if (dao == null || (cookie = (OpenCookie)dao.getLookup().lookup(OpenCookie.class)) == null) continue;
                cookie.open();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static void addFiles(List<File> files, String[] args) {
        if (args != null) {
            for (String s2 : args) {
                File f = new File(s2);
                if (!f.exists()) continue;
                files.add(f);
            }
        }
    }
}

