/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.ClipboardGraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.ui.graph.GraphCopyHelper;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.ui.graph.clipboard.GraphDataFlavor;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public abstract class GraphCopyCutAction
extends TopGraphEntitySelectionAction {
    private final String _name;
    private final boolean _removeParts;

    public GraphCopyCutAction(String name, boolean removeParts) {
        this._name = name;
        this._removeParts = removeParts;
    }

    public String getName() {
        return this._name;
    }

    @Override
    protected boolean isActionEnabled() {
        return super.isActionEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed() {
        WindowUtil.showWaitCursor();
        try {
            GraphID graphID = this.getTopGraphID();
            Set<EntityID> entityIDs = this.getSelectedModelEntities();
            if (!entityIDs.isEmpty()) {
                boolean proceed = true;
                int count = entityIDs.size();
                if (count > 100000) {
                    String msg = "Are you sure you want to place " + count + " entities on the clipboard?";
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg);
                    nd.setTitle(this._name + " " + count + " entities");
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    proceed = NotifyDescriptor.OK_OPTION.equals(result);
                }
                if (proceed) {
                    this.placeSelectionOnClipboard(entityIDs);
                    if (this._removeParts) {
                        String descriptionStr = "%s " + GraphTransactionHelper.getDescriptionForEntityIDs(graphID, entityIDs, true);
                        SimilarStrings description = new SimilarStrings(descriptionStr, "Cut", "Add");
                        GraphTransactionHelper.doDeleteEntities(description, graphID, entityIDs);
                    }
                }
            } else {
                StatusDisplayer.getDefault().setStatusText("No selection to copy");
            }
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    private void placeSelectionOnClipboard(Set<EntityID> entities) {
        try {
            GraphID clipboardGraphID = ClipboardGraphID.get();
            GraphStore clipboardGraphStore = GraphStoreRegistry.getDefault().forGraphID(clipboardGraphID);
            clipboardGraphStore.open();
            GraphStoreWriter.clear((GraphID)clipboardGraphID);
            GraphCopyHelper.copy(this.getTopGraphID(), entities, clipboardGraphID);
            clipboardGraphStore.close(false);
            ExTransferable.Single t = new ExTransferable.Single(GraphDataFlavor.FLAVOR){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    return new ByteArrayInputStream("1.2".getBytes(StandardCharsets.UTF_8));
                }
            };
            Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
            clipboard.setContents((Transferable)t, null);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

