/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.DateTime;
import java.util.ArrayList;
import java.util.Collection;

public class ModifiedHelper {
    public static final String PROP_USER_CREATED = "maltego.user.created";
    public static final String PROP_DATE_CREATED = "maltego.date.created";
    public static final String PROP_USER_MODIFIED = "maltego.user.modified";
    public static final String PROP_DATE_MODIFIED = "maltego.date.modified";
    private static final String ENTITY = "entity";
    private static final String LINK = "link";
    private static DisplayDescriptor _entityUserCreatedProperty;
    private static DisplayDescriptor _entityUserModifiedProperty;
    private static DisplayDescriptor _entityCreatedProperty;
    private static DisplayDescriptor _entityModifiedProperty;
    private static DisplayDescriptor _linkUserCreatedProperty;
    private static DisplayDescriptor _linkUserModifiedProperty;
    private static DisplayDescriptor _linkCreatedProperty;
    private static DisplayDescriptor _linkModifiedProperty;

    private ModifiedHelper() {
    }

    public static void updateModified(String user, MaltegoPart<? extends Guid> part) {
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty(part);
        if (pd != null) {
            part.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty(part)) != null) {
            part.setValue(pd, (Object)user);
        }
    }

    public static void updateCreated(String user, MaltegoPart<? extends Guid> part) {
        PropertyDescriptor pd = ModifiedHelper.getDateCreatedProperty(part);
        if (pd != null) {
            part.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserCreatedProperty(part)) != null) {
            part.setValue(pd, (Object)user);
        }
    }

    public static void addCreatedAndModifiedIfMissing(MaltegoPart<? extends Guid> part, String user, DateTime dateTime) {
        ModifiedHelper.addCreatedIfMissing(part, user, dateTime);
        ModifiedHelper.addModifiedIfMissing(part, user, dateTime);
    }

    public static void addCreatedIfMissing(MaltegoPart<? extends Guid> part, String user, DateTime created) {
        if (part instanceof MaltegoEntity) {
            ModifiedHelper.addIfMissing(part, ModifiedHelper.getEntityUserCreatedProperty(), user);
            ModifiedHelper.addIfMissing(part, ModifiedHelper.getEntityDateCreatedProperty(), created);
        } else {
            ModifiedHelper.addIfMissing(part, ModifiedHelper.getLinkUserCreatedProperty(), user);
            ModifiedHelper.addIfMissing(part, ModifiedHelper.getLinkDateCreatedProperty(), created);
        }
    }

    public static void addModifiedIfMissing(MaltegoPart<? extends Guid> part, String user, DateTime modified) {
        if (part instanceof MaltegoEntity) {
            ModifiedHelper.addIfMissing(part, ModifiedHelper.getEntityUserModifiedProperty(), user);
            ModifiedHelper.addIfMissing(part, ModifiedHelper.getEntityDateModifiedProperty(), modified);
        } else {
            ModifiedHelper.addIfMissing(part, ModifiedHelper.getLinkUserModifiedProperty(), user);
            ModifiedHelper.addIfMissing(part, ModifiedHelper.getLinkDateModifiedProperty(), modified);
        }
    }

    private static void addIfMissing(MaltegoPart<? extends Guid> part, DisplayDescriptor dd, Object value) {
        PropertyDescriptor pd = part.getProperties().get(dd.getName());
        if (pd == null) {
            part.setValue((PropertyDescriptor)dd, value);
        }
    }

    public static EntityUpdate createUpdate(String user, MaltegoEntity entity) {
        EntityUpdate update = null;
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty((MaltegoPart<? extends Guid>)entity);
        if (pd != null) {
            update = new EntityUpdate(entity);
            update.addProperty(pd);
            update.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty((MaltegoPart<? extends Guid>)entity)) != null) {
            if (update == null) {
                update = new EntityUpdate(entity);
            }
            update.addProperty(pd);
            update.setValue(pd, (Object)user);
        }
        return update;
    }

    public static EntityUpdate createUpdate(String user, GraphID graphID, EntityID entityID) {
        return ModifiedHelper.createUpdate(user, new GraphEntity(graphID, entityID));
    }

    public static EntityUpdate createUpdate(String user, GraphEntity entity) {
        EntityUpdate update = null;
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty((GraphPart<? extends Guid>)entity);
        if (pd != null) {
            update = new EntityUpdate((EntityID)entity.getID(), GraphStoreHelper.getPart((GraphPart)entity).getTypeName());
            update.addProperty(pd);
            update.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty((GraphPart<? extends Guid>)entity)) != null) {
            if (update == null) {
                update = new EntityUpdate((EntityID)entity.getID(), GraphStoreHelper.getPart((GraphPart)entity).getTypeName());
            }
            update.addProperty(pd);
            update.setValue(pd, (Object)user);
        }
        return update;
    }

    public static LinkUpdate createUpdate(String user, MaltegoLink link) {
        LinkUpdate update = null;
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty((MaltegoPart<? extends Guid>)link);
        if (pd != null) {
            update = new LinkUpdate(link);
            update.addProperty(pd);
            update.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty((MaltegoPart<? extends Guid>)link)) != null) {
            if (update == null) {
                update = new LinkUpdate(link);
            }
            update.addProperty(pd);
            update.setValue(pd, (Object)user);
        }
        return update;
    }

    public static LinkUpdate createUpdate(String user, GraphID graphID, LinkID linkID) {
        return ModifiedHelper.createUpdate(user, new GraphLink(graphID, linkID));
    }

    public static LinkUpdate createUpdate(String user, GraphLink link) {
        LinkUpdate update = null;
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty((GraphPart<? extends Guid>)link);
        if (pd != null) {
            update = new LinkUpdate((LinkID)link.getID(), GraphStoreHelper.getPart((GraphPart)link).getTypeName());
            update.addProperty(pd);
            update.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty((GraphPart<? extends Guid>)link)) != null) {
            if (update == null) {
                update = new LinkUpdate((LinkID)link.getID(), GraphStoreHelper.getPart((GraphPart)link).getTypeName());
            }
            update.addProperty(pd);
            update.setValue(pd, (Object)user);
        }
        return update;
    }

    public static void addToUpdate(String user, MaltegoEntity entity, EntityUpdate update) {
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty((MaltegoPart<? extends Guid>)entity);
        if (pd != null) {
            update.addProperty(pd);
            update.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty((MaltegoPart<? extends Guid>)entity)) != null) {
            update.addProperty(pd);
            update.setValue(pd, (Object)user);
        }
    }

    public static void addToUpdate(String user, GraphEntity entity, EntityUpdate update) {
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty((GraphPart<? extends Guid>)entity);
        if (pd != null) {
            update.addProperty(pd);
            update.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty((GraphPart<? extends Guid>)entity)) != null) {
            update.addProperty(pd);
            update.setValue(pd, (Object)user);
        }
    }

    public static void addToUpdate(String user, MaltegoLink link, LinkUpdate update) {
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty((MaltegoPart<? extends Guid>)link);
        if (pd != null) {
            update.addProperty(pd);
            update.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty((MaltegoPart<? extends Guid>)link)) != null) {
            update.addProperty(pd);
            update.setValue(pd, (Object)user);
        }
    }

    public static void addToUpdate(String user, GraphLink link, LinkUpdate update) {
        PropertyDescriptor pd = ModifiedHelper.getDateModifiedProperty((GraphPart<? extends Guid>)link);
        if (pd != null) {
            update.addProperty(pd);
            update.setValue(pd, (Object)new DateTime());
        }
        if ((pd = ModifiedHelper.getUserModifiedProperty((GraphPart<? extends Guid>)link)) != null) {
            update.addProperty(pd);
            update.setValue(pd, (Object)user);
        }
    }

    public static Collection<EntityUpdate> createEntityUpdates(String user, Collection<MaltegoEntity> entities) {
        ArrayList<EntityUpdate> updates = new ArrayList<EntityUpdate>();
        for (MaltegoEntity entity : entities) {
            EntityUpdate update = ModifiedHelper.createUpdate(user, entity);
            if (update == null) continue;
            updates.add(update);
        }
        return updates;
    }

    public static Collection<EntityUpdate> createGraphEntityUpdates(String user, Collection<GraphEntity> entities) {
        ArrayList<EntityUpdate> updates = new ArrayList<EntityUpdate>();
        for (GraphEntity entity : entities) {
            EntityUpdate update = ModifiedHelper.createUpdate(user, entity);
            if (update == null) continue;
            updates.add(update);
        }
        return updates;
    }

    public static Collection<LinkUpdate> createLinkUpdates(String user, Collection<MaltegoLink> links) {
        ArrayList<LinkUpdate> updates = new ArrayList<LinkUpdate>();
        for (MaltegoLink link : links) {
            LinkUpdate update = ModifiedHelper.createUpdate(user, link);
            if (update == null) continue;
            updates.add(update);
        }
        return updates;
    }

    public static Collection<LinkUpdate> createGraphLinkUpdates(String user, Collection<GraphLink> links) {
        ArrayList<LinkUpdate> updates = new ArrayList<LinkUpdate>();
        for (GraphLink link : links) {
            LinkUpdate update = ModifiedHelper.createUpdate(user, link);
            if (update == null) continue;
            updates.add(update);
        }
        return updates;
    }

    private static PropertyDescriptor getUserCreatedProperty(MaltegoPart<? extends Guid> part) {
        return part.getProperties().get(PROP_USER_CREATED);
    }

    private static PropertyDescriptor getDateCreatedProperty(MaltegoPart<? extends Guid> part) {
        return part.getProperties().get(PROP_DATE_CREATED);
    }

    private static PropertyDescriptor getUserModifiedProperty(MaltegoPart<? extends Guid> part) {
        return part.getProperties().get(PROP_USER_MODIFIED);
    }

    private static PropertyDescriptor getDateModifiedProperty(MaltegoPart<? extends Guid> part) {
        return part.getProperties().get(PROP_DATE_MODIFIED);
    }

    private static PropertyDescriptor getUserCreatedProperty(GraphPart<? extends Guid> part) {
        return GraphStoreHelper.getPart(part).getProperties().get(PROP_USER_CREATED);
    }

    private static PropertyDescriptor getDateCreatedProperty(GraphPart<? extends Guid> part) {
        return GraphStoreHelper.getPart(part).getProperties().get(PROP_DATE_CREATED);
    }

    private static PropertyDescriptor getUserModifiedProperty(GraphPart<? extends Guid> part) {
        return GraphStoreHelper.getPart(part).getProperties().get(PROP_USER_MODIFIED);
    }

    private static PropertyDescriptor getDateModifiedProperty(GraphPart<? extends Guid> part) {
        return GraphStoreHelper.getPart(part).getProperties().get(PROP_DATE_MODIFIED);
    }

    public static synchronized DisplayDescriptor getEntityUserCreatedProperty() {
        if (_entityUserCreatedProperty == null) {
            _entityUserCreatedProperty = ModifiedHelper.createUserCreatedProperty(ENTITY);
        }
        return _entityUserCreatedProperty;
    }

    public static synchronized DisplayDescriptor getLinkUserCreatedProperty() {
        if (_linkUserCreatedProperty == null) {
            _linkUserCreatedProperty = ModifiedHelper.createUserCreatedProperty(LINK);
        }
        return _linkUserCreatedProperty;
    }

    public static synchronized DisplayDescriptor getEntityUserModifiedProperty() {
        if (_entityUserModifiedProperty == null) {
            _entityUserModifiedProperty = ModifiedHelper.createUserModifiedProperty(ENTITY);
        }
        return _entityUserModifiedProperty;
    }

    public static synchronized DisplayDescriptor getLinkUserModifiedProperty() {
        if (_linkUserModifiedProperty == null) {
            _linkUserModifiedProperty = ModifiedHelper.createUserModifiedProperty(LINK);
        }
        return _linkUserModifiedProperty;
    }

    public static synchronized DisplayDescriptor getEntityDateCreatedProperty() {
        if (_entityCreatedProperty == null) {
            _entityCreatedProperty = ModifiedHelper.createDateCreatedProperty(ENTITY);
        }
        return _entityCreatedProperty;
    }

    public static synchronized DisplayDescriptor getLinkDateCreatedProperty() {
        if (_linkCreatedProperty == null) {
            _linkCreatedProperty = ModifiedHelper.createDateCreatedProperty(LINK);
        }
        return _linkCreatedProperty;
    }

    public static synchronized DisplayDescriptor getEntityDateModifiedProperty() {
        if (_entityModifiedProperty == null) {
            _entityModifiedProperty = ModifiedHelper.createDateModifiedProperty(ENTITY);
        }
        return _entityModifiedProperty;
    }

    public static synchronized DisplayDescriptor getLinkDateModifiedProperty() {
        if (_linkModifiedProperty == null) {
            _linkModifiedProperty = ModifiedHelper.createDateModifiedProperty(LINK);
        }
        return _linkModifiedProperty;
    }

    private static DisplayDescriptor createUserCreatedProperty(String part) {
        DisplayDescriptor dd = new DisplayDescriptor(String.class, PROP_USER_CREATED, "Created by");
        dd.setDescription(String.format("The user who created this %s", part));
        dd.setReadonly(true);
        return dd;
    }

    private static DisplayDescriptor createUserModifiedProperty(String part) {
        DisplayDescriptor dd = new DisplayDescriptor(String.class, PROP_USER_MODIFIED, "Modified by");
        dd.setDescription(String.format("The user who modified this %s last", part));
        dd.setReadonly(true);
        return dd;
    }

    private static DisplayDescriptor createDateCreatedProperty(String part) {
        DisplayDescriptor dd = new DisplayDescriptor(DateTime.class, PROP_DATE_CREATED, "Date created");
        dd.setDescription(String.format("When this %s was created", part));
        dd.setReadonly(true);
        return dd;
    }

    private static DisplayDescriptor createDateModifiedProperty(String part) {
        DisplayDescriptor dd = new DisplayDescriptor(DateTime.class, PROP_DATE_MODIFIED, "Date modified");
        dd.setDescription(String.format("When this %s was last modified", part));
        dd.setReadonly(true);
        return dd;
    }
}

