/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateTime {
    private static final Logger LOG = Logger.getLogger(DateTime.class.getName());
    public static final String DATETIME_TIME_FORMAT_STRING = "HH:mm:ss.S";
    private Date _date;

    public DateTime() {
        this._date = new Date();
    }

    public DateTime(Date date) {
        this._date = date;
    }

    public DateTime(long ticks) {
        this(new Date(ticks));
    }

    public Date getDate() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public long getTime() {
        return this._date.getTime();
    }

    public String toString() {
        return DateTime.getDefaultFormat().format(this._date);
    }

    public static SimpleDateFormat getDefaultFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z");
    }

    public static DateTime parse(String text) {
        Date date = null;
        try {
            date = DateTime.getDefaultFormat().parse(text);
        }
        catch (ParseException ex) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
            try {
                date = df.parse(text);
            }
            catch (ParseException ex1) {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                try {
                    date = df.parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (date == null) {
            try {
                long millis = Long.parseLong(text);
                date = new Date(millis);
            }
            catch (Exception millis) {
                // empty catch block
            }
        }
        if (date == null) {
            LOG.log(Level.WARNING, "Could not convert string '{0}' to DateTime", text);
        }
        DateTime dateTime = null;
        if (date != null) {
            dateTime = new DateTime(date);
        }
        return dateTime;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this._date != null ? this._date.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTime other = (DateTime)obj;
        return this._date == other._date || this._date != null && this._date.equals(other._date);
    }
}

