/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import com.paterva.maltego.typing.types.DateRangePresets;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.FixedDateRange;
import com.paterva.maltego.typing.types.PresetsRelative;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.openide.util.Exceptions;

public class DateRange {
    private static final SimpleDateFormat TO_STRING_SDF = DateTime.getDefaultFormat();
    private static final SimpleDateFormat TO_DISPLAY_STRING_SDF = new SimpleDateFormat("ddMMM''yy HH:mm:ss zzz");
    private static final String DATE_TIME_RANGE_PREFIX_OLD = "From ";
    private static final String DATE_TIME_RANGE_PREFIX = "\u23f0 ";
    private static final String DATE_TIME_RANGE_DIVIDER_OLD = " to ";
    private static final String DATE_TIME_RANGE_DIVIDER = " \u279c ";
    private FixedDateRange _fixedDateRange;
    private PresetsRelative _presetRelativeItem = null;
    private boolean _isRelativeDateRange = false;

    public DateRange() {
        this(PresetsRelative.PRESETS_SINCE_UNIX_EPOCH_TIME);
    }

    public DateRange(long fromTicks, long toTicks) {
        this(new Date(fromTicks), new Date(toTicks));
    }

    public DateRange(Date fromDate, Date toDate) {
        this(new FixedDateRange(fromDate, toDate));
    }

    public DateRange(DateTime fromDate, DateTime toDate) {
        this(new FixedDateRange(fromDate, toDate));
    }

    public DateRange(FixedDateRange fixedDateRange) {
        this(fixedDateRange, PresetsRelative.PRESETS_SINCE_UNIX_EPOCH_TIME, false);
    }

    public DateRange(PresetsRelative presetRelativeItem) {
        this(DateRangePresets.getPresetDateRange(presetRelativeItem), presetRelativeItem, true);
    }

    public DateRange(Date fromDate, Date toDate, PresetsRelative presetRelativeItem, boolean isRelative) {
        this(new FixedDateRange(fromDate, toDate), presetRelativeItem, isRelative);
    }

    public DateRange(DateTime fromDate, DateTime toDate, PresetsRelative presetRelativeItem, boolean isRelative) {
        this(new FixedDateRange(fromDate, toDate), presetRelativeItem, isRelative);
    }

    public DateRange(FixedDateRange fixedDateRange, PresetsRelative presetRelativeItem, boolean isRelative) {
        this._fixedDateRange = fixedDateRange;
        this._presetRelativeItem = presetRelativeItem;
        this._isRelativeDateRange = isRelative;
    }

    public static DateRange createCopy(DateRange in) {
        if (in == null) {
            throw new IllegalArgumentException("DateRange.createCopy: input DateRange may not be null");
        }
        DateRange out = new DateRange(in.getFromDate(), in.getToDate(), in.getRelativeItem(), in.isRelative());
        return out;
    }

    public boolean isValidRange() {
        boolean isValidRange = true;
        if (!this.isRelative()) {
            isValidRange = this.getFromDate().getDate().before(this.getToDate().getDate());
        }
        return isValidRange;
    }

    public FixedDateRange getFixedDateRange() {
        return this._fixedDateRange;
    }

    public boolean isRelative() {
        return this._isRelativeDateRange;
    }

    public PresetsRelative getRelativeItem() {
        return this._presetRelativeItem;
    }

    public DateTime getFromDate() {
        return this._fixedDateRange.getFromDate();
    }

    public long getFromTime() {
        return this.getFromDate().getTime();
    }

    public DateTime getToDate() {
        return this._fixedDateRange.getToDate();
    }

    public long getToTime() {
        return this.getToDate().getTime();
    }

    public String toString() {
        return this.toStringHandler(TO_STRING_SDF);
    }

    public String toDisplayString() {
        return this.toStringHandler(TO_DISPLAY_STRING_SDF);
    }

    private synchronized String toStringHandler(SimpleDateFormat sdf) {
        if (this.isRelative()) {
            return this.getRelativeItem().getDisplayValue();
        }
        return DATE_TIME_RANGE_PREFIX + sdf.format(this.getFromDate().getDate()) + DATE_TIME_RANGE_DIVIDER + sdf.format(this.getToDate().getDate());
    }

    public static DateRange parse(String text) {
        DateRange dateTimeRange = null;
        if (text != null) {
            text = text.trim();
            boolean isRelative = false;
            for (PresetsRelative presetRelative : PresetsRelative.values()) {
                if (!presetRelative.getDisplayValue().equals(text)) continue;
                isRelative = true;
                dateTimeRange = new DateRange(presetRelative);
                break;
            }
            if (!isRelative && text.startsWith(DATE_TIME_RANGE_PREFIX) && text.contains(DATE_TIME_RANGE_DIVIDER)) {
                dateTimeRange = DateRange.getFixedDateTimeRange(text, DATE_TIME_RANGE_PREFIX, DATE_TIME_RANGE_DIVIDER);
            } else if (!isRelative && text.startsWith(DATE_TIME_RANGE_PREFIX_OLD) && text.contains(DATE_TIME_RANGE_DIVIDER_OLD)) {
                dateTimeRange = DateRange.getFixedDateTimeRange(text, DATE_TIME_RANGE_PREFIX_OLD, DATE_TIME_RANGE_DIVIDER_OLD);
            }
        }
        return dateTimeRange;
    }

    private static DateRange getFixedDateTimeRange(String text, String prefix, String divider) {
        DateRange dateTimeRange = null;
        try {
            Date toDate;
            int dividerIndex = text.indexOf(divider);
            String fromString = text.substring(prefix.length(), dividerIndex).trim();
            DateTime fromDateTime = DateTime.parse(fromString);
            Date fromDate = fromDateTime == null ? null : fromDateTime.getDate();
            String toString = text.substring(dividerIndex + divider.length()).trim();
            DateTime toDateTime = DateTime.parse(toString);
            Date date = toDate = toDateTime == null ? null : toDateTime.getDate();
            if (fromDate != null && toDate != null) {
                dateTimeRange = new DateRange(fromDate, toDate);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return dateTimeRange;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this._fixedDateRange);
        hash = 97 * hash + Objects.hashCode((Object)this._presetRelativeItem);
        hash = 97 * hash + (this._isRelativeDateRange ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateRange other = (DateRange)obj;
        if (this.isRelative() != other.isRelative()) {
            return false;
        }
        return !(this.isRelative() ? this._presetRelativeItem != other._presetRelativeItem && (this._presetRelativeItem == null || !this._presetRelativeItem.equals((Object)other._presetRelativeItem)) : this._fixedDateRange != other._fixedDateRange && (this._fixedDateRange == null || !this._fixedDateRange.equals(other._fixedDateRange)));
    }

    public boolean isCopyEquals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateRange other = (DateRange)obj;
        if (!Objects.equals(this._fixedDateRange, other._fixedDateRange)) {
            return false;
        }
        if (!Objects.equals((Object)this._presetRelativeItem, (Object)other._presetRelativeItem)) {
            return false;
        }
        return this.isRelative() == other.isRelative();
    }
}

