/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.convert.ColorStringConverter;
import com.paterva.maltego.typing.convert.DateRangeConverter;
import com.paterva.maltego.typing.convert.DateStringConverter;
import com.paterva.maltego.typing.convert.DateTimeStringConverter;
import com.paterva.maltego.typing.convert.FastURLStringConverter;
import com.paterva.maltego.typing.convert.ImageURLStringConverter;
import com.paterva.maltego.typing.convert.StringConverter;
import com.paterva.maltego.typing.convert.TimeSpanStringConverter;
import com.paterva.maltego.typing.formatting.BooleanFormatAdapter;
import com.paterva.maltego.typing.formatting.SimpleDateFormatAdapter;
import com.paterva.maltego.typing.formatting.TimeSpanFormatAdapter;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.InternalFile;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.util.FastURL;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypeRegistry {
    private static TypeRegistry _default;
    private final Map<String, TypeDescriptor> _nameMap = new LinkedHashMap<String, TypeDescriptor>();
    private final Map<Class, TypeDescriptor> _classMap = new LinkedHashMap<Class, TypeDescriptor>();

    public static TypeRegistry getDefault() {
        if (_default == null) {
            _default = new TypeRegistry();
            TypeRegistry.registerDefaults(_default);
        }
        return _default;
    }

    private TypeRegistry() {
    }

    public void registerType(TypeDescriptor descriptor) {
        this._nameMap.put(descriptor.getTypeName(), descriptor);
        this._classMap.put(descriptor.getType(), descriptor);
    }

    public void deregisterType(String typeName) {
        TypeDescriptor td = this._nameMap.get(typeName);
        if (td != null) {
            this._classMap.remove(td.getType());
        }
    }

    public void deregisterType(Class type) {
        TypeDescriptor td = this._classMap.get(type);
        if (td != null) {
            this._nameMap.remove(td.getTypeName());
        }
    }

    public TypeDescriptor getType(String typeName) {
        return this._nameMap.get(typeName);
    }

    public TypeDescriptor getType(Class type) {
        return this._classMap.get(type);
    }

    public TypeDescriptor[] getTypes() {
        Collection<TypeDescriptor> values = this._nameMap.values();
        return values.toArray(new TypeDescriptor[values.size()]);
    }

    public void registerType(String typeName, Class clazz) {
        this.registerType(new TypeDescriptor(typeName, clazz));
    }

    public void registerType(String typeName, Class clazz, StringConverter converter) {
        this.registerType(new TypeDescriptor(typeName, clazz, converter));
    }

    public void registerType(String typeName, Class clazz, StringConverter converter, Object defaultValue) {
        this.registerType(new TypeDescriptor(typeName, clazz, converter, defaultValue));
    }

    public void registerType(String typeName, Class clazz, Object defaultValue) {
        this.registerType(new TypeDescriptor(typeName, clazz, defaultValue));
    }

    public static void registerDefaults(TypeRegistry registry) {
        registry.registerType("string", String.class, "");
        registry.registerType("char", Character.TYPE, Character.valueOf('0'));
        registry.registerType("int", Integer.TYPE, 0);
        registry.registerType("double", Double.TYPE, 0.0);
        registry.registerType("float", Float.TYPE, Float.valueOf(0.0f));
        registry.registerType("byte", Byte.TYPE, (byte)0);
        TypeDescriptor dateDescriptor = new TypeDescriptor("date", Date.class, new DateStringConverter(), null);
        dateDescriptor.setFormatAdapter(new SimpleDateFormatAdapter());
        registry.registerType(dateDescriptor);
        TypeDescriptor booleanDescriptor = new TypeDescriptor("boolean", Boolean.TYPE, false);
        booleanDescriptor.setFormatAdapter(new BooleanFormatAdapter());
        registry.registerType(booleanDescriptor);
        registry.registerType("file", File.class, null);
        registry.registerType("image", Image.class, new ImageURLStringConverter(), null);
        registry.registerType("url", FastURL.class, new FastURLStringConverter());
        registry.registerType("color", Color.class, new ColorStringConverter(), null);
        registry.registerType("attachments", Attachments.class, null);
        registry.registerType("internalfile", InternalFile.class, null);
        TypeDescriptor dateTimeDescriptor = new TypeDescriptor("datetime", DateTime.class, new DateTimeStringConverter(), null);
        dateTimeDescriptor.setFormatAdapter(new SimpleDateFormatAdapter());
        registry.registerType(dateTimeDescriptor);
        TypeDescriptor dateRangeDescriptor = new TypeDescriptor("daterange", DateRange.class, new DateRangeConverter(), null);
        dateRangeDescriptor.setFormatAdapter(new SimpleDateFormatAdapter());
        registry.registerType(dateRangeDescriptor);
        TypeDescriptor timeDescriptor = new TypeDescriptor("timespan", TimeSpan.class, new TimeSpanStringConverter(), null);
        timeDescriptor.setFormatAdapter(new TimeSpanFormatAdapter());
        registry.registerType(timeDescriptor);
        registry.registerType("int[]", int[].class, new int[0]);
        registry.registerType("string[]", String[].class, new String[0]);
        registry.registerType("boolean[]", boolean[].class, new boolean[0]);
        registry.registerType("double[]", double[].class, new double[0]);
        registry.registerType("float[]", float[].class, new float[0]);
        TypeDescriptor booleanArrayDescriptor = new TypeDescriptor("boolean[]", boolean[].class, new boolean[0]);
        booleanArrayDescriptor.setFormatAdapter(booleanDescriptor.getFormatAdapter());
        registry.registerType(booleanArrayDescriptor);
        TypeDescriptor dateArrayDescriptor = new TypeDescriptor("date[]", Date[].class, new Date[0]);
        dateArrayDescriptor.setFormatAdapter(dateDescriptor.getFormatAdapter());
        registry.registerType(dateArrayDescriptor);
    }

    public static String getDefaultDateFormat() {
        return "yyyy-MM-dd";
    }
}

