/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.EditorDescriptor;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.HighlightStyle;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.ValidationDescriptor;
import java.text.Format;
import java.util.List;
import java.util.Objects;

public class DisplayDescriptor
extends PropertyDescriptor {
    private int _sortOrder;
    private boolean _popup;
    private HighlightStyle _highlight;
    private String _description = "";
    private Object _defaultValue;
    private Object _sampleValue;
    private String _groupName;
    private Format _format;
    private Evaluator _evaluator;
    private ValidationDescriptor _validator;
    private EditorDescriptor _editor;
    private TypeDescriptor _typeDescriptor;

    public DisplayDescriptor(Class type, String name) {
        this(type, name, name);
    }

    public DisplayDescriptor(Class type, String name, String displayName) {
        super(type, name, displayName);
        TypeDescriptor typeDescr = TypeRegistry.getDefault().getType(type);
        if (typeDescr != null) {
            this._defaultValue = typeDescr.getDefaultValue();
            this._sampleValue = typeDescr.getDefaultValue();
        }
    }

    public DisplayDescriptor(PropertyDescriptor descriptor) {
        super(descriptor);
    }

    public DisplayDescriptor(DisplayDescriptor descriptor) {
        this((PropertyDescriptor)descriptor);
        this._defaultValue = descriptor.getDefaultValue();
        this._sampleValue = descriptor.getSampleValue();
        this._editor = descriptor.getEditor();
        this._sortOrder = descriptor.getSortOrder();
        this._description = descriptor.getDescription();
        this._popup = descriptor.isPopup();
        this._highlight = descriptor.getHighlight();
        this._typeDescriptor = descriptor.getTypeDescriptor();
        this._groupName = descriptor.getGroupName();
        this._evaluator = descriptor.getEvaluator();
        this._format = descriptor.getFormat();
        this._validator = descriptor.getValidator();
    }

    public TypeDescriptor getTypeDescriptor() {
        if (this._typeDescriptor == null) {
            this._typeDescriptor = TypeRegistry.getDefault().getType(this.getType());
        }
        return this._typeDescriptor;
    }

    public Object getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        TypeDescriptor td;
        if (defaultValue == null && (td = this.getTypeDescriptor()) != null && td.getDefaultValue() != null) {
            defaultValue = td.getDefaultValue();
        }
        this._defaultValue = defaultValue;
    }

    public Object getSampleValue() {
        return this._sampleValue;
    }

    public void setSampleValue(Object sampleValue) {
        this._sampleValue = sampleValue;
    }

    public ValidationDescriptor getValidator() {
        return this._validator;
    }

    public void setValidator(ValidationDescriptor validator) {
        this._validator = validator;
    }

    public EditorDescriptor getEditor() {
        return this._editor;
    }

    public void setEditor(EditorDescriptor editor) {
        this._editor = editor;
    }

    public int getSortOrder() {
        return this._sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this._sortOrder = sortOrder;
    }

    public boolean isPopup() {
        return this._popup;
    }

    public void setPopup(boolean popup) {
        this._popup = popup;
    }

    public HighlightStyle getHighlight() {
        return this._highlight;
    }

    public void setHighlight(HighlightStyle highlight) {
        this._highlight = highlight;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description == null ? "" : description;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    public Format getFormat() {
        return this._format;
    }

    public void setFormat(Format format) {
        this._format = format;
    }

    public void setEvaluator(Evaluator evaluator) {
        this._evaluator = evaluator;
    }

    public Evaluator getEvaluator() {
        return this._evaluator;
    }

    @Override
    public List<PropertyDescriptor> getLinkedProperties() {
        Evaluator evaluator = this.getEvaluator();
        Object defaultValue = this.getDefaultValue();
        if (evaluator != null && defaultValue instanceof String) {
            return evaluator.getLinkedProperties((String)defaultValue);
        }
        return super.getLinkedProperties();
    }

    @Override
    protected Object evaluate(Object oldValue, DataSource inputs) {
        Evaluator evaluator = this.getEvaluator();
        Object defaultValue = this.getDefaultValue();
        if (evaluator != null && defaultValue instanceof String) {
            return evaluator.evaluate((String)defaultValue, inputs);
        }
        return super.evaluate(oldValue, inputs);
    }

    @Override
    public boolean deepEquals(PropertyDescriptor other) {
        if (!(other instanceof DisplayDescriptor)) {
            return false;
        }
        DisplayDescriptor that = (DisplayDescriptor)other;
        return super.deepEquals(that) && Objects.equals(this._typeDescriptor, that._typeDescriptor) && Objects.equals(this._description, that._description) && Objects.equals(this._sampleValue, that._sampleValue) && Objects.equals(this._defaultValue, that._defaultValue) && Objects.equals(this._groupName, that._groupName);
    }
}

