/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub.item.custom;

import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedIcon;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.ui.hub.item.custom.SeedAddEditController;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Random;
import javax.swing.ImageIcon;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;

public class CustomSeedHelper {
    public static void addSeed() {
        String title = "Add Transform Seed";
        HubSeedDescriptor seed = new HubSeedDescriptor();
        seed.setName("mytransforms" + new Random().nextInt(10000));
        seed.setDisplayName("My Transforms");
        seed.setUrl(new HubSeedUrl(""));
        CustomSeedHelper.addEditSeed(seed, title, true);
    }

    public static void editSeed(HubSeedDescriptor seed) {
        String title = "Edit Transform Seed";
        CustomSeedHelper.addEditSeed(seed, title, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEditSeed(HubSeedDescriptor seed, String title, boolean isAdd) {
        boolean valid;
        String seedName = seed.getName();
        SeedAddEditController controller = new SeedAddEditController();
        EditDialogDescriptor dd = new EditDialogDescriptor(title, (WizardDescriptor.Panel)controller);
        dd.putProperty("name", (Object)seedName);
        dd.putProperty("displayname", (Object)seed.getDisplayName());
        HubSeedUrl hubSeedUrl = seed.getHubSeedUrl();
        String oldSeedUrl = null;
        if (hubSeedUrl != null) {
            oldSeedUrl = hubSeedUrl.getUrl();
            dd.putProperty("seedurl", (Object)oldSeedUrl);
        }
        dd.putProperty("description", (Object)seed.getDescription());
        dd.putProperty("details", (Object)seed.getDetails());
        HubSeedIcon icon = seed.getIcon();
        if (icon != null) {
            dd.putProperty("iconurl", (Object)icon.getUrl());
        }
        boolean canceled = false;
        do {
            valid = true;
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == EditDialogDescriptor.OK_OPTION) {
                String error = CustomSeedHelper.getError(dd, seed);
                if (error == null) continue;
                CustomSeedHelper.showError(title, error);
                valid = false;
                continue;
            }
            canceled = true;
        } while (!canceled && !valid);
        if (!canceled) {
            try {
                boolean uninstallTransforms;
                WindowUtil.showWaitCursor();
                String name = (String)dd.getProperty("name");
                String displayName = (String)dd.getProperty("displayname");
                String seedUrl = (String)dd.getProperty("seedurl");
                String iconUrl = (String)dd.getProperty("iconurl");
                String description = (String)dd.getProperty("description");
                String details = (String)dd.getProperty("details");
                HubSeedRegistry registry = HubSeedRegistry.getDefault();
                boolean bl = uninstallTransforms = !name.equals(seedName) || !seedUrl.equals(oldSeedUrl);
                if (!isAdd) {
                    registry.removeSeed(seed, uninstallTransforms);
                }
                seed.setCustom(true);
                seed.setPos(Integer.MAX_VALUE);
                seed.setName(name);
                seed.setDisplayName(displayName);
                hubSeedUrl = seed.getHubSeedUrl();
                if (hubSeedUrl == null) {
                    hubSeedUrl = new HubSeedUrl(seedUrl);
                } else {
                    hubSeedUrl.setUrl(seedUrl);
                }
                seed.setUrl(hubSeedUrl);
                seed.setDescription(description);
                seed.setDetails(details);
                if (!StringUtilities.isNullOrEmpty((String)iconUrl)) {
                    HubSeedIcon seedIcon = new HubSeedIcon();
                    seedIcon.setUrl(iconUrl);
                    seed.setIcon(seedIcon);
                }
                seed.setModified(new Date().getTime());
                registry.addSeed(seed);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getError(EditDialogDescriptor dd, HubSeedDescriptor oldSeed) {
        WindowUtil.showWaitCursor();
        try {
            String name = (String)dd.getProperty("name");
            String seedUrl = (String)dd.getProperty("seedurl");
            String iconUrl = (String)dd.getProperty("iconurl");
            if (!CustomSeedHelper.isValidUrl(seedUrl)) {
                String string = "The entered Seed URL is invalid.";
                return string;
            }
            HubSeedDescriptor seed = HubSeedRegistry.getDefault().getSeeds(false).getSeedForName(name);
            if (seed != null && !seed.equals((Object)oldSeed)) {
                String string = "The seed already exists as:\n\n" + seed.getDisplayName();
                return string;
            }
            seed = HubSeedRegistry.getDefault().getSeeds(false).getSeedForUrl(seedUrl);
            if (seed != null && !seed.equals((Object)oldSeed)) {
                String string = "The following seed is already added with the specified Seed URL:\n\n" + seed.getDisplayName();
                return string;
            }
            if (!StringUtilities.isNullOrEmpty((String)iconUrl)) {
                if (!CustomSeedHelper.isValidUrl(iconUrl)) {
                    String string = "The entered Icon URL is invalid.";
                    return string;
                }
                ImageIcon icon = ImageFactory.getDefault().getImageIcon((Object)iconUrl, HubSeedIcon.SIZE, HubSeedIcon.SIZE);
                if (icon == null) {
                    String string = "The entered Icon URL does not point to a valid icon.";
                    return string;
                }
            }
            if (!A.A((String)seedUrl)) {
                String string = "Only seeds from the paterva.com domain may be added in the free version of Maltego.";
                return string;
            }
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
        return null;
    }

    private static void showError(String title, String error) {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)error, 2);
        nd.setTitle(title);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private static boolean isValidUrl(String url) {
        try {
            URL uRL = new URL(url);
        }
        catch (MalformedURLException ex) {
            return false;
        }
        return true;
    }
}

