/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui;

import com.paterva.maltego.licensing.ApiKeyProvider;
import com.paterva.maltego.licensing.rest.A;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubProvider;
import com.paterva.maltego.seeds.api.serialize.HubSeedReader;
import com.paterva.maltego.seeds.api.test.TestHubXml;
import com.paterva.maltego.util.NormalException;
import java.io.IOException;
import java.util.logging.Logger;

public class LicenseModeHubProvider
extends HubProvider {
    private static final Logger LOG = Logger.getLogger(LicenseModeHubProvider.class.getName());

    public HubSeeds getHubSeeds() {
        LOG.info("Loading Hub");
        return ApiKeyProvider.get().map(apiKey -> {
            HubSeeds hubSeeds = null;
            try {
                String hubXml = TestHubXml.isEnabled() ? TestHubXml.loadXml() : A.E((String)apiKey);
                LOG.fine(hubXml);
                HubSeedReader reader = new HubSeedReader();
                hubSeeds = reader.read(hubXml);
                for (HubSeedDescriptor seed : hubSeeds.getSeeds()) {
                    if (seed.getName() == null) {
                        throw new IOException("Seed must have a unique name. Display name: " + seed.getDisplayName());
                    }
                    if (seed.getHubSeedUrl() != null || seed.getRestrictionReason() != null) continue;
                    throw new IOException("Seed must have either a URL or a restriction reason. Display name: " + seed.getDisplayName());
                }
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
            return hubSeeds;
        }).orElse(null);
    }
}

