/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformServerAuthentication;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.ProgressCallback;
import com.paterva.maltego.transform.discovery.TransformFinder;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerListingProvider;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.protocol.v2api.EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.v2api.TransformTranslator;
import com.paterva.maltego.transform.protocol.v2api.V2TransformSetRepository;
import com.paterva.maltego.transform.protocol.v2api.V2TransformSource;
import com.paterva.maltego.transform.protocol.v2api.WebServiceTranslator;
import com.paterva.maltego.transform.protocol.v2api.api.DiscoveryResult;
import com.paterva.maltego.transform.protocol.v2api.api.DiscoveryServer;
import com.paterva.maltego.transform.protocol.v2api.api.DiscoveryStrategy;
import com.paterva.maltego.transform.protocol.v2api.api.OAuthAuthenticatorInfo;
import com.paterva.maltego.transform.protocol.v2api.api.ProgressListener;
import com.paterva.maltego.transform.protocol.v2api.api.TransformApplicationDescriptor;
import com.paterva.maltego.transform.protocol.v2api.api.TransformInfo;
import com.paterva.maltego.transform.protocol.v2api.api.TransformListInfo;
import com.paterva.maltego.transform.protocol.v2api.api.TransformSource;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.NamedThreadFactory;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.SlownessDetector;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class V2TransformFinder
extends TransformFinder {
    private static final Logger LOG = Logger.getLogger(V2TransformFinder.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerReference> findServers(TransformSeed[] seeds, ProgressCallback cb) throws DiscoveryException {
        DiscoveryStrategy strategy = new DiscoveryStrategy();
        V2TransformSource source = new V2TransformSource();
        ProgressListener adapter = event -> {
            if (cb != null) {
                cb.progress(event.getMessage());
            }
        };
        strategy.addProgressListener(adapter);
        try {
            DiscoveryResult result = strategy.doDiscovery((TransformSource)source, V2TransformFinder.translate(seeds));
            com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerReference> discoveryResult = V2TransformFinder.translate(result);
            return discoveryResult;
        }
        finally {
            strategy.removeProgressListener(adapter);
        }
    }

    private static com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerReference> translate(DiscoveryResult result) {
        ArrayList<TransformServerDetail> list = new ArrayList<TransformServerDetail>();
        for (TransformApplicationDescriptor app : result.getApplications()) {
            try {
                FastURL url = new FastURL(app.getUrl());
                url.getURL();
                TransformServerDetail server = new TransformServerDetail(app.getSeedUrl(), url, app.getName(), ProtocolVersion.V2_0);
                if (app.requiresKey()) {
                    server.setAuthentication(TransformServerAuthentication.License);
                } else {
                    server.setAuthentication(TransformServerAuthentication.MAC);
                }
                server.setOverwriteConfig(app.isOverwriteConfig());
                list.add(server);
            }
            catch (MalformedURLException ex) {
                result.getErrors().add(ex);
            }
        }
        return new com.paterva.maltego.transform.discovery.DiscoveryResult((Object[])list.toArray(new TransformServerDetail[list.size()]), result.getErrors().toArray(new Exception[result.getErrors().size()]));
    }

    private static Collection<DiscoveryServer> translate(TransformSeed[] seeds) {
        LinkedList<DiscoveryServer> list = new LinkedList<DiscoveryServer>();
        for (TransformSeed seed : seeds) {
            try {
                list.add(new DiscoveryServer(seed.getUrl().getURL(), seed.getName()));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return list;
    }

    public com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerDetail> getDetails(TransformServerReference[] references, ProgressCallback cb) throws DiscoveryException {
        return new com.paterva.maltego.transform.discovery.DiscoveryResult((Object[])((TransformServerDetail[])references));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.paterva.maltego.transform.discovery.DiscoveryResult<TransformServerListing> listTransforms(TransformServerDetail[] references, ProgressCallback cb) throws DiscoveryException {
        List errors = Collections.synchronizedList(new ArrayList());
        List listings = Collections.synchronizedList(new ArrayList());
        try {
            SlownessDetector.setEnabled((boolean)false);
            ExecutorService executor = Executors.newFixedThreadPool(references.length, (ThreadFactory)new NamedThreadFactory("Transform Discovery"));
            Set found = Collections.synchronizedSet(new HashSet());
            for (TransformServerDetail ref : references) {
                executor.submit(() -> {
                    FastURL serverUrl = ref.getBaseUrl();
                    if (found.add(serverUrl.toString())) {
                        V2TransformSource source = new V2TransformSource();
                        if (cb != null) {
                            cb.progress("Getting transforms for " + serverUrl);
                        }
                        try {
                            TransformListInfo transforms = source.getTransforms(serverUrl.toString());
                            LOG.log(Level.FINE, "Discovered: {0}", transforms);
                            TransformServerListing listing = new TransformServerListing(ref);
                            this.attachWebServices(listing, transforms);
                            this.attachTransformsEntitiesSets(listing, transforms);
                            for (TransformServerListingProvider provider : TransformServerListingProvider.getAll()) {
                                provider.update(ref, listing);
                            }
                            listings.add(listing);
                        }
                        catch (Exception ex) {
                            NormalException.logStackTrace((Throwable)ex);
                            errors.add(ex);
                        }
                    }
                });
            }
            executor.shutdown();
            try {
                executor.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            SlownessDetector.setEnabled((boolean)true);
        }
        return new com.paterva.maltego.transform.discovery.DiscoveryResult((Object[])listings.toArray(new TransformServerListing[listings.size()]), errors.toArray(new Exception[errors.size()]));
    }

    private void attachWebServices(TransformServerListing listing, TransformListInfo listInfo) {
        WebServiceTranslator translator = new WebServiceTranslator();
        List authenticators = listInfo.getOAuthAuthenticators();
        Map webServices = listing.getPublicWebServices();
        for (OAuthAuthenticatorInfo a : authenticators) {
            Map webService = translator.translate(a);
            webServices.putAll(webService);
        }
    }

    private void attachTransformsEntitiesSets(TransformServerListing listing, TransformListInfo listInfo) {
        V2TransformSetRepository setRepository = new V2TransformSetRepository();
        TransformTranslator transformTranslator = new TransformTranslator(setRepository.allSets());
        List transforms = listInfo.getTransforms();
        for (TransformInfo info : transforms) {
            try {
                listing.getTransforms().add(transformTranslator.translate(info, listing.getBaseUrl().getURL()));
                listing.getSets().addAll(setRepository.allSets());
                listing.getEntities().addAll(EntitySpecTranslator.getEntities((TransformInfo)info));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

