/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.discover.DiscoveryContext;
import com.paterva.maltego.archive.mtz.discover.DiscoveryMergingRules;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryProvider;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerListingProvider;
import com.paterva.maltego.transform.protocol.v2api.messaging.Proxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.ProxyException;
import com.paterva.maltego.transform.protocol.v2api.messaging.ProxyFactory;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.NormalException;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FileUtils;

public class MtzListingProvider
extends TransformServerListingProvider {
    private static final Logger LOG = Logger.getLogger(MtzListingProvider.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TransformServerDetail serverDetail, TransformServerListing listing) throws Exception {
        File tempFile = null;
        FastURL mtzUrl = serverDetail.getBaseUrl();
        String source = mtzUrl.toString();
        String seedUrl = serverDetail.getSeedUrl();
        DiscoveryMergingRules rules = DiscoveryMergingRules.getDefault();
        boolean overwriteConfig = serverDetail.isOverwriteConfig();
        String host = mtzUrl.getURL().getHost().toLowerCase();
        if (overwriteConfig && (host.equals("maltego.com") || host.endsWith(".maltego.com") || host.equals("paterva.com") || host.endsWith(".paterva.com"))) {
            rules = new DiscoveryMergingRules.Replace();
        }
        DiscoveryContext ctx = new DiscoveryContext(seedUrl, rules);
        try {
            Proxy proxy = ProxyFactory.getDefault().createProxy(source);
            byte[] mtzConfig = proxy.getMtzConfig();
            if (mtzConfig.length > 2) {
                tempFile = File.createTempFile("mtz", null);
                FileUtils.writeByteArrayToFile((File)tempFile, (byte[])mtzConfig);
                ZipFile zipFile = new ZipFile(tempFile);
                MaltegoArchiveReader reader = new MaltegoArchiveReader(zipFile);
                Set items = listing.getMtzDiscoveryItems();
                Collection providers = MtzDiscoveryProvider.getAll();
                for (MtzDiscoveryProvider provider : providers) {
                    items.add(provider.read(ctx, reader));
                }
            }
        }
        catch (Exception ex) {
            System.out.println("source = " + source);
            boolean logged = this.logNoConfigFile(ex, source);
            if (!logged) {
                NormalException.logStackTrace((Throwable)ex);
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    private boolean logNoConfigFile(Exception ex, String source) {
        boolean logged;
        block3: {
            logged = false;
            try {
                String msg;
                if (!(ex instanceof ProxyException) || (msg = ex.getMessage()) == null || !msg.contains("?Command=_CONFIG")) break block3;
                Throwable throwable = ex.getCause();
                for (int count = 0; throwable != null && count < 7; ++count, throwable = throwable.getCause()) {
                    String innerMessage = throwable.getMessage();
                    if (innerMessage == null || !innerMessage.contains("Unexpected HTTP response: 404")) continue;
                    logged = true;
                    LOG.log(Level.WARNING, "No Configuration File Found (MTZ file): {0}", innerMessage);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return logged;
    }
}

