/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.BodyParser;
import com.kenai.jbosh.BodyParserResults;
import com.kenai.jbosh.BodyQName;
import com.kenai.jbosh.ServiceLib;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

final class StaticBody
extends AbstractBody {
    private static final BodyParser PARSER = ServiceLib.loadService(BodyParser.class);
    private static final int BUFFER_SIZE = 1024;
    private final Map<BodyQName, String> attrs;
    private final String raw;

    private StaticBody(Map<BodyQName, String> attrMap, String rawXML) {
        this.attrs = attrMap;
        this.raw = rawXML;
    }

    public static StaticBody fromStream(InputStream inStream) throws BOSHException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            int read;
            byte[] buffer = new byte[1024];
            do {
                if ((read = inStream.read(buffer)) <= 0) continue;
                byteOut.write(buffer, 0, read);
            } while (read >= 0);
        }
        catch (IOException iox) {
            throw new BOSHException("Could not read body data", iox);
        }
        return StaticBody.fromString(byteOut.toString());
    }

    public static StaticBody fromString(String rawXML) throws BOSHException {
        BodyParserResults results = PARSER.parse(rawXML);
        return new StaticBody(results.getAttributes(), rawXML);
    }

    @Override
    public Map<BodyQName, String> getAttributes() {
        return Collections.unmodifiableMap(this.attrs);
    }

    @Override
    public String toXML() {
        return this.raw;
    }
}

