/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.graphml;

import com.ctc.wstx.stax.WstxOutputFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.serializers.graphml.GraphMLWriter;
import com.paterva.maltego.ui.graph.imex.MaltegoEntityIOStax;
import com.paterva.maltego.ui.graph.imex.MaltegoLinkIOStax;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.XMLEscapeUtils;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GraphStoreGraphMLWriter
extends GraphMLWriter {
    private Collection<EntityID> _entityIDs;
    private XMLStreamWriter _writer;
    private GraphDataStoreReader _dataReader;
    private GraphStructureReader _structureReader;
    private GraphLayoutReader _layoutReader;
    private boolean _withLinks = true;

    public void write(GraphID graphID, OutputStream os) throws IOException {
        this.write(graphID, os, null);
    }

    public String toString(GraphID graphID) throws IOException {
        return this.toString(graphID, null);
    }

    public String toString(GraphID graphID, Collection<EntityID> entityIDs) throws IOException {
        return this.toString(graphID, entityIDs, true);
    }

    public String toString(GraphID graphID, Collection<EntityID> entityIDs, boolean withLinks) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(graphID, baos, entityIDs, withLinks);
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    public void write(GraphID graphID, OutputStream os, Collection<EntityID> entityIDs) throws IOException {
        this.write(graphID, os, entityIDs, true);
    }

    public void write(GraphID graphID, OutputStream os, Collection<EntityID> entityIDs, boolean withLinks) throws IOException {
        this._withLinks = withLinks;
        this._writer = null;
        try {
            this.initialize(graphID, entityIDs);
            String encoding = StandardCharsets.UTF_8.name();
            WstxOutputFactory outputFactory = new WstxOutputFactory();
            outputFactory.configureForSpeed();
            this._writer = new CustomXMLStreamWriter(outputFactory.createXMLStreamWriter(os, encoding));
            this._writer.writeStartDocument(encoding, "1.1");
            this.writeGraphML();
            this._writer.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        finally {
            if (this._writer != null) {
                try {
                    this._writer.close();
                    this._writer = null;
                }
                catch (XMLStreamException ex) {
                    NormalException.logStackTrace((Throwable)ex);
                }
            }
            this.uninitialize();
        }
    }

    private void initialize(GraphID graphID, Collection<EntityID> entities) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        this._dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        this._structureReader = graphStore.getGraphStructureStore().getStructureReader();
        this._layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
        this._entityIDs = entities != null ? entities : this.getEntities();
    }

    private void uninitialize() {
        this._entityIDs = null;
        this._dataReader = null;
        this._layoutReader = null;
    }

    private void writeGraphML() throws XMLStreamException, GraphStoreException {
        this._writer.writeStartElement("graphml");
        this.writeNamespaceAttributes();
        this.writeVersion();
        this.writeKeys();
        this.writeGraph();
        this._writer.writeEndElement();
    }

    private void writeNamespaceAttributes() throws XMLStreamException {
        this._writer.writeDefaultNamespace("http://graphml.graphdrawing.org/xmlns");
        this._writer.writeNamespace("mtg", "http://maltego.paterva.com/xml/mtgx");
    }

    private void writeVersion() throws XMLStreamException {
        Version version = Version.getCurrent();
        this._writer.writeStartElement("VersionInfo");
        this._writer.writeAttribute("createdBy", System.getProperty("maltego.product-name", "Maltego"));
        this._writer.writeAttribute("subtitle", version.getSubtitle());
        this._writer.writeAttribute("version", version.toString(false, true, false));
        this._writer.writeEndElement();
    }

    private void writeKeys() throws XMLStreamException {
        this.writeKey("MaltegoEntity", "node", "d0", null);
        this.writeKey(null, "node", "d1", "nodegraphics");
        this.writeKey("MaltegoLink", "edge", "d2", null);
        this.writeKey(null, "edge", "d3", "edgegraphics");
    }

    private void writeKey(String attrName, String fOr, String id, String yFilesType) throws XMLStreamException {
        this._writer.writeStartElement("key");
        if (attrName != null) {
            this._writer.writeAttribute("attr.name", attrName);
        }
        this._writer.writeAttribute("for", fOr);
        this._writer.writeAttribute("id", id);
        if (yFilesType != null) {
            this._writer.writeAttribute("yfiles.type", yFilesType);
        }
        this._writer.writeEndElement();
    }

    private void writeGraph() throws XMLStreamException, GraphStoreException {
        this._writer.writeStartElement("graph");
        this._writer.writeAttribute("edgedefault", "directed");
        this._writer.writeAttribute("id", "G");
        int id = 0;
        HashMap<EntityID, Integer> nodeIDs = new HashMap<EntityID, Integer>(this._entityIDs.size());
        for (EntityID entityID : this._entityIDs) {
            this.writeNode(entityID, id);
            nodeIDs.put(entityID, id);
            ++id;
        }
        if (this._withLinks) {
            id = 0;
            Set<LinkID> linkIDs = this.getLinks();
            for (LinkID linkID : linkIDs) {
                this.writeEdge(linkID, id, nodeIDs);
                ++id;
            }
        }
    }

    private void writeNode(EntityID entityID, int id) throws XMLStreamException, GraphStoreException {
        this.writeStartElement("node", "n" + id);
        this.writeEntityData(entityID);
        this.writeNodeData(entityID);
        this.writeEndElement();
    }

    private void writeEntityData(EntityID entityID) throws XMLStreamException, GraphStoreException {
        this.writeStartData("d0");
        this.writeEntity(entityID);
        this.writeEndElement();
    }

    private void writeEntity(EntityID entityID) throws XMLStreamException, GraphStoreException {
        MaltegoEntity entity = this._dataReader.getEntity(entityID);
        MaltegoEntityIOStax.write((XMLStreamWriter)this._writer, (MaltegoEntity)entity);
    }

    private void writeNodeData(EntityID entityID) throws XMLStreamException, GraphStoreException {
        this.writeStartData("d1");
        this.writeCenter(entityID);
        this.writeEndElement();
    }

    private void writeCenter(EntityID entityID) throws XMLStreamException, GraphStoreException {
        this._writer.writeStartElement("mtg", "EntityRenderer", "http://maltego.paterva.com/xml/mtgx");
        this._writer.writeStartElement("mtg", "Position", "http://maltego.paterva.com/xml/mtgx");
        Point center = this._layoutReader.getCenter(entityID);
        this._writer.writeAttribute("x", Double.toString(center.getX()));
        this._writer.writeAttribute("y", Double.toString(center.getY()));
        this._writer.writeEndElement();
        this._writer.writeEndElement();
    }

    private void writeEdge(LinkID linkID, int id, Map<EntityID, Integer> nodeIDs) throws XMLStreamException, GraphStoreException {
        this.writeStartElement("edge", "e" + id);
        this.writeSourceTargetAttributes(linkID, nodeIDs);
        this.writeLinkData(linkID);
        this.writeEdgeData(linkID);
        this.writeEndElement();
    }

    private void writeSourceTargetAttributes(LinkID linkID, Map<EntityID, Integer> nodeIDs) throws GraphStoreException, XMLStreamException {
        LinkEntityIDs entities = this._structureReader.getEntities(linkID);
        this._writer.writeAttribute("source", "n" + nodeIDs.get(entities.getSourceID()));
        this._writer.writeAttribute("target", "n" + nodeIDs.get(entities.getTargetID()));
    }

    private void writeLinkData(LinkID linkID) throws XMLStreamException, GraphStoreException {
        this.writeStartData("d2");
        this.writeLink(linkID);
        this.writeEndElement();
    }

    private void writeLink(LinkID linkID) throws XMLStreamException, GraphStoreException {
        MaltegoLink link = this._dataReader.getLink(linkID);
        MaltegoLinkIOStax.write((XMLStreamWriter)this._writer, (MaltegoLink)link);
    }

    private void writeEdgeData(LinkID linkID) throws XMLStreamException, GraphStoreException {
        this.writeStartData("d3");
        this.writePath(linkID);
        this.writeEndElement();
    }

    private void writePath(LinkID linkID) throws XMLStreamException, GraphStoreException {
        this._writer.writeStartElement("mtg", "LinkRenderer", "http://maltego.paterva.com/xml/mtgx");
        this._writer.writeEndElement();
    }

    private void writeStartData(String keyId) throws XMLStreamException {
        this.writeStartElement("data", "key", keyId);
    }

    private void writeStartElement(String name, String id) throws XMLStreamException {
        this.writeStartElement(name, "id", id);
    }

    private void writeStartElement(String name, String attrName, String attrValue) throws XMLStreamException {
        this._writer.writeStartElement(name);
        this._writer.writeAttribute(attrName, attrValue);
    }

    private void writeEndElement() throws XMLStreamException {
        this._writer.writeEndElement();
    }

    private Set<LinkID> getLinks() throws GraphStoreException {
        return this._structureReader.getLinksBetween(this._entityIDs);
    }

    private Set<EntityID> getEntities() throws GraphStoreException {
        return this._structureReader.getEntities();
    }

    private class CustomXMLStreamWriter
    extends IndentingXMLStreamWriter {
        public CustomXMLStreamWriter(XMLStreamWriter delegate) {
            super(delegate);
        }

        public void writeCData(String s) throws XMLStreamException {
            super.writeCData((s = XMLEscapeUtils.escapeUnicode((String)s)) != null ? s : "");
        }
    }
}

