/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.view;

import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import com.paterva.maltego.util.ui.components.ScrollablePanel;
import com.paterva.maltego.util.ui.look.Look;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CertificateDetailView
extends JPanel
implements PropertyChangeListener {
    private final ExplorerManager _explorer;
    private Node _boundItem;
    private PropertyChangeListener _listener;
    private JPanel _detailPanel;
    public JScrollPane _extScroll;
    private JLabel _extensionsLabel;
    private JTextArea _extensionsValue;
    private JPanel _extentionsPanel;
    private JLabel _fingerprintSha1Label;
    private JLabel _fingerprintSha1Value;
    private JLabel _fingerprintSha256Label;
    private JLabel _fingerprintSha256Value;
    private JPanel _fingerprintsPanel;
    private JLabel _issuerAlgLabel;
    private JLabel _issuerAlgValue;
    private JLabel _issuerCountryLabel;
    private JLabel _issuerCountryValue;
    private JLabel _issuerNameLabel;
    private JLabel _issuerNameValue;
    private JLabel _issuerOrgLabel;
    private JLabel _issuerOrgValue;
    private JPanel _issuerPanel;
    private JLabel _issuerParamLabel;
    private JLabel _issuerParamValue;
    private JLabel _issuerSerialLabel;
    private JLabel _issuerSerialValue;
    private JLabel _issuerValidFromLabel;
    private JLabel _issuerValidFromValue;
    private JLabel _issuerValidToLabel;
    private JLabel _issuerValidToValue;
    private JLabel _issuerVerLabel;
    private JLabel _issuerVerValue;
    private JLabel _publicKeyAlgLabel;
    private JLabel _publicKeyAlgValue;
    private JLabel _publicKeyExpLabel;
    private JLabel _publicKeyExpValue;
    private JLabel _publicKeyLabel;
    private JPanel _publicKeyPanel;
    private JLabel _publicKeyParamLabel;
    private JLabel _publicKeyParamValue;
    private JLabel _publicKeyPurposeLabel;
    private JLabel _publicKeyPurposeValue;
    public JScrollPane _publicKeyScroll;
    public JScrollPane _publicKeySigScroll;
    private JLabel _publicKeySignatureLabel;
    private JTextArea _publicKeySignatureValue;
    private JLabel _publicKeySizeLabel;
    private JLabel _publicKeySizeValue;
    private JTextArea _publicKeyValue;
    private JLabel _sanLabel;
    public JScrollPane _sanScroll;
    private JTextArea _sanValue;
    private JLabel _subjectCountryLabel;
    private JLabel _subjectCountryValue;
    private JLabel _subjectNameLabel;
    private JLabel _subjectNameValue;
    private JLabel _subjectOrgLabel;
    private JLabel _subjectOrgValue;
    private JPanel _subjectPanel;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;

    public CertificateDetailView(ExplorerManager.Provider provider) {
        this.initComponents();
        this._explorer = provider.getExplorerManager();
        this.bindExplorer();
        this.initPanel();
    }

    public CertificateDetailView(X509Certificate cert) {
        this.initComponents();
        this._explorer = null;
        this.initPanel();
        if (cert != null) {
            CertificateRepository certRepo = CertificateRepository.getDefault();
            CertificateDefinition certDef = certRepo.get(cert);
            if (certDef == null) {
                certDef = new CertificateDefinition(cert);
            }
            try {
                this.bindCertificate(certDef);
            }
            catch (GeneralSecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initPanel() {
        Color basePanelBg = Look.getColor((String)"transform-manager-base-panel-bg");
        this.setBackground(basePanelBg);
        this._detailPanel.setBackground(basePanelBg);
        this._detailPanel.setBorder(new LineBorder(basePanelBg, 5));
        Color groupTitleColor = Look.getColor((String)"transform-manager-group-panel-title");
        ((TitledBorder)this._subjectPanel.getBorder()).setTitleColor(groupTitleColor);
        ((TitledBorder)this._issuerPanel.getBorder()).setTitleColor(groupTitleColor);
        ((TitledBorder)this._publicKeyPanel.getBorder()).setTitleColor(groupTitleColor);
        ((TitledBorder)this._extentionsPanel.getBorder()).setTitleColor(groupTitleColor);
        ((TitledBorder)this._fingerprintsPanel.getBorder()).setTitleColor(groupTitleColor);
        Border scrollBorder = BorderFactory.createLineBorder(Look.getColor((String)"transform-manager-group-panel-border"), 1);
        this._sanScroll.setBorder(scrollBorder);
        this._publicKeyScroll.setBorder(scrollBorder);
        this._publicKeySigScroll.setBorder(scrollBorder);
        this._extScroll.setBorder(scrollBorder);
        Color fg = Look.getColor((String)"transform-manager-group-panel-disabled-fg");
        this._sanValue.setBackground(basePanelBg);
        this._sanValue.setForeground(fg);
        this._publicKeyValue.setBackground(basePanelBg);
        this._publicKeyValue.setForeground(fg);
        this._publicKeySignatureValue.setBackground(basePanelBg);
        this._publicKeySignatureValue.setForeground(fg);
        this._extensionsValue.setBackground(basePanelBg);
        this._extensionsValue.setForeground(fg);
        this.setDefaultValues();
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._sanScroll, (JPanel)this._subjectPanel, (boolean)false);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._publicKeyScroll, (JPanel)this._publicKeyPanel, (boolean)false);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._publicKeySigScroll, (JPanel)this._publicKeyPanel, (boolean)false);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._extScroll, (JPanel)this._extentionsPanel, (boolean)false);
    }

    private void bindExplorer() {
        this._explorer.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] nodes = this._explorer.getSelectedNodes();
                this.bindItems(nodes);
            }
        });
    }

    public void bindItems(Node[] items) {
        if (items.length == 1) {
            if (this._boundItem != null) {
                this._boundItem.removePropertyChangeListener(this._listener);
            }
            this._boundItem = items[0];
            this._listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this._boundItem);
            this._boundItem.addPropertyChangeListener(this._listener);
            this.bindItem(this._boundItem);
        } else {
            this.setDefaultValues();
        }
    }

    private void setDefaultValues() {
        String defaultString = CertificateUtils.getDisplayString(null);
        this._subjectNameValue.setText(defaultString);
        this._subjectOrgValue.setText(defaultString);
        this._subjectCountryValue.setText(defaultString);
        this._issuerNameValue.setText(defaultString);
        this._issuerOrgValue.setText(defaultString);
        this._issuerCountryValue.setText(defaultString);
        this._issuerVerValue.setText(defaultString);
        this._issuerSerialValue.setText(defaultString);
        this._issuerAlgValue.setText(defaultString);
        this._issuerParamValue.setText(defaultString);
        this._issuerValidFromValue.setText(defaultString);
        this._issuerValidToValue.setText(defaultString);
        this._sanValue.setText(defaultString);
        SwingUtilities.invokeLater(() -> this._sanValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
        this._sanLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._sanLabel.text"));
        this._sanScroll.setPreferredSize(new Dimension(0, 35));
        this._sanValue.setText(defaultString);
        SwingUtilities.invokeLater(() -> this._sanValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
        this._publicKeySignatureValue.setText(defaultString);
        SwingUtilities.invokeLater(() -> this._publicKeySignatureValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
        this._publicKeyPurposeValue.setText(defaultString);
        this._publicKeyValue.setText(defaultString);
        this._publicKeySizeValue.setText(defaultString);
        this._publicKeyAlgValue.setText(defaultString);
        this._publicKeyParamValue.setText(defaultString);
        this._publicKeyExpValue.setText(defaultString);
        SwingUtilities.invokeLater(() -> this._publicKeyValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
        this._extensionsValue.setText(defaultString);
        SwingUtilities.invokeLater(() -> this._extensionsValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
        this._fingerprintSha256Value.setText(defaultString);
        this._fingerprintSha1Value.setText(defaultString);
        SwingUtilities.invokeLater(() -> this._detailPanel.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
    }

    private void bindItem(Node item) {
        CertificateDefinition certDef = (CertificateDefinition)item.getLookup().lookup(CertificateDefinition.class);
        if (certDef != null) {
            try {
                this.bindCertificate(certDef);
            }
            catch (GeneralSecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bindCertificate(CertificateDefinition certDef) throws GeneralSecurityException {
        X509Certificate cert = certDef.getCertificate();
        if (cert != null) {
            String extensionsString;
            this._subjectNameValue.setText(CertificateUtils.getDisplayString((String)certDef.getSubject().getName()));
            this._subjectOrgValue.setText(CertificateUtils.getDisplayString((String)certDef.getSubject().getOrg()));
            this._subjectCountryValue.setText(CertificateUtils.getDisplayString((String)certDef.getSubject().getCountry()));
            this._issuerNameValue.setText(CertificateUtils.getDisplayString((String)certDef.getIssuer().getName()));
            this._issuerOrgValue.setText(CertificateUtils.getDisplayString((String)certDef.getIssuer().getOrg()));
            this._issuerCountryValue.setText(CertificateUtils.getDisplayString((String)certDef.getIssuer().getCountry()));
            this._issuerVerValue.setText(String.valueOf(cert.getVersion()));
            this._issuerSerialValue.setText(this.insertStringPeriodically(certDef.getSerialNumber(), " ", 2));
            this._issuerAlgValue.setText(CertificateUtils.getDisplayString((String)cert.getSigAlgName()) + " ( " + CertificateUtils.getDisplayString((String)cert.getSigAlgOID()) + " )");
            this._issuerParamValue.setText(CertificateUtils.getDisplayString((String)Arrays.toString(cert.getSigAlgParams())));
            this._issuerValidFromValue.setText(CertificateUtils.getDisplayString((String)CertificateUtils.toDateString((Date)cert.getNotBefore())));
            this._issuerValidToValue.setText(CertificateUtils.getDisplayString((String)CertificateUtils.toDateString((Date)cert.getNotAfter())));
            String sansOrHostnamesString = null;
            boolean displaySans = true;
            List sans = certDef.getSubjectAlternativeNames();
            if (sans == null || sans.isEmpty()) {
                this._sanLabel.setText("Maltego Associated Hostnames");
                List hostnames = certDef.getHostnames();
                if (hostnames == null || hostnames.isEmpty()) {
                    displaySans = true;
                } else {
                    displaySans = false;
                    sansOrHostnamesString = String.join((CharSequence)"\n", hostnames);
                }
            }
            if (displaySans) {
                this._sanLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._sanLabel.text"));
                sansOrHostnamesString = String.join((CharSequence)"\n", sans);
            }
            String displayString = CertificateUtils.getDisplayString(sansOrHostnamesString);
            this._sanValue.setText(displayString);
            int maxHeight = 100;
            int rows = StringUtils.countMatches((CharSequence)displayString, (CharSequence)"\n") + 2;
            this._sanScroll.setPreferredSize(new Dimension(0, Math.min(rows * 15, maxHeight)));
            SwingUtilities.invokeLater(() -> this._sanValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
            String sig = this.insertStringPeriodically(certDef.getSignature(), " ", 2);
            this._publicKeySignatureValue.setText(CertificateUtils.getDisplayString((String)sig));
            SwingUtilities.invokeLater(() -> this._publicKeySignatureValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
            this._publicKeyPurposeValue.setText(CertificateUtils.getDisplayString((String)String.join((CharSequence)", ", certDef.getKeyUsage())));
            CertificateDefinition.CertPublicKey pk = certDef.getPublicKey();
            if (pk != null) {
                String hexEnc = this.insertStringPeriodically(pk.getModulus(), " ", 2);
                if (StringUtilities.isNullOrEmpty((String)pk.getModulus())) {
                    hexEnc = this.insertStringPeriodically(pk.getEncoded(), " ", 2);
                }
                this._publicKeyValue.setText(CertificateUtils.getDisplayString((String)hexEnc));
                int keySizeBytes = pk.getKeySizeBytes();
                String keySizeBytesString = keySizeBytes == -1 ? "" : Integer.toString(keySizeBytes);
                this._publicKeySizeValue.setText(CertificateUtils.getDisplayString((String)keySizeBytesString, (String)" bytes"));
                this._publicKeyAlgValue.setText(CertificateUtils.getDisplayString((String)pk.getAlg()));
                this._publicKeyParamValue.setText(CertificateUtils.getDisplayString((String)pk.getParams()));
                BigInteger exponent = pk.getExponent();
                String exponentString = exponent == null ? null : exponent.toString();
                this._publicKeyExpValue.setText(CertificateUtils.getDisplayString((String)exponentString));
                SwingUtilities.invokeLater(() -> this._publicKeyValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
            }
            if (!StringUtilities.isNullOrEmpty((String)(extensionsString = certDef.getExtensionsString()))) {
                this._extensionsValue.setText(extensionsString);
            } else {
                this._extensionsValue.setText(CertificateUtils.toPrettyString2((X509Certificate)cert));
            }
            SwingUtilities.invokeLater(() -> this._extensionsValue.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
            try {
                byte[] encoded = cert.getEncoded();
                String sha256 = DigestUtils.sha256Hex((byte[])encoded);
                String sha1 = DigestUtils.sha1Hex((byte[])encoded);
                this._fingerprintSha256Value.setText(this.insertStringPeriodically(sha256, " ", 2));
                this._fingerprintSha1Value.setText(this.insertStringPeriodically(sha1, " ", 2));
            }
            catch (CertificateEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            SwingUtilities.invokeLater(() -> this._detailPanel.scrollRectToVisible(new Rectangle(0, 0, 1, 1)));
        }
    }

    public String insertStringPeriodically(String original, String insert, int period) {
        return original == null ? null : StringUtilities.insertStringPeriodically((String)original.toUpperCase(), (String)insert, (int)period);
    }

    private void polulateExtensionsValue(CertificateDefinition certDef) {
        String value;
        String key;
        StringBuilder sb = new StringBuilder();
        Map critExtenstions = certDef.getCritExtenstions();
        Map nonCritExtenstions = certDef.getNonCritExtenstions();
        if (critExtenstions != null) {
            sb.append("Set of critical extensions:").append("\n");
            for (Map.Entry entry : critExtenstions.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                sb.append("ID: ").append(key).append("\n");
                sb.append(value).append("\n\n");
            }
        }
        if (nonCritExtenstions != null) {
            sb.append("Set of non-critical extensions:").append("\n");
            for (Map.Entry entry : nonCritExtenstions.entrySet()) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                sb.append("ID: ").append(key).append("\n");
                sb.append(value).append("\n\n");
            }
        }
        if (critExtenstions != null || nonCritExtenstions != null) {
            this._extensionsValue.setText(CertificateUtils.getDisplayString((String)sb.toString()));
        }
    }

    private void initComponents() {
        this._detailPanel = new JPanel();
        this._subjectPanel = new JPanel();
        this._subjectCountryLabel = new JLabel();
        this._subjectCountryValue = new JLabel();
        this._subjectOrgLabel = new JLabel();
        this._subjectOrgValue = new JLabel();
        this._subjectNameLabel = new JLabel();
        this._subjectNameValue = new JLabel();
        this._sanLabel = new JLabel();
        this._sanScroll = new JScrollPane();
        this._sanValue = new JTextArea();
        this.jPanel2 = new JPanel();
        this._issuerPanel = new JPanel();
        this._issuerCountryLabel = new JLabel();
        this._issuerCountryValue = new JLabel();
        this._issuerOrgLabel = new JLabel();
        this._issuerOrgValue = new JLabel();
        this._issuerNameLabel = new JLabel();
        this._issuerNameValue = new JLabel();
        this._issuerSerialLabel = new JLabel();
        this._issuerSerialValue = new JLabel();
        this._issuerVerLabel = new JLabel();
        this._issuerVerValue = new JLabel();
        this._issuerAlgLabel = new JLabel();
        this._issuerAlgValue = new JLabel();
        this._issuerParamLabel = new JLabel();
        this._issuerParamValue = new JLabel();
        this._issuerValidFromLabel = new JLabel();
        this._issuerValidFromValue = new JLabel();
        this._issuerValidToLabel = new JLabel();
        this._issuerValidToValue = new JLabel();
        this.jPanel3 = new JPanel();
        this._publicKeyPanel = new JPanel();
        this._publicKeyAlgLabel = new JLabel();
        this._publicKeyAlgValue = new JLabel();
        this._publicKeyParamLabel = new JLabel();
        this._publicKeyParamValue = new JLabel();
        this._publicKeyLabel = new JLabel();
        this._publicKeyScroll = new JScrollPane();
        this._publicKeyValue = new JTextArea();
        this._publicKeyExpLabel = new JLabel();
        this._publicKeyExpValue = new JLabel();
        this._publicKeySizeLabel = new JLabel();
        this._publicKeySizeValue = new JLabel();
        this._publicKeyPurposeLabel = new JLabel();
        this._publicKeyPurposeValue = new JLabel();
        this._publicKeySignatureLabel = new JLabel();
        this._publicKeySigScroll = new JScrollPane();
        this._publicKeySignatureValue = new JTextArea();
        this.jPanel4 = new JPanel();
        this._extentionsPanel = new JPanel();
        this._extensionsLabel = new JLabel();
        this._extScroll = new JScrollPane();
        this._extensionsValue = new JTextArea();
        this._fingerprintsPanel = new JPanel();
        this._fingerprintSha256Label = new JLabel();
        this._fingerprintSha256Value = new JLabel();
        this._fingerprintSha1Label = new JLabel();
        this._fingerprintSha1Value = new JLabel();
        this.setLayout(new BorderLayout());
        this._detailPanel.setBorder(new LineBorder(new Color(221, 221, 221), 1, true));
        this._detailPanel.setLayout(new BorderLayout(0, 5));
        this._subjectPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), Look.getColor((String)"transform-manager-group-panel-border")), NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._subjectPanel.border.title")));
        this._subjectPanel.setOpaque(false);
        this._subjectPanel.setLayout(new GridBagLayout());
        this._subjectCountryLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._subjectCountryLabel.setLabelFor(this._subjectCountryValue);
        this._subjectCountryLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._subjectCountry.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._subjectCountryLabel, gridBagConstraints);
        this._subjectCountryValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._subjectCountryValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._subjectCountryValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._subjectCountryValue, gridBagConstraints);
        this._subjectOrgLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._subjectOrgLabel.setLabelFor(this._subjectOrgValue);
        this._subjectOrgLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._subjectOrgLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._subjectOrgLabel, gridBagConstraints);
        this._subjectOrgValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._subjectOrgValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._subjectOrgValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._subjectOrgValue, gridBagConstraints);
        this._subjectNameLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._subjectNameLabel.setLabelFor(this._subjectNameValue);
        this._subjectNameLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._subjectNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._subjectPanel.add((Component)this._subjectNameLabel, gridBagConstraints);
        this._subjectNameValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._subjectNameValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._subjectNameValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._subjectPanel.add((Component)this._subjectNameValue, gridBagConstraints);
        this._sanLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._sanLabel.setLabelFor(this._subjectCountryValue);
        this._sanLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._sanLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._subjectPanel.add((Component)this._sanLabel, gridBagConstraints);
        this._sanScroll.setHorizontalScrollBarPolicy(31);
        this._sanScroll.setHorizontalScrollBar(null);
        this._sanScroll.setMinimumSize(new Dimension(0, 20));
        this._sanScroll.setOpaque(false);
        this._sanScroll.setPreferredSize(new Dimension(0, 36));
        this._sanValue.setEditable(false);
        this._sanValue.setLineWrap(true);
        this._sanValue.setWrapStyleWord(true);
        this._sanScroll.setViewportView(this._sanValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._subjectPanel.add((Component)this._sanScroll, gridBagConstraints);
        this._detailPanel.add((Component)this._subjectPanel, "North");
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new BorderLayout(0, 5));
        this._issuerPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), Look.getColor((String)"transform-manager-group-panel-border")), NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerPanel.border.title")));
        this._issuerPanel.setOpaque(false);
        this._issuerPanel.setLayout(new GridBagLayout());
        this._issuerCountryLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerCountryLabel.setLabelFor(this._subjectCountryValue);
        this._issuerCountryLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerCountryLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerCountryLabel, gridBagConstraints);
        this._issuerCountryValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerCountryValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerCountryValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerCountryValue, gridBagConstraints);
        this._issuerOrgLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerOrgLabel.setLabelFor(this._subjectOrgValue);
        this._issuerOrgLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerOrgLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerOrgLabel, gridBagConstraints);
        this._issuerOrgValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerOrgValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerOrgValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerOrgValue, gridBagConstraints);
        this._issuerNameLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerNameLabel.setLabelFor(this._subjectNameValue);
        this._issuerNameLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._issuerPanel.add((Component)this._issuerNameLabel, gridBagConstraints);
        this._issuerNameValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerNameValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerNameValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._issuerPanel.add((Component)this._issuerNameValue, gridBagConstraints);
        this._issuerSerialLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerSerialLabel.setLabelFor(this._subjectNameValue);
        this._issuerSerialLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerSerialLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerSerialLabel, gridBagConstraints);
        this._issuerSerialValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerSerialValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerSerialValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerSerialValue, gridBagConstraints);
        this._issuerVerLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerVerLabel.setLabelFor(this._subjectNameValue);
        this._issuerVerLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerVerLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerVerLabel, gridBagConstraints);
        this._issuerVerValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerVerValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerVerValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerVerValue, gridBagConstraints);
        this._issuerAlgLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerAlgLabel.setLabelFor(this._subjectNameValue);
        this._issuerAlgLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerAlgLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerAlgLabel, gridBagConstraints);
        this._issuerAlgValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerAlgValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerAlgValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerAlgValue, gridBagConstraints);
        this._issuerParamLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerParamLabel.setLabelFor(this._subjectNameValue);
        this._issuerParamLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerParamLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._issuerPanel.add((Component)this._issuerParamLabel, gridBagConstraints);
        this._issuerParamValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerParamValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerParamValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 0);
        this._issuerPanel.add((Component)this._issuerParamValue, gridBagConstraints);
        this._issuerValidFromLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerValidFromLabel.setLabelFor(this._subjectNameValue);
        this._issuerValidFromLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerValidFromLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerValidFromLabel, gridBagConstraints);
        this._issuerValidFromValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerValidFromValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerValidFromValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerValidFromValue, gridBagConstraints);
        this._issuerValidToLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._issuerValidToLabel.setLabelFor(this._subjectNameValue);
        this._issuerValidToLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerValidToLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerValidToLabel, gridBagConstraints);
        this._issuerValidToValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._issuerValidToValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._issuerValidToValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._issuerPanel.add((Component)this._issuerValidToValue, gridBagConstraints);
        this.jPanel2.add((Component)this._issuerPanel, "North");
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new BorderLayout(0, 5));
        this._publicKeyPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), Look.getColor((String)"transform-manager-group-panel-border")), NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyPanel.border.title")));
        this._publicKeyPanel.setOpaque(false);
        this._publicKeyPanel.setLayout(new GridBagLayout());
        this._publicKeyAlgLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._publicKeyAlgLabel.setLabelFor(this._subjectNameValue);
        this._publicKeyAlgLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyAlgLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyAlgLabel, gridBagConstraints);
        this._publicKeyAlgValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._publicKeyAlgValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyAlgValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyAlgValue, gridBagConstraints);
        this._publicKeyParamLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._publicKeyParamLabel.setLabelFor(this._subjectNameValue);
        this._publicKeyParamLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyParamLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyParamLabel, gridBagConstraints);
        this._publicKeyParamValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._publicKeyParamValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyParamValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyParamValue, gridBagConstraints);
        this._publicKeyLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._publicKeyLabel.setLabelFor(this._subjectCountryValue);
        this._publicKeyLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyLabel, gridBagConstraints);
        this._publicKeyScroll.setHorizontalScrollBarPolicy(31);
        this._publicKeyScroll.setHorizontalScrollBar(null);
        this._publicKeyScroll.setMinimumSize(new Dimension(0, 20));
        this._publicKeyScroll.setOpaque(false);
        this._publicKeyScroll.setPreferredSize(new Dimension(0, 120));
        this._publicKeyValue.setEditable(false);
        this._publicKeyValue.setLineWrap(true);
        this._publicKeyValue.setWrapStyleWord(true);
        this._publicKeyScroll.setViewportView(this._publicKeyValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyScroll, gridBagConstraints);
        this._publicKeyExpLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._publicKeyExpLabel.setLabelFor(this._subjectNameValue);
        this._publicKeyExpLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyExpLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyExpLabel, gridBagConstraints);
        this._publicKeyExpValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._publicKeyExpValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyExpValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyExpValue, gridBagConstraints);
        this._publicKeySizeLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._publicKeySizeLabel.setLabelFor(this._subjectOrgValue);
        this._publicKeySizeLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeySizeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeySizeLabel, gridBagConstraints);
        this._publicKeySizeValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._publicKeySizeValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeySizeValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeySizeValue, gridBagConstraints);
        this._publicKeyPurposeLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._publicKeyPurposeLabel.setLabelFor(this._subjectNameValue);
        this._publicKeyPurposeLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyPurposeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyPurposeLabel, gridBagConstraints);
        this._publicKeyPurposeValue.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._publicKeyPurposeValue.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeyPurposeValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeyPurposeValue, gridBagConstraints);
        this._publicKeySignatureLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._publicKeySignatureLabel.setLabelFor(this._subjectNameValue);
        this._publicKeySignatureLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._publicKeySignatureLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeySignatureLabel, gridBagConstraints);
        this._publicKeySigScroll.setHorizontalScrollBarPolicy(31);
        this._publicKeySigScroll.setHorizontalScrollBar(null);
        this._publicKeySigScroll.setMinimumSize(new Dimension(0, 20));
        this._publicKeySigScroll.setOpaque(false);
        this._publicKeySigScroll.setPreferredSize(new Dimension(0, 120));
        this._publicKeySignatureValue.setEditable(false);
        this._publicKeySignatureValue.setLineWrap(true);
        this._publicKeySignatureValue.setWrapStyleWord(true);
        this._publicKeySigScroll.setViewportView(this._publicKeySignatureValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._publicKeyPanel.add((Component)this._publicKeySigScroll, gridBagConstraints);
        this.jPanel3.add((Component)this._publicKeyPanel, "North");
        this.jPanel4.setOpaque(false);
        this.jPanel4.setLayout(new BorderLayout(0, 5));
        this._extentionsPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), Look.getColor((String)"transform-manager-group-panel-border")), NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._extentionsPanel.border.title")));
        this._extentionsPanel.setOpaque(false);
        this._extentionsPanel.setLayout(new GridBagLayout());
        this._extensionsLabel.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._extensionsLabel.setLabelFor(this._subjectCountryValue);
        this._extensionsLabel.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._extensionsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._extentionsPanel.add((Component)this._extensionsLabel, gridBagConstraints);
        this._extScroll.setHorizontalScrollBarPolicy(31);
        this._extScroll.setHorizontalScrollBar(null);
        this._extScroll.setMinimumSize(new Dimension(0, 20));
        this._extScroll.setOpaque(false);
        this._extScroll.setPreferredSize(new Dimension(0, 200));
        this._extensionsValue.setEditable(false);
        this._extensionsValue.setLineWrap(true);
        this._extensionsValue.setWrapStyleWord(true);
        this._extScroll.setViewportView(this._extensionsValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this._extentionsPanel.add((Component)this._extScroll, gridBagConstraints);
        this.jPanel4.add((Component)this._extentionsPanel, "North");
        this._fingerprintsPanel.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), Look.getColor((String)"transform-manager-group-panel-border")), NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._fingerprintsPanel.border.title")));
        this._fingerprintsPanel.setOpaque(false);
        this._fingerprintsPanel.setLayout(new GridBagLayout());
        this._fingerprintSha256Label.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._fingerprintSha256Label.setLabelFor(this._subjectCountryValue);
        this._fingerprintSha256Label.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._fingerprintSha256Label.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._fingerprintsPanel.add((Component)this._fingerprintSha256Label, gridBagConstraints);
        this._fingerprintSha256Value.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._fingerprintSha256Value.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._fingerprintSha256Value.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._fingerprintsPanel.add((Component)this._fingerprintSha256Value, gridBagConstraints);
        this._fingerprintSha1Label.setForeground(Look.getColor((String)"transform-manager-group-panel-fg"));
        this._fingerprintSha1Label.setLabelFor(this._subjectOrgValue);
        this._fingerprintSha1Label.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._fingerprintSha1Label.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 49;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._fingerprintsPanel.add((Component)this._fingerprintSha1Label, gridBagConstraints);
        this._fingerprintSha1Value.setForeground(Look.getColor((String)"transform-manager-group-panel-disabled-fg"));
        this._fingerprintSha1Value.setText(NbBundle.getMessage(CertificateDetailView.class, (String)"CertificateDetailView._fingerprintSha1Value.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this._fingerprintsPanel.add((Component)this._fingerprintSha1Value, gridBagConstraints);
        this.jPanel4.add((Component)this._fingerprintsPanel, "Center");
        this.jPanel3.add((Component)this.jPanel4, "Center");
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this._detailPanel.add((Component)this.jPanel2, "Center");
        this.add((Component)this._detailPanel, "First");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this._boundItem != null) {
            this.bindItem(this._boundItem);
        }
    }
}

