/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui.manager;

import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.ui.manager.CertificateNode;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.beans.PropertyChangeEvent;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.WeakListeners;

public class AllCertificatesChildFactory
extends ChildFactory<CertificateDefinition>
implements NodeListener,
RepositoryListener {
    public AllCertificatesChildFactory() {
        CertificateRepository registry = CertificateRepository.getDefault();
        registry.addRepositoryListener((RepositoryListener)WeakListeners.create(RepositoryListener.class, (EventListener)((Object)this), (Object)registry));
    }

    protected boolean createKeys(List<CertificateDefinition> toFill) {
        boolean success = false;
        CertificateRepository certRepo = CertificateRepository.getDefault();
        Collection allCertificates = certRepo.getAllDisplay();
        for (X509Certificate cert : allCertificates) {
            CertificateDefinition certDef = certRepo.get(cert);
            if (certDef == null) {
                certDef = new CertificateDefinition(cert);
            }
            toFill.add(certDef);
        }
        Collections.sort(toFill, (o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName()));
        success = true;
        return success;
    }

    protected Node createNodeForKey(CertificateDefinition key) {
        CertificateNode certNode = new CertificateNode(key);
        certNode.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)((Object)this), (Object)((Object)certNode)));
        return certNode;
    }

    protected Node createWaitNode() {
        AbstractNode wait = new AbstractNode(Children.LEAF);
        wait.setDisplayName("Getting certificate information...");
        return wait;
    }

    public void childrenAdded(NodeMemberEvent nme) {
    }

    public void childrenRemoved(NodeMemberEvent nme) {
    }

    public void childrenReordered(NodeReorderEvent nre) {
    }

    public void nodeDestroyed(NodeEvent ne) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void onItemAdded(RepositoryEvent evt) {
        this.refresh(true);
        this.refreshNode(evt);
    }

    public void onItemChanged(RepositoryEvent evt) {
        this.refresh(true);
        this.refreshNode(evt);
    }

    public void onItemRemoved(RepositoryEvent evt) {
        this.refresh(true);
        this.refreshNode(null);
    }

    public String refreshNode(RepositoryEvent evt) {
        Object data;
        if (evt != null && (data = evt.getItem()) != null && data instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)data;
            CertificateRepository certRepo = CertificateRepository.getDefault();
            CertificateDefinition certDef = certRepo.get(cert);
            if (certDef == null) {
                certDef = new CertificateDefinition(cert);
            }
            String name = certDef.getSubjectName();
            return name;
        }
        return null;
    }
}

